/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.version;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;
import net.sf.robocode.settings.ISettingsManager;
import net.sf.robocode.version.IVersionManager;

public final class VersionManager
implements IVersionManager {
    private static final String UNKNOWN_VERSION = "unknown";
    private static Version version;
    final ISettingsManager settingsManager;
    final boolean versionChanged;

    public VersionManager(ISettingsManager settingsManager) {
        this.settingsManager = settingsManager;
        if (settingsManager != null) {
            boolean bl = this.versionChanged = !settingsManager.getLastRunVersion().equals(this.getVersion());
            if (this.versionChanged) {
                settingsManager.setLastRunVersion(this.getVersion());
            }
        } else {
            this.versionChanged = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String checkForNewVersion() {
        String newVersLine;
        block9: {
            newVersLine = null;
            InputStream inputStream = null;
            InputStreamReader inputStreamReader = null;
            BufferedReader reader = null;
            try {
                URL url = new URL("http://robocode.sourceforge.net/version/version.html");
                URLConnection urlConnection = url.openConnection();
                urlConnection.setConnectTimeout(5000);
                if (urlConnection instanceof HttpURLConnection) {
                    Logger.logMessage((String)"Update checking with http.");
                    HttpURLConnection h = (HttpURLConnection)urlConnection;
                    if (h.usingProxy()) {
                        Logger.logMessage((String)"http using proxy.");
                    }
                }
                inputStream = urlConnection.getInputStream();
                inputStreamReader = new InputStreamReader(inputStream);
                reader = new BufferedReader(inputStreamReader);
                newVersLine = reader.readLine();
                FileUtil.cleanupStream((Object)inputStream);
            }
            catch (MalformedURLException e) {
                Logger.logError((String)"Unable to check for new version", (Throwable)e);
                newVersLine = null;
                break block9;
            }
            catch (IOException e2) {
                Logger.logError((String)"Unable to check for new version", (Throwable)e2);
                newVersLine = null;
                break block9;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                FileUtil.cleanupStream(inputStream);
                FileUtil.cleanupStream(inputStreamReader);
                FileUtil.cleanupStream(reader);
            }
            FileUtil.cleanupStream((Object)inputStreamReader);
            FileUtil.cleanupStream((Object)reader);
        }
        return newVersLine;
    }

    public boolean isFinal(String version) {
        return new Version(version).isFinal();
    }

    public String getVersion() {
        return VersionManager.getVersionInstance().toString();
    }

    private static Version getVersionInstance() {
        if (version == null) {
            version = new Version(VersionManager.getVersionFromJar());
        }
        return version;
    }

    public boolean isLastRunVersionChanged() {
        return this.versionChanged;
    }

    public int getVersionAsInt() {
        Version v = VersionManager.getVersionInstance();
        return (v.getMajor() << 24) + (v.getMinor() << 16) + (v.getRevision() << 8) + v.getBuild();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getVersionFromJar() {
        String versionString = null;
        BufferedReader in = null;
        try {
            URL versionsUrl = VersionManager.class.getResource("/versions.txt");
            if (versionsUrl == null) {
                Logger.logMessage((String)"The URL for the versions.txt was not found");
                versionString = UNKNOWN_VERSION;
            } else {
                URLConnection connection = versionsUrl.openConnection();
                connection.setUseCaches(false);
                InputStream is = connection.getInputStream();
                in = new BufferedReader(new InputStreamReader(is));
                versionString = in.readLine();
                while (versionString != null && !versionString.substring(0, 8).equalsIgnoreCase("Version ")) {
                    versionString = in.readLine();
                }
            }
        }
        catch (FileNotFoundException e) {
            Logger.logError((String)"No versions.txt file in robocode.jar");
            versionString = UNKNOWN_VERSION;
        }
        catch (IOException e) {
            Logger.logError((String)("IO Exception reading versions.txt from robocode.jar" + e));
            versionString = UNKNOWN_VERSION;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignored) {}
            }
        }
        String version = UNKNOWN_VERSION;
        if (versionString != null && !versionString.equals(UNKNOWN_VERSION)) {
            try {
                version = versionString.substring(7);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (version.equals(UNKNOWN_VERSION)) {
            Logger.logMessage((String)"Warning: Getting version from file");
            return VersionManager.getVersionFromFile();
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getVersionFromFile() {
        String versionString = null;
        InputStreamReader fileReader = null;
        BufferedReader in = null;
        try {
            File dir = FileUtil.getCwd();
            if (System.getProperty("TESTING", "false").equals("true")) {
                dir = dir.getParentFile().getParentFile().getParentFile();
            }
            fileReader = new FileReader(new File(dir, "versions.txt"));
            in = new BufferedReader(fileReader);
            versionString = in.readLine();
        }
        catch (FileNotFoundException e) {
            Logger.logError((String)"No versions.txt file.");
            versionString = UNKNOWN_VERSION;
        }
        catch (IOException e) {
            Logger.logError((String)("IO Exception reading versions.txt" + e));
            versionString = UNKNOWN_VERSION;
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException ignored) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignored) {}
            }
        }
        String version = UNKNOWN_VERSION;
        if (versionString != null && !versionString.equals(UNKNOWN_VERSION)) {
            try {
                version = versionString.substring(7);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        return version;
    }

    public int compare(String a, String b) {
        return new Version(a).compareTo(new Version(b));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Version
    implements Comparable<Object> {
        private final String version;
        private final int major;
        private final int minor;
        private final int revision;
        private final int build;
        public final int maturity;
        public final int maturity_version;

        public Version(String version) {
            int maturity;
            if (!version.matches("\\s*[0-9]+\\.[0-9]+(\\.[0-9]+)?(\\.[0-9]+)?(\\s?(([aA]lpha)|([bB]eta))(\\s?[0-9]+)?)?\\s*")) {
                throw new IllegalArgumentException("The format of the version string is not a valid");
            }
            this.version = version;
            String[] numbers = version.trim().split("\\.");
            int major = 0;
            if (numbers.length >= 1) {
                try {
                    major = Integer.parseInt(numbers[0]);
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
            }
            this.major = major;
            int minor = 0;
            if (numbers.length >= 2) {
                try {
                    String[] split = numbers[1].split("\\s++|([aA]lpha)|([bB]eta)");
                    minor = Integer.parseInt(split[0]);
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
            }
            this.minor = minor;
            int revision = 0;
            if (numbers.length >= 3) {
                try {
                    String[] split = numbers[2].split("\\s++|([aA]lpha)|([bB]eta)");
                    revision = Integer.parseInt(split[0]);
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
            }
            this.revision = revision;
            int build = 0;
            if (numbers.length >= 4) {
                try {
                    String[] split = numbers[3].split("\\s++|([aA]lpha)|([bB]eta)");
                    build = Integer.parseInt(split[0]);
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
            }
            this.build = build;
            int maturity_version = 1;
            if (this.isAlpha()) {
                maturity = 1;
                String[] split = version.split("[aA]lpha");
                if (split.length >= 2) {
                    maturity_version = Integer.parseInt(split[1].trim());
                }
            } else if (this.isBeta()) {
                maturity = 2;
                String[] split = version.split("[bB]eta");
                if (split.length >= 2) {
                    maturity_version = Integer.parseInt(split[1].trim());
                }
            } else {
                maturity = 3;
            }
            this.maturity = maturity;
            this.maturity_version = maturity_version;
        }

        public boolean isAlpha() {
            return this.version.matches(".*[aA]lpha.*");
        }

        public boolean isBeta() {
            return this.version.matches(".*[bB]eta.*");
        }

        public boolean isFinal() {
            return !this.isAlpha() && !this.isBeta();
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        public int getRevision() {
            return this.revision;
        }

        public int getBuild() {
            return this.build;
        }

        public String toString() {
            return this.version;
        }

        @Override
        public int compareTo(Object o) {
            if (o == null) {
                throw new IllegalArgumentException("The input object cannot be null");
            }
            if (o instanceof String) {
                return this.compareTo(new Version((String)o));
            }
            if (o instanceof Version) {
                Version v = (Version)o;
                long delta = this.getVersionLong() - v.getVersionLong();
                return delta == 0L ? 0 : (delta < 0L ? -1 : 1);
            }
            throw new IllegalArgumentException("The input object must be a String or Version object");
        }

        private long getVersionLong() {
            return ((long)this.major << 40) + ((long)this.minor << 32) + (long)(this.revision << 24) + (long)(this.build << 16) + (long)(this.maturity << 8) + (long)this.maturity_version;
        }
    }
}

