/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host.proxies;

import net.sf.robocode.host.IHostManager;
import net.sf.robocode.host.RobotStatics;
import net.sf.robocode.host.proxies.BasicRobotProxy;
import net.sf.robocode.peer.ExecCommands;
import net.sf.robocode.peer.IRobotPeer;
import net.sf.robocode.repository.IRobotFileSpecification;
import robocode.RobotStatus;
import robocode.robotinterfaces.peer.IStandardRobotPeer;

public class StandardRobotProxy
extends BasicRobotProxy
implements IStandardRobotPeer {
    private boolean isStopped;
    private double saveAngleToTurn;
    private double saveDistanceToGo;
    private double saveGunAngleToTurn;
    private double saveRadarAngleToTurn;

    public StandardRobotProxy(IRobotFileSpecification specification, IHostManager hostManager, IRobotPeer peer, RobotStatics statics) {
        super(specification, hostManager, peer, statics);
    }

    protected void initializeRound(ExecCommands commands, RobotStatus status) {
        super.initializeRound(commands, status);
        this.isStopped = true;
    }

    public void stop(boolean overwrite) {
        this.setStopImpl(overwrite);
        this.execute();
    }

    public void resume() {
        this.setResumeImpl();
        this.execute();
    }

    public void rescan() {
        boolean reset = false;
        boolean resetValue = false;
        if (this.eventManager.getCurrentTopEventPriority() == this.eventManager.getScannedRobotEventPriority()) {
            reset = true;
            resetValue = this.eventManager.getInterruptible(this.eventManager.getScannedRobotEventPriority());
            this.eventManager.setInterruptible(this.eventManager.getScannedRobotEventPriority(), true);
        }
        this.commands.setScan(true);
        this.executeImpl();
        if (reset) {
            this.eventManager.setInterruptible(this.eventManager.getScannedRobotEventPriority(), resetValue);
        }
    }

    public void turnRadar(double radians) {
        this.setTurnRadarImpl(radians);
        do {
            this.execute();
        } while (this.getRadarTurnRemaining() != 0.0);
    }

    public void setAdjustGunForBodyTurn(boolean newAdjustGunForBodyTurn) {
        this.setCall();
        this.commands.setAdjustGunForBodyTurn(newAdjustGunForBodyTurn);
    }

    public void setAdjustRadarForGunTurn(boolean newAdjustRadarForGunTurn) {
        this.setCall();
        this.commands.setAdjustRadarForGunTurn(newAdjustRadarForGunTurn);
        if (!this.commands.isAdjustRadarForBodyTurnSet()) {
            this.commands.setAdjustRadarForBodyTurn(newAdjustRadarForGunTurn);
        }
    }

    public void setAdjustRadarForBodyTurn(boolean newAdjustRadarForBodyTurn) {
        this.setCall();
        this.commands.setAdjustRadarForBodyTurn(newAdjustRadarForBodyTurn);
        this.commands.setAdjustRadarForBodyTurnSet(true);
    }

    protected final void setResumeImpl() {
        if (this.isStopped) {
            this.isStopped = false;
            this.commands.setDistanceRemaining(this.saveDistanceToGo);
            this.commands.setBodyTurnRemaining(this.saveAngleToTurn);
            this.commands.setGunTurnRemaining(this.saveGunAngleToTurn);
            this.commands.setRadarTurnRemaining(this.saveRadarAngleToTurn);
        }
    }

    protected final void setStopImpl(boolean overwrite) {
        if (!this.isStopped || overwrite) {
            this.saveDistanceToGo = this.getDistanceRemaining();
            this.saveAngleToTurn = this.getBodyTurnRemaining();
            this.saveGunAngleToTurn = this.getGunTurnRemaining();
            this.saveRadarAngleToTurn = this.getRadarTurnRemaining();
        }
        this.isStopped = true;
        this.commands.setDistanceRemaining(0.0);
        this.commands.setBodyTurnRemaining(0.0);
        this.commands.setGunTurnRemaining(0.0);
        this.commands.setRadarTurnRemaining(0.0);
    }
}

