/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host;

import java.io.PrintStream;
import net.sf.robocode.core.Container;
import net.sf.robocode.host.IHost;
import net.sf.robocode.host.IHostManager;
import net.sf.robocode.host.IThreadManager;
import net.sf.robocode.host.RobotStatics;
import net.sf.robocode.host.jarjar.JarJarURLConnection;
import net.sf.robocode.host.proxies.IHostingRobotProxy;
import net.sf.robocode.host.security.RobocodeSecurityManager;
import net.sf.robocode.host.security.RobocodeSecurityPolicy;
import net.sf.robocode.host.security.SecureInputStream;
import net.sf.robocode.host.security.SecurePrintStream;
import net.sf.robocode.io.Logger;
import net.sf.robocode.peer.IRobotPeer;
import net.sf.robocode.repository.IRobotRepositoryItem;
import net.sf.robocode.repository.RobotType;
import net.sf.robocode.security.HiddenAccess;
import net.sf.robocode.settings.ISettingsManager;
import robocode.control.RobotSpecification;

public class HostManager
implements IHostManager {
    private final ISettingsManager properties;
    private IThreadManager threadManager;

    public HostManager(ISettingsManager properties, IThreadManager threadManager) {
        this.properties = properties;
        this.threadManager = threadManager;
    }

    private static void initStreams() {
        SecurePrintStream sysout = new SecurePrintStream(Logger.realOut, true);
        SecurePrintStream syserr = new SecurePrintStream(Logger.realErr, true);
        SecureInputStream sysin = new SecureInputStream(System.in);
        System.setOut(sysout);
        if (!System.getProperty("debug", "false").equals("true")) {
            System.setErr(syserr);
        }
        System.setIn(sysin);
    }

    public long getRobotFilesystemQuota() {
        return this.properties.getRobotFilesystemQuota();
    }

    public IThreadManager getThreadManager() {
        return this.threadManager;
    }

    public void resetThreadManager() {
        this.threadManager.reset();
    }

    public void addSafeThread(Thread safeThread) {
        this.threadManager.addSafeThread(safeThread);
    }

    public void removeSafeThread(Thread safeThread) {
        this.threadManager.removeSafeThread(safeThread);
    }

    public PrintStream getRobotOutputStream() {
        return this.threadManager.getRobotOutputStream();
    }

    public void cleanup() {
    }

    public String[] getReferencedClasses(IRobotRepositoryItem robotRepositoryItem) {
        return this.getHost(robotRepositoryItem).getReferencedClasses(robotRepositoryItem);
    }

    public RobotType getRobotType(IRobotRepositoryItem robotRepositoryItem, boolean resolve, boolean message) {
        return this.getHost(robotRepositoryItem).getRobotType(robotRepositoryItem, resolve, message);
    }

    public IHostingRobotProxy createRobotProxy(RobotSpecification robotSpecification, RobotStatics statics, IRobotPeer peer) {
        IRobotRepositoryItem specification = (IRobotRepositoryItem)HiddenAccess.getFileSpecification((RobotSpecification)robotSpecification);
        return this.getHost(specification).createRobotProxy(this, robotSpecification, statics, peer);
    }

    private IHost getHost(IRobotRepositoryItem robotRepositoryItem) {
        return (IHost)Container.cache.getComponent((Object)("robocode.host." + robotRepositoryItem.getRobotLanguage()));
    }

    public void initSecurity() {
        JarJarURLConnection.register();
        new RobocodeSecurityPolicy(this.threadManager);
        new RobocodeSecurityManager(this.threadManager);
    }

    static {
        HostManager.initStreams();
    }
}

