/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host.proxies;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.sf.robocode.core.Container;
import net.sf.robocode.host.HostManager;
import net.sf.robocode.host.IHostManager;
import net.sf.robocode.host.IHostedThread;
import net.sf.robocode.host.IRobotClassLoader;
import net.sf.robocode.host.IThreadManager;
import net.sf.robocode.host.JavaHost;
import net.sf.robocode.host.RobotStatics;
import net.sf.robocode.host.events.EventManager;
import net.sf.robocode.host.io.RobotFileSystemManager;
import net.sf.robocode.host.io.RobotOutputStream;
import net.sf.robocode.host.proxies.IHostingRobotProxy;
import net.sf.robocode.host.security.RobotThreadManager;
import net.sf.robocode.io.Logger;
import net.sf.robocode.peer.BadBehavior;
import net.sf.robocode.peer.ExecCommands;
import net.sf.robocode.peer.IRobotPeer;
import net.sf.robocode.repository.IRobotRepositoryItem;
import robocode.RobotStatus;
import robocode.robotinterfaces.IBasicRobot;
import robocode.robotinterfaces.peer.IBasicRobotPeer;

public abstract class HostingRobotProxy
implements IHostingRobotProxy,
IHostedThread {
    protected EventManager eventManager;
    protected RobotThreadManager robotThreadManager;
    protected RobotFileSystemManager robotFileSystemManager;
    private final IRobotRepositoryItem robotSpecification;
    protected IRobotClassLoader robotClassLoader;
    protected final RobotStatics statics;
    protected RobotOutputStream out;
    protected final IRobotPeer peer;
    protected final IHostManager hostManager;
    private IThreadManager threadManager;
    protected IBasicRobot robot;
    private final Set<String> securityViolations = Collections.synchronizedSet(new HashSet());

    HostingRobotProxy(IRobotRepositoryItem robotSpecification, IHostManager hostManager, IRobotPeer peer, RobotStatics statics) {
        this.peer = peer;
        this.statics = statics;
        this.hostManager = hostManager;
        this.robotSpecification = robotSpecification;
        this.robotClassLoader = this.getHost(robotSpecification).createLoader(robotSpecification);
        this.robotClassLoader.setRobotProxy((Object)this);
        this.out = new RobotOutputStream();
        this.robotThreadManager = new RobotThreadManager(this);
        this.loadClassBattle();
        this.robotFileSystemManager = new RobotFileSystemManager(this, hostManager.getRobotFilesystemQuota(), robotSpecification.getWritableDirectory(), robotSpecification.getReadableDirectory(), robotSpecification.getRootFile());
        this.robotFileSystemManager.initialize();
    }

    private JavaHost getHost(IRobotRepositoryItem robotSpecification) {
        return (JavaHost)Container.cache.getComponent((Object)("robocode.host." + robotSpecification.getRobotLanguage()));
    }

    public void cleanup() {
        this.cleanupStaticFields();
        this.robot = null;
        this.robotFileSystemManager = null;
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
        if (this.robotThreadManager != null) {
            this.robotThreadManager.cleanup();
        }
        this.robotThreadManager = null;
        if (this.robotClassLoader != null) {
            this.robotClassLoader.cleanup();
            this.robotClassLoader = null;
        }
    }

    private void cleanupStaticFields() {
        if (this.robot == null) {
            return;
        }
        Field[] fields = new Field[]{};
        try {
            fields = this.robot.getClass().getDeclaredFields();
        }
        catch (Throwable t) {
            // empty catch block
        }
        for (Field f : fields) {
            int m = f.getModifiers();
            if (!Modifier.isStatic(m) || Modifier.isFinal(m) || f.getType().isPrimitive()) continue;
            try {
                f.setAccessible(true);
                f.set(this.robot, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public RobotOutputStream getOut() {
        return this.out;
    }

    public void println(String s) {
        this.out.println(s);
    }

    public void println(Throwable ex) {
        ex.printStackTrace(this.out);
    }

    public RobotStatics getStatics() {
        return this.statics;
    }

    public RobotFileSystemManager getRobotFileSystemManager() {
        return this.robotFileSystemManager;
    }

    public ClassLoader getRobotClassloader() {
        return (ClassLoader)this.robotClassLoader;
    }

    protected abstract void initializeRound(ExecCommands var1, RobotStatus var2);

    public void startRound(ExecCommands commands, RobotStatus status) {
        this.initializeRound(commands, status);
        this.threadManager = ((HostManager)this.hostManager).getThreadManager();
        this.robotThreadManager.start(this.threadManager);
    }

    public void forceStopThread() {
        if (!this.robotThreadManager.forceStop()) {
            this.peer.punishBadBehavior(BadBehavior.UNSTOPPABLE);
            this.peer.setRunning(false);
        }
    }

    public void waitForStopThread() {
        if (!this.robotThreadManager.waitForStop()) {
            this.peer.punishBadBehavior(BadBehavior.UNSTOPPABLE);
            this.peer.setRunning(false);
        }
    }

    private void loadClassBattle() {
        try {
            this.robotClassLoader.loadRobotMainClass(true);
        }
        catch (Throwable e) {
            this.println("SYSTEM: Could not load " + this.statics.getName() + " : ");
            this.println(e);
            this.drainEnergy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadRobotRound() {
        this.robot = null;
        try {
            this.threadManager.setLoadingRobot(this);
            this.robot = this.robotClassLoader.createRobotInstance();
            if (this.robot == null) {
                this.println("SYSTEM: Skipping robot: " + this.statics.getName());
                boolean bl = false;
                return bl;
            }
            this.robot.setOut((PrintStream)this.out);
            this.robot.setPeer((IBasicRobotPeer)this);
            this.eventManager.setRobot(this.robot);
        }
        catch (IllegalAccessException e) {
            this.println("SYSTEM: Unable to instantiate this robot: " + e);
            this.println("SYSTEM: Is your constructor marked public?");
            this.println(e);
            this.robot = null;
            Logger.logError((Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.println("SYSTEM: An error occurred during initialization of " + this.statics.getName());
            this.println("SYSTEM: " + e);
            this.println(e);
            this.robot = null;
            Logger.logError((Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.threadManager.setLoadingRobot(null);
        }
        return true;
    }

    protected abstract void executeImpl();

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected abstract void waitForBattleEndImpl();

    public void drainEnergy() {
        this.peer.drainEnergy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void punishSecurityViolation(String message) {
        Set<String> set = this.securityViolations;
        synchronized (set) {
            if (this.securityViolations.contains(message)) {
                return;
            }
            this.securityViolations.add(message);
        }
        Logger.logError((String)message);
        this.println("SYSTEM: " + message);
        this.peer.punishBadBehavior(BadBehavior.SECURITY_VIOLATION);
    }
}

