/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository;

import java.io.File;
import java.io.FileFilter;

public class FileTypeFilter
implements FileFilter {
    private final String[] fileTypes;

    public FileTypeFilter(String[] fileTypes) {
        if (fileTypes == null) {
            this.fileTypes = null;
        } else {
            this.fileTypes = new String[fileTypes.length];
            System.arraycopy(fileTypes, 0, this.fileTypes, 0, fileTypes.length);
        }
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String filename = file.getName();
        for (String fileType : this.fileTypes) {
            if (filename.length() <= fileType.length() || !filename.substring(filename.length() - fileType.length()).equals(fileType)) continue;
            return true;
        }
        return false;
    }
}

