/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.swing.JOptionPane;
import net.sf.robocode.core.Container;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;
import net.sf.robocode.repository.FileSpecification;
import net.sf.robocode.ui.IWindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JarFileSpecification
extends FileSpecification {
    protected JarFileSpecification(File f, File rootDir, boolean developmentVersion) {
        this.rootDir = rootDir;
        this.developmentVersion = developmentVersion;
        this.valid = true;
        String filename = f.getName();
        String fileType = FileUtil.getFileType((String)filename);
        if (fileType.equals(".jar") || fileType.equals(".zip")) {
            this.setFileLastModified(f.lastModified());
            this.setFileLength(f.length());
            this.setFileType(fileType);
            try {
                this.setFilePath(f.getCanonicalPath());
            }
            catch (IOException e) {
                Logger.logError((String)("Warning:  Unable to determine canonical path for " + f.getPath()));
                this.setFilePath(f.getPath());
            }
        } else {
            throw new RuntimeException("JarFileSpecification can only be constructed from a .jar file");
        }
        this.setFileName(f.getName());
    }

    @Override
    public String getUid() {
        return this.getFilePath();
    }

    public void processJar(File robotCache, File robotsDirectory, List<FileSpecification> updatedJarList) {
        File dest;
        IWindowManager windowManager = (IWindowManager)Container.getComponent(IWindowManager.class);
        if (windowManager != null) {
            windowManager.setStatus("Extracting .jar: " + this.getFileName());
        }
        if ((dest = this.getRootDir().equals(robotsDirectory) ? new File(robotCache, this.getFileName() + "_") : new File(this.getRootDir(), this.getFileName() + "_")).exists()) {
            FileUtil.deleteDir((File)dest);
        }
        if (!dest.exists() && !dest.mkdirs()) {
            Logger.logError((String)("Can't create" + dest.toString()));
        }
        File f = new File(this.getFilePath());
        JarFileSpecification.extractJar(f, dest, "Extracting .jar: " + this.getFileName(), updatedJarList, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int extractJar(File f, File dest, String statusPrefix, List<FileSpecification> updatedJarList, boolean close, boolean alwaysReplace) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            JarInputStream jarIS = new JarInputStream(fis);
            int n = JarFileSpecification.extractJar(jarIS, dest, statusPrefix, updatedJarList, close, alwaysReplace);
            return n;
        }
        catch (IOException e) {
            Logger.logError((String)("Exception reading " + f + ": " + e));
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ignored) {}
            }
        }
        return 16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int extractJar(JarInputStream jarIS, File dest, String statusPrefix, List<FileSpecification> updatedJarList, boolean close, boolean alwaysReplace) {
        int rc = 0;
        boolean always = alwaysReplace;
        byte[] buf = new byte[2048];
        IWindowManager windowManager = (IWindowManager)Container.getComponent(IWindowManager.class);
        try {
            JarEntry entry = jarIS.getNextJarEntry();
            while (entry != null) {
                if (windowManager != null) {
                    windowManager.setStatus(statusPrefix + " (" + entry.getName() + ")");
                }
                if (entry.isDirectory()) {
                    File dir = new File(dest, entry.getName());
                    if (!dir.exists() && !dir.mkdirs()) {
                        Logger.logError((String)("Can't create dir " + dir.toString()));
                    }
                } else {
                    File parentDirectory;
                    File out = new File(dest, entry.getName());
                    if (out.exists() && !always) {
                        Object[] options = new Object[]{"Yes to All", "Yes", "No", "Cancel"};
                        int r = JOptionPane.showOptionDialog(null, entry.getName() + " exists.  Replace?", "Warning", -1, 2, null, options, options[0]);
                        if (r == 0) {
                            always = true;
                        } else {
                            if (r == 2) {
                                if (windowManager != null) {
                                    windowManager.setStatus(entry.getName() + " skipped.");
                                }
                                entry = jarIS.getNextJarEntry();
                                continue;
                            }
                            if (r == 3) {
                                entry = null;
                                rc = -1;
                                continue;
                            }
                        }
                    }
                    if (!(parentDirectory = new File(out.getParent()).getCanonicalFile()).exists() && !parentDirectory.mkdirs()) {
                        Logger.logError((String)("Can't create dir " + parentDirectory.toString()));
                    }
                    FileOutputStream fos = null;
                    try {
                        int num;
                        fos = new FileOutputStream(out);
                        while ((num = jarIS.read(buf, 0, 2048)) != -1) {
                            fos.write(buf, 0, num);
                        }
                        FileDescriptor fd = fos.getFD();
                        fd.sync();
                    }
                    finally {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    if (entry.getTime() >= 0L && !out.setLastModified(entry.getTime())) {
                        Logger.logError((String)("Can't set file time " + out.toString()));
                    }
                    if (updatedJarList != null && entry.getName().indexOf("/") < 0 && FileUtil.getFileType((String)entry.getName()).equals(".jar")) {
                        FileSpecification fileSpecification = JarFileSpecification.createSpecification(null, out, parentDirectory, "", false);
                        updatedJarList.add(fileSpecification);
                    }
                }
                entry = jarIS.getNextJarEntry();
            }
            if (close) {
                jarIS.close();
            }
        }
        catch (IOException e) {
            Logger.logError((String)("IOException " + statusPrefix + ": "), (Throwable)e);
        }
        return rc;
    }
}

