/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository;

import net.sf.robocode.repository.FileSpecification;
import net.sf.robocode.repository.INamedFileSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class NamedFileSpecification
extends FileSpecification
implements Comparable<INamedFileSpecification>,
INamedFileSpecification {
    private static final long serialVersionUID = 1L;
    private String fullPackage;
    private String fullClassNameWithVersion;
    private String uniqueFullClassNameWithVersion;
    private String shortClassName;
    private String shortClassNameWithVersion;
    private String uniqueShortClassNameWithVersion;
    private String veryShortClassName;
    private String veryShortClassNameWithVersion;
    private String uniqueVeryShortClassNameWithVersion;

    NamedFileSpecification() {
    }

    public String getFullClassName() {
        return this.name;
    }

    public String getShortClassName() {
        if (this.shortClassName == null) {
            this.shortClassName = this.getFullClassName().lastIndexOf(".") > 0 ? this.getFullClassName().substring(this.getFullClassName().lastIndexOf(".") + 1) : this.getFullClassName();
        }
        return this.shortClassName;
    }

    public String getShortClassNameWithVersion() {
        if (this.shortClassNameWithVersion == null) {
            this.shortClassNameWithVersion = this.version == null ? this.getShortClassName() : this.getShortClassName() + " " + this.version;
        }
        return this.shortClassNameWithVersion;
    }

    public String getUniqueFullClassNameWithVersion() {
        if (this.uniqueFullClassNameWithVersion == null) {
            this.uniqueFullClassNameWithVersion = this.getFullClassNameWithVersion().equals(this.getFullClassName()) ? this.getFullClassName() : (!this.developmentVersion ? this.getFullClassNameWithVersion() : this.getFullClassNameWithVersion() + "*");
        }
        return this.uniqueFullClassNameWithVersion;
    }

    public String getUniqueShortClassNameWithVersion() {
        if (this.uniqueShortClassNameWithVersion == null) {
            this.uniqueShortClassNameWithVersion = this.getShortClassName().equals(this.getShortClassNameWithVersion()) ? this.getShortClassName() : (!this.developmentVersion ? this.getShortClassNameWithVersion() : this.getShortClassNameWithVersion() + "*");
        }
        return this.uniqueShortClassNameWithVersion;
    }

    public String getUniqueVeryShortClassNameWithVersion() {
        if (this.uniqueVeryShortClassNameWithVersion == null) {
            this.uniqueVeryShortClassNameWithVersion = this.getVeryShortClassName().equals(this.getVeryShortClassNameWithVersion()) ? this.getVeryShortClassName() : (!this.developmentVersion ? this.getVeryShortClassNameWithVersion() : this.getVeryShortClassNameWithVersion() + "*");
        }
        return this.uniqueVeryShortClassNameWithVersion;
    }

    public String getVeryShortClassName() {
        if (this.veryShortClassName == null) {
            this.veryShortClassName = this.getShortClassName();
            if (this.veryShortClassName.length() > 12) {
                this.veryShortClassName = this.veryShortClassName.substring(0, 12) + "...";
            }
        }
        return this.veryShortClassName;
    }

    public String getVeryShortClassNameWithVersion() {
        if (this.veryShortClassNameWithVersion == null) {
            this.veryShortClassNameWithVersion = this.version == null ? this.getVeryShortClassName() : this.getVeryShortClassName() + " " + this.version;
        }
        return this.veryShortClassNameWithVersion;
    }

    public String getFullClassNameWithVersion() {
        if (this.fullClassNameWithVersion == null) {
            this.fullClassNameWithVersion = this.version == null ? this.getFullClassName() : this.getFullClassName() + " " + this.version;
        }
        return this.fullClassNameWithVersion;
    }

    public String getFullPackage() {
        if (this.fullPackage == null) {
            this.fullPackage = this.name.lastIndexOf(".") > 0 ? this.name.substring(0, this.name.lastIndexOf(".")) : null;
        }
        return this.fullPackage;
    }

    @Override
    public int compareTo(INamedFileSpecification other) {
        return NamedFileSpecification.compare(this.getFullPackage(), this.getFullClassName(), this.getVersion(), other.getFullPackage(), other.getFullClassName(), other.getVersion());
    }
}

