/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.robocode.core.Container;
import net.sf.robocode.host.IHostManager;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;
import net.sf.robocode.repository.ClassSpecification;
import net.sf.robocode.repository.FileSpecification;
import net.sf.robocode.repository.FileSpecificationDatabase;
import net.sf.robocode.repository.FileTypeFilter;
import net.sf.robocode.repository.INamedFileSpecification;
import net.sf.robocode.repository.IRepositoryManager;
import net.sf.robocode.repository.ITeamFileSpecificationExt;
import net.sf.robocode.repository.JarFileSpecification;
import net.sf.robocode.repository.NamedFileSpecification;
import net.sf.robocode.repository.Repository;
import net.sf.robocode.repository.RobotFileSpecification;
import net.sf.robocode.repository.TeamFileSpecification;
import net.sf.robocode.security.HiddenAccess;
import net.sf.robocode.settings.ISettingsListener;
import net.sf.robocode.settings.ISettingsManager;
import net.sf.robocode.ui.IWindowManager;
import robocode.control.RobotSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RepositoryManager
implements IRepositoryManager {
    private static final int MAX_FULL_PACKAGE_NAME_LENGTH = 32;
    private static final int MAX_SHORT_CLASS_NAME_LENGTH = 32;
    private FileSpecificationDatabase robotDatabase;
    private File robotsDirectory;
    private File robotCache;
    private Repository repository;
    private final List<FileSpecification> updatedJarList = Collections.synchronizedList(new ArrayList());
    private boolean write;
    private final ISettingsManager properties;
    private final IHostManager hostManager;

    public RepositoryManager(ISettingsManager properties, IHostManager hostManager) {
        this.hostManager = hostManager;
        this.properties = properties;
        properties.addPropertyListener(new ISettingsListener(){

            public void settingChanged(String property) {
                if (property.equals("robocode.options.development.path")) {
                    RepositoryManager.this.clearRobotList();
                }
            }
        });
    }

    public File getRobotCache() {
        if (this.robotCache == null) {
            File oldRobotCache = new File(this.getRobotsDirectory(), "robotcache");
            File newRobotCache = new File(this.getRobotsDirectory(), ".robotcache");
            if (oldRobotCache.exists() && !oldRobotCache.renameTo(newRobotCache)) {
                Logger.logError((String)("Can't move " + newRobotCache.toString()));
            }
            this.robotCache = newRobotCache;
            if (!this.robotCache.exists()) {
                if (!this.robotCache.mkdirs()) {
                    Logger.logError((String)("Can't create " + this.robotCache.toString()));
                }
                File readme = new File(this.robotCache, "README");
                try {
                    PrintStream out = new PrintStream(new FileOutputStream(readme));
                    out.println("WARNING!");
                    out.println("Do not edit files in this directory.");
                    out.println("Any changes you make here may be lost.");
                    out.println("If you want to make changes to these robots,");
                    out.println("then copy the files into your robots directory");
                    out.println("and make the changes there.");
                    out.close();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
        }
        return this.robotCache;
    }

    private FileSpecificationDatabase getRobotDatabase() {
        if (this.robotDatabase == null) {
            this.setStatus("Reading robot database");
            this.robotDatabase = new FileSpecificationDatabase();
            try {
                this.robotDatabase.load(new File(this.getRobotsDirectory(), "robot.database"));
            }
            catch (FileNotFoundException e) {
                Logger.logMessage((String)"Building robot database.");
            }
            catch (IOException e) {
                Logger.logMessage((String)"Rebuilding robot database.");
            }
            catch (ClassNotFoundException e) {
                Logger.logMessage((String)"Rebuilding robot database.");
            }
        }
        return this.robotDatabase;
    }

    private void setStatus(String message) {
        IWindowManager windowManager = (IWindowManager)Container.getComponent(IWindowManager.class);
        if (windowManager != null) {
            windowManager.setStatus(message);
        }
    }

    public void loadRobotRepository() {
        if (this.repository != null) {
            return;
        }
        this.setStatus("Refreshing robot database");
        this.updatedJarList.clear();
        this.write = false;
        this.repository = new Repository();
        this.cleanupCache();
        this.setStatus("Cleaning up robot database");
        this.cleanupDatabase();
        String externalRobotsPath = this.properties.getOptionsDevelopmentPath();
        StringTokenizer tokenizer = new StringTokenizer(externalRobotsPath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            File f = new File(tok);
            if (f.equals(this.getRobotsDirectory()) || f.equals(this.getRobotCache()) || f.equals(this.getRobotsDirectory().getParentFile())) continue;
            this.getSpecificationsInDirectory(f, f, "", true);
        }
        this.updatedJarList.clear();
        File f = this.getRobotsDirectory();
        this.setStatus("Reading: " + f.getName());
        if (f.exists() && f.isDirectory()) {
            this.getSpecificationsInDirectory(f, f, "", true);
        }
        for (int i = 0; i < this.updatedJarList.size(); ++i) {
            JarFileSpecification updatedJar = (JarFileSpecification)this.updatedJarList.get(i);
            try {
                updatedJar.processJar(this.getRobotCache(), this.getRobotsDirectory(), this.updatedJarList);
                this.getRobotDatabase().put(updatedJar.getFilePath(), updatedJar);
                this.updateRobotDatabase(updatedJar);
            }
            catch (Throwable t) {
                Logger.logError((Throwable)t);
            }
            this.write = true;
        }
        this.updatedJarList.clear();
        f = this.getRobotCache();
        this.setStatus("Reading: " + this.getRobotCache());
        if (f.exists() && f.isDirectory()) {
            this.getSpecificationsInDirectory(f, f, "", false);
        }
        List<FileSpecification> fileSpecificationList = this.getRobotDatabase().getFileSpecifications();
        if (this.write) {
            this.setStatus("Saving robot database");
            this.saveRobotDatabase();
        }
        this.setStatus("Adding robots to repository");
        for (FileSpecification fs : fileSpecificationList) {
            if (!(fs instanceof INamedFileSpecification)) continue;
            this.repository.add((NamedFileSpecification)fs);
        }
        this.setStatus("Sorting repository");
        this.repository.sortRobotSpecifications();
        this.setStatus("");
    }

    private void cleanupCache() {
        File dir = this.getRobotCache();
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                File f;
                if ((!file.isDirectory() || file.getName().lastIndexOf(".jar_") != file.getName().length() - 5) && (!file.isDirectory() || file.getName().lastIndexOf(".zip_") != file.getName().length() - 5) && (!file.isDirectory() || file.getName().lastIndexOf(".jar") != file.getName().length() - 4) || (f = new File(this.getRobotsDirectory(), file.getName().substring(0, file.getName().length() - 1))).exists() && !f.getName().startsWith("robocode")) continue;
                this.setStatus("Cleaning up cache: Removing " + file);
                FileUtil.deleteDir((File)file);
            }
        }
    }

    private void cleanupDatabase() {
        List<File> develDirectories = this.getDevelDirectories();
        List<FileSpecification> fileSpecificationList = this.getRobotDatabase().getFileSpecifications();
        for (FileSpecification fs : fileSpecificationList) {
            if (fs.exists()) {
                File rootDir = fs.getRootDir();
                if (rootDir == null) {
                    Logger.logError((String)("Warning, null root directory: " + fs.getFilePath()));
                    continue;
                }
                if (!fs.isDevelopmentVersion() || rootDir.equals(this.getRobotsDirectory()) || develDirectories.contains(rootDir)) continue;
                this.getRobotDatabase().remove(fs.getFilePath());
                this.write = true;
                continue;
            }
            this.getRobotDatabase().remove(fs.getFilePath());
            this.write = true;
        }
    }

    public List<File> getDevelDirectories() {
        ArrayList<File> develDirectories = new ArrayList<File>();
        String externalPath = this.properties.getOptionsDevelopmentPath();
        StringTokenizer tokenizer = new StringTokenizer(externalPath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            try {
                File f = new File(tokenizer.nextToken()).getCanonicalFile();
                develDirectories.add(f);
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }
        return develDirectories;
    }

    public File getRobotsDirectory() {
        if (this.robotsDirectory == null) {
            this.robotsDirectory = FileUtil.getRobotsDir();
        }
        return this.robotsDirectory;
    }

    public void clearRobotList() {
        this.repository = null;
    }

    public void reload(String file) {
        this.clearRobotList();
    }

    private List<FileSpecification> getSpecificationsInDirectory(File rootDir, File dir, String prefix, boolean isDevelopmentDirectory) {
        List<FileSpecification> robotList = Collections.synchronizedList(new ArrayList());
        try {
            rootDir = rootDir.getCanonicalFile();
        }
        catch (IOException e) {
            Logger.logError((Throwable)e);
            return robotList;
        }
        String[] fileTypes = new String[]{".class", ".jar", ".team", ".jar.zip"};
        File[] files = dir.listFiles(new FileTypeFilter(fileTypes));
        if (files == null) {
            Logger.logError((String)("Warning:  Unable to read directory " + dir));
            return robotList;
        }
        for (File file : files) {
            FileSpecification fileSpecification;
            String fileName = file.getName();
            if (file.isDirectory()) {
                if (prefix.length() == 0) {
                    int jidx = fileName.lastIndexOf(".jar_");
                    if (jidx > 0 && jidx == fileName.length() - 5) {
                        robotList.addAll(this.getSpecificationsInDirectory(file, file, "", isDevelopmentDirectory));
                        continue;
                    }
                    jidx = fileName.lastIndexOf(".zip_");
                    if (jidx > 0 && jidx == fileName.length() - 5) {
                        robotList.addAll(this.getSpecificationsInDirectory(file, file, "", isDevelopmentDirectory));
                        continue;
                    }
                    robotList.addAll(this.getSpecificationsInDirectory(rootDir, file, prefix + fileName + ".", isDevelopmentDirectory));
                    continue;
                }
                int odidx = fileName.indexOf("data.");
                if (odidx == 0) {
                    this.renameOldDataDir(dir, file);
                    continue;
                }
                int didx = fileName.lastIndexOf(".data");
                if (didx > 0 && didx == fileName.length() - 5) continue;
                robotList.addAll(this.getSpecificationsInDirectory(rootDir, file, prefix + fileName + ".", isDevelopmentDirectory));
                continue;
            }
            if (fileName.indexOf("$") >= 0 || fileName.indexOf("robocode") == 0) continue;
            FileSpecification cachedSpecification = this.getRobotDatabase().get(file.getPath());
            if (cachedSpecification != null && cachedSpecification.isSameFile(file.getPath(), file.length(), file.lastModified())) {
                fileSpecification = cachedSpecification;
            } else {
                fileSpecification = FileSpecification.createSpecification(this, file, rootDir, prefix, isDevelopmentDirectory);
                this.updateRobotDatabase(fileSpecification);
                this.write = true;
                if (fileSpecification instanceof JarFileSpecification && fileSpecification.getRootDir().equals(this.getRobotsDirectory())) {
                    this.updatedJarList.add(fileSpecification);
                }
            }
            if (!fileSpecification.isValid()) continue;
            robotList.add(fileSpecification);
        }
        return robotList;
    }

    private void saveRobotDatabase() {
        if (this.robotDatabase == null) {
            Logger.logError((String)"Cannot save a null robot database.");
            return;
        }
        try {
            this.robotDatabase.store(new File(this.getRobotsDirectory(), "robot.database"));
        }
        catch (IOException e) {
            Logger.logError((String)"IO Exception writing robot database: ", (Throwable)e);
        }
    }

    private void updateRobotDatabase(FileSpecification fileSpecification) {
        String name = fileSpecification.getName();
        if (name == null || name.startsWith(".robotcache.")) {
            return;
        }
        String key = fileSpecification.getFilePath();
        if (fileSpecification instanceof RobotFileSpecification) {
            RobotFileSpecification robotFileSpecification = (RobotFileSpecification)fileSpecification;
            if (robotFileSpecification.isValid() && robotFileSpecification.verifyRobotName() && robotFileSpecification.update(this.hostManager)) {
                this.updateNoDuplicates(robotFileSpecification);
            } else {
                robotFileSpecification.setValid(false);
                this.getRobotDatabase().put(key, new ClassSpecification(robotFileSpecification));
                this.getRobotDatabase().put(key, robotFileSpecification);
            }
        } else if (fileSpecification instanceof JarFileSpecification) {
            this.getRobotDatabase().put(key, fileSpecification);
        } else if (fileSpecification instanceof TeamFileSpecification) {
            this.updateNoDuplicates((TeamFileSpecification)fileSpecification);
        } else if (fileSpecification instanceof ClassSpecification) {
            this.getRobotDatabase().put(key, fileSpecification);
        } else {
            Logger.logMessage((String)("Update robot database not possible for type " + fileSpecification.getFileType()));
        }
    }

    private void updateNoDuplicates(NamedFileSpecification spec) {
        String key = spec.getFilePath();
        this.setStatus("Updating database: " + spec.getName());
        if (!spec.isDevelopmentVersion() && this.getRobotDatabase().contains(spec.getFullClassName(), spec.getVersion(), false)) {
            FileSpecification existingSpec = this.getRobotDatabase().get(spec.getFullClassName(), spec.getVersion(), false);
            if (existingSpec == null) {
                this.getRobotDatabase().put(key, spec);
            } else if (!existingSpec.getUid().equals(spec.getUid())) {
                if (existingSpec.getFilePath().equals(spec.getFilePath())) {
                    this.getRobotDatabase().put(key, spec);
                } else {
                    File existingSource = existingSpec.getJarFile();
                    File newSource = spec.getJarFile();
                    if (existingSource != null && newSource != null) {
                        long t2;
                        long t1 = existingSource.lastModified();
                        if (t1 > (t2 = newSource.lastModified())) {
                            if (!existingSource.renameTo(new File(existingSource.getPath() + ".invalid"))) {
                                Logger.logError((String)("Can't move " + existingSource.toString()));
                            }
                            this.getRobotDatabase().remove(existingSpec.getFilePath());
                            this.getRobotDatabase().put(key, spec);
                            this.conflictLog("Renaming " + existingSource + " to invalid, as it contains a robot " + spec.getName() + " which conflicts with the same robot in " + newSource);
                        } else {
                            if (!newSource.renameTo(new File(newSource.getPath() + ".invalid"))) {
                                Logger.logError((String)("Can't move " + newSource.toString()));
                            }
                            this.conflictLog("Renaming " + newSource + " to invalid, as it contains a robot " + spec.getName() + " which conflicts with the same robot in " + existingSource);
                        }
                    }
                }
            } else {
                spec.setDuplicate(true);
                this.getRobotDatabase().put(key, spec);
            }
        } else {
            this.getRobotDatabase().put(key, spec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void conflictLog(String s) {
        Logger.logError((String)s);
        File f = new File(FileUtil.getCwd(), "conflict.logError");
        FileWriter writer = null;
        BufferedWriter out = null;
        try {
            writer = new FileWriter(f.getPath(), true);
            out = new BufferedWriter(writer);
            out.write(s + "\n");
        }
        catch (IOException e) {
            Logger.logError((String)"Warning:  Could not write to conflict.logError");
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ignored) {}
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    private void renameOldDataDir(File dir, File f) {
        String name = f.getName();
        String botName = name.substring(name.indexOf(".") + 1);
        File newFile = new File(dir, botName + ".data");
        if (!newFile.exists()) {
            File oldFile = new File(dir, name);
            Logger.logError((String)("Renaming " + oldFile.getName() + " to " + newFile.getName()));
            if (!oldFile.renameTo(newFile)) {
                Logger.logError((String)("Can't move " + oldFile.toString()));
            }
        }
    }

    public List<INamedFileSpecification> getRobotSpecificationsList() {
        this.loadRobotRepository();
        return this.repository.getRobotSpecificationsList(false, false, false, false, false, false);
    }

    public List<INamedFileSpecification> getRobotSpecificationsList(boolean onlyWithSource, boolean onlyWithPackage, boolean onlyRobots, boolean onlyDevelopment, boolean onlyNotDevelopment, boolean ignoreTeamRobots) {
        this.loadRobotRepository();
        return this.repository.getRobotSpecificationsList(onlyWithSource, onlyWithPackage, onlyRobots, onlyDevelopment, onlyNotDevelopment, ignoreTeamRobots);
    }

    public RobotSpecification[] getRobotSpecifications() {
        List<INamedFileSpecification> list = this.getRobotSpecificationsList();
        RobotSpecification[] robotSpecs = new RobotSpecification[list.size()];
        for (int i = 0; i < robotSpecs.length; ++i) {
            INamedFileSpecification specification = list.get(i);
            if (!specification.isValid()) continue;
            robotSpecs[i] = specification.createRobotSpecification();
        }
        return robotSpecs;
    }

    private FileSpecification getRobot(String fullClassNameWithVersion) {
        this.loadRobotRepository();
        return this.repository.get(fullClassNameWithVersion);
    }

    public boolean load(List<RobotSpecification> battlingRobotsList, String bot, RobotSpecification battleRobotSpec, int teamNum) {
        return this.load(battlingRobotsList, bot, battleRobotSpec, String.format("%4d", teamNum), false);
    }

    private boolean load(List<RobotSpecification> battlingRobotsList, String bot, RobotSpecification battleRobotSpec, String teamName, boolean inTeam) {
        FileSpecification fileSpec = this.getRobot(bot);
        if (fileSpec != null) {
            if (fileSpec instanceof RobotFileSpecification) {
                RobotSpecification specification = !inTeam && battleRobotSpec != null ? battleRobotSpec : fileSpec.createRobotSpecification();
                HiddenAccess.setTeamName((RobotSpecification)specification, (String)(inTeam ? teamName : null));
                battlingRobotsList.add(specification);
                return true;
            }
            if (fileSpec instanceof TeamFileSpecification) {
                TeamFileSpecification currentTeam = (TeamFileSpecification)fileSpec;
                String version = currentTeam.getVersion();
                if (version == null) {
                    version = "";
                }
                String newTeam = currentTeam.getName() + version + "[" + teamName + "]";
                StringTokenizer teamTokenizer = new StringTokenizer(currentTeam.getMembers(), ",");
                while (teamTokenizer.hasMoreTokens()) {
                    String botName = teamTokenizer.nextToken();
                    String teamBot = currentTeam.getRootDir() + File.separator + botName;
                    if (this.load(battlingRobotsList, teamBot, battleRobotSpec, newTeam, true)) continue;
                    this.load(battlingRobotsList, botName, battleRobotSpec, newTeam, true);
                }
                return true;
            }
        }
        return false;
    }

    public boolean verifyRobotName(String robotName, String shortClassName) {
        return RepositoryManager.verifyRobotNameStatic(robotName, shortClassName);
    }

    public int extractJar(File f) {
        return JarFileSpecification.extractJar(f, this.getRobotsDirectory(), "Extracting to " + this.getRobotsDirectory(), null, true, false);
    }

    public static boolean verifyRobotNameStatic(String robotName, String shortClassName) {
        int lIndex = robotName.indexOf(".");
        if (lIndex > 0) {
            String rootPackage = robotName.substring(0, lIndex);
            if (rootPackage.equalsIgnoreCase("robocode")) {
                Logger.logError((String)("Robot " + robotName + " ignored.  You cannot use package " + rootPackage));
                return false;
            }
            if (rootPackage.length() > 32) {
                String message = "Robot " + robotName + " has package name too long.  " + 32 + " characters maximum please.";
                Logger.logError((String)message);
                return false;
            }
        }
        if (shortClassName != null && shortClassName.length() > 32) {
            String message = "Robot " + robotName + " has classname too long.  " + 32 + " characters maximum please.";
            Logger.logError((String)message);
            return false;
        }
        return true;
    }

    public ITeamFileSpecificationExt createTeam() {
        return new TeamFileSpecification();
    }
}

