/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository.items;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import net.sf.robocode.repository.IRepositoryItem;
import net.sf.robocode.repository.items.BaseItem;
import net.sf.robocode.repository.root.IRepositoryRoot;
import net.sf.robocode.security.HiddenAccess;
import net.sf.robocode.util.AlphanumericComparator;
import robocode.control.RobotSpecification;

public abstract class NamedItem
extends BaseItem
implements IRepositoryItem {
    private static final long serialVersionUID = 1L;
    protected Properties properties = new Properties();
    protected URL htmlUrl;

    public NamedItem(URL url, IRepositoryRoot root) {
        super(url, root);
    }

    public abstract URL getPropertiesUrl();

    public abstract String getFullClassName();

    public abstract String getVersion();

    public abstract URL getWebpage();

    public abstract String getAuthorName();

    public abstract String getRobocodeVersion();

    public abstract String getDescription();

    public abstract URL getHtmlUrl();

    public void storeHtml(OutputStream os) throws IOException {
        if (this.htmlUrl != null) {
            // empty if block
        }
    }

    public boolean isDevelopmentVersion() {
        return !this.getFullClassName().startsWith("sample") && this.root.isDevel();
    }

    public String getRootFile() {
        return this.root.getRootUrl().toString();
    }

    public String getRootPackage() {
        int lIndex = this.getFullClassName().indexOf(".");
        String rootPackage = null;
        if (lIndex > 0) {
            rootPackage = this.getFullClassName().substring(0, lIndex);
        }
        return rootPackage;
    }

    public String getFullPackage() {
        if (this.getFullClassName() == null) {
            return null;
        }
        int index = this.getFullClassName().lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        return this.getFullClassName().substring(0, index);
    }

    public String getRelativePath() {
        int index = this.getFullClassName().lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        return this.getFullClassName().substring(0, index).replace('.', '/');
    }

    public String getShortClassName() {
        if (this.getFullClassName() == null) {
            return null;
        }
        int index = this.getFullClassName().lastIndexOf(46);
        if (index == -1) {
            return this.getFullClassName();
        }
        return this.getFullClassName().substring(index + 1);
    }

    public String getFullClassNameWithVersion() {
        if (this.getVersion() == null) {
            return this.getFullClassName();
        }
        return this.getFullClassName() + " " + this.getVersion();
    }

    public String getUniqueFullClassNameWithVersion() {
        if (this.getVersion() == null) {
            return this.getFullClassName();
        }
        if (!this.isDevelopmentVersion()) {
            return this.getFullClassNameWithVersion();
        }
        return this.getFullClassNameWithVersion() + "*";
    }

    public String getUniqueShortClassNameWithVersion() {
        if (this.getVersion() == null) {
            return this.getShortClassName();
        }
        if (!this.isDevelopmentVersion()) {
            return this.getShortClassNameWithVersion();
        }
        return this.getShortClassNameWithVersion() + "*";
    }

    public String getUniqueVeryShortClassNameWithVersion() {
        if (this.getVersion() == null) {
            return this.getVeryShortClassName();
        }
        if (!this.isDevelopmentVersion()) {
            return this.getVeryShortClassNameWithVersion();
        }
        return this.getVeryShortClassNameWithVersion() + "*";
    }

    public String getShortClassNameWithVersion() {
        if (this.getVersion() == null) {
            return this.getShortClassName();
        }
        return this.getShortClassName() + " " + this.getVersion();
    }

    public String getVeryShortClassNameWithVersion() {
        if (this.getVersion() == null) {
            return this.getVeryShortClassName();
        }
        return this.getVeryShortClassName() + " " + this.getVersion();
    }

    public String getVeryShortClassName() {
        String veryShortClassName = this.getShortClassName();
        if (veryShortClassName.length() > 12) {
            veryShortClassName = veryShortClassName.substring(0, 12) + "...";
        }
        return veryShortClassName;
    }

    public RobotSpecification createRobotSpecification() {
        return HiddenAccess.createSpecification((Object)this, (String)this.getFullClassName(), (String)this.getAuthorName(), (String)(this.getWebpage() != null ? this.getWebpage().toString() : null), (String)this.getVersion(), (String)this.getRobocodeVersion(), (String)this.root.getRootUrl().toString(), (String)this.getFullClassName(), (String)this.getDescription());
    }

    public int compareTo(Object other) {
        if (other == this) {
            return 0;
        }
        if (other instanceof IRepositoryItem) {
            IRepositoryItem otherRI = (IRepositoryItem)other;
            return NamedItem.compare(this.getFullPackage(), this.getFullClassName(), this.getVersion(), otherRI.getFullPackage(), otherRI.getFullClassName(), otherRI.getVersion());
        }
        return 0;
    }

    private static int compare(String p1, String c1, String v1, String p2, String c2, String v2) {
        AlphanumericComparator alphaNumComparator = new AlphanumericComparator();
        int result = alphaNumComparator.compare(p1, p2);
        if (result != 0) {
            return result;
        }
        result = alphaNumComparator.compare(c1, c2);
        if (result != 0) {
            return result;
        }
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return 1;
        }
        if (v2 == null) {
            return -1;
        }
        if (v1.equals(v2)) {
            return 0;
        }
        if (v1.indexOf(".") < 0 || v2.indexOf(".") < 0) {
            return alphaNumComparator.compare(v1, v2);
        }
        StringTokenizer s1 = new StringTokenizer(v1, ".");
        StringTokenizer s2 = new StringTokenizer(v2, ".");
        while (s1.hasMoreTokens() && s2.hasMoreTokens()) {
            String tok1 = s1.nextToken();
            String tok2 = s2.nextToken();
            try {
                int i2;
                int i1 = Integer.parseInt(tok1);
                if (i1 == (i2 = Integer.parseInt(tok2))) continue;
                return i1 - i2;
            }
            catch (NumberFormatException e) {
                int tc = alphaNumComparator.compare(tok1, tok2);
                if (tc == 0) continue;
                return tc;
            }
        }
        if (s1.hasMoreTokens()) {
            return 1;
        }
        if (s2.hasMoreTokens()) {
            return -1;
        }
        return 0;
    }
}

