/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository.items;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import net.sf.robocode.core.Container;
import net.sf.robocode.host.IHostManager;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;
import net.sf.robocode.io.URLJarCollector;
import net.sf.robocode.repository.IRobotRepositoryItem;
import net.sf.robocode.repository.RobotType;
import net.sf.robocode.repository.items.NamedItem;
import net.sf.robocode.repository.root.IRepositoryRoot;
import net.sf.robocode.security.HiddenAccess;
import net.sf.robocode.version.IVersionManager;
import robocode.control.RobotSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RobotItem
extends NamedItem
implements IRobotRepositoryItem {
    private static final long serialVersionUID = 1L;
    private static final int MAX_FULL_PACKAGE_NAME_LENGTH = 32;
    private static final int MAX_SHORT_CLASS_NAME_LENGTH = 32;
    private static final String ROBOT_DESCRIPTION = "robot.description";
    private static final String ROBOT_AUTHOR_NAME = "robot.author.name";
    private static final String ROBOT_JAVA_SOURCE_INCLUDED = "robot.java.source.included";
    private static final String ROBOT_VERSION = "robot.version";
    private static final String ROBOT_LANGUAGE = "robot.language";
    private static final String ROBOT_CLASSNAME = "robot.classname";
    private static final String ROBOT_WEBPAGE = "robot.webpage";
    private static final String ROBOCODE_VERSION = "robocode.version";
    private static final String CLASS_EXTENSION = ".class";
    RobotType robotType;
    private boolean isExpectedRobot;
    private boolean isClassURL;
    private boolean isPropertiesURL;
    private boolean isPropertiesLoaded;
    private boolean alwaysUseCacheForData = System.getProperty("ALWAYSUSECACHEFORDATA", "false").equals("true");
    private URL classURL;
    private URL propertiesURL;
    private URL classPathURL;
    private Set<URL> sourcePathURLs;

    public RobotItem(IRepositoryRoot root) {
        super(root.getRootUrl(), root);
        this.isValid = true;
        this.classPathURL = root.getRootUrl();
        this.sourcePathURLs = new HashSet<URL>();
        this.init();
    }

    protected void init() {
        this.propsUrlFromClassUrl();
        this.classUrlFromProperties();
        this.classUrlFromPropertiesUrl();
        this.classNameFromClassUrl(this.root);
    }

    public void setClassUrl(URL classUrl) {
        this.classURL = classUrl;
        this.isClassURL = classUrl != null;
        this.init();
    }

    public void setPropertiesUrl(URL propertiesUrl) {
        this.propertiesURL = propertiesUrl;
        this.isPropertiesURL = propertiesUrl != null;
        this.init();
    }

    public void setClassPathURL(URL classPathUrl) {
        this.classPathURL = classPathUrl;
    }

    public void addSourcePathURL(URL sourcePathUrl) {
        this.sourcePathURLs.add(sourcePathUrl);
    }

    private void propsUrlFromClassUrl() {
        if (this.propertiesURL == null && this.isClassURL) {
            String pUrl = this.classURL.toString().replaceAll("\\.class", ".properties");
            try {
                this.propertiesURL = new URL(pUrl);
                this.loadProperties();
            }
            catch (MalformedURLException e) {
                Logger.logError((Throwable)e);
            }
        }
    }

    private void classUrlFromProperties() {
        if (this.classURL == null && this.isPropertiesURL) {
            if (!this.loadProperties()) {
                this.isValid = false;
            } else {
                String cn = this.properties.getProperty(ROBOT_CLASSNAME, null);
                if (cn != null) {
                    this.isExpectedRobot = true;
                    try {
                        String cUrl = this.root.getRootUrl().toString() + cn.replace('.', '/') + CLASS_EXTENSION;
                        this.classURL = new URL(cUrl);
                    }
                    catch (MalformedURLException e) {
                        Logger.logError((Throwable)e);
                    }
                } else {
                    this.isValid = false;
                }
            }
        }
    }

    private void classUrlFromPropertiesUrl() {
        if (this.isPropertiesURL) {
            try {
                String pUrl = this.propertiesURL.toString();
                String cUrl = pUrl.substring(0, pUrl.lastIndexOf(46)) + CLASS_EXTENSION;
                this.classURL = new URL(cUrl);
            }
            catch (MalformedURLException e) {
                Logger.logError((Throwable)e);
            }
        }
    }

    private void classNameFromClassUrl(IRepositoryRoot root) {
        if (this.getFullClassName() == null && this.isClassURL) {
            String cUrl = this.classURL.toString();
            cUrl = cUrl.substring(0, cUrl.lastIndexOf(46));
            String cn = cUrl.substring(root.getRootUrl().toString().length()).replace('/', '.').replace('\\', '.');
            this.properties.setProperty(ROBOT_CLASSNAME, cn);
        }
    }

    private void htmlUrlFromPropertiesUrl() {
        try {
            if (this.propertiesURL != null) {
                this.htmlUrl = new URL(this.propertiesURL.toString().replaceAll("\\.properties", ".html"));
                URLConnection conn = URLJarCollector.openConnection((URL)this.htmlUrl);
                conn.getInputStream().close();
            }
        }
        catch (IOException ignored) {
            this.htmlUrl = null;
        }
    }

    private void htmlUrlFromClassUrl() {
        if (this.htmlUrl == null) {
            try {
                if (this.classURL != null) {
                    this.htmlUrl = new URL(this.classURL.toString().replaceAll("\\.class", ".html"));
                    URLConnection conn = URLJarCollector.openConnection((URL)this.htmlUrl);
                    conn.getInputStream().close();
                }
            }
            catch (IOException ignored) {
                this.htmlUrl = null;
            }
        }
    }

    public boolean isTeam() {
        return false;
    }

    @Override
    public URL getHtmlUrl() {
        if (this.htmlUrl == null) {
            this.htmlUrlFromPropertiesUrl();
            this.htmlUrlFromClassUrl();
        }
        return this.htmlUrl;
    }

    @Override
    public URL getPropertiesUrl() {
        return this.propertiesURL;
    }

    @Override
    public List<String> getFriendlyUrls() {
        String noType;
        ArrayList<String> urls = new ArrayList<String>();
        if (this.propertiesURL != null) {
            String pUrl = this.propertiesURL.toString();
            noType = pUrl.substring(0, pUrl.lastIndexOf(46));
            urls.add(pUrl);
            urls.add(noType);
            urls.add(this.propertiesURL.getFile());
        }
        if (this.classURL != null) {
            String cUrl = this.classURL.toString();
            noType = cUrl.substring(0, cUrl.lastIndexOf(46));
            urls.add(noType);
            urls.add(this.classURL.getFile());
        }
        if (this.getFullClassName() != null) {
            urls.add(this.getFullClassName());
            urls.add(this.getUniqueFullClassNameWithVersion());
        }
        if (this.root.isJar()) {
            urls.add(this.root.getRootUrl().toString());
        }
        return urls;
    }

    @Override
    public void update(long lastModified, boolean force) {
        if (lastModified > this.lastModified || force) {
            if (force) {
                this.isValid = true;
            }
            this.init();
            this.lastModified = lastModified;
            if (this.classURL == null) {
                this.isValid = false;
            }
            this.loadProperties();
            if (this.root.isJar() && !this.isPropertiesLoaded) {
                this.isValid = false;
            }
            if (this.isValid) {
                this.validateType(false);
            }
            if (this.isValid) {
                this.verifyName();
            }
        }
    }

    protected void validateType(boolean resolve) {
        IHostManager hostManager = (IHostManager)Container.getComponent(IHostManager.class);
        this.robotType = hostManager.getRobotType((IRobotRepositoryItem)this, resolve, this.isExpectedRobot || this.isClassURL);
        if (!this.robotType.isValid()) {
            this.isValid = false;
        }
    }

    public boolean validate() {
        this.validateType(true);
        return this.isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadProperties() {
        if (this.propertiesURL != null) {
            boolean bl;
            InputStream ios = null;
            try {
                URLConnection con = URLJarCollector.openConnection((URL)this.propertiesURL);
                ios = con.getInputStream();
                this.properties.load(ios);
                this.isPropertiesLoaded = true;
                bl = true;
            }
            catch (IOException e) {
                boolean bl2;
                try {
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    FileUtil.cleanupStream(ios);
                    throw throwable;
                }
                FileUtil.cleanupStream((Object)ios);
                return bl2;
            }
            FileUtil.cleanupStream((Object)ios);
            return bl;
        }
        return false;
    }

    private boolean verifyName() {
        String shortClassName;
        String robotName = this.getFullClassName();
        boolean valid = RobotItem.verifyRobotName(robotName, shortClassName = this.getShortClassName(), this.isExpectedRobot);
        if (!valid) {
            this.isValid = false;
        }
        return valid;
    }

    public static boolean verifyRobotName(String fullClassName, String shortClassName, boolean silent) {
        if (fullClassName == null || fullClassName.length() == 0 || fullClassName.contains("$")) {
            return false;
        }
        int lIndex = fullClassName.indexOf(".");
        if (lIndex > 0) {
            String rootPackage = fullClassName.substring(0, lIndex);
            if (rootPackage.equalsIgnoreCase("robocode")) {
                if (!silent) {
                    Logger.logError((String)("Robot " + fullClassName + " ignored.  You cannot use package " + rootPackage));
                }
                return false;
            }
            if (rootPackage.length() > 32) {
                String message = "Robot " + fullClassName + " has package name too long.  " + 32 + " characters maximum please.";
                if (!silent) {
                    Logger.logError((String)message);
                }
                return false;
            }
        }
        if (shortClassName != null && shortClassName.length() > 32) {
            String message = "Robot " + fullClassName + " has classname too long.  " + 32 + " characters maximum please.";
            if (!silent) {
                Logger.logError((String)message);
            }
            return false;
        }
        return true;
    }

    public void storeProperties(OutputStream os) throws IOException {
        this.properties.store(os, "Robocode Robot");
    }

    public void storeProperties(OutputStream os, URL web, String desc, String author, String version, boolean sourceIncluded) throws IOException {
        Properties copy = (Properties)this.properties.clone();
        if (version != null) {
            copy.setProperty(ROBOT_VERSION, version);
        }
        if (desc != null) {
            copy.setProperty(ROBOT_DESCRIPTION, desc);
        }
        if (author != null) {
            copy.setProperty(ROBOT_AUTHOR_NAME, author);
        }
        if (web != null) {
            copy.setProperty(ROBOT_WEBPAGE, web.toString());
        }
        copy.setProperty(ROBOT_JAVA_SOURCE_INCLUDED, "" + sourceIncluded);
        IVersionManager vm = (IVersionManager)Container.getComponent(IVersionManager.class);
        copy.setProperty(ROBOCODE_VERSION, vm.getVersion());
        copy.store(os, "Robocode Robot");
    }

    public boolean isDroid() {
        return this.robotType.isDroid();
    }

    public boolean isTeamRobot() {
        return this.robotType.isTeamRobot();
    }

    public boolean isAdvancedRobot() {
        return this.robotType.isAdvancedRobot();
    }

    public boolean isStandardRobot() {
        return this.robotType.isStandardRobot();
    }

    public boolean isInteractiveRobot() {
        return this.robotType.isInteractiveRobot();
    }

    public boolean isPaintRobot() {
        return this.robotType.isPaintRobot();
    }

    public boolean isJuniorRobot() {
        return this.robotType.isJuniorRobot();
    }

    public URL getClassPathURL() {
        return this.classPathURL;
    }

    public URL[] getSourcePathURLs() {
        if (this.sourcePathURLs.size() == 0) {
            return new URL[]{this.classPathURL};
        }
        return this.sourcePathURLs.toArray(new URL[0]);
    }

    @Override
    public String getFullClassName() {
        return this.properties.getProperty(ROBOT_CLASSNAME, null);
    }

    @Override
    public String getVersion() {
        return this.properties.getProperty(ROBOT_VERSION, null);
    }

    @Override
    public String getDescription() {
        return this.properties.getProperty(ROBOT_DESCRIPTION, null);
    }

    @Override
    public String getAuthorName() {
        return this.properties.getProperty(ROBOT_AUTHOR_NAME, null);
    }

    public String getRobotLanguage() {
        String lang = this.properties.getProperty(ROBOT_LANGUAGE, null);
        return lang == null ? "java" : lang;
    }

    @Override
    public URL getWebpage() {
        try {
            return new URL(this.properties.getProperty(ROBOT_WEBPAGE, null));
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public boolean getJavaSourceIncluded() {
        return this.properties.getProperty(ROBOT_JAVA_SOURCE_INCLUDED, "false").toLowerCase().equals("true");
    }

    @Override
    public String getRobocodeVersion() {
        return this.properties.getProperty(ROBOCODE_VERSION, null);
    }

    public String getReadableDirectory() {
        if (this.getRootPackage() == null) {
            return null;
        }
        if (this.root.isJar()) {
            String jarFile = this.getClassPathURL().getFile();
            jarFile = jarFile.substring(jarFile.lastIndexOf(47) + 1, jarFile.length());
            return FileUtil.getRobotCacheDir() + File.separator + jarFile + "_" + File.separator + this.getRootPackage();
        }
        return this.getClassPathURL().getFile() + this.getRootPackage();
    }

    public String getWritableDirectory() {
        if (this.getRootPackage() == null) {
            return null;
        }
        if (this.root.isJar()) {
            String jarFile = this.getClassPathURL().getFile();
            jarFile = jarFile.substring(jarFile.lastIndexOf(47) + 1, jarFile.length());
            return FileUtil.getRobotCacheDir() + File.separator + jarFile + "_" + File.separator + this.getFullPackage().replace('.', File.separatorChar);
        }
        File vroot = this.alwaysUseCacheForData ? FileUtil.getRobotCacheDir() : this.root.getRootPath();
        return vroot + File.separator + this.getFullPackage().replace('.', File.separatorChar);
    }

    public RobotSpecification createRobotSpecification(RobotSpecification battleRobotSpec, String teamId) {
        RobotSpecification specification = battleRobotSpec != null ? battleRobotSpec : this.createRobotSpecification();
        if (teamId != null) {
            HiddenAccess.setTeamId((RobotSpecification)specification, (String)teamId);
        }
        return specification;
    }

    public String toString() {
        return this.url.toString();
    }
}

