/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository.items.handlers;

import java.net.URL;
import net.sf.robocode.repository.Database;
import net.sf.robocode.repository.items.IItem;
import net.sf.robocode.repository.items.RobotItem;
import net.sf.robocode.repository.items.handlers.ItemHandler;
import net.sf.robocode.repository.root.IRepositoryRoot;

public class ClassHandler
extends ItemHandler {
    public IItem acceptItem(URL itemURL, IRepositoryRoot root, Database db) {
        String name = itemURL.toString().toLowerCase();
        if (name.endsWith(".class") && !name.contains("$")) {
            return this.register(itemURL, root, db);
        }
        return null;
    }

    private IItem register(URL itemURL, IRepositoryRoot root, Database db) {
        String itemKey = ClassHandler.getItemKey(itemURL, root);
        RobotItem item = (RobotItem)db.getOldItem(itemKey);
        if (item == null) {
            item = (RobotItem)db.getItem(itemKey);
        }
        if (item == null) {
            item = new RobotItem(root);
        }
        item.setClassPathURL(root.getRootUrl());
        item.setClassUrl(itemURL);
        db.putItem(itemKey, item);
        return item;
    }
}

