/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.sound;

import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Mixer;
import net.sf.robocode.battle.IBattleManager;
import net.sf.robocode.settings.ISettingsListener;
import net.sf.robocode.settings.ISettingsManager;
import net.sf.robocode.sound.ISoundManager;
import net.sf.robocode.sound.SoundCache;
import robocode.control.events.BattleAdaptor;
import robocode.control.events.BattleFinishedEvent;
import robocode.control.events.BattleStartedEvent;
import robocode.control.events.IBattleListener;
import robocode.control.events.TurnEndedEvent;
import robocode.control.snapshot.IBulletSnapshot;
import robocode.control.snapshot.IRobotSnapshot;
import robocode.control.snapshot.RobotState;

public class SoundManager
implements ISoundManager {
    private SoundCache sounds;
    private final ISettingsManager properties;
    private final IBattleManager battleManager;
    private boolean isSoundEnabled = true;
    BattleObserver observer;

    public SoundManager(ISettingsManager properties, IBattleManager battleManager) {
        this.battleManager = battleManager;
        this.properties = properties;
        if (this.isSoundEnabled()) {
            this.observer = new BattleObserver();
            battleManager.addListener((IBattleListener)this.observer);
        }
        properties.addPropertyListener(new ISettingsListener(){

            public void settingChanged(String property) {
                if (property.equals("robocode.options.sound.enableSound")) {
                    SoundManager.this.updateListener();
                }
            }
        });
    }

    public Mixer getMixer() {
        return this.findMixer(this.properties.getOptionsSoundMixer());
    }

    private boolean isSoundEnabled() {
        return this.isSoundEnabled && this.properties.getOptionsSoundEnableSound();
    }

    public void setEnableSound(boolean enable) {
        this.isSoundEnabled = enable;
        this.updateListener();
    }

    private void updateListener() {
        if (this.observer == null && this.isSoundEnabled()) {
            this.observer = new BattleObserver();
            this.battleManager.addListener((IBattleListener)this.observer);
        } else if (this.observer != null && !this.isSoundEnabled()) {
            this.battleManager.removeListener((IBattleListener)this.observer);
            this.observer = null;
        }
    }

    private SoundCache getSounds() {
        if (this.sounds == null) {
            this.sounds = new SoundCache(this.getMixer());
            this.sounds.addSound("gunshot", this.properties.getFileGunshotSfx(), 5);
            this.sounds.addSound("robot death", this.properties.getRobotDeathSfx(), 3);
            this.sounds.addSound("bullet hits robot", this.properties.getBulletHitsRobotSfx(), 3);
            this.sounds.addSound("bullet hits bullet", this.properties.getBulletHitsBulletSfx(), 2);
            this.sounds.addSound("robot collision", this.properties.getRobotCollisionSfx(), 2);
            this.sounds.addSound("wall collision", this.properties.getWallCollisionSfx(), 2);
            this.sounds.addSound("theme", this.properties.getFileThemeMusic(), 1);
            this.sounds.addSound("background", this.properties.getFileBackgroundMusic(), 1);
            this.sounds.addSound("endOfBattle", this.properties.getFileEndOfBattleMusic(), 1);
        }
        return this.sounds;
    }

    private Mixer findMixer(String mixerClassName) {
        for (Mixer.Info mi : AudioSystem.getMixerInfo()) {
            Mixer m = AudioSystem.getMixer(mi);
            if (!m.getClass().getSimpleName().equals(mixerClassName)) continue;
            return m;
        }
        return null;
    }

    public void dispose() {
        if (this.sounds != null) {
            this.sounds.clear();
        }
    }

    private void playSound(Object key, float pan, float volume, int loop) {
        Clip c = this.getSounds().getSound(key);
        if (c == null) {
            return;
        }
        if (this.properties.getOptionsSoundEnableMixerPan() && c.isControlSupported(FloatControl.Type.PAN)) {
            FloatControl panCtrl = (FloatControl)c.getControl(FloatControl.Type.PAN);
            panCtrl.setValue(pan);
        }
        if (this.properties.getOptionsSoundEnableMixerVolume() && c.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
            FloatControl volCtrl = (FloatControl)c.getControl(FloatControl.Type.MASTER_GAIN);
            float min = volCtrl.getMinimum() / 4.0f;
            if (volume != 1.0f) {
                volCtrl.setValue(min * (1.0f - volume));
            }
        }
        c.loop(loop);
    }

    private void playSound(Object key, float pan) {
        this.playSound(key, pan, 1.0f, 0);
    }

    private void playMusic(Object key, int loop) {
        this.playSound(key, 0.0f, 1.0f, loop);
    }

    public void playBulletSound(IBulletSnapshot bp, int battleFieldWidth) {
        float pan = 0.0f;
        if (this.properties.getOptionsSoundEnableMixerPan()) {
            pan = this.calcPan((float)bp.getPaintX(), battleFieldWidth);
        }
        switch (bp.getState()) {
            case FIRED: {
                if (!this.properties.getOptionsSoundEnableGunshot()) break;
                this.playSound("gunshot", pan, this.calcBulletVolume(bp), 0);
                break;
            }
            case HIT_VICTIM: {
                if (!this.properties.getOptionsSoundEnableBulletHit()) break;
                this.playSound("bullet hits robot", pan);
                break;
            }
            case HIT_BULLET: {
                if (!this.properties.getOptionsSoundEnableBulletHit()) break;
                this.playSound("bullet hits bullet", pan);
                break;
            }
            case HIT_WALL: {
                break;
            }
            case EXPLODED: {
                if (!this.properties.getOptionsSoundEnableRobotDeath()) break;
                this.playSound("robot death", pan);
            }
        }
    }

    public void playRobotSound(IRobotSnapshot robotPeer, int battleFieldWidth) {
        float pan = 0.0f;
        if (this.properties.getOptionsSoundEnableMixerPan()) {
            pan = this.calcPan((float)robotPeer.getX(), battleFieldWidth);
        }
        switch (robotPeer.getState()) {
            case HIT_ROBOT: {
                if (!this.properties.getOptionsSoundEnableRobotCollision()) break;
                this.playSound("robot collision", pan);
                break;
            }
            case HIT_WALL: {
                if (!this.properties.getOptionsSoundEnableWallCollision()) break;
                this.playSound("wall collision", pan);
            }
        }
    }

    public void playThemeMusic() {
        if (this.isSoundEnabled()) {
            this.playMusic("theme", 0);
        }
    }

    public void playBackgroundMusic() {
        this.playMusic("background", -1);
    }

    public void stopBackgroundMusic() {
        Clip c = this.getSounds().getSound("background");
        if (c != null) {
            c.stop();
        }
    }

    public void playEndOfBattleMusic() {
        this.playMusic("endOfBattle", 0);
    }

    private float calcPan(float x, float width) {
        float semiWidth = width / 2.0f;
        return (x - semiWidth) / semiWidth;
    }

    private float calcBulletVolume(IBulletSnapshot bp) {
        return (float)(bp.getPower() / 3.0);
    }

    private class BattleObserver
    extends BattleAdaptor {
        private BattleObserver() {
        }

        public void onBattleStarted(BattleStartedEvent event) {
            if (SoundManager.this.isSoundEnabled()) {
                SoundManager.this.playBackgroundMusic();
            }
        }

        public void onBattleFinished(BattleFinishedEvent event) {
            SoundManager.this.stopBackgroundMusic();
            if (SoundManager.this.isSoundEnabled()) {
                SoundManager.this.playEndOfBattleMusic();
            }
        }

        public void onTurnEnded(TurnEndedEvent event) {
            if (SoundManager.this.isSoundEnabled()) {
                int battleFieldWidth = SoundManager.this.battleManager.getBattleProperties().getBattlefieldWidth();
                for (IBulletSnapshot bp : event.getTurnSnapshot().getBullets()) {
                    if (bp.getFrame() != 0) continue;
                    SoundManager.this.playBulletSound(bp, battleFieldWidth);
                }
                boolean playedRobotHitRobot = false;
                for (IRobotSnapshot rp : event.getTurnSnapshot().getRobots()) {
                    if (rp.getState() == RobotState.HIT_ROBOT) {
                        if (playedRobotHitRobot) continue;
                        playedRobotHitRobot = true;
                    }
                    SoundManager.this.playRobotSound(rp, battleFieldWidth);
                }
            }
        }
    }
}

