/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.editor;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.sf.robocode.ui.editor.EditWindow;
import net.sf.robocode.ui.editor.RobocodeEditor;

public class FindReplaceDialog
extends JDialog
implements ActionListener {
    private JTextField findField;
    private JTextField replaceField;
    private JButton findNextButton;
    private JButton replaceButton;
    private JButton replaceAllButton;
    private JButton toggleReplaceButton;
    private JButton closeButton;
    private JCheckBox caseSensitiveCheckBox;
    private JCheckBox wholeWordCheckBox;
    private JRadioButton regexButton;
    private JRadioButton wildCardsButton;
    private JRadioButton literalButton;
    private JLabel findLabel;
    private JLabel replaceLabel;
    private boolean initLoc;
    private final RobocodeEditor window;

    public FindReplaceDialog(RobocodeEditor parentFrame) {
        super((Frame)parentFrame, false);
        this.window = parentFrame;
        JPanel bigPanel = new JPanel();
        bigPanel.setLayout(new BoxLayout(bigPanel, 0));
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 1));
        JPanel findReplacePanel = new JPanel();
        findReplacePanel.setLayout(new BoxLayout(findReplacePanel, 0));
        JPanel labelsPanel = new JPanel();
        labelsPanel.setLayout(new BoxLayout(labelsPanel, 1));
        labelsPanel.add(this.getFindLabel());
        labelsPanel.add(this.getReplaceLabel());
        findReplacePanel.add(labelsPanel);
        JPanel fieldsPanel = new JPanel();
        fieldsPanel.setLayout(new BoxLayout(fieldsPanel, 1));
        fieldsPanel.add(this.getFindField());
        fieldsPanel.add(this.getReplaceField());
        findReplacePanel.add(fieldsPanel);
        leftPanel.add(findReplacePanel);
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 0));
        JPanel checkboxPanel = new JPanel();
        checkboxPanel.setLayout(new BoxLayout(checkboxPanel, 1));
        checkboxPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Options"));
        checkboxPanel.add(this.getCaseSensitiveCheckBox());
        checkboxPanel.add(this.getWholeWordCheckBox());
        checkboxPanel.setAlignmentY(0.0f);
        optionsPanel.add(checkboxPanel);
        JPanel radioPanel = new JPanel();
        radioPanel.setLayout(new BoxLayout(radioPanel, 1));
        radioPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Use:"));
        radioPanel.add(this.getLiteralButton());
        radioPanel.add(this.getWildCardsButton());
        radioPanel.add(this.getRegexButton());
        radioPanel.setAlignmentY(0.0f);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.getLiteralButton());
        buttonGroup.add(this.getWildCardsButton());
        buttonGroup.add(this.getRegexButton());
        optionsPanel.add(radioPanel);
        leftPanel.add(optionsPanel);
        leftPanel.setAlignmentY(0.0f);
        bigPanel.add(leftPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        buttonPanel.add(this.getFindNextButton());
        buttonPanel.add(this.getToggleReplaceButton());
        buttonPanel.add(this.getReplaceButton());
        buttonPanel.add(this.getReplaceAllButton());
        buttonPanel.add(this.getCloseButton());
        buttonPanel.setAlignmentY(0.0f);
        bigPanel.add(buttonPanel);
        this.setContentPane(bigPanel);
    }

    public void showDialog(boolean showReplace) {
        this.getReplaceLabel().setVisible(showReplace);
        this.getReplaceField().setVisible(showReplace);
        this.getReplaceButton().setVisible(showReplace);
        this.getReplaceAllButton().setVisible(showReplace);
        if (showReplace) {
            this.setTitle("Replace");
            this.getRootPane().setDefaultButton(this.getReplaceButton());
            this.getToggleReplaceButton().setText("Find...");
            this.getToggleReplaceButton().setMnemonic('d');
            this.getToggleReplaceButton().setDisplayedMnemonicIndex(3);
        } else {
            this.setTitle("Find");
            this.getRootPane().setDefaultButton(this.getFindNextButton());
            this.getToggleReplaceButton().setText("Replace...");
            this.getToggleReplaceButton().setMnemonic('R');
        }
        this.pack();
        if (!this.initLoc) {
            Rectangle bounds = this.window.getBounds();
            Dimension size = this.getSize();
            this.setLocation((int)(bounds.getX() + (bounds.getWidth() - size.getWidth()) / 2.0), (int)(bounds.getY() + (bounds.getHeight() - size.getHeight()) / 2.0));
            this.initLoc = true;
        }
        this.setVisible(true);
    }

    public JLabel getFindLabel() {
        if (this.findLabel == null) {
            this.findLabel = new JLabel();
            this.findLabel.setText(" Find:");
            this.findLabel.setDisplayedMnemonicIndex(3);
        }
        return this.findLabel;
    }

    public JLabel getReplaceLabel() {
        if (this.replaceLabel == null) {
            this.replaceLabel = new JLabel();
            this.replaceLabel.setText(" Replace:");
            this.replaceLabel.setDisplayedMnemonicIndex(3);
        }
        return this.replaceLabel;
    }

    public JTextField getFindField() {
        if (this.findField == null) {
            this.findField = new JTextField();
            this.findField.setFocusAccelerator('n');
            this.findField.addActionListener(this);
        }
        return this.findField;
    }

    public JTextField getReplaceField() {
        if (this.replaceField == null) {
            this.replaceField = new JTextField();
            this.replaceField.setFocusAccelerator('p');
            this.replaceField.addActionListener(this);
        }
        return this.replaceField;
    }

    public JButton getFindNextButton() {
        if (this.findNextButton == null) {
            this.findNextButton = new JButton();
            this.findNextButton.setText("Find Next");
            this.findNextButton.setMnemonic('F');
            this.findNextButton.setDefaultCapable(true);
            this.findNextButton.addActionListener(this);
        }
        return this.findNextButton;
    }

    public JButton getReplaceButton() {
        if (this.replaceButton == null) {
            this.replaceButton = new JButton();
            this.replaceButton.setText("Replace");
            this.replaceButton.setMnemonic('R');
            this.replaceButton.setDefaultCapable(true);
            this.replaceButton.addActionListener(this);
        }
        return this.replaceButton;
    }

    public JButton getReplaceAllButton() {
        if (this.replaceAllButton == null) {
            this.replaceAllButton = new JButton();
            this.replaceAllButton.setText("Replace All");
            this.replaceAllButton.setMnemonic('A');
            this.replaceAllButton.setDisplayedMnemonicIndex(8);
            this.replaceAllButton.addActionListener(this);
        }
        return this.replaceAllButton;
    }

    public JButton getToggleReplaceButton() {
        if (this.toggleReplaceButton == null) {
            this.toggleReplaceButton = new JButton();
            this.toggleReplaceButton.addActionListener(this);
        }
        return this.toggleReplaceButton;
    }

    public JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton();
            this.closeButton.setText("Close");
            this.closeButton.setMnemonic('e');
            this.closeButton.setDisplayedMnemonicIndex(4);
            this.closeButton.addActionListener(this);
        }
        return this.closeButton;
    }

    public JCheckBox getCaseSensitiveCheckBox() {
        if (this.caseSensitiveCheckBox == null) {
            this.caseSensitiveCheckBox = new JCheckBox();
            this.caseSensitiveCheckBox.setText("Case Sensitive");
            this.caseSensitiveCheckBox.setMnemonic('C');
            this.caseSensitiveCheckBox.addActionListener(this);
        }
        return this.caseSensitiveCheckBox;
    }

    public JCheckBox getWholeWordCheckBox() {
        if (this.wholeWordCheckBox == null) {
            this.wholeWordCheckBox = new JCheckBox();
            this.wholeWordCheckBox.setText("Whole Word");
            this.wholeWordCheckBox.setMnemonic('W');
            this.wholeWordCheckBox.addActionListener(this);
        }
        return this.wholeWordCheckBox;
    }

    public JRadioButton getLiteralButton() {
        if (this.literalButton == null) {
            this.literalButton = new JRadioButton();
            this.literalButton.setText("Literal");
            this.literalButton.setMnemonic('L');
            this.literalButton.setSelected(true);
            this.literalButton.addActionListener(this);
        }
        return this.literalButton;
    }

    public JRadioButton getWildCardsButton() {
        if (this.wildCardsButton == null) {
            this.wildCardsButton = new JRadioButton();
            this.wildCardsButton.setText("Wild Cards");
            this.wildCardsButton.setMnemonic('i');
            this.wildCardsButton.setDisplayedMnemonicIndex(1);
            this.wildCardsButton.addActionListener(this);
        }
        return this.wildCardsButton;
    }

    public JRadioButton getRegexButton() {
        if (this.regexButton == null) {
            this.regexButton = new JRadioButton();
            this.regexButton.setText("Regular Expressions");
            this.regexButton.setMnemonic('x');
            this.regexButton.setDisplayedMnemonicIndex(9);
            this.regexButton.addActionListener(this);
        }
        return this.regexButton;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.getFindNextButton()) {
            this.findNext();
        } else if (source == this.getReplaceButton()) {
            this.doReplacement();
            this.findNext();
        } else if (source == this.getReplaceAllButton()) {
            this.doReplaceAll();
        } else if (source == this.getCloseButton()) {
            this.setVisible(false);
        } else if (source == this.getToggleReplaceButton()) {
            this.showDialog(!this.getReplaceButton().isVisible());
        } else if (source instanceof JTextField) {
            this.getRootPane().getDefaultButton().doClick();
        }
    }

    private Pattern getCurrentPattern() {
        String pattern = this.getFindField().getText();
        int flags = 32;
        if (!this.getRegexButton().isSelected()) {
            String newpattern = "";
            for (int i = 0; i < pattern.length(); ++i) {
                if ("\\[]^$&|().*+?{}".indexOf(pattern.charAt(i)) >= 0) {
                    newpattern = newpattern + '\\';
                }
                newpattern = newpattern + pattern.charAt(i);
            }
            if (this.getWildCardsButton().isSelected()) {
                newpattern = newpattern.replaceAll("\\\\\\*", ".+?");
                newpattern = newpattern.replaceAll("\\\\\\?", ".");
            }
            pattern = newpattern;
        }
        if (!this.getCaseSensitiveCheckBox().isSelected()) {
            flags |= 2;
        }
        if (this.getWholeWordCheckBox().isSelected()) {
            pattern = "\\b" + pattern + "\\b";
        }
        return Pattern.compile(pattern, flags);
    }

    public void findNext() {
        int index;
        JEditorPane editorPane;
        String text;
        EditWindow currentWindow = this.window.getActiveWindow();
        if (currentWindow == null || this.getFindField().getText().length() == 0) {
            return;
        }
        Pattern p = this.getCurrentPattern();
        Matcher m = p.matcher(text = (editorPane = currentWindow.getEditorPane()).getText().replaceAll("\\r", ""));
        if (!m.find(index = editorPane.getSelectionEnd()) && !m.find()) {
            return;
        }
        editorPane.setSelectionStart(m.start());
        editorPane.setSelectionEnd(m.end());
    }

    public void doReplacement() {
        EditWindow currentWindow = this.window.getActiveWindow();
        if (currentWindow == null || this.getFindField().getText().length() == 0) {
            return;
        }
        JEditorPane editorPane = currentWindow.getEditorPane();
        String text = editorPane.getSelectedText();
        if (text == null) {
            return;
        }
        Matcher m = this.getCurrentPattern().matcher(text);
        if (m.matches()) {
            String replacement = this.getReplaceField().getText();
            if (this.getRegexButton().isSelected()) {
                replacement = m.replaceFirst(replacement);
            }
            editorPane.replaceSelection(replacement);
        }
    }

    public void doReplaceAll() {
        EditWindow currentWindow = this.window.getActiveWindow();
        if (currentWindow == null || this.getFindField().getText().length() == 0) {
            return;
        }
        JEditorPane editorPane = currentWindow.getEditorPane();
        String text = editorPane.getText();
        String replacement = this.getReplaceField().getText();
        editorPane.setText(this.getCurrentPattern().matcher(text).replaceAll(replacement));
    }
}

