/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sf.robocode.ui.editor.RobocodeEditor;
import net.sf.robocode.ui.editor.WindowMenuItem;

public class MoreWindowsDialog
extends JDialog
implements ActionListener,
MouseListener {
    private JButton activateButton;
    private JButton cancelButton;
    private JButton closeButton;
    private JList windowList;
    private final Vector<WindowMenuItem> windowListItems = new Vector();

    public MoreWindowsDialog(RobocodeEditor window) {
        super(window, "More Windows...", false);
        JPanel listPanel = new JPanel(new GridLayout(1, 1));
        listPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Open Windows"));
        listPanel.add(new JScrollPane(this.getWindowList()));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(this.getActivateButton());
        buttonPanel.add(this.getCancelButton());
        buttonPanel.add(this.getCloseButton());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)buttonPanel, "South");
        this.getContentPane().add(listPanel);
        this.setSize(400, 400);
    }

    public void addWindowItem(WindowMenuItem item) {
        this.windowListItems.add(item);
        this.getWindowList().setListData(this.windowListItems);
    }

    public void removeWindowItem(WindowMenuItem item) {
        this.windowListItems.remove(item);
        this.getWindowList().setListData(this.windowListItems);
    }

    public JButton getActivateButton() {
        if (this.activateButton == null) {
            this.activateButton = new JButton();
            this.activateButton.setText("Activate");
            this.activateButton.setMnemonic('A');
            this.activateButton.setDefaultCapable(true);
            this.activateButton.addActionListener(this);
        }
        return this.activateButton;
    }

    public JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.setMnemonic('C');
            this.cancelButton.addActionListener(this);
        }
        return this.cancelButton;
    }

    public JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton();
            this.closeButton.setText("Close");
            this.closeButton.setMnemonic('l');
            this.closeButton.setDisplayedMnemonicIndex(1);
            this.closeButton.addActionListener(this);
        }
        return this.closeButton;
    }

    public JList getWindowList() {
        if (this.windowList == null) {
            this.windowList = new JList();
            this.windowList.addMouseListener(this);
            this.windowList.setSelectionMode(0);
        }
        return this.windowList;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.closeButton) {
            WindowMenuItem item = (WindowMenuItem)this.windowList.getSelectedValue();
            if (item != null && item.getEditWindow() != null) {
                item.getEditWindow().doDefaultCloseAction();
            }
        } else {
            WindowMenuItem item;
            if (e.getSource() == this.activateButton && (item = (WindowMenuItem)this.windowList.getSelectedValue()) != null) {
                item.actionPerformed(null);
            }
            this.setVisible(false);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.getWindowList() && e.getClickCount() == 2) {
            WindowMenuItem item = this.windowListItems.get(this.windowList.locationToIndex(e.getPoint()));
            item.actionPerformed(null);
            this.setVisible(false);
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

