/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.editor;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import net.sf.robocode.ui.dialog.WindowUtil;
import net.sf.robocode.ui.editor.CompilerPreferencesDialog;
import net.sf.robocode.ui.editor.EditWindow;
import net.sf.robocode.ui.editor.MoreWindowsDialog;
import net.sf.robocode.ui.editor.RobocodeEditor;
import net.sf.robocode.ui.editor.WindowMenuItem;
import net.sf.robocode.ui.util.ShortcutUtil;

public class RobocodeEditorMenuBar
extends JMenuBar {
    private JMenu fileMenu;
    private JMenuItem fileOpenMenuItem;
    private JMenuItem fileExtractMenuItem;
    private JMenuItem fileSaveMenuItem;
    private JMenuItem fileSaveAsMenuItem;
    private JMenuItem fileExitMenuItem;
    private JMenuItem compilerCompileMenuItem;
    private JMenu compilerMenu;
    private JMenu compilerOptionsMenu;
    private JMenuItem compilerOptionsPreferencesMenuItem;
    private JMenuItem compilerOptionsResetCompilerMenuItem;
    private final RobocodeEditor editor;
    private final EventHandler eventHandler = new EventHandler();
    private JMenuItem fileNewJavaFileMenuItem;
    private JMenu fileNewMenu;
    private JMenuItem fileNewRobotMenuItem;
    private JMenu helpMenu;
    private JMenuItem helpRobocodeApiMenuItem;
    private JMenu editMenu;
    private JMenuItem editUndoMenuItem;
    private JMenuItem editRedoMenuItem;
    private JMenuItem editCutMenuItem;
    private JMenuItem editCopyMenuItem;
    private JMenuItem editPasteMenuItem;
    private JMenuItem editDeleteMenuItem;
    private JMenuItem editFindMenuItem;
    private JMenuItem editFindNextMenuItem;
    private JMenuItem editReplaceMenuItem;
    private JMenuItem editSelectAllMenuItem;
    private JMenu windowMenu;
    private JMenuItem windowCloseMenuItem;
    private JMenuItem windowCloseAllMenuItem;
    private JMenuItem windowWindowsDialogMenuItem;
    private MoreWindowsDialog moreWindowsDialog;

    public RobocodeEditorMenuBar(RobocodeEditor editor) {
        this.editor = editor;
        this.initialize();
    }

    private void compilerCompileActionPerformed() {
        EditWindow editWindow = this.editor.getActiveWindow();
        if (editWindow != null) {
            editWindow.compile();
        }
    }

    private void compilerOptionsPreferencesActionPerformed() {
        CompilerPreferencesDialog d = new CompilerPreferencesDialog(this.editor);
        WindowUtil.packCenterShow((Window)this.editor, (Window)d);
    }

    private void compilerOptionsResetCompilerActionPerformed() {
        if (JOptionPane.showConfirmDialog(this.editor, "You are about to reset the compiler preferences.  Do you wish to proceed?", "Reset Compiler Preferences", 0, 3) == 1) {
            return;
        }
        new Thread(new Runnable(){

            public void run() {
                RobocodeEditorMenuBar.this.editor.resetCompilerProperties();
            }
        }).start();
    }

    private void fileExitActionPerformed() {
        this.editor.dispose();
    }

    private void fileNewJavaFileActionPerformed() {
        this.editor.createNewJavaFile();
        this.getFileSaveMenuItem().setEnabled(true);
        this.getFileSaveAsMenuItem().setEnabled(true);
    }

    private void fileNewRobotActionPerformed() {
        this.editor.createNewRobot();
        this.getFileSaveMenuItem().setEnabled(true);
        this.getFileSaveAsMenuItem().setEnabled(true);
    }

    private void fileOpenActionPerformed() {
        this.editor.openRobot();
    }

    private void fileExtractActionPerformed() {
        this.editor.extractRobot();
    }

    private void fileSaveActionPerformed() {
        this.editor.saveRobot();
    }

    private void fileSaveAsActionPerformed() {
        this.editor.saveAsRobot();
    }

    private void editUndoActionPerformed() {
        EditWindow editWindow = this.editor.getActiveWindow();
        if (editWindow != null) {
            editWindow.undo();
        }
    }

    private void editRedoActionPerformed() {
        EditWindow editWindow = this.editor.getActiveWindow();
        if (editWindow != null) {
            editWindow.redo();
        }
    }

    private void editCutActionPerformed() {
        EditWindow editWindow = this.editor.getActiveWindow();
        if (editWindow != null) {
            editWindow.getEditorPane().cut();
        }
    }

    private void editCopyActionPerformed() {
        EditWindow editWindow = this.editor.getActiveWindow();
        if (editWindow != null) {
            editWindow.getEditorPane().copy();
        }
    }

    private void editPasteActionPerformed() {
        EditWindow editWindow = this.editor.getActiveWindow();
        if (editWindow != null) {
            editWindow.getEditorPane().paste();
        }
    }

    private void editDeleteActionPerformed() {
        EditWindow editWindow = this.editor.getActiveWindow();
        if (editWindow != null) {
            editWindow.getEditorPane().replaceSelection(null);
        }
    }

    private void editSelectAllActionPerformed() {
        EditWindow editWindow = this.editor.getActiveWindow();
        if (editWindow != null) {
            editWindow.getEditorPane().selectAll();
        }
    }

    private void editFindActionPerformed() {
        this.editor.findDialog();
    }

    private void editReplaceActionPerformed() {
        this.editor.replaceDialog();
    }

    private void editFindNextActionPerformed() {
        this.editor.getFindReplaceDialog().findNext();
    }

    private void windowCloseActionPerformed() {
        EditWindow editWindow = this.editor.getActiveWindow();
        if (editWindow != null) {
            editWindow.doDefaultCloseAction();
        }
    }

    private void windowCloseAllActionPerformed() {
        JInternalFrame[] frames = this.editor.getDesktopPane().getAllFrames();
        if (frames != null) {
            for (JInternalFrame frame : frames) {
                frame.doDefaultCloseAction();
            }
        }
    }

    private void windowMoreWindowsActionPerformed() {
        this.getMoreWindowsDialog().setVisible(true);
    }

    private JMenuItem getCompilerCompileMenuItem() {
        if (this.compilerCompileMenuItem == null) {
            this.compilerCompileMenuItem = new JMenuItem();
            this.compilerCompileMenuItem.setText("Compile");
            this.compilerCompileMenuItem.setMnemonic('m');
            this.compilerCompileMenuItem.setDisplayedMnemonicIndex(2);
            this.compilerCompileMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, ShortcutUtil.MENU_SHORTCUT_KEY_MASK));
            this.compilerCompileMenuItem.addActionListener(this.eventHandler);
        }
        return this.compilerCompileMenuItem;
    }

    private JMenu getCompilerMenu() {
        if (this.compilerMenu == null) {
            this.compilerMenu = new JMenu();
            this.compilerMenu.setText("Compiler");
            this.compilerMenu.setMnemonic('C');
            this.compilerMenu.add(this.getCompilerCompileMenuItem());
            this.compilerMenu.add(this.getCompilerOptionsMenu());
        }
        return this.compilerMenu;
    }

    private JMenu getCompilerOptionsMenu() {
        if (this.compilerOptionsMenu == null) {
            this.compilerOptionsMenu = new JMenu();
            this.compilerOptionsMenu.setText("Options");
            this.compilerOptionsMenu.setMnemonic('O');
            this.compilerOptionsMenu.add(this.getCompilerOptionsPreferencesMenuItem());
            this.compilerOptionsMenu.add(this.getCompilerOptionsResetCompilerMenuItem());
        }
        return this.compilerOptionsMenu;
    }

    private JMenuItem getCompilerOptionsPreferencesMenuItem() {
        if (this.compilerOptionsPreferencesMenuItem == null) {
            this.compilerOptionsPreferencesMenuItem = new JMenuItem();
            this.compilerOptionsPreferencesMenuItem.setText("Preferences");
            this.compilerOptionsPreferencesMenuItem.setMnemonic('P');
            this.compilerOptionsPreferencesMenuItem.addActionListener(this.eventHandler);
        }
        return this.compilerOptionsPreferencesMenuItem;
    }

    private JMenuItem getCompilerOptionsResetCompilerMenuItem() {
        if (this.compilerOptionsResetCompilerMenuItem == null) {
            this.compilerOptionsResetCompilerMenuItem = new JMenuItem();
            this.compilerOptionsResetCompilerMenuItem.setText("Reset Compiler");
            this.compilerOptionsResetCompilerMenuItem.setMnemonic('R');
            this.compilerOptionsResetCompilerMenuItem.addActionListener(this.eventHandler);
        }
        return this.compilerOptionsResetCompilerMenuItem;
    }

    private JMenuItem getFileExitMenuItem() {
        if (this.fileExitMenuItem == null) {
            this.fileExitMenuItem = new JMenuItem();
            this.fileExitMenuItem.setText("Exit");
            this.fileExitMenuItem.setMnemonic('x');
            this.fileExitMenuItem.setDisplayedMnemonicIndex(1);
            this.fileExitMenuItem.addActionListener(this.eventHandler);
        }
        return this.fileExitMenuItem;
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.setText("File");
            this.fileMenu.setMnemonic('F');
            this.fileMenu.add(this.getFileNewMenu());
            this.fileMenu.add(this.getFileOpenMenuItem());
            this.fileMenu.add(this.getFileExtractMenuItem());
            this.fileMenu.add(this.getFileSaveMenuItem());
            this.fileMenu.add(this.getFileSaveAsMenuItem());
            this.fileMenu.add(new JSeparator());
            this.fileMenu.add(this.getFileExitMenuItem());
        }
        return this.fileMenu;
    }

    private JMenuItem getFileNewJavaFileMenuItem() {
        if (this.fileNewJavaFileMenuItem == null) {
            this.fileNewJavaFileMenuItem = new JMenuItem();
            this.fileNewJavaFileMenuItem.setText("Java File");
            this.fileNewJavaFileMenuItem.setMnemonic('J');
            this.fileNewJavaFileMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, ShortcutUtil.MENU_SHORTCUT_KEY_MASK | 1));
            this.fileNewJavaFileMenuItem.addActionListener(this.eventHandler);
        }
        return this.fileNewJavaFileMenuItem;
    }

    private JMenu getFileNewMenu() {
        if (this.fileNewMenu == null) {
            this.fileNewMenu = new JMenu();
            this.fileNewMenu.setText("New");
            this.fileNewMenu.setMnemonic('N');
            this.fileNewMenu.add(this.getFileNewRobotMenuItem());
            this.fileNewMenu.add(this.getFileNewJavaFileMenuItem());
        }
        return this.fileNewMenu;
    }

    private JMenuItem getFileNewRobotMenuItem() {
        if (this.fileNewRobotMenuItem == null) {
            this.fileNewRobotMenuItem = new JMenuItem();
            this.fileNewRobotMenuItem.setText("Robot");
            this.fileNewRobotMenuItem.setMnemonic('R');
            this.fileNewRobotMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, ShortcutUtil.MENU_SHORTCUT_KEY_MASK));
            this.fileNewRobotMenuItem.addActionListener(this.eventHandler);
        }
        return this.fileNewRobotMenuItem;
    }

    private JMenuItem getFileOpenMenuItem() {
        if (this.fileOpenMenuItem == null) {
            this.fileOpenMenuItem = new JMenuItem();
            this.fileOpenMenuItem.setText("Open");
            this.fileOpenMenuItem.setMnemonic('O');
            this.fileOpenMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, ShortcutUtil.MENU_SHORTCUT_KEY_MASK));
            this.fileOpenMenuItem.addActionListener(this.eventHandler);
        }
        return this.fileOpenMenuItem;
    }

    private JMenuItem getFileExtractMenuItem() {
        if (this.fileExtractMenuItem == null) {
            this.fileExtractMenuItem = new JMenuItem();
            this.fileExtractMenuItem.setText("Extract downloaded robot for editing");
            this.fileExtractMenuItem.setMnemonic('t');
            this.fileExtractMenuItem.setDisplayedMnemonicIndex(2);
            this.fileExtractMenuItem.addActionListener(this.eventHandler);
        }
        return this.fileExtractMenuItem;
    }

    public JMenuItem getFileSaveAsMenuItem() {
        if (this.fileSaveAsMenuItem == null) {
            this.fileSaveAsMenuItem = new JMenuItem();
            this.fileSaveAsMenuItem.setText("Save As");
            this.fileSaveAsMenuItem.setMnemonic('A');
            this.fileSaveAsMenuItem.setDisplayedMnemonicIndex(5);
            this.fileSaveAsMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, ShortcutUtil.MENU_SHORTCUT_KEY_MASK | 1));
            this.fileSaveAsMenuItem.addActionListener(this.eventHandler);
            this.fileSaveAsMenuItem.setEnabled(false);
        }
        return this.fileSaveAsMenuItem;
    }

    public JMenuItem getFileSaveMenuItem() {
        if (this.fileSaveMenuItem == null) {
            this.fileSaveMenuItem = new JMenuItem();
            this.fileSaveMenuItem.setText("Save");
            this.fileSaveMenuItem.setMnemonic('S');
            this.fileSaveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, ShortcutUtil.MENU_SHORTCUT_KEY_MASK));
            this.fileSaveMenuItem.addActionListener(this.eventHandler);
            this.fileSaveMenuItem.setEnabled(false);
        }
        return this.fileSaveMenuItem;
    }

    public JMenu getHelpMenu() {
        if (this.helpMenu == null) {
            this.helpMenu = new JMenu();
            this.helpMenu.setText("Help");
            this.helpMenu.setMnemonic('H');
            this.helpMenu.add(this.getHelpRobocodeApiMenuItem());
        }
        return this.helpMenu;
    }

    private JMenuItem getHelpRobocodeApiMenuItem() {
        if (this.helpRobocodeApiMenuItem == null) {
            this.helpRobocodeApiMenuItem = new JMenuItem();
            this.helpRobocodeApiMenuItem.setText("Robocode API");
            this.helpRobocodeApiMenuItem.setMnemonic('A');
            this.helpRobocodeApiMenuItem.setDisplayedMnemonicIndex(9);
            this.helpRobocodeApiMenuItem.addActionListener(this.eventHandler);
        }
        return this.helpRobocodeApiMenuItem;
    }

    private JMenu getEditMenu() {
        if (this.editMenu == null) {
            this.editMenu = new JMenu();
            this.editMenu.setText("Edit");
            this.editMenu.setMnemonic('E');
            this.editMenu.add(this.getEditUndoMenuItem());
            this.editMenu.add(this.getEditRedoMenuItem());
            this.editMenu.addSeparator();
            this.editMenu.add(this.getEditCutMenuItem());
            this.editMenu.add(this.getEditCopyMenuItem());
            this.editMenu.add(this.getEditPasteMenuItem());
            this.editMenu.add(this.getEditDeleteMenuItem());
            this.editMenu.addSeparator();
            this.editMenu.add(this.getEditFindMenuItem());
            this.editMenu.add(this.getEditFindNextMenuItem());
            this.editMenu.add(this.getEditReplaceMenuItem());
            this.editMenu.addSeparator();
            this.editMenu.add(this.getEditSelectAllMenuItem());
        }
        return this.editMenu;
    }

    private JMenuItem getEditUndoMenuItem() {
        if (this.editUndoMenuItem == null) {
            this.editUndoMenuItem = new JMenuItem();
            this.editUndoMenuItem.setText("Undo");
            this.editUndoMenuItem.setMnemonic('U');
            this.editUndoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, ShortcutUtil.MENU_SHORTCUT_KEY_MASK));
            this.editUndoMenuItem.addActionListener(this.eventHandler);
        }
        return this.editUndoMenuItem;
    }

    private JMenuItem getEditRedoMenuItem() {
        if (this.editRedoMenuItem == null) {
            this.editRedoMenuItem = new JMenuItem();
            this.editRedoMenuItem.setText("Redo");
            this.editRedoMenuItem.setMnemonic('R');
            this.editRedoMenuItem.setAccelerator(KeyStroke.getKeyStroke(89, ShortcutUtil.MENU_SHORTCUT_KEY_MASK));
            this.editRedoMenuItem.addActionListener(this.eventHandler);
        }
        return this.editRedoMenuItem;
    }

    private JMenuItem getEditCutMenuItem() {
        if (this.editCutMenuItem == null) {
            this.editCutMenuItem = new JMenuItem();
            this.editCutMenuItem.setText("Cut");
            this.editCutMenuItem.setMnemonic('t');
            this.editCutMenuItem.setDisplayedMnemonicIndex(2);
            this.editCutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, ShortcutUtil.MENU_SHORTCUT_KEY_MASK));
            this.editCutMenuItem.addActionListener(this.eventHandler);
        }
        return this.editCutMenuItem;
    }

    private JMenuItem getEditCopyMenuItem() {
        if (this.editCopyMenuItem == null) {
            this.editCopyMenuItem = new JMenuItem();
            this.editCopyMenuItem.setText("Copy");
            this.editCopyMenuItem.setMnemonic('C');
            this.editCopyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, ShortcutUtil.MENU_SHORTCUT_KEY_MASK));
            this.editCopyMenuItem.addActionListener(this.eventHandler);
        }
        return this.editCopyMenuItem;
    }

    private JMenuItem getEditPasteMenuItem() {
        if (this.editPasteMenuItem == null) {
            this.editPasteMenuItem = new JMenuItem();
            this.editPasteMenuItem.setText("Paste");
            this.editPasteMenuItem.setMnemonic('P');
            this.editPasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, ShortcutUtil.MENU_SHORTCUT_KEY_MASK));
            this.editPasteMenuItem.addActionListener(this.eventHandler);
        }
        return this.editPasteMenuItem;
    }

    private JMenuItem getEditDeleteMenuItem() {
        if (this.editDeleteMenuItem == null) {
            this.editDeleteMenuItem = new JMenuItem();
            this.editDeleteMenuItem.setText("Delete");
            this.editDeleteMenuItem.setMnemonic('l');
            this.editDeleteMenuItem.setDisplayedMnemonicIndex(2);
            this.editDeleteMenuItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
            this.editDeleteMenuItem.addActionListener(this.eventHandler);
        }
        return this.editDeleteMenuItem;
    }

    private JMenuItem getEditFindMenuItem() {
        if (this.editFindMenuItem == null) {
            this.editFindMenuItem = new JMenuItem();
            this.editFindMenuItem.setText("Find...");
            this.editFindMenuItem.setMnemonic('F');
            this.editFindMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, ShortcutUtil.MENU_SHORTCUT_KEY_MASK));
            this.editFindMenuItem.addActionListener(this.eventHandler);
        }
        return this.editFindMenuItem;
    }

    private JMenuItem getEditFindNextMenuItem() {
        if (this.editFindNextMenuItem == null) {
            this.editFindNextMenuItem = new JMenuItem();
            this.editFindNextMenuItem.setText("Find Next");
            this.editFindNextMenuItem.setMnemonic('N');
            this.editFindNextMenuItem.setDisplayedMnemonicIndex(5);
            this.editFindNextMenuItem.setAccelerator(KeyStroke.getKeyStroke(71, ShortcutUtil.MENU_SHORTCUT_KEY_MASK));
            this.editFindNextMenuItem.addActionListener(this.eventHandler);
        }
        return this.editFindNextMenuItem;
    }

    private JMenuItem getEditReplaceMenuItem() {
        if (this.editReplaceMenuItem == null) {
            this.editReplaceMenuItem = new JMenuItem();
            this.editReplaceMenuItem.setText("Replace...");
            this.editReplaceMenuItem.setMnemonic('R');
            this.editReplaceMenuItem.setAccelerator(KeyStroke.getKeyStroke(72, ShortcutUtil.MENU_SHORTCUT_KEY_MASK));
            this.editReplaceMenuItem.addActionListener(this.eventHandler);
        }
        return this.editReplaceMenuItem;
    }

    private JMenuItem getEditSelectAllMenuItem() {
        if (this.editSelectAllMenuItem == null) {
            this.editSelectAllMenuItem = new JMenuItem();
            this.editSelectAllMenuItem.setText("Select All");
            this.editSelectAllMenuItem.setMnemonic('A');
            this.editSelectAllMenuItem.setDisplayedMnemonicIndex(7);
            this.editSelectAllMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, ShortcutUtil.MENU_SHORTCUT_KEY_MASK));
            this.editSelectAllMenuItem.addActionListener(this.eventHandler);
        }
        return this.editSelectAllMenuItem;
    }

    public JMenu getWindowMenu() {
        if (this.windowMenu == null) {
            this.windowMenu = new JMenu();
            this.windowMenu.setText("Window");
            this.windowMenu.setMnemonic('W');
            this.windowMenu.add(this.getWindowCloseMenuItem());
            this.windowMenu.add(this.getWindowCloseAllMenuItem());
            this.windowMenu.addSeparator();
            this.windowMenu.add(this.getWindowWindowsDialogMenuItem());
        }
        return this.windowMenu;
    }

    private JMenuItem getWindowCloseMenuItem() {
        if (this.windowCloseMenuItem == null) {
            this.windowCloseMenuItem = new JMenuItem();
            this.windowCloseMenuItem.setText("Close");
            this.windowCloseMenuItem.setMnemonic('C');
            this.windowCloseMenuItem.addActionListener(this.eventHandler);
        }
        return this.windowCloseMenuItem;
    }

    private JMenuItem getWindowCloseAllMenuItem() {
        if (this.windowCloseAllMenuItem == null) {
            this.windowCloseAllMenuItem = new JMenuItem();
            this.windowCloseAllMenuItem.setText("Close All");
            this.windowCloseAllMenuItem.setMnemonic('A');
            this.windowCloseAllMenuItem.setDisplayedMnemonicIndex(6);
            this.windowCloseAllMenuItem.addActionListener(this.eventHandler);
        }
        return this.windowCloseAllMenuItem;
    }

    private JMenuItem getWindowWindowsDialogMenuItem() {
        if (this.windowWindowsDialogMenuItem == null) {
            this.windowWindowsDialogMenuItem = new WindowMenuItem();
            this.windowWindowsDialogMenuItem.addActionListener(this.eventHandler);
        }
        return this.windowWindowsDialogMenuItem;
    }

    public MoreWindowsDialog getMoreWindowsDialog() {
        if (this.moreWindowsDialog == null) {
            this.moreWindowsDialog = new MoreWindowsDialog(this.editor);
        }
        return this.moreWindowsDialog;
    }

    private void helpRobocodeApiActionPerformed() {
        this.editor.showHelpApi();
    }

    private void initialize() {
        this.add(this.getFileMenu());
        this.add(this.getEditMenu());
        this.add(this.getCompilerMenu());
        this.add(this.getWindowMenu());
        this.add(this.getHelpMenu());
    }

    private class EventHandler
    implements ActionListener {
        private EventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == RobocodeEditorMenuBar.this.getFileNewRobotMenuItem()) {
                RobocodeEditorMenuBar.this.fileNewRobotActionPerformed();
            } else if (source == RobocodeEditorMenuBar.this.getFileNewJavaFileMenuItem()) {
                RobocodeEditorMenuBar.this.fileNewJavaFileActionPerformed();
            } else if (source == RobocodeEditorMenuBar.this.getFileOpenMenuItem()) {
                RobocodeEditorMenuBar.this.fileOpenActionPerformed();
            } else if (source == RobocodeEditorMenuBar.this.getFileExtractMenuItem()) {
                RobocodeEditorMenuBar.this.fileExtractActionPerformed();
            } else if (source == RobocodeEditorMenuBar.this.getFileSaveMenuItem()) {
                RobocodeEditorMenuBar.this.fileSaveActionPerformed();
            } else if (source == RobocodeEditorMenuBar.this.getFileSaveAsMenuItem()) {
                RobocodeEditorMenuBar.this.fileSaveAsActionPerformed();
            } else if (source == RobocodeEditorMenuBar.this.getFileExitMenuItem()) {
                RobocodeEditorMenuBar.this.fileExitActionPerformed();
            } else if (source == RobocodeEditorMenuBar.this.getCompilerCompileMenuItem()) {
                RobocodeEditorMenuBar.this.compilerCompileActionPerformed();
            } else if (source == RobocodeEditorMenuBar.this.getCompilerOptionsPreferencesMenuItem()) {
                RobocodeEditorMenuBar.this.compilerOptionsPreferencesActionPerformed();
            } else if (source == RobocodeEditorMenuBar.this.getCompilerOptionsResetCompilerMenuItem()) {
                RobocodeEditorMenuBar.this.compilerOptionsResetCompilerActionPerformed();
            } else if (source == RobocodeEditorMenuBar.this.getHelpRobocodeApiMenuItem()) {
                RobocodeEditorMenuBar.this.helpRobocodeApiActionPerformed();
            } else if (source == RobocodeEditorMenuBar.this.getEditUndoMenuItem()) {
                RobocodeEditorMenuBar.this.editUndoActionPerformed();
            } else if (source == RobocodeEditorMenuBar.this.getEditRedoMenuItem()) {
                RobocodeEditorMenuBar.this.editRedoActionPerformed();
            } else if (source == RobocodeEditorMenuBar.this.getEditCutMenuItem()) {
                RobocodeEditorMenuBar.this.editCutActionPerformed();
            } else if (source == RobocodeEditorMenuBar.this.getEditCopyMenuItem()) {
                RobocodeEditorMenuBar.this.editCopyActionPerformed();
            } else if (source == RobocodeEditorMenuBar.this.getEditPasteMenuItem()) {
                RobocodeEditorMenuBar.this.editPasteActionPerformed();
            } else if (source == RobocodeEditorMenuBar.this.getEditDeleteMenuItem()) {
                RobocodeEditorMenuBar.this.editDeleteActionPerformed();
            } else if (source == RobocodeEditorMenuBar.this.getEditSelectAllMenuItem()) {
                RobocodeEditorMenuBar.this.editSelectAllActionPerformed();
            } else if (source == RobocodeEditorMenuBar.this.getEditFindMenuItem()) {
                RobocodeEditorMenuBar.this.editFindActionPerformed();
            } else if (source == RobocodeEditorMenuBar.this.getEditFindNextMenuItem()) {
                RobocodeEditorMenuBar.this.editFindNextActionPerformed();
            } else if (source == RobocodeEditorMenuBar.this.getEditReplaceMenuItem()) {
                RobocodeEditorMenuBar.this.editReplaceActionPerformed();
            } else if (source == RobocodeEditorMenuBar.this.getWindowCloseMenuItem()) {
                RobocodeEditorMenuBar.this.windowCloseActionPerformed();
            } else if (source == RobocodeEditorMenuBar.this.getWindowCloseAllMenuItem()) {
                RobocodeEditorMenuBar.this.windowCloseAllActionPerformed();
            } else if (source == RobocodeEditorMenuBar.this.getWindowWindowsDialogMenuItem()) {
                RobocodeEditorMenuBar.this.windowMoreWindowsActionPerformed();
            }
        }
    }
}

