/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.robocode.repository.INamedFileSpecification;
import net.sf.robocode.repository.ITeamFileSpecificationExt;
import net.sf.robocode.ui.dialog.RobotSelectionPanel;
import net.sf.robocode.ui.util.ShortcutUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvailableRobotsPanel
extends JPanel {
    private final List<INamedFileSpecification> availableRobots = new CopyOnWriteArrayList<INamedFileSpecification>();
    private List<INamedFileSpecification> robotList = new CopyOnWriteArrayList<INamedFileSpecification>();
    private final List<String> availablePackages = new CopyOnWriteArrayList<String>();
    private JScrollPane availableRobotsScrollPane;
    private JList availableRobotsList;
    private final JButton actionButton;
    private final JList actionList;
    private JList availablePackagesList;
    private JScrollPane availablePackagesScrollPane;
    private RobotNameCellRenderer robotNamesCellRenderer;
    private final RobotSelectionPanel robotSelectionPanel;
    private final String title;
    private final EventHandler eventHandler = new EventHandler();

    public AvailableRobotsPanel(JButton actionButton, String title, JList actionList, RobotSelectionPanel robotSelectionPanel) {
        this.title = title;
        this.actionButton = actionButton;
        this.actionList = actionList;
        this.robotSelectionPanel = robotSelectionPanel;
        this.initialize();
    }

    private void initialize() {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.title));
        this.setLayout(new BorderLayout());
        JPanel top = new JPanel();
        top.setLayout(new GridLayout(1, 2));
        JPanel a = new JPanel();
        a.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Packages"));
        a.setLayout(new BorderLayout());
        a.add(this.getAvailablePackagesScrollPane());
        a.setPreferredSize(new Dimension(120, 100));
        top.add(a);
        JPanel b = new JPanel();
        b.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Robots"));
        b.setLayout(new BorderLayout());
        b.add(this.getAvailableRobotsScrollPane());
        b.setPreferredSize(new Dimension(120, 100));
        top.add(b);
        this.add((Component)top, "Center");
        JLabel refreshLabel = new JLabel("Press " + ShortcutUtil.getModifierKeyText() + "+R to refresh");
        refreshLabel.setHorizontalAlignment(0);
        this.add((Component)refreshLabel, "South");
    }

    public List<INamedFileSpecification> getAvailableRobots() {
        return this.availableRobots;
    }

    public List<INamedFileSpecification> getRobotList() {
        return this.robotList;
    }

    public List<INamedFileSpecification> getSelectedRobots() {
        ArrayList<INamedFileSpecification> selected = new ArrayList<INamedFileSpecification>();
        for (int i : this.getAvailableRobotsList().getSelectedIndices()) {
            selected.add(this.availableRobots.get(i));
        }
        return selected;
    }

    public JList getAvailableRobotsList() {
        if (this.availableRobotsList == null) {
            this.availableRobotsList = new JList();
            this.availableRobotsList.setModel(new AvailableRobotsModel());
            this.availableRobotsList.setSelectionMode(2);
            this.robotNamesCellRenderer = new RobotNameCellRenderer();
            this.availableRobotsList.setCellRenderer(this.robotNamesCellRenderer);
            MouseAdapter mouseListener = new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() >= 2 && e.getClickCount() % 2 == 0 && AvailableRobotsPanel.this.actionButton != null) {
                        AvailableRobotsPanel.this.actionButton.doClick();
                    }
                }
            };
            this.availableRobotsList.addMouseListener(mouseListener);
            this.availableRobotsList.addListSelectionListener(this.eventHandler);
        }
        return this.availableRobotsList;
    }

    private JScrollPane getAvailableRobotsScrollPane() {
        if (this.availableRobotsScrollPane == null) {
            this.availableRobotsScrollPane = new JScrollPane();
            this.availableRobotsScrollPane.setViewportView(this.getAvailableRobotsList());
        }
        return this.availableRobotsScrollPane;
    }

    public void setRobotList(List<INamedFileSpecification> robotListList) {
        this.robotList = robotListList;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AvailableRobotsPanel.this.availablePackages.clear();
                AvailableRobotsPanel.this.availableRobots.clear();
                if (AvailableRobotsPanel.this.robotList == null) {
                    AvailableRobotsPanel.this.robotList = new CopyOnWriteArrayList();
                    AvailableRobotsPanel.this.availablePackages.add("One moment please...");
                    ((AvailablePackagesModel)AvailableRobotsPanel.this.getAvailablePackagesList().getModel()).changed();
                    AvailableRobotsPanel.this.getAvailablePackagesList().clearSelection();
                    ((AvailableRobotsModel)AvailableRobotsPanel.this.getAvailableRobotsList().getModel()).changed();
                } else {
                    AvailableRobotsPanel.this.availablePackages.add("(All)");
                    for (INamedFileSpecification robotSpec : AvailableRobotsPanel.this.robotList) {
                        String packageName = robotSpec.getFullPackage();
                        if (packageName == null || AvailableRobotsPanel.this.availablePackages.contains(packageName)) continue;
                        AvailableRobotsPanel.this.availablePackages.add(packageName);
                    }
                    AvailableRobotsPanel.this.availablePackages.add("(No package)");
                    for (INamedFileSpecification robotSpec : AvailableRobotsPanel.this.robotList) {
                        AvailableRobotsPanel.this.availableRobots.add(robotSpec);
                    }
                    ((AvailablePackagesModel)AvailableRobotsPanel.this.getAvailablePackagesList().getModel()).changed();
                    AvailableRobotsPanel.this.getAvailablePackagesList().setSelectedIndex(0);
                    ((AvailableRobotsModel)AvailableRobotsPanel.this.getAvailableRobotsList().getModel()).changed();
                    AvailableRobotsPanel.this.getAvailablePackagesList().requestFocus();
                }
            }
        });
    }

    private void availablePackagesListSelectionChanged() {
        int[] sel = this.getAvailablePackagesList().getSelectedIndices();
        this.availableRobots.clear();
        if (sel.length == 1) {
            this.robotNamesCellRenderer.setUseShortNames(true);
            this.getAvailablePackagesList().scrollRectToVisible(this.getAvailablePackagesList().getCellBounds(sel[0], sel[0]));
        } else {
            this.robotNamesCellRenderer.setUseShortNames(false);
        }
        for (int element : sel) {
            String selectedPackage = this.availablePackages.get(element);
            if (selectedPackage.equals("(All)")) {
                this.robotNamesCellRenderer.setUseShortNames(false);
                this.availableRobots.clear();
                for (INamedFileSpecification aRobotList : this.robotList) {
                    this.availableRobots.add(aRobotList);
                }
                break;
            }
            for (INamedFileSpecification robotSpecification : this.robotList) {
                if (robotSpecification.getFullPackage() == null) {
                    if (!selectedPackage.equals("(No package)")) continue;
                    this.availableRobots.add(robotSpecification);
                    continue;
                }
                if (!robotSpecification.getFullPackage().equals(selectedPackage)) continue;
                this.availableRobots.add(robotSpecification);
            }
        }
        ((AvailableRobotsModel)this.getAvailableRobotsList().getModel()).changed();
        if (this.availableRobots.size() > 0) {
            this.availableRobotsList.setSelectedIndex(0);
            this.availableRobotsListSelectionChanged();
        }
    }

    private void availableRobotsListSelectionChanged() {
        int[] sel = this.getAvailableRobotsList().getSelectedIndices();
        if (sel.length == 1) {
            if (this.actionList != null) {
                this.actionList.clearSelection();
            }
            INamedFileSpecification robotSpecification = (INamedFileSpecification)this.getAvailableRobotsList().getModel().getElementAt(sel[0]);
            if (this.robotSelectionPanel != null) {
                this.robotSelectionPanel.showDescription(robotSpecification);
            }
        } else if (this.robotSelectionPanel != null) {
            this.robotSelectionPanel.showDescription(null);
        }
    }

    public void clearSelection() {
        this.getAvailableRobotsList().clearSelection();
        ((AvailableRobotsModel)this.getAvailableRobotsList().getModel()).changed();
    }

    private JList getAvailablePackagesList() {
        if (this.availablePackagesList == null) {
            this.availablePackagesList = new JList();
            this.availablePackagesList.setModel(new AvailablePackagesModel());
            this.availablePackagesList.setSelectionMode(1);
            this.availablePackagesList.addListSelectionListener(this.eventHandler);
        }
        return this.availablePackagesList;
    }

    private JScrollPane getAvailablePackagesScrollPane() {
        if (this.availablePackagesScrollPane == null) {
            this.availablePackagesScrollPane = new JScrollPane();
            this.availablePackagesScrollPane.setViewportView(this.getAvailablePackagesList());
        }
        return this.availablePackagesScrollPane;
    }

    private static class RobotNameCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private boolean useShortNames = false;

        public RobotNameCellRenderer() {
            this.setOpaque(true);
        }

        public void setUseShortNames(boolean useShortNames) {
            this.useShortNames = useShortNames;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setComponentOrientation(list.getComponentOrientation());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (this.useShortNames && value instanceof INamedFileSpecification) {
                INamedFileSpecification fileSpecification = (INamedFileSpecification)value;
                if (fileSpecification instanceof ITeamFileSpecificationExt) {
                    this.setText("Team: " + fileSpecification.getUniqueShortClassNameWithVersion());
                } else {
                    this.setText(fileSpecification.getUniqueShortClassNameWithVersion());
                }
            } else if (value instanceof INamedFileSpecification) {
                INamedFileSpecification fileSpecification = (INamedFileSpecification)value;
                if (fileSpecification instanceof ITeamFileSpecificationExt) {
                    this.setText("Team: " + fileSpecification.getUniqueFullClassNameWithVersion());
                } else {
                    this.setText(fileSpecification.getUniqueFullClassNameWithVersion());
                }
            } else {
                this.setText(value.toString());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            return this;
        }
    }

    private class AvailableRobotsModel
    extends AbstractListModel {
        private AvailableRobotsModel() {
        }

        public void changed() {
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public int getSize() {
            return AvailableRobotsPanel.this.availableRobots.size();
        }

        public INamedFileSpecification getElementAt(int which) {
            return (INamedFileSpecification)AvailableRobotsPanel.this.availableRobots.get(which);
        }
    }

    private class AvailablePackagesModel
    extends AbstractListModel {
        private AvailablePackagesModel() {
        }

        public void changed() {
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public int getSize() {
            return AvailableRobotsPanel.this.availablePackages.size();
        }

        public String getElementAt(int which) {
            return (String)AvailableRobotsPanel.this.availablePackages.get(which);
        }
    }

    private class EventHandler
    implements ListSelectionListener {
        private EventHandler() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (e.getSource() == AvailableRobotsPanel.this.getAvailableRobotsList()) {
                AvailableRobotsPanel.this.availableRobotsListSelectionChanged();
            } else if (e.getSource() == AvailableRobotsPanel.this.getAvailablePackagesList()) {
                AvailableRobotsPanel.this.availablePackagesListSelectionChanged();
            }
        }
    }
}

