/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.robocode.settings.ISettingsManager;
import net.sf.robocode.ui.dialog.WizardPanel;

public class PreferencesCommonOptionsTab
extends WizardPanel {
    private JPanel optionsPanel;
    private JCheckBox showResultsCheckBox;
    private JCheckBox appendWhenSavingResultsCheckBox;
    private JCheckBox enableReplayRecordingCheckBox;
    private final ISettingsManager properties;

    public PreferencesCommonOptionsTab(ISettingsManager properties) {
        this.properties = properties;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridLayout(1, 2));
        this.add(this.getOptionsPanel());
        this.loadPreferences(this.properties);
    }

    private JPanel getOptionsPanel() {
        if (this.optionsPanel == null) {
            this.optionsPanel = new JPanel();
            this.optionsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Common"));
            this.optionsPanel.setLayout(new BoxLayout(this.optionsPanel, 1));
            this.optionsPanel.add(this.getShowResultsCheckBox());
            this.optionsPanel.add(this.getAppendWhenSavingResultsCheckBox());
            this.optionsPanel.add(new JLabel(" "));
            this.optionsPanel.add(this.getEnableReplayRecordingCheckBox());
        }
        return this.optionsPanel;
    }

    private JCheckBox getShowResultsCheckBox() {
        if (this.showResultsCheckBox == null) {
            this.showResultsCheckBox = new JCheckBox("Show results when battle(s) ends");
            this.showResultsCheckBox.setMnemonic('h');
            this.showResultsCheckBox.setDisplayedMnemonicIndex(1);
        }
        return this.showResultsCheckBox;
    }

    private JCheckBox getAppendWhenSavingResultsCheckBox() {
        if (this.appendWhenSavingResultsCheckBox == null) {
            this.appendWhenSavingResultsCheckBox = new JCheckBox("Append when saving results");
            this.appendWhenSavingResultsCheckBox.setMnemonic('A');
        }
        return this.appendWhenSavingResultsCheckBox;
    }

    private JCheckBox getEnableReplayRecordingCheckBox() {
        if (this.enableReplayRecordingCheckBox == null) {
            this.enableReplayRecordingCheckBox = new JCheckBox("Enable replay recording (uses memory and disk space)");
            this.enableReplayRecordingCheckBox.setMnemonic('E');
        }
        return this.enableReplayRecordingCheckBox;
    }

    private void loadPreferences(ISettingsManager robocodeProperties) {
        this.getShowResultsCheckBox().setSelected(robocodeProperties.getOptionsCommonShowResults());
        this.getAppendWhenSavingResultsCheckBox().setSelected(robocodeProperties.getOptionsCommonAppendWhenSavingResults());
        this.getEnableReplayRecordingCheckBox().setSelected(robocodeProperties.getOptionsCommonEnableReplayRecording());
    }

    public void storePreferences() {
        ISettingsManager props = this.properties;
        props.setOptionsCommonShowResults(this.getShowResultsCheckBox().isSelected());
        props.setOptionsCommonAppendWhenSavingResults(this.getAppendWhenSavingResultsCheckBox().isSelected());
        props.setOptionsCommonEnableReplayRecording(this.getEnableReplayRecordingCheckBox().isSelected());
        this.properties.saveProperties();
    }

    public boolean isReady() {
        return true;
    }
}

