/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.robocode.battle.IBattleManager;
import net.sf.robocode.core.Container;
import net.sf.robocode.recording.IRecordManager;
import net.sf.robocode.settings.ISettingsListener;
import net.sf.robocode.settings.ISettingsManager;
import net.sf.robocode.ui.BrowserManager;
import net.sf.robocode.ui.IRobotDialogManager;
import net.sf.robocode.ui.IWindowManager;
import net.sf.robocode.ui.IWindowManagerExt;
import net.sf.robocode.ui.battleview.BattleView;
import net.sf.robocode.ui.battleview.InteractiveHandler;
import net.sf.robocode.ui.dialog.BattleButton;
import net.sf.robocode.ui.dialog.MenuBar;
import net.sf.robocode.ui.dialog.RobotButton;
import net.sf.robocode.ui.dialog.WindowUtil;
import net.sf.robocode.ui.gfx.ImageUtil;
import net.sf.robocode.version.IVersionManager;
import robocode.control.events.BattleAdaptor;
import robocode.control.events.BattleCompletedEvent;
import robocode.control.events.BattleFinishedEvent;
import robocode.control.events.BattlePausedEvent;
import robocode.control.events.BattleResumedEvent;
import robocode.control.events.BattleStartedEvent;
import robocode.control.events.IBattleListener;
import robocode.control.events.RoundStartedEvent;
import robocode.control.events.TurnEndedEvent;
import robocode.control.snapshot.IRobotSnapshot;
import robocode.control.snapshot.ITurnSnapshot;

public class RobocodeFrame
extends JFrame {
    private static final int MAX_TPS = 10000;
    private static final int MAX_TPS_SLIDER_VALUE = 61;
    private static final int UPDATE_TITLE_INTERVAL = 500;
    private static final String INSTALL_URL = "http://robocode.sourceforge.net/installer";
    private static final Cursor BUSY_CURSOR = Cursor.getPredefinedCursor(3);
    private static final Cursor DEFAULT_CURSOR = Cursor.getPredefinedCursor(0);
    private final EventHandler eventHandler = new EventHandler();
    private BattleObserver battleObserver;
    private final InteractiveHandler interactiveHandler;
    private JPanel robocodeContentPane;
    private JLabel statusLabel;
    private JScrollPane robotButtonsScrollPane;
    private JPanel mainPanel;
    private JPanel battleViewPanel;
    private JPanel sidePanel;
    private JPanel robotButtonsPanel;
    private JToolBar toolBar;
    private JToggleButton pauseButton;
    private JButton nextTurnButton;
    private JButton stopButton;
    private JButton restartButton;
    private JButton replayButton;
    private JSlider tpsSlider;
    private JLabel tpsLabel;
    private boolean iconified;
    private boolean exitOnClose = true;
    private final ISettingsManager properties;
    private final IWindowManagerExt windowManager;
    private final IVersionManager versionManager;
    private final IBattleManager battleManager;
    private final IRobotDialogManager dialogManager;
    private final IRecordManager recordManager;
    private final BattleView battleView;
    private final MenuBar menuBar;
    final List<RobotButton> robotButtons = new ArrayList<RobotButton>();

    public RobocodeFrame(ISettingsManager properties, IWindowManager windowManager, IRobotDialogManager dialogManager, IVersionManager versionManager, IBattleManager battleManager, IRecordManager recordManager, InteractiveHandler interactiveHandler, MenuBar menuBar, BattleView battleView) {
        this.windowManager = (IWindowManagerExt)windowManager;
        this.properties = properties;
        this.interactiveHandler = interactiveHandler;
        this.versionManager = versionManager;
        this.battleManager = battleManager;
        this.dialogManager = dialogManager;
        this.recordManager = recordManager;
        menuBar.setup(this);
        this.battleView = battleView;
        this.menuBar = menuBar;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.windowManager.removeBattleListener((IBattleListener)this.battleObserver);
        }
        finally {
            super.finalize();
        }
    }

    public void setBusyPointer(boolean enabled) {
        this.setCursor(enabled ? BUSY_CURSOR : DEFAULT_CURSOR);
    }

    public void addRobotButton(JButton b) {
        if (b instanceof RobotButton) {
            this.robotButtons.add((RobotButton)b);
        }
        this.getRobotButtonsPanel().add(b);
        b.setVisible(true);
        this.getRobotButtonsPanel().validate();
    }

    public void checkUpdateOnStart() {
        if (!this.isIconified()) {
            Date lastCheckedDate = this.properties.getVersionChecked();
            Date today = new Date();
            if (lastCheckedDate == null) {
                lastCheckedDate = today;
                this.properties.setVersionChecked(lastCheckedDate);
                this.properties.saveProperties();
            }
            Calendar checkDate = Calendar.getInstance();
            checkDate.setTime(lastCheckedDate);
            checkDate.add(5, 5);
            if (checkDate.getTime().before(today) && this.checkForNewVersion(false)) {
                this.properties.setVersionChecked(today);
                this.properties.saveProperties();
            }
        }
    }

    public boolean checkForNewVersion(boolean notifyNoUpdate) {
        String currentVersion = this.versionManager.getVersion();
        String newVersion = this.versionManager.checkForNewVersion();
        boolean newVersionAvailable = false;
        if (newVersion != null && currentVersion != null && this.versionManager.compare(newVersion, currentVersion) > 0) {
            newVersionAvailable = true;
            this.showNewVersion(newVersion);
        }
        if (!newVersionAvailable && notifyNoUpdate) {
            this.showLatestVersion(currentVersion);
        }
        return true;
    }

    private void showLatestVersion(String version) {
        JOptionPane.showMessageDialog(this, "You have version " + version + ".  This is the latest version of Robocode.", "No update available", 1);
    }

    private void showNewVersion(String newVersion) {
        if (JOptionPane.showConfirmDialog(this, "Version " + newVersion + " of Robocode is now available.  Would you like to download it?", "Version " + newVersion + " available", 0) == 0) {
            try {
                BrowserManager.openURL(INSTALL_URL);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Unable to open browser!", 1);
            }
        } else if (this.versionManager.isFinal(newVersion)) {
            JOptionPane.showMessageDialog(this, "It is highly recommended that you always download the latest version.  You may get it at http://robocode.sourceforge.net/installer", "Update when you can!", 1);
        }
    }

    private void battleViewResized() {
        this.battleView.validate();
        this.battleView.setInitialized(false);
    }

    private void battleViewPanelResized() {
        this.battleView.setBounds(this.getBattleViewPanel().getBounds());
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.add((Component)this.getSidePanel(), "East");
            this.mainPanel.add(this.getBattleViewPanel());
        }
        return this.mainPanel;
    }

    private JPanel getBattleViewPanel() {
        if (this.battleViewPanel == null) {
            this.battleViewPanel = new JPanel();
            this.battleViewPanel.setPreferredSize(new Dimension(800, 600));
            this.battleViewPanel.setLayout(null);
            this.battleViewPanel.add(this.battleView);
            this.battleViewPanel.addComponentListener(this.eventHandler);
        }
        return this.battleViewPanel;
    }

    private JPanel getRobocodeContentPane() {
        if (this.robocodeContentPane == null) {
            this.robocodeContentPane = new JPanel();
            this.robocodeContentPane.setLayout(new BorderLayout());
            this.robocodeContentPane.add((Component)this.getToolBar(), "South");
            this.robocodeContentPane.add((Component)this.getMainPanel(), "Center");
        }
        return this.robocodeContentPane;
    }

    private JPanel getSidePanel() {
        if (this.sidePanel == null) {
            this.sidePanel = new JPanel();
            this.sidePanel.setLayout(new BorderLayout());
            this.sidePanel.add((Component)this.getRobotButtonsScrollPane(), "Center");
            BattleButton btn = (BattleButton)Container.getComponent(BattleButton.class);
            btn.attach();
            this.sidePanel.add((Component)btn, "South");
        }
        return this.sidePanel;
    }

    private JPanel getRobotButtonsPanel() {
        if (this.robotButtonsPanel == null) {
            this.robotButtonsPanel = new JPanel();
            this.robotButtonsPanel.setLayout(new BoxLayout(this.robotButtonsPanel, 1));
            this.robotButtonsPanel.addContainerListener(this.eventHandler);
        }
        return this.robotButtonsPanel;
    }

    private JScrollPane getRobotButtonsScrollPane() {
        if (this.robotButtonsScrollPane == null) {
            this.robotButtonsScrollPane = new JScrollPane();
            this.robotButtonsScrollPane.setAutoscrolls(false);
            this.robotButtonsScrollPane.setVerticalScrollBarPolicy(20);
            this.robotButtonsScrollPane.setHorizontalScrollBarPolicy(31);
            this.robotButtonsScrollPane.setAlignmentY(0.0f);
            this.robotButtonsScrollPane.setMaximumSize(new Dimension(113, Short.MAX_VALUE));
            this.robotButtonsScrollPane.setPreferredSize(new Dimension(113, 28));
            this.robotButtonsScrollPane.setAlignmentX(0.5f);
            this.robotButtonsScrollPane.setMinimumSize(new Dimension(113, 53));
            this.robotButtonsScrollPane.setViewportView(this.getRobotButtonsPanel());
        }
        return this.robotButtonsScrollPane;
    }

    public JLabel getStatusLabel() {
        if (this.statusLabel == null) {
            this.statusLabel = new JLabel();
            this.statusLabel.setText("");
        }
        return this.statusLabel;
    }

    private JToggleButton getPauseButton() {
        if (this.pauseButton == null) {
            this.pauseButton = new JToggleButton("Pause/Debug");
            this.pauseButton.setMnemonic('P');
            this.pauseButton.setHorizontalTextPosition(0);
            this.pauseButton.setVerticalTextPosition(3);
            this.pauseButton.addActionListener(this.eventHandler);
        }
        return this.pauseButton;
    }

    private Component getNextTurnButton() {
        if (this.nextTurnButton == null) {
            this.nextTurnButton = new JButton("Next Turn");
            this.nextTurnButton.setMnemonic('N');
            this.nextTurnButton.setHorizontalTextPosition(0);
            this.nextTurnButton.setVerticalTextPosition(3);
            this.nextTurnButton.addActionListener(this.eventHandler);
            this.nextTurnButton.setEnabled(false);
        }
        return this.nextTurnButton;
    }

    private JButton getStopButton() {
        if (this.stopButton == null) {
            this.stopButton = new JButton("Stop");
            this.stopButton.setMnemonic('S');
            this.stopButton.setHorizontalTextPosition(0);
            this.stopButton.setVerticalTextPosition(3);
            this.stopButton.addActionListener(this.eventHandler);
            this.stopButton.setEnabled(false);
        }
        return this.stopButton;
    }

    private JButton getRestartButton() {
        if (this.restartButton == null) {
            this.restartButton = new JButton("Restart");
            this.restartButton.setMnemonic('t');
            this.restartButton.setDisplayedMnemonicIndex(3);
            this.restartButton.setHorizontalTextPosition(0);
            this.restartButton.setVerticalTextPosition(3);
            this.restartButton.addActionListener(this.eventHandler);
            this.restartButton.setEnabled(false);
        }
        return this.restartButton;
    }

    public JButton getReplayButton() {
        if (this.replayButton == null) {
            this.replayButton = new JButton("Replay");
            this.replayButton.setMnemonic('y');
            this.replayButton.setDisplayedMnemonicIndex(5);
            this.replayButton.setHorizontalTextPosition(0);
            this.replayButton.setVerticalTextPosition(3);
            this.replayButton.addActionListener(this.eventHandler);
            ISettingsManager props = this.properties;
            this.replayButton.setVisible(props.getOptionsCommonEnableReplayRecording());
            props.addPropertyListener(new ISettingsListener(){

                public void settingChanged(String property) {
                    if (property.equals("robocode.options.common.enableReplayRecording")) {
                        RobocodeFrame.this.replayButton.setVisible(RobocodeFrame.this.properties.getOptionsCommonEnableReplayRecording());
                    }
                }
            });
            this.replayButton.setEnabled(false);
        }
        return this.replayButton;
    }

    private JSlider getTpsSlider() {
        if (this.tpsSlider == null) {
            final ISettingsManager props = this.properties;
            int tps = Math.max(props.getOptionsBattleDesiredTPS(), 1);
            this.tpsSlider = new JSlider(0, 61, this.tpsToSliderValue(tps));
            this.tpsSlider.setPaintLabels(true);
            this.tpsSlider.setPaintTicks(true);
            this.tpsSlider.setMinorTickSpacing(1);
            this.tpsSlider.addChangeListener(this.eventHandler);
            Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
            labels.put(0, new JLabel("0"));
            labels.put(5, new JLabel("5"));
            labels.put(10, new JLabel("10"));
            labels.put(15, new JLabel("15"));
            labels.put(20, new JLabel("20"));
            labels.put(25, new JLabel("25"));
            labels.put(30, new JLabel("30"));
            labels.put(35, new JLabel("40"));
            labels.put(40, new JLabel("50"));
            labels.put(45, new JLabel("65"));
            labels.put(50, new JLabel("90"));
            labels.put(55, new JLabel("150"));
            labels.put(60, new JLabel("1000"));
            this.tpsSlider.setMajorTickSpacing(5);
            this.tpsSlider.setLabelTable(labels);
            WindowUtil.setFixedSize(this.tpsSlider, new Dimension(372, 40));
            props.addPropertyListener(new ISettingsListener(){

                public void settingChanged(String property) {
                    if (property.equals("robocode.options.battle.desiredTPS")) {
                        RobocodeFrame.this.setTpsOnSlider(props.getOptionsBattleDesiredTPS());
                    }
                }
            });
        }
        return this.tpsSlider;
    }

    private JLabel getTpsLabel() {
        if (this.tpsLabel == null) {
            this.tpsLabel = new JLabel(this.getTpsFromSliderAsString());
        }
        return this.tpsLabel;
    }

    private JToolBar getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = new JToolBar();
            this.toolBar.add(this.getPauseButton());
            this.toolBar.add(this.getNextTurnButton());
            this.toolBar.add(this.getStopButton());
            this.toolBar.add(this.getRestartButton());
            this.toolBar.add(this.getReplayButton());
            this.toolBar.addSeparator();
            this.toolBar.add(this.getTpsSlider());
            this.toolBar.add(this.getTpsLabel());
            this.toolBar.addSeparator();
            this.toolBar.add(this.getStatusLabel());
            WindowUtil.setDefaultStatusLabel(this.getStatusLabel());
        }
        return this.toolBar;
    }

    private void initialize() {
        this.setDefaultCloseOperation(0);
        this.setTitle("Robocode");
        this.setIconImage(ImageUtil.getImage("/net/sf/robocode/ui/icons/robocode-icon.png"));
        this.setResizable(true);
        this.setVisible(false);
        this.setContentPane(this.getRobocodeContentPane());
        this.setJMenuBar(this.menuBar);
        this.battleObserver = new BattleObserver();
        this.addWindowListener(this.eventHandler);
        this.battleView.addMouseListener(this.interactiveHandler);
        this.battleView.addMouseMotionListener(this.interactiveHandler);
        this.battleView.addMouseWheelListener(this.interactiveHandler);
        this.battleView.setFocusable(true);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.interactiveHandler);
        if (this.windowManager.isSlave()) {
            this.menuBar.getBattleMenu().setEnabled(false);
            this.menuBar.getRobotMenu().setEnabled(false);
            this.getStopButton().setEnabled(false);
            this.getPauseButton().setEnabled(false);
            this.getNextTurnButton().setEnabled(false);
            this.getRestartButton().setEnabled(false);
            this.getReplayButton().setEnabled(false);
            this.exitOnClose = false;
        }
    }

    private void pauseResumeButtonActionPerformed() {
        this.battleManager.togglePauseResumeBattle();
    }

    public boolean isIconified() {
        return this.iconified;
    }

    public void afterIntroBattle() {
        this.getRestartButton().setEnabled(false);
        this.getRobotButtonsPanel().removeAll();
        this.getRobotButtonsPanel().repaint();
    }

    private void setIconified(boolean iconified) {
        this.iconified = iconified;
    }

    private int getTpsFromSlider() {
        int value = this.getTpsSlider().getValue();
        if (value <= 30) {
            return value;
        }
        if (value <= 40) {
            return 2 * value - 30;
        }
        if (value <= 45) {
            return 3 * value - 70;
        }
        if (value <= 52) {
            return 5 * value - 160;
        }
        switch (value) {
            case 53: {
                return 110;
            }
            case 54: {
                return 130;
            }
            case 55: {
                return 150;
            }
            case 56: {
                return 200;
            }
            case 57: {
                return 300;
            }
            case 58: {
                return 500;
            }
            case 59: {
                return 750;
            }
            case 60: {
                return 1000;
            }
        }
        return 10000;
    }

    private void setTpsOnSlider(int tps) {
        this.tpsSlider.setValue(this.tpsToSliderValue(tps));
    }

    private int tpsToSliderValue(int tps) {
        if (tps <= 30) {
            return tps;
        }
        if (tps <= 50) {
            return (tps + 30) / 2;
        }
        if (tps <= 65) {
            return (tps + 70) / 3;
        }
        if (tps <= 100) {
            return (tps + 160) / 5;
        }
        if (tps <= 110) {
            return 53;
        }
        if (tps <= 130) {
            return 54;
        }
        if (tps <= 150) {
            return 55;
        }
        if (tps <= 200) {
            return 56;
        }
        if (tps <= 300) {
            return 57;
        }
        if (tps <= 500) {
            return 58;
        }
        if (tps <= 750) {
            return 59;
        }
        if (tps <= 1000) {
            return 60;
        }
        return 61;
    }

    private String getTpsFromSliderAsString() {
        int tps = this.getTpsFromSlider();
        return "  " + (tps == 10000 ? "max" : "" + tps) + "  ";
    }

    private class BattleObserver
    extends BattleAdaptor {
        private int tps;
        private int currentRound;
        private int numberOfRounds;
        private int currentTurn;
        private boolean isBattleRunning;
        private boolean isBattlePaused;
        private boolean isBattleReplay;
        private long lastTitleUpdateTime;

        public BattleObserver() {
            RobocodeFrame.this.windowManager.addBattleListener((IBattleListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                RobocodeFrame.this.windowManager.removeBattleListener((IBattleListener)this);
            }
            finally {
                super.finalize();
            }
        }

        public void onBattleStarted(BattleStartedEvent event) {
            this.numberOfRounds = event.getBattleRules().getNumRounds();
            this.isBattleRunning = true;
            this.isBattleReplay = event.isReplay();
            RobocodeFrame.this.getStopButton().setEnabled(true);
            RobocodeFrame.this.getRestartButton().setEnabled(RobocodeFrame.this.battleManager.getBattleProperties().getSelectedRobots() != null);
            RobocodeFrame.this.getReplayButton().setEnabled(event.isReplay());
            RobocodeFrame.this.menuBar.getBattleSaveRecordAsMenuItem().setEnabled(false);
            RobocodeFrame.this.menuBar.getBattleExportRecordMenuItem().setEnabled(false);
            RobocodeFrame.this.menuBar.getBattleSaveAsMenuItem().setEnabled(true);
            RobocodeFrame.this.menuBar.getBattleSaveMenuItem().setEnabled(true);
            JCheckBoxMenuItem rankingCheckBoxMenuItem = RobocodeFrame.this.menuBar.getOptionsShowRankingCheckBoxMenuItem();
            rankingCheckBoxMenuItem.setEnabled(!this.isBattleReplay);
            if (rankingCheckBoxMenuItem.isSelected()) {
                RobocodeFrame.this.windowManager.showRankingDialog(!this.isBattleReplay);
            }
            RobocodeFrame.this.validate();
            this.updateTitle();
        }

        public void onRoundStarted(RoundStartedEvent event) {
            if (event.getRound() == 0) {
                RobocodeFrame.this.getRobotButtonsPanel().removeAll();
                List<IRobotSnapshot> robots = Arrays.asList(event.getStartSnapshot().getRobots());
                RobocodeFrame.this.dialogManager.trim(robots);
                int maxEnergy = 0;
                for (IRobotSnapshot robot : robots) {
                    if (!((double)maxEnergy < robot.getEnergy())) continue;
                    maxEnergy = (int)robot.getEnergy();
                }
                if (maxEnergy == 0) {
                    maxEnergy = 1;
                }
                for (int index = 0; index < robots.size(); ++index) {
                    IRobotSnapshot robot;
                    robot = robots.get(index);
                    boolean attach = index < 25;
                    RobotButton button = (RobotButton)Container.createComponent(RobotButton.class);
                    button.setup(robot.getName(), maxEnergy, index, robot.getContestantIndex(), attach);
                    button.setText(robot.getShortName());
                    RobocodeFrame.this.addRobotButton(button);
                }
                RobocodeFrame.this.getRobotButtonsPanel().repaint();
            }
        }

        public void onBattleFinished(BattleFinishedEvent event) {
            this.isBattleRunning = false;
            for (RobotButton robotButton : RobocodeFrame.this.robotButtons) {
                robotButton.detach();
            }
            RobocodeFrame.this.robotButtons.clear();
            boolean canReplayRecord = RobocodeFrame.this.recordManager.hasRecord();
            boolean enableSaveRecord = RobocodeFrame.this.properties.getOptionsCommonEnableReplayRecording() & canReplayRecord;
            RobocodeFrame.this.getStopButton().setEnabled(false);
            RobocodeFrame.this.getReplayButton().setEnabled(canReplayRecord);
            RobocodeFrame.this.getNextTurnButton().setEnabled(false);
            RobocodeFrame.this.menuBar.getBattleSaveRecordAsMenuItem().setEnabled(enableSaveRecord);
            RobocodeFrame.this.menuBar.getBattleExportRecordMenuItem().setEnabled(enableSaveRecord);
            RobocodeFrame.this.menuBar.getOptionsShowRankingCheckBoxMenuItem().setEnabled(false);
            this.updateTitle();
        }

        public void onBattlePaused(BattlePausedEvent event) {
            this.isBattlePaused = true;
            RobocodeFrame.this.getPauseButton().setSelected(true);
            RobocodeFrame.this.getNextTurnButton().setEnabled(true);
            this.updateTitle();
        }

        public void onBattleResumed(BattleResumedEvent event) {
            this.isBattlePaused = false;
            RobocodeFrame.this.getPauseButton().setSelected(false);
            RobocodeFrame.this.getNextTurnButton().setEnabled(false);
            if (RobocodeFrame.this.getTpsFromSlider() == 0) {
                RobocodeFrame.this.setTpsOnSlider(1);
            }
            this.updateTitle();
        }

        public void onTurnEnded(TurnEndedEvent event) {
            if (event == null) {
                return;
            }
            ITurnSnapshot turn = event.getTurnSnapshot();
            if (turn == null) {
                return;
            }
            this.tps = event.getTurnSnapshot().getTPS();
            this.currentRound = event.getTurnSnapshot().getRound();
            this.currentTurn = event.getTurnSnapshot().getTurn();
            if (System.currentTimeMillis() - this.lastTitleUpdateTime >= 500L) {
                this.updateTitle();
            }
        }

        private void updateTitle() {
            StringBuffer title = new StringBuffer("Robocode");
            if (this.isBattleRunning) {
                title.append(": ");
                if (this.currentTurn == 0) {
                    title.append("Starting round");
                } else {
                    boolean dispFps;
                    boolean dispTps;
                    if (this.isBattleReplay) {
                        title.append("Replaying: ");
                    }
                    title.append("Turn ");
                    title.append(this.currentTurn);
                    title.append(", Round ");
                    title.append(this.currentRound + 1).append(" of ").append(this.numberOfRounds);
                    if (!this.isBattlePaused && (dispTps = RobocodeFrame.this.properties.getOptionsViewTPS()) | (dispFps = RobocodeFrame.this.properties.getOptionsViewFPS())) {
                        title.append(", ");
                        if (dispTps) {
                            title.append(this.tps).append(" TPS");
                        }
                        if (dispTps & dispFps) {
                            title.append(", ");
                        }
                        if (dispFps) {
                            title.append(RobocodeFrame.this.windowManager.getFPS()).append(" FPS");
                        }
                    }
                }
            }
            if (this.isBattlePaused) {
                title.append(" (paused)");
            }
            RobocodeFrame.this.setTitle(title.toString());
            this.lastTitleUpdateTime = System.currentTimeMillis();
        }

        public void onBattleCompleted(BattleCompletedEvent event) {
            if (RobocodeFrame.this.properties.getOptionsCommonShowResults()) {
                ResultsTask resultTask = new ResultsTask(event);
                EventQueue.invokeLater(resultTask);
            }
        }

        private class ResultsTask
        implements Runnable {
            final BattleCompletedEvent event;

            ResultsTask(BattleCompletedEvent event) {
                this.event = event;
            }

            public void run() {
                RobocodeFrame.this.windowManager.showResultsDialog(this.event);
            }
        }
    }

    private class EventHandler
    implements ComponentListener,
    ActionListener,
    ContainerListener,
    WindowListener,
    ChangeListener {
        private EventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == RobocodeFrame.this.getPauseButton()) {
                RobocodeFrame.this.pauseResumeButtonActionPerformed();
            } else if (source == RobocodeFrame.this.getStopButton()) {
                RobocodeFrame.this.battleManager.stop(false);
            } else if (source == RobocodeFrame.this.getRestartButton()) {
                RobocodeFrame.this.battleManager.restart();
            } else if (source == RobocodeFrame.this.getNextTurnButton()) {
                RobocodeFrame.this.battleManager.nextTurn();
            } else if (source == RobocodeFrame.this.getReplayButton()) {
                RobocodeFrame.this.battleManager.replay();
            }
        }

        public void componentResized(ComponentEvent e) {
            if (e.getSource() == RobocodeFrame.this.battleView) {
                RobocodeFrame.this.battleViewResized();
            }
            if (e.getSource() == RobocodeFrame.this.getBattleViewPanel()) {
                RobocodeFrame.this.battleViewPanelResized();
            }
        }

        public void componentShown(ComponentEvent e) {
        }

        public void componentHidden(ComponentEvent e) {
        }

        public void componentRemoved(ContainerEvent e) {
        }

        public void componentAdded(ContainerEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowClosed(WindowEvent e) {
            if (RobocodeFrame.this.exitOnClose) {
                System.exit(0);
            }
        }

        public void windowClosing(WindowEvent e) {
            RobocodeFrame.this.exitOnClose = true;
            if (RobocodeFrame.this.windowManager.isSlave()) {
                WindowUtil.message("If you wish to exit Robocode, please exit the program controlling it.");
                RobocodeFrame.this.exitOnClose = false;
                return;
            }
            if (RobocodeFrame.this.windowManager.closeRobocodeEditor()) {
                WindowUtil.saveWindowPositions();
                RobocodeFrame.this.battleObserver = null;
                RobocodeFrame.this.dispose();
            }
            RobocodeFrame.this.properties.saveProperties();
        }

        public void windowDeactivated(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
            RobocodeFrame.this.setIconified(false);
            RobocodeFrame.this.battleManager.setManagedTPS(true);
        }

        public void windowIconified(WindowEvent e) {
            RobocodeFrame.this.setIconified(true);
            RobocodeFrame.this.battleManager.setManagedTPS(false);
        }

        public void windowOpened(WindowEvent e) {
            RobocodeFrame.this.battleManager.setManagedTPS(true);
        }

        public void stateChanged(ChangeEvent e) {
            if (e.getSource() == RobocodeFrame.this.getTpsSlider()) {
                int tps = RobocodeFrame.this.getTpsFromSlider();
                if (tps == 0) {
                    RobocodeFrame.this.battleManager.pauseIfResumedBattle();
                } else {
                    RobocodeFrame.this.properties.setOptionsBattleDesiredTPS(tps);
                    RobocodeFrame.this.battleManager.resumeIfPausedBattle();
                }
                RobocodeFrame.this.tpsLabel.setText(RobocodeFrame.this.getTpsFromSliderAsString());
            }
        }
    }
}

