/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.robocode.battle.IBattleManager;
import net.sf.robocode.ui.IWindowManager;
import net.sf.robocode.ui.dialog.ConsoleScrollPane;
import net.sf.robocode.ui.dialog.RobotButton;
import robocode.control.events.BattleAdaptor;
import robocode.control.events.BattleFinishedEvent;
import robocode.control.events.BattlePausedEvent;
import robocode.control.events.BattleResumedEvent;
import robocode.control.events.BattleStartedEvent;
import robocode.control.events.IBattleListener;
import robocode.control.events.TurnEndedEvent;
import robocode.control.snapshot.IDebugProperty;
import robocode.control.snapshot.IRobotSnapshot;
import robocode.control.snapshot.ITurnSnapshot;

public class RobotDialog
extends JFrame {
    private final Color grayGreen = new Color(0x80C080);
    private RobotButton robotButton;
    private JTabbedPane tabbedPane;
    private ConsoleScrollPane scrollPane;
    private ConsoleScrollPane propertiesPane;
    private JPanel robotDialogContentPane;
    private JPanel buttonPanel;
    private JButton okButton;
    private JButton clearButton;
    private JButton killButton;
    private JToggleButton paintButton;
    private JCheckBox sgCheckBox;
    private JToggleButton pauseButton;
    private boolean isListening;
    private int robotIndex;
    private IRobotSnapshot lastSnapshot;
    private boolean paintSnapshot;
    private boolean grayGreenButton;
    private final Hashtable<String, String> debugProperties = new Hashtable();
    private final BattleObserver battleObserver = new BattleObserver();
    private final IWindowManager windowManager;
    private final IBattleManager battleManager;
    private final ActionListener eventHandler = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == RobotDialog.this.getOkButton()) {
                RobotDialog.this.okButtonActionPerformed();
            } else if (src == RobotDialog.this.getClearButton()) {
                RobotDialog.this.clearButtonActionPerformed();
            } else if (src == RobotDialog.this.getKillButton()) {
                RobotDialog.this.killButtonActionPerformed();
            } else if (src == RobotDialog.this.getPaintButton()) {
                RobotDialog.this.paintButtonActionPerformed();
            } else if (src == RobotDialog.this.getSGCheckBox()) {
                RobotDialog.this.sgCheckBoxActionPerformed();
            } else if (src == RobotDialog.this.getPauseButton()) {
                RobotDialog.this.pauseResumeButtonActionPerformed();
            }
        }
    };

    public RobotDialog(IWindowManager windowManager, IBattleManager battleManager) {
        this.battleManager = battleManager;
        this.windowManager = windowManager;
    }

    public void setup(RobotButton robotButton) {
        this.robotButton = robotButton;
        this.initialize();
    }

    private void initialize() {
        this.robotIndex = this.robotButton.getRobotIndex();
        this.setDefaultCloseOperation(2);
        this.setContentPane(this.getRobotDialogContentPane());
        if (this.windowManager.isSlave()) {
            this.getKillButton().setEnabled(false);
        }
        this.setTitle(this.robotButton.getRobotName());
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.detach();
        }
        finally {
            super.finalize();
        }
    }

    public void detach() {
        if (this.isListening) {
            this.windowManager.removeBattleListener((IBattleListener)this.battleObserver);
            this.isListening = false;
        }
        this.robotButton.detach();
    }

    public void attach(RobotButton robotButton) {
        this.robotButton = robotButton;
        this.robotIndex = this.robotButton.getRobotIndex();
        if (!this.isListening) {
            this.isListening = true;
            this.windowManager.addBattleListener((IBattleListener)this.battleObserver);
        }
    }

    public void reset() {
        this.getConsoleScrollPane().setText(null);
        this.lastSnapshot = null;
        this.debugProperties.clear();
    }

    public void pack() {
        this.getConsoleScrollPane().setPreferredSize(new Dimension(426, 200));
        super.pack();
        this.getConsoleScrollPane().setPreferredSize(null);
    }

    public boolean isPaintEnabled() {
        return this.getPaintButton().isSelected();
    }

    public boolean isSGPaintEnabled() {
        return this.getSGCheckBox().isSelected();
    }

    private JPanel getRobotDialogContentPane() {
        if (this.robotDialogContentPane == null) {
            this.robotDialogContentPane = new JPanel();
            this.robotDialogContentPane.setLayout(new BorderLayout());
            this.robotDialogContentPane.add(this.getTabbedPane());
            this.robotDialogContentPane.add((Component)this.getButtonPanel(), "South");
        }
        return this.robotDialogContentPane;
    }

    private JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.setLayout(new BorderLayout());
            this.tabbedPane.addTab("Console", this.getConsoleScrollPane());
            this.tabbedPane.addTab("Properties", this.getTurnScrollPane());
            this.tabbedPane.setTabLayoutPolicy(1);
            this.tabbedPane.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    RobotDialog.this.paintSnapshot = RobotDialog.this.tabbedPane.getSelectedIndex() == 1;
                    RobotDialog.this.paintSnapshot();
                }
            });
        }
        return this.tabbedPane;
    }

    private void paintSnapshot() {
        if (this.paintSnapshot) {
            if (this.lastSnapshot != null) {
                StringBuilder sb = new StringBuilder();
                sb.append("energy: ").append(this.lastSnapshot.getEnergy()).append('\n');
                sb.append("x: ").append(this.lastSnapshot.getX()).append('\n');
                sb.append("y: ").append(this.lastSnapshot.getY()).append('\n');
                sb.append("velocity: ").append(this.lastSnapshot.getVelocity()).append('\n');
                sb.append("heat: ").append(this.lastSnapshot.getGunHeat()).append('\n');
                sb.append("bodyHeading: rad: ").append(this.lastSnapshot.getBodyHeading()).append(" deg: ").append(Math.toDegrees(this.lastSnapshot.getBodyHeading())).append('\n');
                sb.append("gunHeading: rad: ").append(this.lastSnapshot.getGunHeading()).append(" deg: ").append(Math.toDegrees(this.lastSnapshot.getGunHeading())).append('\n');
                sb.append("radarHeading: rad: ").append(this.lastSnapshot.getRadarHeading()).append(" deg: ").append(Math.toDegrees(this.lastSnapshot.getRadarHeading())).append('\n');
                sb.append("state: ").append(this.lastSnapshot.getState()).append('\n');
                sb.append('\n');
                IDebugProperty[] debugPropeties = this.lastSnapshot.getDebugProperties();
                if (debugPropeties != null) {
                    for (IDebugProperty prop : debugPropeties) {
                        if (prop.getValue() == null || prop.getValue().length() == 0) {
                            this.debugProperties.remove(prop.getKey());
                            continue;
                        }
                        this.debugProperties.put(prop.getKey(), prop.getValue());
                    }
                }
                for (Map.Entry<String, String> prop : this.debugProperties.entrySet()) {
                    sb.append(prop.getKey()).append(": ").append(prop.getValue()).append('\n');
                }
                this.getTurnScrollPane().setText(sb.toString());
            } else {
                this.getTurnScrollPane().setText(null);
            }
        }
    }

    private ConsoleScrollPane getTurnScrollPane() {
        if (this.propertiesPane == null) {
            this.propertiesPane = new ConsoleScrollPane();
        }
        return this.propertiesPane;
    }

    private ConsoleScrollPane getConsoleScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new ConsoleScrollPane();
            JTextArea textPane = this.scrollPane.getTextPane();
            textPane.setBackground(Color.DARK_GRAY);
            textPane.setForeground(Color.WHITE);
        }
        return this.scrollPane;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new FlowLayout(0));
            this.buttonPanel.add(this.getOkButton());
            this.buttonPanel.add(this.getClearButton());
            this.buttonPanel.add(this.getKillButton());
            this.buttonPanel.add(this.getPaintButton());
            this.buttonPanel.add(this.getSGCheckBox());
            this.buttonPanel.add(this.getPauseButton());
        }
        return this.buttonPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = this.getNewButton("OK");
        }
        return this.okButton;
    }

    private JButton getClearButton() {
        if (this.clearButton == null) {
            this.clearButton = this.getNewButton("Clear");
        }
        return this.clearButton;
    }

    private JButton getKillButton() {
        if (this.killButton == null) {
            this.killButton = this.getNewButton("Kill Robot");
        }
        return this.killButton;
    }

    private JToggleButton getPaintButton() {
        if (this.paintButton == null) {
            this.paintButton = new JToggleButton("Paint");
            this.paintButton.addActionListener(this.eventHandler);
        }
        return this.paintButton;
    }

    private JCheckBox getSGCheckBox() {
        if (this.sgCheckBox == null) {
            this.sgCheckBox = new JCheckBox("Robocode SG");
            this.sgCheckBox.addActionListener(this.eventHandler);
        }
        return this.sgCheckBox;
    }

    private JToggleButton getPauseButton() {
        if (this.pauseButton == null) {
            this.pauseButton = new JToggleButton("Pause/Debug");
            this.pauseButton.addActionListener(this.eventHandler);
        }
        return this.pauseButton;
    }

    private JButton getNewButton(String text) {
        JButton button = new JButton(text);
        button.addActionListener(this.eventHandler);
        return button;
    }

    private void okButtonActionPerformed() {
        this.dispose();
    }

    private void clearButtonActionPerformed() {
        this.reset();
    }

    private void killButtonActionPerformed() {
        this.battleManager.killRobot(this.robotIndex);
    }

    private void paintButtonActionPerformed() {
        this.battleManager.setPaintEnabled(this.robotIndex, this.getPaintButton().isSelected());
    }

    private void sgCheckBoxActionPerformed() {
        this.battleManager.setSGPaintEnabled(this.robotIndex, this.getSGCheckBox().isSelected());
    }

    private void pauseResumeButtonActionPerformed() {
        this.battleManager.togglePauseResumeBattle();
    }

    private class BattleObserver
    extends BattleAdaptor {
        private BattleObserver() {
        }

        public void onBattleStarted(BattleStartedEvent event) {
            RobotDialog.this.getPauseButton().setEnabled(true);
            RobotDialog.this.getKillButton().setEnabled(true);
        }

        public void onBattleFinished(BattleFinishedEvent event) {
            RobotDialog.this.lastSnapshot = null;
            RobotDialog.this.paintSnapshot();
            RobotDialog.this.getPauseButton().setEnabled(false);
            RobotDialog.this.getKillButton().setEnabled(false);
        }

        public void onBattlePaused(BattlePausedEvent event) {
            RobotDialog.this.getPauseButton().setSelected(true);
        }

        public void onBattleResumed(BattleResumedEvent event) {
            RobotDialog.this.getPauseButton().setSelected(false);
        }

        public void onTurnEnded(TurnEndedEvent event) {
            ITurnSnapshot turn = event.getTurnSnapshot();
            if (turn == null) {
                return;
            }
            RobotDialog.this.lastSnapshot = turn.getRobots()[RobotDialog.this.robotIndex];
            String text = RobotDialog.this.lastSnapshot.getOutputStreamSnapshot();
            if (text != null && text.length() > 0) {
                RobotDialog.this.getConsoleScrollPane().append(text);
                RobotDialog.this.getConsoleScrollPane().scrollToBottom();
            }
            if (RobotDialog.this.lastSnapshot.isPaintRobot() && !RobotDialog.this.grayGreenButton) {
                RobotDialog.this.grayGreenButton = true;
                RobotDialog.this.getPaintButton().setBackground(RobotDialog.this.grayGreen);
            }
            RobotDialog.this.paintSnapshot();
        }
    }
}

