/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import net.sf.robocode.core.Container;
import net.sf.robocode.repository.INamedFileSpecification;
import net.sf.robocode.repository.IRepositoryManager;
import net.sf.robocode.ui.IWindowManager;
import net.sf.robocode.ui.dialog.ConsoleDialog;
import net.sf.robocode.ui.dialog.RobotSelectionPanel;
import net.sf.robocode.ui.dialog.WindowUtil;
import net.sf.robocode.ui.dialog.WizardCardPanel;
import net.sf.robocode.ui.dialog.WizardController;
import net.sf.robocode.ui.dialog.WizardListener;
import net.sf.robocode.ui.util.ShortcutUtil;

public class RobotExtractor
extends JDialog
implements WizardListener {
    String unusedrobotPath;
    private final int minRobots = 1;
    private final int maxRobots = 1;
    private JPanel robotImporterContentPane;
    private WizardCardPanel wizardPanel;
    private WizardController buttonsPanel;
    private RobotSelectionPanel robotSelectionPanel;
    public byte[] buf = new byte[4096];
    private StringWriter output;
    private final IWindowManager windowManager;
    private final IRepositoryManager repositoryManager;
    private final EventHandler eventHandler = new EventHandler();

    public RobotExtractor(JFrame owner, IWindowManager windowManager, IRepositoryManager repositoryManager) {
        super(owner);
        this.repositoryManager = repositoryManager;
        this.windowManager = windowManager;
        this.initialize();
    }

    public void cancelButtonActionPerformed() {
        this.dispose();
    }

    public void finishButtonActionPerformed() {
        int rc = this.extractRobot();
        ConsoleDialog d = new ConsoleDialog(this.windowManager.getRobocodeFrame(), "Extract results", false);
        d.setText(this.output.toString());
        d.pack();
        d.pack();
        WindowUtil.packCenterShow(this, d);
        if (rc < 8) {
            this.dispose();
        }
    }

    private WizardController getButtonsPanel() {
        if (this.buttonsPanel == null) {
            this.buttonsPanel = this.getWizardPanel().getWizardController();
        }
        return this.buttonsPanel;
    }

    private JPanel getRobotImporterContentPane() {
        if (this.robotImporterContentPane == null) {
            this.robotImporterContentPane = new JPanel();
            this.robotImporterContentPane.setLayout(new BorderLayout());
            this.robotImporterContentPane.add((Component)this.getButtonsPanel(), "South");
            this.robotImporterContentPane.add((Component)this.getWizardPanel(), "Center");
            this.getWizardPanel().getWizardController().setFinishButtonTextAndMnemonic("Extract!", 'E', 0);
            this.robotImporterContentPane.registerKeyboardAction(this.eventHandler, "Refresh", KeyStroke.getKeyStroke(82, ShortcutUtil.MENU_SHORTCUT_KEY_MASK), 1);
            this.robotImporterContentPane.registerKeyboardAction(this.eventHandler, "Refresh", KeyStroke.getKeyStroke(82, ShortcutUtil.MENU_SHORTCUT_KEY_MASK), 0);
        }
        return this.robotImporterContentPane;
    }

    public RobotSelectionPanel getRobotSelectionPanel() {
        if (this.robotSelectionPanel == null) {
            this.robotSelectionPanel = (RobotSelectionPanel)Container.createComponent(RobotSelectionPanel.class);
            this.robotSelectionPanel.setup(1, 1, false, "Select the robot you would like to extract to the robots directory.  Robots not shown do not include source.", true, true, true, false, true, true, null);
        }
        return this.robotSelectionPanel;
    }

    private WizardCardPanel getWizardPanel() {
        if (this.wizardPanel == null) {
            this.wizardPanel = new WizardCardPanel(this);
            this.wizardPanel.add((Component)this.getRobotSelectionPanel(), "Select robot");
        }
        return this.wizardPanel;
    }

    private void initialize() {
        this.setDefaultCloseOperation(2);
        this.setTitle("Robot Extract");
        this.setContentPane(this.getRobotImporterContentPane());
    }

    private int extractRobot() {
        int rv;
        this.repositoryManager.clearRobotList();
        this.output = new StringWriter();
        PrintWriter out = new PrintWriter(this.output);
        out.println("Robot Extract");
        List<INamedFileSpecification> selectedRobots = this.getRobotSelectionPanel().getSelectedRobots();
        INamedFileSpecification spec = selectedRobots.get(0);
        try {
            WindowUtil.setStatusWriter(out);
            rv = this.repositoryManager.extractJar(spec.getJarFile());
            WindowUtil.setStatusWriter(null);
            WindowUtil.setStatus("");
            if (rv == 0) {
                out.println("Robot extracted successfully.");
            } else if (rv == -1) {
                out.println("Cancelled.");
            }
        }
        catch (Exception e) {
            out.println(e);
            rv = 8;
        }
        return rv;
    }

    class EventHandler
    implements ActionListener {
        EventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("Refresh")) {
                RobotExtractor.this.getRobotSelectionPanel().refreshRobotList(false);
            }
        }
    }
}

