/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.robocode.battle.IBattleManager;
import net.sf.robocode.io.Logger;
import net.sf.robocode.repository.INamedFileSpecification;
import net.sf.robocode.repository.IRepositoryManager;
import net.sf.robocode.repository.ITeamFileSpecificationExt;
import net.sf.robocode.settings.ISettingsManager;
import net.sf.robocode.ui.dialog.AvailableRobotsPanel;
import net.sf.robocode.ui.dialog.RobotDescriptionPanel;
import net.sf.robocode.ui.dialog.WizardPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RobotSelectionPanel
extends WizardPanel {
    private AvailableRobotsPanel availableRobotsPanel;
    private JPanel selectedRobotsPanel;
    private JScrollPane selectedRobotsScrollPane;
    private JList selectedRobotsList;
    private JPanel buttonsPanel;
    private JPanel addButtonsPanel;
    private JPanel removeButtonsPanel;
    private JButton addButton;
    private JButton addAllButton;
    private JButton removeButton;
    private JButton removeAllButton;
    private final EventHandler eventHandler = new EventHandler();
    private RobotDescriptionPanel descriptionPanel;
    private String instructions;
    private JLabel instructionsLabel;
    private JPanel mainPanel;
    private int maxRobots = 1;
    private int minRobots = 1;
    private JPanel numRoundsPanel;
    private JTextField numRoundsTextField;
    private boolean onlyShowSource;
    private boolean onlyShowWithPackage;
    private boolean onlyShowRobots;
    private boolean onlyShowDevelopment;
    private boolean onlyShowPackaged;
    private boolean ignoreTeamRobots;
    private String preSelectedRobots;
    private final List<INamedFileSpecification> selectedRobots = new CopyOnWriteArrayList<INamedFileSpecification>();
    private boolean showNumRoundsPanel;
    private final ISettingsManager properties;
    private final IBattleManager battleManager;
    private final IRepositoryManager repositoryManager;
    private static final Cursor BUSY_CURSOR = Cursor.getPredefinedCursor(3);
    private static final Cursor DEFAULT_CURSOR = Cursor.getPredefinedCursor(0);

    public RobotSelectionPanel(ISettingsManager properties, IBattleManager battleManager, IRepositoryManager repositoryManager) {
        this.properties = properties;
        this.repositoryManager = repositoryManager;
        this.battleManager = battleManager;
    }

    public void setup(int minRobots, int maxRobots, boolean showNumRoundsPanel, String instructions, boolean onlyShowSource, boolean onlyShowWithPackage, boolean onlyShowRobots, boolean onlyShowDevelopment, boolean onlyShowPackaged, boolean ignoreTeamRobots, String preSelectedRobots) {
        this.showNumRoundsPanel = showNumRoundsPanel;
        this.minRobots = minRobots;
        this.maxRobots = maxRobots;
        this.instructions = instructions;
        this.onlyShowSource = onlyShowSource;
        this.onlyShowWithPackage = onlyShowWithPackage;
        this.onlyShowRobots = onlyShowRobots;
        this.onlyShowDevelopment = onlyShowDevelopment;
        this.onlyShowPackaged = onlyShowPackaged;
        this.ignoreTeamRobots = ignoreTeamRobots;
        this.preSelectedRobots = preSelectedRobots;
        this.initialize();
    }

    private void addAllButtonActionPerformed() {
        JList selectedList = this.getSelectedRobotsList();
        SelectedRobotsModel selectedModel = (SelectedRobotsModel)selectedList.getModel();
        for (INamedFileSpecification selected : this.availableRobotsPanel.getAvailableRobots()) {
            this.selectedRobots.add(selected);
        }
        selectedList.clearSelection();
        selectedModel.changed();
        this.fireStateChanged();
        if (selectedModel.getSize() >= this.minRobots && selectedModel.getSize() <= this.maxRobots) {
            this.showInstructions();
        } else if (selectedModel.getSize() > this.maxRobots) {
            this.showWrongNumInstructions();
        }
        this.availableRobotsPanel.getAvailableRobotsList().requestFocus();
    }

    private void addButtonActionPerformed() {
        SelectedRobotsModel selectedModel = (SelectedRobotsModel)this.getSelectedRobotsList().getModel();
        List<INamedFileSpecification> moves = this.availableRobotsPanel.getSelectedRobots();
        for (INamedFileSpecification move : moves) {
            this.selectedRobots.add(move);
        }
        selectedModel.changed();
        this.fireStateChanged();
        if (selectedModel.getSize() >= this.minRobots && selectedModel.getSize() <= this.maxRobots) {
            this.showInstructions();
        } else if (selectedModel.getSize() > this.maxRobots) {
            this.showWrongNumInstructions();
        }
        this.availableRobotsPanel.getAvailableRobotsList().requestFocus();
    }

    private JButton getAddAllButton() {
        if (this.addAllButton == null) {
            this.addAllButton = new JButton();
            this.addAllButton.setText("Add All ->");
            this.addAllButton.setMnemonic('l');
            this.addAllButton.setDisplayedMnemonicIndex(5);
            this.addAllButton.addActionListener(this.eventHandler);
        }
        return this.addAllButton;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("Add ->");
            this.addButton.setMnemonic('A');
            this.addButton.addActionListener(this.eventHandler);
        }
        return this.addButton;
    }

    private JPanel getAddButtonsPanel() {
        if (this.addButtonsPanel == null) {
            this.addButtonsPanel = new JPanel();
            this.addButtonsPanel.setLayout(new GridLayout(2, 1));
            this.addButtonsPanel.add(this.getAddButton());
            this.addButtonsPanel.add(this.getAddAllButton());
        }
        return this.addButtonsPanel;
    }

    private JPanel getButtonsPanel() {
        if (this.buttonsPanel == null) {
            this.buttonsPanel = new JPanel();
            this.buttonsPanel.setLayout(new BorderLayout(5, 5));
            this.buttonsPanel.setBorder(BorderFactory.createEmptyBorder(21, 5, 5, 5));
            this.buttonsPanel.add((Component)this.getAddButtonsPanel(), "North");
            if (this.showNumRoundsPanel) {
                this.buttonsPanel.add((Component)this.getNumRoundsPanel(), "Center");
            }
            this.buttonsPanel.add((Component)this.getRemoveButtonsPanel(), "South");
        }
        return this.buttonsPanel;
    }

    private JButton getRemoveAllButton() {
        if (this.removeAllButton == null) {
            this.removeAllButton = new JButton();
            this.removeAllButton.setText("<- Remove All");
            this.removeAllButton.setMnemonic('v');
            this.removeAllButton.setDisplayedMnemonicIndex(7);
            this.removeAllButton.addActionListener(this.eventHandler);
        }
        return this.removeAllButton;
    }

    private JButton getRemoveButton() {
        if (this.removeButton == null) {
            this.removeButton = new JButton();
            this.removeButton.setText("<- Remove");
            this.removeButton.setMnemonic('m');
            this.removeButton.setDisplayedMnemonicIndex(5);
            this.removeButton.addActionListener(this.eventHandler);
        }
        return this.removeButton;
    }

    private JPanel getRemoveButtonsPanel() {
        if (this.removeButtonsPanel == null) {
            this.removeButtonsPanel = new JPanel();
            this.removeButtonsPanel.setLayout(new GridLayout(2, 1));
            this.removeButtonsPanel.add(this.getRemoveButton());
            this.removeButtonsPanel.add(this.getRemoveAllButton());
        }
        return this.removeButtonsPanel;
    }

    public String getSelectedRobotsAsString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.selectedRobots.size(); ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(this.selectedRobots.get(i).getUniqueFullClassNameWithVersion());
        }
        return sb.toString();
    }

    public List<INamedFileSpecification> getSelectedRobots() {
        return this.selectedRobots;
    }

    private JList getSelectedRobotsList() {
        if (this.selectedRobotsList == null) {
            this.selectedRobotsList = new JList();
            this.selectedRobotsList.setModel(new SelectedRobotsModel());
            this.selectedRobotsList.setSelectionMode(2);
            RobotNameCellRenderer robotNamesCellRenderer = new RobotNameCellRenderer();
            this.selectedRobotsList.setCellRenderer(robotNamesCellRenderer);
            MouseAdapter mouseListener = new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        RobotSelectionPanel.this.removeButtonActionPerformed();
                    }
                    if ((e.getModifiers() & 4) != 0) {
                        RobotSelectionPanel.this.contextMenuActionPerformed();
                    }
                }
            };
            this.selectedRobotsList.addMouseListener(mouseListener);
            this.selectedRobotsList.addListSelectionListener(this.eventHandler);
        }
        return this.selectedRobotsList;
    }

    private JPanel getSelectedRobotsPanel() {
        if (this.selectedRobotsPanel == null) {
            this.selectedRobotsPanel = new JPanel();
            this.selectedRobotsPanel.setLayout(new BorderLayout());
            this.selectedRobotsPanel.setPreferredSize(new Dimension(120, 100));
            this.selectedRobotsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Selected Robots"));
            this.selectedRobotsPanel.add((Component)this.getSelectedRobotsScrollPane(), "Center");
        }
        return this.selectedRobotsPanel;
    }

    private JScrollPane getSelectedRobotsScrollPane() {
        if (this.selectedRobotsScrollPane == null) {
            this.selectedRobotsScrollPane = new JScrollPane();
            this.selectedRobotsScrollPane.setViewportView(this.getSelectedRobotsList());
        }
        return this.selectedRobotsScrollPane;
    }

    private void initialize() {
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BorderLayout());
        this.add((Component)this.getInstructionsLabel(), "North");
        this.add((Component)this.getMainPanel(), "Center");
        this.add((Component)this.getDescriptionPanel(), "South");
        this.setVisible(true);
        this.showInstructions();
        this.refreshRobotList(false);
    }

    private void removeAllButtonActionPerformed() {
        JList selectedList = this.getSelectedRobotsList();
        SelectedRobotsModel selectedModel = (SelectedRobotsModel)selectedList.getModel();
        this.selectedRobots.clear();
        selectedList.clearSelection();
        selectedModel.changed();
        this.fireStateChanged();
        this.showInstructions();
    }

    private void contextMenuActionPerformed() {
    }

    private void removeButtonActionPerformed() {
        JList selectedList = this.getSelectedRobotsList();
        SelectedRobotsModel selectedModel = (SelectedRobotsModel)selectedList.getModel();
        int[] sel = selectedList.getSelectedIndices();
        for (int i = 0; i < sel.length; ++i) {
            this.selectedRobots.remove(sel[i] - i);
        }
        selectedList.clearSelection();
        selectedModel.changed();
        this.fireStateChanged();
        if (selectedModel.getSize() < this.minRobots || selectedModel.getSize() > this.maxRobots) {
            this.showWrongNumInstructions();
        } else {
            this.showInstructions();
        }
    }

    public AvailableRobotsPanel getAvailableRobotsPanel() {
        if (this.availableRobotsPanel == null) {
            this.availableRobotsPanel = new AvailableRobotsPanel(this.getAddButton(), "Available Robots", this.getSelectedRobotsList(), this);
        }
        return this.availableRobotsPanel;
    }

    private RobotDescriptionPanel getDescriptionPanel() {
        if (this.descriptionPanel == null) {
            this.descriptionPanel = new RobotDescriptionPanel();
            this.descriptionPanel.setBorder(BorderFactory.createEmptyBorder(1, 10, 1, 10));
        }
        return this.descriptionPanel;
    }

    private JLabel getInstructionsLabel() {
        if (this.instructionsLabel == null) {
            this.instructionsLabel = new JLabel();
            if (this.instructions != null) {
                this.instructionsLabel.setText(this.instructions);
            }
        }
        return this.instructionsLabel;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setPreferredSize(new Dimension(550, 300));
            GridBagLayout layout = new GridBagLayout();
            this.mainPanel.setLayout(layout);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 1;
            constraints.weightx = 2.0;
            constraints.weighty = 1.0;
            constraints.anchor = 18;
            constraints.gridwidth = 2;
            layout.setConstraints(this.getAvailableRobotsPanel(), constraints);
            this.mainPanel.add(this.getAvailableRobotsPanel());
            constraints.gridwidth = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 10;
            layout.setConstraints(this.getButtonsPanel(), constraints);
            this.mainPanel.add(this.getButtonsPanel());
            constraints.gridwidth = 0;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.anchor = 18;
            layout.setConstraints(this.getSelectedRobotsPanel(), constraints);
            this.mainPanel.add(this.getSelectedRobotsPanel());
        }
        return this.mainPanel;
    }

    public int getNumRounds() {
        try {
            return Integer.parseInt(this.getNumRoundsTextField().getText());
        }
        catch (NumberFormatException e) {
            int numRounds = this.properties.getNumberOfRounds();
            this.getNumRoundsTextField().setText("" + numRounds);
            return numRounds;
        }
    }

    private JPanel getNumRoundsPanel() {
        if (this.numRoundsPanel == null) {
            this.numRoundsPanel = new JPanel();
            this.numRoundsPanel.setLayout(new BoxLayout(this.numRoundsPanel, 1));
            this.numRoundsPanel.setBorder(BorderFactory.createEmptyBorder());
            this.numRoundsPanel.add(new JPanel());
            JPanel j = new JPanel();
            j.setLayout(new BoxLayout(j, 1));
            TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Number of Rounds");
            j.setBorder(border);
            j.add(this.getNumRoundsTextField());
            j.setPreferredSize(new Dimension(border.getMinimumSize((Component)j).width, j.getPreferredSize().height));
            j.setMinimumSize(j.getPreferredSize());
            j.setMaximumSize(j.getPreferredSize());
            this.numRoundsPanel.add(j);
            this.numRoundsPanel.add(new JPanel());
        }
        return this.numRoundsPanel;
    }

    private JTextField getNumRoundsTextField() {
        final ISettingsManager props = this.properties;
        if (this.numRoundsTextField == null) {
            this.numRoundsTextField = new JTextField();
            this.numRoundsTextField.setAutoscrolls(false);
            this.numRoundsTextField.setAlignmentX(0.5f);
            this.numRoundsTextField.setHorizontalAlignment(0);
            this.numRoundsTextField.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent e) {
                }

                public void insertUpdate(DocumentEvent e) {
                    this.handleChange();
                }

                public void removeUpdate(DocumentEvent e) {
                    this.handleChange();
                }

                private void handleChange() {
                    try {
                        int numRounds = Integer.parseInt(RobotSelectionPanel.this.numRoundsTextField.getText());
                        RobotSelectionPanel.this.battleManager.getBattleProperties().setNumRounds(numRounds);
                        if (numRounds != props.getNumberOfRounds()) {
                            props.setNumberOfRounds(numRounds);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
        }
        return this.numRoundsTextField;
    }

    public int getSelectedRobotsCount() {
        return this.selectedRobots.size();
    }

    @Override
    public boolean isReady() {
        return this.getSelectedRobotsCount() >= this.minRobots && this.getSelectedRobotsCount() <= this.maxRobots;
    }

    public void refreshRobotList(final boolean withClear) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    RobotSelectionPanel.this.setBusyPointer(true);
                    if (withClear) {
                        RobotSelectionPanel.this.repositoryManager.clearRobotList();
                    }
                    List robotList = RobotSelectionPanel.this.repositoryManager.getRobotSpecificationsList(RobotSelectionPanel.this.onlyShowSource, RobotSelectionPanel.this.onlyShowWithPackage, RobotSelectionPanel.this.onlyShowRobots, RobotSelectionPanel.this.onlyShowDevelopment, RobotSelectionPanel.this.onlyShowPackaged, RobotSelectionPanel.this.ignoreTeamRobots);
                    RobotSelectionPanel.this.getAvailableRobotsPanel().setRobotList(robotList);
                    if (RobotSelectionPanel.this.preSelectedRobots != null && RobotSelectionPanel.this.preSelectedRobots.length() > 0) {
                        RobotSelectionPanel.this.setSelectedRobots(robotList, RobotSelectionPanel.this.preSelectedRobots);
                        RobotSelectionPanel.this.preSelectedRobots = null;
                    }
                }
                finally {
                    RobotSelectionPanel.this.setBusyPointer(false);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void setBusyPointer(boolean enabled) {
        this.setCursor(enabled ? BUSY_CURSOR : DEFAULT_CURSOR);
    }

    private void selectedRobotsListSelectionChanged() {
        int[] sel = this.getSelectedRobotsList().getSelectedIndices();
        if (sel.length == 1) {
            this.availableRobotsPanel.clearSelection();
            INamedFileSpecification robotSpecification = (INamedFileSpecification)this.getSelectedRobotsList().getModel().getElementAt(sel[0]);
            this.showDescription(robotSpecification);
        } else {
            this.showDescription(null);
        }
    }

    public void setNumRounds(int numRounds) {
        this.getNumRoundsTextField().setText("" + numRounds);
    }

    private void setSelectedRobots(List<INamedFileSpecification> robotList, String selectedRobotsString) {
        if (selectedRobotsString != null) {
            StringTokenizer tokenizer = new StringTokenizer(selectedRobotsString, ",");
            if (robotList == null) {
                Logger.logError((String)"Cannot add robots to a null robots list!");
                return;
            }
            this.selectedRobots.clear();
            block0: while (tokenizer.hasMoreTokens()) {
                String bot = tokenizer.nextToken();
                for (INamedFileSpecification selected : robotList) {
                    if (!selected.getUniqueFullClassNameWithVersion().equals(bot)) continue;
                    this.selectedRobots.add(selected);
                    continue block0;
                }
            }
        }
        ((SelectedRobotsModel)this.getSelectedRobotsList().getModel()).changed();
        this.fireStateChanged();
    }

    public void showDescription(INamedFileSpecification robotSpecification) {
        this.getDescriptionPanel().showDescription(robotSpecification);
    }

    public void showInstructions() {
        if (this.instructions != null) {
            this.instructionsLabel.setText(this.instructions);
            this.instructionsLabel.setVisible(true);
        } else {
            this.instructionsLabel.setVisible(false);
        }
    }

    public void showWrongNumInstructions() {
        if (this.minRobots == this.maxRobots) {
            if (this.minRobots == 1) {
                this.instructionsLabel.setText("Please select exactly 1 robot.");
            } else {
                this.instructionsLabel.setText("Please select exactly " + this.minRobots + " robots.");
            }
        } else {
            this.instructionsLabel.setText("Please select between " + this.minRobots + " and " + this.maxRobots + " robots.");
        }
        this.instructionsLabel.setVisible(true);
    }

    class SelectedRobotsModel
    extends AbstractListModel {
        SelectedRobotsModel() {
        }

        public void changed() {
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public int getSize() {
            return RobotSelectionPanel.this.selectedRobots.size();
        }

        public Object getElementAt(int which) {
            return RobotSelectionPanel.this.selectedRobots.get(which);
        }
    }

    private static class RobotNameCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private boolean useShortNames;

        public RobotNameCellRenderer() {
            this.setOpaque(true);
        }

        public void setUseShortNames(boolean useShortNames) {
            this.useShortNames = useShortNames;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setComponentOrientation(list.getComponentOrientation());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (this.useShortNames && value instanceof INamedFileSpecification) {
                INamedFileSpecification robotSpecification = (INamedFileSpecification)value;
                if (value instanceof ITeamFileSpecificationExt) {
                    this.setText("Team: " + robotSpecification.getUniqueShortClassNameWithVersion());
                } else {
                    this.setText(robotSpecification.getUniqueShortClassNameWithVersion());
                }
            } else if (value instanceof INamedFileSpecification) {
                INamedFileSpecification robotSpecification = (INamedFileSpecification)value;
                if (value instanceof ITeamFileSpecificationExt) {
                    this.setText("Team: " + robotSpecification.getUniqueFullClassNameWithVersion());
                } else {
                    this.setText(robotSpecification.getUniqueFullClassNameWithVersion());
                }
            } else {
                this.setText("??" + value.toString());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            return this;
        }
    }

    private class EventHandler
    implements ActionListener,
    ListSelectionListener {
        private EventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == RobotSelectionPanel.this.getAddAllButton()) {
                RobotSelectionPanel.this.addAllButtonActionPerformed();
            } else if (e.getSource() == RobotSelectionPanel.this.getAddButton()) {
                RobotSelectionPanel.this.addButtonActionPerformed();
            } else if (e.getSource() == RobotSelectionPanel.this.getRemoveAllButton()) {
                RobotSelectionPanel.this.removeAllButtonActionPerformed();
            } else if (e.getSource() == RobotSelectionPanel.this.getRemoveButton()) {
                RobotSelectionPanel.this.removeButtonActionPerformed();
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (e.getSource() == RobotSelectionPanel.this.getSelectedRobotsList()) {
                RobotSelectionPanel.this.selectedRobotsListSelectionChanged();
            }
        }
    }
}

