/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import net.sf.robocode.core.Container;
import net.sf.robocode.io.Logger;
import net.sf.robocode.repository.IRepositoryManager;
import net.sf.robocode.repository.ITeamFileSpecificationExt;
import net.sf.robocode.ui.IWindowManager;
import net.sf.robocode.ui.dialog.RobotSelectionPanel;
import net.sf.robocode.ui.dialog.TeamCreatorOptionsPanel;
import net.sf.robocode.ui.dialog.WizardCardPanel;
import net.sf.robocode.ui.dialog.WizardController;
import net.sf.robocode.ui.dialog.WizardListener;
import net.sf.robocode.ui.util.ShortcutUtil;
import net.sf.robocode.version.IVersionManager;

public class TeamCreator
extends JDialog
implements WizardListener {
    private JPanel teamCreatorContentPane;
    private WizardCardPanel wizardPanel;
    private WizardController wizardController;
    private RobotSelectionPanel robotSelectionPanel;
    private TeamCreatorOptionsPanel teamCreatorOptionsPanel;
    private final int minRobots = 2;
    private final int maxRobots = 10;
    private final EventHandler eventHandler = new EventHandler();
    private final IVersionManager versionManager;
    private final IRepositoryManager repositoryManager;

    public TeamCreator(IWindowManager windowManager, IRepositoryManager repositoryManager, IVersionManager versionManager) {
        super(windowManager.getRobocodeFrame());
        this.repositoryManager = repositoryManager;
        this.versionManager = versionManager;
        this.initialize();
    }

    protected TeamCreatorOptionsPanel getTeamCreatorOptionsPanel() {
        if (this.teamCreatorOptionsPanel == null) {
            this.teamCreatorOptionsPanel = new TeamCreatorOptionsPanel(this);
        }
        return this.teamCreatorOptionsPanel;
    }

    private JPanel getTeamCreatorContentPane() {
        if (this.teamCreatorContentPane == null) {
            this.teamCreatorContentPane = new JPanel();
            this.teamCreatorContentPane.setLayout(new BorderLayout());
            this.teamCreatorContentPane.add((Component)this.getWizardController(), "South");
            this.teamCreatorContentPane.add((Component)this.getWizardPanel(), "Center");
            this.getWizardPanel().getWizardController().setFinishButtonTextAndMnemonic("Create Team!", 'C', 0);
            this.teamCreatorContentPane.registerKeyboardAction(this.eventHandler, "Refresh", KeyStroke.getKeyStroke(82, ShortcutUtil.MENU_SHORTCUT_KEY_MASK), 1);
            this.teamCreatorContentPane.registerKeyboardAction(this.eventHandler, "Refresh", KeyStroke.getKeyStroke(82, ShortcutUtil.MENU_SHORTCUT_KEY_MASK), 0);
        }
        return this.teamCreatorContentPane;
    }

    protected RobotSelectionPanel getRobotSelectionPanel() {
        if (this.robotSelectionPanel == null) {
            this.robotSelectionPanel = (RobotSelectionPanel)Container.createComponent(RobotSelectionPanel.class);
            this.robotSelectionPanel.setup(2, 10, false, "Select the robots for this team.", false, true, true, false, false, false, null);
        }
        return this.robotSelectionPanel;
    }

    private WizardCardPanel getWizardPanel() {
        if (this.wizardPanel == null) {
            this.wizardPanel = new WizardCardPanel(this);
            this.wizardPanel.add((Component)this.getRobotSelectionPanel(), "Select robots");
            this.wizardPanel.add((Component)this.getTeamCreatorOptionsPanel(), "Select options");
        }
        return this.wizardPanel;
    }

    public void initialize() {
        this.setDefaultCloseOperation(2);
        this.setTitle("Create a team");
        this.setContentPane(this.getTeamCreatorContentPane());
    }

    private WizardController getWizardController() {
        if (this.wizardController == null) {
            this.wizardController = this.getWizardPanel().getWizardController();
        }
        return this.wizardController;
    }

    public void cancelButtonActionPerformed() {
        this.dispose();
    }

    public void finishButtonActionPerformed() {
        try {
            int rc = this.createTeam();
            if (rc == 0) {
                JOptionPane.showMessageDialog(this, "Team created successfully.", "Success", 1, null);
                this.dispose();
            } else {
                JOptionPane.showMessageDialog(this, "Team creation cancelled", "Cancelled", 1, null);
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Team Creation Failed", 0, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createTeam() throws IOException {
        int ok;
        File f = new File(this.repositoryManager.getRobotsDirectory(), this.teamCreatorOptionsPanel.getTeamPackage().replace('.', File.separatorChar) + this.teamCreatorOptionsPanel.getTeamNameField().getText() + ".team");
        if (f.exists() && ((ok = JOptionPane.showConfirmDialog(this, f + " already exists.  Are you sure you want to replace it?", "Warning", 1)) == 1 || ok == 2)) {
            return -1;
        }
        if (!f.getParentFile().exists() && !f.getParentFile().mkdirs()) {
            Logger.logError((String)("Can't create " + f.getParentFile().toString()));
        }
        ITeamFileSpecificationExt teamSpec = (ITeamFileSpecificationExt)this.repositoryManager.createTeam();
        URL u = null;
        String w = this.teamCreatorOptionsPanel.getWebpageField().getText();
        if (w != null && w.length() > 0) {
            try {
                u = new URL(w);
            }
            catch (MalformedURLException e) {
                try {
                    u = new URL("http://" + w);
                    this.teamCreatorOptionsPanel.getWebpageField().setText(u.toString());
                }
                catch (MalformedURLException ignored) {
                    // empty catch block
                }
            }
        }
        teamSpec.setTeamWebpage(u);
        teamSpec.setTeamDescription(this.teamCreatorOptionsPanel.getDescriptionArea().getText());
        teamSpec.setTeamAuthorName(this.teamCreatorOptionsPanel.getAuthorField().getText());
        teamSpec.setMembers(this.robotSelectionPanel.getSelectedRobotsAsString());
        teamSpec.setRobocodeVersion(this.versionManager.getVersion());
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(f);
            teamSpec.store((OutputStream)out, "Robocode robot team");
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        this.repositoryManager.clearRobotList();
        return 0;
    }

    class EventHandler
    implements ActionListener {
        EventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("Refresh")) {
                TeamCreator.this.getRobotSelectionPanel().refreshRobotList(true);
            }
        }
    }
}

