/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;

public class WindowPositionManager
implements ComponentListener {
    private Properties windowPositions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getWindowPositions() {
        if (this.windowPositions == null) {
            this.windowPositions = new Properties();
            FileInputStream in = null;
            try {
                in = new FileInputStream(FileUtil.getWindowConfigFile());
                this.windowPositions.load(in);
            }
            catch (FileNotFoundException e) {
                Logger.logMessage((String)("Creating " + FileUtil.getWindowConfigFile().getName() + " file"));
            }
            catch (Exception e) {
                Logger.logError((Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ignored) {}
                }
            }
        }
        return this.windowPositions;
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
        if (e.getComponent().getBounds().getWidth() >= (double)Toolkit.getDefaultToolkit().getScreenSize().width || e.getComponent().getBounds().getHeight() >= (double)Toolkit.getDefaultToolkit().getScreenSize().height) {
            return;
        }
        this.setWindowRect((Window)e.getComponent(), e.getComponent().getBounds());
    }

    public void componentResized(ComponentEvent e) {
        if (e.getComponent().getBounds().getWidth() >= (double)Toolkit.getDefaultToolkit().getScreenSize().width || e.getComponent().getBounds().getHeight() >= (double)Toolkit.getDefaultToolkit().getScreenSize().height) {
            return;
        }
        this.setWindowRect((Window)e.getComponent(), e.getComponent().getBounds());
    }

    public void componentShown(ComponentEvent e) {
    }

    public void setWindowRect(Window w, Rectangle rect) {
        String rString = rect.x + "," + rect.y + "," + rect.width + "," + rect.height;
        this.getWindowPositions().put(w.getClass().getName(), rString);
    }

    public Rectangle getWindowRect(Window window) {
        window.addComponentListener(this);
        String rString = (String)this.getWindowPositions().get(window.getClass().getName());
        if (rString == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(rString, ",");
        int x = Integer.parseInt(tokenizer.nextToken());
        int y = Integer.parseInt(tokenizer.nextToken());
        int width = Integer.parseInt(tokenizer.nextToken());
        int height = Integer.parseInt(tokenizer.nextToken());
        return this.fitWindowBoundsToScreen(new Rectangle(x, y, width, height));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveWindowPositions() {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(FileUtil.getWindowConfigFile());
            this.getWindowPositions().store(out, "Robocode window sizes");
        }
        catch (IOException e) {
            Logger.logError((String)"Warning:  Unable to save window positions: ", (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private Rectangle fitWindowBoundsToScreen(Rectangle windowBounds) {
        if (windowBounds == null) {
            return null;
        }
        GraphicsEnvironment gfxEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screenDevices = gfxEnv.getScreenDevices();
        for (int i = screenDevices.length - 1; i >= 0; --i) {
            GraphicsConfiguration[] gfxCfg = screenDevices[i].getConfigurations();
            for (int j = gfxCfg.length - 1; j >= 0; --j) {
                if (!gfxCfg[j].getBounds().contains(windowBounds.getLocation())) continue;
                return windowBounds;
            }
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - windowBounds.width) / 2;
        int y = (screenSize.height - windowBounds.height) / 2;
        return new Rectangle(x, y, windowBounds.width, windowBounds.height);
    }
}

