/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.packager;

import codesize.Codesize;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import net.sf.robocode.core.Container;
import net.sf.robocode.host.IHostManager;
import net.sf.robocode.host.security.RobotClassLoader;
import net.sf.robocode.io.Logger;
import net.sf.robocode.repository.INamedFileSpecification;
import net.sf.robocode.repository.IRepositoryManager;
import net.sf.robocode.repository.IRobotFileSpecificationExt;
import net.sf.robocode.repository.ITeamFileSpecificationExt;
import net.sf.robocode.ui.IWindowManager;
import net.sf.robocode.ui.dialog.ConsoleDialog;
import net.sf.robocode.ui.dialog.RobotSelectionPanel;
import net.sf.robocode.ui.dialog.WindowUtil;
import net.sf.robocode.ui.dialog.WizardCardPanel;
import net.sf.robocode.ui.dialog.WizardController;
import net.sf.robocode.ui.dialog.WizardListener;
import net.sf.robocode.ui.packager.ConfirmPanel;
import net.sf.robocode.ui.packager.FilenamePanel;
import net.sf.robocode.ui.packager.NoDuplicateJarOutputStream;
import net.sf.robocode.ui.packager.PackagerOptionsPanel;
import net.sf.robocode.ui.util.ShortcutUtil;
import net.sf.robocode.version.IVersionManager;

public class RobotPackager
extends JDialog
implements WizardListener {
    private final int minRobots = 1;
    private final int maxRobots = 1;
    private JPanel robotPackagerContentPane;
    private WizardCardPanel wizardPanel;
    private WizardController buttonsPanel;
    private FilenamePanel filenamePanel;
    private ConfirmPanel confirmPanel;
    private RobotSelectionPanel robotSelectionPanel;
    private PackagerOptionsPanel packagerOptionsPanel;
    public final byte[] buf = new byte[4096];
    private StringWriter output;
    private final IRepositoryManager repositoryManager;
    private final IWindowManager windowManager;
    private final IVersionManager versionManager;
    private final EventHandler eventHandler = new EventHandler();
    private final Object threadMonitor = new Object();

    public RobotPackager(IRepositoryManager repositoryManager, IWindowManager windowManager, IVersionManager versionManager) {
        super(windowManager.getRobocodeFrame());
        this.versionManager = versionManager;
        this.repositoryManager = repositoryManager;
        this.windowManager = windowManager;
        this.initialize();
    }

    public void cancelButtonActionPerformed() {
        this.dispose();
    }

    public void copy(FileInputStream in, NoDuplicateJarOutputStream out) throws IOException {
        while (in.available() > 0) {
            int count = in.read(this.buf, 0, 4096);
            out.write(this.buf, 0, count);
        }
    }

    public void finishButtonActionPerformed() {
        int rc = this.packageRobots();
        ConsoleDialog d = new ConsoleDialog(this.windowManager.getRobocodeFrame(), "Packaging results", false);
        if (rc < 8) {
            this.outputSizeClass();
        }
        String resultsString = rc == 0 ? "Robots Packaged Successfully.\n" + this.output.toString() : (rc == 4 ? "Robots Packaged, but with warnings.\n" + this.output.toString() : (rc == 8 ? "Robots Packaging failed.\n" + this.output.toString() : "FATAL: Unknown return code " + rc + " from packager.\n" + this.output.toString()));
        d.setText(resultsString);
        d.pack();
        d.pack();
        WindowUtil.packCenterShow(this, d);
        if (rc < 8) {
            this.dispose();
        }
    }

    private WizardController getButtonsPanel() {
        if (this.buttonsPanel == null) {
            this.buttonsPanel = this.getWizardPanel().getWizardController();
        }
        return this.buttonsPanel;
    }

    private ConfirmPanel getConfirmPanel() {
        if (this.confirmPanel == null) {
            this.confirmPanel = new ConfirmPanel(this);
        }
        return this.confirmPanel;
    }

    protected FilenamePanel getFilenamePanel() {
        if (this.filenamePanel == null) {
            this.filenamePanel = new FilenamePanel(this);
        }
        return this.filenamePanel;
    }

    protected PackagerOptionsPanel getPackagerOptionsPanel() {
        if (this.packagerOptionsPanel == null) {
            this.packagerOptionsPanel = new PackagerOptionsPanel(this);
        }
        return this.packagerOptionsPanel;
    }

    private JPanel getRobotPackagerContentPane() {
        if (this.robotPackagerContentPane == null) {
            this.robotPackagerContentPane = new JPanel();
            this.robotPackagerContentPane.setLayout(new BorderLayout());
            this.robotPackagerContentPane.add((Component)this.getButtonsPanel(), "South");
            this.robotPackagerContentPane.add((Component)this.getWizardPanel(), "Center");
            this.getWizardPanel().getWizardController().setFinishButtonTextAndMnemonic("Package!", 'P', 0);
            this.robotPackagerContentPane.registerKeyboardAction(this.eventHandler, "Refresh", KeyStroke.getKeyStroke(82, ShortcutUtil.MENU_SHORTCUT_KEY_MASK), 1);
            this.robotPackagerContentPane.registerKeyboardAction(this.eventHandler, "Refresh", KeyStroke.getKeyStroke(82, ShortcutUtil.MENU_SHORTCUT_KEY_MASK), 0);
        }
        return this.robotPackagerContentPane;
    }

    public RobotSelectionPanel getRobotSelectionPanel() {
        if (this.robotSelectionPanel == null) {
            this.robotSelectionPanel = (RobotSelectionPanel)Container.createComponent(RobotSelectionPanel.class);
            this.robotSelectionPanel.setup(1, 1, false, "Select the robot or team you would like to package.", false, false, false, true, false, true, null);
        }
        return this.robotSelectionPanel;
    }

    private WizardCardPanel getWizardPanel() {
        if (this.wizardPanel == null) {
            this.wizardPanel = new WizardCardPanel(this);
            this.wizardPanel.add((Component)this.getRobotSelectionPanel(), "Select robot");
            this.wizardPanel.add((Component)this.getPackagerOptionsPanel(), "Select options");
            this.wizardPanel.add((Component)this.getFilenamePanel(), "Select filename");
            this.wizardPanel.add((Component)this.getConfirmPanel(), "Confirm");
        }
        return this.wizardPanel;
    }

    private void initialize() {
        this.setDefaultCloseOperation(2);
        this.setTitle("Robot Packager");
        this.setContentPane(this.getRobotPackagerContentPane());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int packageRobots() {
        this.repositoryManager.clearRobotList();
        int rv = 0;
        this.output = new StringWriter();
        PrintWriter out = new PrintWriter(this.output);
        out.println("Robot Packager");
        List robotSpecificationsList = this.repositoryManager.getRobotSpecificationsList();
        String jarFilename = this.getFilenamePanel().getFilenameField().getText();
        File f = new File(jarFilename);
        if (f.exists()) {
            int ok = JOptionPane.showConfirmDialog(this, jarFilename + " already exists.  Are you sure you want to replace it?", "Warning", 1);
            if (ok == 1 || ok == 2) {
                out.println("Cancelled by user.");
                return -1;
            }
            out.println("Overwriting " + jarFilename);
        }
        List<INamedFileSpecification> selectedRobots = this.getRobotSelectionPanel().getSelectedRobots();
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        StringBuilder robots = new StringBuilder();
        for (int i = 0; i < selectedRobots.size(); ++i) {
            robots.append(selectedRobots.get(i).getFullClassName());
            if (i >= selectedRobots.size() - 1) continue;
            robots.append(',');
        }
        manifest.getMainAttributes().put(new Attributes.Name("robots"), robots.toString());
        FileOutputStream fos = null;
        try {
            out.println("Creating Jar file: " + f.getName());
            fos = new FileOutputStream(f);
            NoDuplicateJarOutputStream jarout = new NoDuplicateJarOutputStream(fos);
            jarout.setComment(this.versionManager.getVersion() + " - Robocode version");
            for (INamedFileSpecification fileSpecification : selectedRobots) {
                FileOutputStream fos2;
                String w;
                URL u;
                if (fileSpecification instanceof IRobotFileSpecificationExt) {
                    IRobotFileSpecificationExt robotFileSpecification = (IRobotFileSpecificationExt)fileSpecification;
                    if (robotFileSpecification.isDevelopmentVersion()) {
                        robotFileSpecification.setRobotDescription(this.getPackagerOptionsPanel().getDescriptionArea().getText());
                        robotFileSpecification.setRobotJavaSourceIncluded(this.getPackagerOptionsPanel().getIncludeSource().isSelected());
                        robotFileSpecification.setRobotAuthorName(this.getPackagerOptionsPanel().getAuthorField().getText());
                        u = null;
                        w = this.getPackagerOptionsPanel().getWebpageField().getText();
                        if (w.length() > 0) {
                            try {
                                u = new URL(w);
                            }
                            catch (MalformedURLException e) {
                                try {
                                    u = new URL("http://" + w);
                                    this.getPackagerOptionsPanel().getWebpageField().setText(u.toString());
                                }
                                catch (MalformedURLException ignored) {
                                    // empty catch block
                                }
                            }
                        }
                        robotFileSpecification.setRobotWebpage(u);
                        robotFileSpecification.setRobocodeVersion(this.versionManager.getVersion());
                        fos2 = null;
                        try {
                            fos2 = new FileOutputStream(new File(robotFileSpecification.getPropertiesFileName()));
                            robotFileSpecification.store((OutputStream)fos2, "Robot Properties");
                        }
                        catch (IOException e) {
                            rv = 4;
                            out.println("Unable to save properties: ");
                            e.printStackTrace(out);
                            out.println("Attempting to continue...");
                        }
                        finally {
                            if (fos2 != null) {
                                try {
                                    fos2.close();
                                }
                                catch (IOException ignored) {}
                            }
                        }
                        try {
                            robotFileSpecification = (IRobotFileSpecificationExt)robotFileSpecification.clone();
                        }
                        catch (CloneNotSupportedException e) {
                            out.println(e);
                            int n = 8;
                            if (fos != null) {
                                try {
                                    fos.close();
                                }
                                catch (IOException ignored) {
                                    // empty catch block
                                }
                            }
                            return n;
                        }
                        robotFileSpecification.setRobotVersion(this.getPackagerOptionsPanel().getVersionField().getText());
                        this.addRobotSpecification(out, jarout, robotFileSpecification);
                        continue;
                    }
                    out.println("You Cannot package a packaged robot!");
                    continue;
                }
                if (!(fileSpecification instanceof ITeamFileSpecificationExt)) continue;
                ITeamFileSpecificationExt teamSpecification = (ITeamFileSpecificationExt)fileSpecification;
                u = null;
                w = this.getPackagerOptionsPanel().getWebpageField().getText();
                if (w.length() > 0) {
                    try {
                        u = new URL(w);
                    }
                    catch (MalformedURLException e) {
                        try {
                            u = new URL("http://" + w);
                            this.getPackagerOptionsPanel().getWebpageField().setText(u.toString());
                        }
                        catch (MalformedURLException ignored) {
                            // empty catch block
                        }
                    }
                }
                teamSpecification.setTeamWebpage(u);
                teamSpecification.setTeamDescription(this.getPackagerOptionsPanel().getDescriptionArea().getText());
                teamSpecification.setTeamAuthorName(this.getPackagerOptionsPanel().getAuthorField().getText());
                teamSpecification.setRobocodeVersion(this.versionManager.getVersion());
                fos2 = null;
                try {
                    fos2 = new FileOutputStream(new File(teamSpecification.getPropertiesFileName()));
                    teamSpecification.store((OutputStream)fos2, "Team Properties");
                }
                catch (IOException e) {
                    rv = 4;
                    out.println("Unable to save .team file: " + e);
                    out.println("Attempting to continue...");
                }
                finally {
                    if (fos2 != null) {
                        try {
                            fos2.close();
                        }
                        catch (IOException ignored) {}
                    }
                }
                try {
                    teamSpecification = (ITeamFileSpecificationExt)teamSpecification.clone();
                }
                catch (CloneNotSupportedException e) {
                    out.println(e);
                    int n = 8;
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException ignored) {
                            // empty catch block
                        }
                    }
                    return n;
                }
                teamSpecification.setTeamVersion(this.getPackagerOptionsPanel().getVersionField().getText());
                StringTokenizer teamTokenizer = new StringTokenizer(teamSpecification.getMembers(), ",");
                String newMembers = "";
                block62: while (teamTokenizer.hasMoreTokens()) {
                    if (newMembers.length() != 0) {
                        newMembers = newMembers + ",";
                    }
                    String bot = teamTokenizer.nextToken();
                    for (INamedFileSpecification currentFileSpecification : robotSpecificationsList) {
                        IRobotFileSpecificationExt current;
                        if (currentFileSpecification instanceof ITeamFileSpecificationExt || !currentFileSpecification.getUniqueFullClassNameWithVersion().equals(bot) || !(current = (IRobotFileSpecificationExt)currentFileSpecification).isDevelopmentVersion() && (current.getVersion() == null || current.getVersion().length() == 0)) continue;
                        if (current.isDevelopmentVersion() && (current.getVersion() == null || current.getVersion().length() == 0)) {
                            try {
                                current = (IRobotFileSpecificationExt)current.clone();
                            }
                            catch (CloneNotSupportedException e) {
                                out.println(e);
                                int n = 8;
                                if (fos != null) {
                                    try {
                                        fos.close();
                                    }
                                    catch (IOException ignored) {
                                        // empty catch block
                                    }
                                }
                                return n;
                            }
                            current.setRobotVersion("[" + this.getPackagerOptionsPanel().getVersionField().getText() + "]");
                        }
                        newMembers = newMembers + this.addRobotSpecification(out, jarout, current);
                        continue block62;
                    }
                }
                teamSpecification.setMembers(newMembers);
                try {
                    try {
                        JarEntry entry = new JarEntry(teamSpecification.getFullClassName().replace('.', '/') + ".team");
                        jarout.putNextEntry(entry);
                        teamSpecification.store((OutputStream)jarout, "Robocode Robot Team");
                        jarout.closeEntry();
                        out.println("Added: " + entry);
                    }
                    catch (ZipException e) {
                        if (e.getMessage().indexOf("duplicate entry") >= 0) continue;
                        throw e;
                    }
                }
                catch (Throwable e) {
                    rv = 8;
                    out.println(e);
                }
            }
            jarout.close();
        }
        catch (IOException e) {
            out.println(e);
            int n = 8;
            return n;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ignored) {}
            }
        }
        this.repositoryManager.clearRobotList();
        out.println("Packaging complete.");
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputSizeClass() {
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                File jarFile = new File(RobotPackager.this.getFilenamePanel().getFilenameField().getText());
                Codesize.Item item = Codesize.processZipFile((File)jarFile);
                int codesize = item.getCodeSize();
                String weightClass = codesize >= 1500 ? "MegaBot  (codesize >= 1500 bytes)" : (codesize > 750 ? "MiniBot  (codesize < 1500 bytes)" : (codesize > 250 ? "MicroBot  (codesize < 750 bytes)" : "NanoBot  (codesize < 250 bytes)"));
                StringBuffer out = RobotPackager.this.output.getBuffer();
                out.append("\n\n---- Codesize ----\n");
                out.append("Codesize: ").append(codesize).append(" bytes\n");
                out.append("Robot weight class: ").append(weightClass).append('\n');
                Object object = RobotPackager.this.threadMonitor;
                synchronized (object) {
                    RobotPackager.this.threadMonitor.notify();
                }
            }
        };
        IHostManager hostManager = (IHostManager)Container.getComponent(IHostManager.class);
        hostManager.addSafeThread(thread);
        thread.start();
        Object object = this.threadMonitor;
        synchronized (object) {
            try {
                this.threadMonitor.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        hostManager.removeSafeThread(thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addRobotSpecification(PrintWriter out, NoDuplicateJarOutputStream jarout, IRobotFileSpecificationExt robotFileSpecification) {
        int rv = 0;
        if (!robotFileSpecification.isDevelopmentVersion()) {
            try {
                File inputJar = robotFileSpecification.getJarFile();
                FileInputStream input = null;
                try {
                    JarEntry entry = new JarEntry(inputJar.getName());
                    jarout.putNextEntry(entry);
                    input = new FileInputStream(inputJar);
                    this.copy(input, jarout);
                    jarout.closeEntry();
                    out.println("Added: " + entry);
                }
                catch (ZipException e) {
                    if (e.getMessage().indexOf("duplicate entry") < 0) {
                        throw e;
                    }
                }
                finally {
                    if (input != null) {
                        input.close();
                    }
                }
            }
            catch (Throwable e) {
                rv = 8;
                Logger.logError((Throwable)e);
                out.println(e);
            }
        } else {
            this.addToJar(out, jarout, robotFileSpecification);
        }
        String name = robotFileSpecification.getName() + " " + robotFileSpecification.getVersion();
        if (rv != 0) {
            return null;
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void addToJar(PrintWriter out, NoDuplicateJarOutputStream jarout, IRobotFileSpecificationExt robotFileSpecification) {
        classLoader = new RobotClassLoader(robotFileSpecification.getRobotClassPath(), robotFileSpecification.getFullClassName());
        try {
            block31: {
                classLoader.loadRobotMainClass();
                classes = classLoader.getReferencedClasses().iterator();
                rootDirectory = robotFileSpecification.getRootDir().toString();
                try {
                    entry = new JarEntry(robotFileSpecification.getFullClassName().replace('.', '/') + ".properties");
                    jarout.putNextEntry(entry);
                    robotFileSpecification.store((OutputStream)jarout, "Robot Properties");
                    jarout.closeEntry();
                    out.println("Added: " + entry);
                }
                catch (ZipException e) {
                    if (e.getMessage().indexOf("duplicate entry") >= 0) break block31;
                    throw e;
                }
            }
            html = new File(rootDirectory, robotFileSpecification.getFullClassName().replace('.', '/') + ".html");
            if (html.exists()) {
                input = null;
                try {
                    entry = new JarEntry(robotFileSpecification.getFullClassName().replace('.', '/') + ".html");
                    jarout.putNextEntry(entry);
                    input = new FileInputStream(html);
                    this.copy(input, jarout);
                    jarout.closeEntry();
                    out.println("Added: " + entry);
                }
                catch (ZipException e) {
                    if (e.getMessage().indexOf("duplicate entry") < 0) {
                        throw e;
                    }
                }
                finally {
                    if (input != null) {
                        input.close();
                    }
                }
            }
            while (classes.hasNext()) {
                className = (String)classes.next();
                if (className.startsWith("java") || className.startsWith("robocode")) continue;
                if (this.getPackagerOptionsPanel().getIncludeSource().isSelected() && className.indexOf("$") < 0) {
                    javaFile = new File(rootDirectory, className.replace('.', File.separatorChar) + ".java");
                    if (javaFile.exists()) {
                        try {
                            entry = new JarEntry(className.replace('.', '/') + ".java");
                            jarout.putNextEntry(entry);
                            input = new FileInputStream(javaFile);
                            this.copy(input, jarout);
                            jarout.closeEntry();
                            out.println("Added: " + entry);
                        }
                        catch (ZipException e) {
                            if (e.getMessage().indexOf("duplicate entry") >= 0) ** GOTO lbl56
                            throw e;
                        }
                    } else {
                        out.println(className.replace('.', '/') + ".java does not exist.");
                    }
                }
lbl56:
                // 5 sources

                input = null;
                try {
                    entry = new JarEntry(className.replace('.', '/') + ".class");
                    jarout.putNextEntry(entry);
                    input = new FileInputStream(new File(rootDirectory, className.replace('.', File.separatorChar) + ".class"));
                    this.copy(input, jarout);
                    jarout.closeEntry();
                    out.println("Added: " + entry);
                }
                catch (ZipException e) {
                    if (e.getMessage().indexOf("duplicate entry") >= 0) continue;
                    throw e;
                }
                finally {
                    if (input == null) continue;
                    input.close();
                }
            }
            dataDirectory = new File(rootDirectory, robotFileSpecification.getFullClassName().replace('.', '/') + ".data");
            if (dataDirectory.exists()) {
                for (File file : files = dataDirectory.listFiles()) {
                    input = null;
                    try {
                        entry = new JarEntry(robotFileSpecification.getFullClassName().replace('.', '/') + ".data/" + file.getName());
                        jarout.putNextEntry(entry);
                        input = new FileInputStream(file);
                        this.copy(input, jarout);
                        jarout.closeEntry();
                        out.println("Added: " + entry);
                    }
                    catch (ZipException e) {
                        if (e.getMessage().indexOf("duplicate entry") >= 0) continue;
                        throw e;
                    }
                    finally {
                        if (input != null) {
                            input.close();
                        }
                    }
                }
            }
        }
        catch (Throwable e) {
            out.println(e);
        }
    }

    private class EventHandler
    implements ActionListener {
        private EventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("Refresh")) {
                RobotPackager.this.getRobotSelectionPanel().refreshRobotList(true);
            }
        }
    }
}

