/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.util;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;

public class LimitedDocument
extends PlainDocument {
    int maxRows = Integer.MAX_VALUE;
    int maxCols = Integer.MAX_VALUE;

    public LimitedDocument() {
    }

    public LimitedDocument(int maxRows, int maxCols) {
        this.maxRows = maxRows;
        this.maxCols = maxCols;
    }

    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        Element rootElement = this.getDefaultRootElement();
        int i = str.indexOf("\n");
        int newlines = 0;
        while (i < str.length() && i >= 0) {
            ++newlines;
            i = str.indexOf("\n", i + 1);
        }
        int currentLines = rootElement.getElementCount();
        if (newlines > 0 && currentLines + newlines > this.maxRows) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        int lineIndex = rootElement.getElementIndex(offs);
        boolean done = false;
        int carry = rootElement.getElement(lineIndex).getEndOffset() - offs - 1;
        int lineStart = 0;
        while (!done) {
            int currentLen;
            int lineEnd = str.indexOf("\n", lineStart);
            if (lineEnd == -1 || lineEnd == str.length()) {
                if (lineStart == 0) {
                    carry = 0;
                    lineEnd = str.length();
                } else {
                    lineEnd = str.length() + carry;
                }
                done = true;
            }
            int lineLen = lineEnd - lineStart;
            if (!done && lineStart > 0) {
                currentLen = 0;
            } else {
                Element currentLine;
                if (done && lineStart > 0) {
                    ++lineIndex;
                }
                currentLen = (currentLine = rootElement.getElement(lineIndex)) != null ? currentLine.getEndOffset() - currentLine.getStartOffset() : 1;
                if (lineStart == 0) {
                    currentLen -= carry;
                }
            }
            if (lineLen + currentLen > this.maxCols + 1) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            lineStart = lineEnd + 1;
        }
        super.insertString(offs, str, a);
    }
}

