/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.battle;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Timer;
import net.sf.robocode.battle.IBattleManager;
import net.sf.robocode.battle.events.BattleEventDispatcher;
import net.sf.robocode.battle.snapshot.RobotSnapshot;
import net.sf.robocode.io.Logger;
import robocode.control.events.BattleAdaptor;
import robocode.control.events.BattleCompletedEvent;
import robocode.control.events.BattleErrorEvent;
import robocode.control.events.BattleFinishedEvent;
import robocode.control.events.BattleMessageEvent;
import robocode.control.events.BattlePausedEvent;
import robocode.control.events.BattleResumedEvent;
import robocode.control.events.BattleStartedEvent;
import robocode.control.events.IBattleListener;
import robocode.control.events.RoundEndedEvent;
import robocode.control.events.RoundStartedEvent;
import robocode.control.events.TurnEndedEvent;
import robocode.control.snapshot.IRobotSnapshot;
import robocode.control.snapshot.ITurnSnapshot;

public final class AwtBattleAdaptor {
    private final IBattleManager battleManager;
    private final BattleEventDispatcher battleEventDispatcher = new BattleEventDispatcher();
    private final BattleObserver observer;
    private final Timer timerTask;
    private final AtomicReference<ITurnSnapshot> snapshot;
    private final AtomicBoolean isRunning;
    private final AtomicBoolean isPaused;
    private final AtomicInteger majorEvent;
    private final AtomicInteger lastMajorEvent;
    private ITurnSnapshot lastSnapshot;
    private StringBuilder[] outCache;
    private int fps;
    private long measuredFrameCounter;
    private long measuredFrameStartTime;
    private final boolean skipSameFrames;

    public AwtBattleAdaptor(IBattleManager battleManager, int maxFps, boolean skipSameFrames) {
        this.battleManager = battleManager;
        this.snapshot = new AtomicReference<Object>(null);
        this.skipSameFrames = skipSameFrames;
        this.timerTask = new Timer(1000 / maxFps, new TimerTask());
        this.isRunning = new AtomicBoolean(false);
        this.isPaused = new AtomicBoolean(false);
        this.majorEvent = new AtomicInteger(0);
        this.lastMajorEvent = new AtomicInteger(0);
        this.observer = new BattleObserver();
        battleManager.addListener((IBattleListener)this.observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.timerTask.stop();
            this.battleManager.removeListener((IBattleListener)this.observer);
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void addListener(IBattleListener listener) {
        this.battleEventDispatcher.addListener(listener);
    }

    public synchronized void removeListener(IBattleListener listener) {
        this.battleEventDispatcher.removeListener(listener);
    }

    public ITurnSnapshot getLastSnapshot() {
        return this.lastSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awtOnTurnEnded(boolean forceRepaint, boolean readoutText) {
        block10: {
            try {
                ITurnSnapshot current = this.snapshot.get();
                if (current == null) {
                    this.lastSnapshot = null;
                    this.battleEventDispatcher.onTurnEnded(new TurnEndedEvent(null));
                    break block10;
                }
                if (this.lastSnapshot == current && this.skipSameFrames && !forceRepaint) break block10;
                this.lastSnapshot = current;
                IRobotSnapshot[] robots = null;
                if (readoutText) {
                    AtomicReference<ITurnSnapshot> atomicReference = this.snapshot;
                    synchronized (atomicReference) {
                        robots = this.lastSnapshot.getRobots();
                        for (int i = 0; i < robots.length; ++i) {
                            RobotSnapshot robot = (RobotSnapshot)robots[i];
                            StringBuilder cache = this.outCache[i];
                            if (cache.length() <= 0) continue;
                            robot.setOutputStreamSnapshot(cache.toString());
                            this.outCache[i].setLength(0);
                        }
                    }
                }
                this.battleEventDispatcher.onTurnEnded(new TurnEndedEvent(this.lastSnapshot));
                if (readoutText) {
                    for (IRobotSnapshot robot : robots) {
                        ((RobotSnapshot)robot).setOutputStreamSnapshot(null);
                    }
                }
                this.calculateFPS();
            }
            catch (Throwable t) {
                Logger.logError((Throwable)t);
            }
        }
    }

    public int getFPS() {
        return this.fps;
    }

    private void calculateFPS() {
        long deltaTime;
        if (this.measuredFrameCounter++ == 0L) {
            this.measuredFrameStartTime = System.nanoTime();
        }
        if ((deltaTime = System.nanoTime() - this.measuredFrameStartTime) / 1000000000L >= 1L) {
            this.fps = (int)(this.measuredFrameCounter * 1000000000L / deltaTime);
            this.measuredFrameCounter = 0L;
        }
    }

    static /* synthetic */ StringBuilder[] access$602(AwtBattleAdaptor x0, StringBuilder[] x1) {
        x0.outCache = x1;
        return x1;
    }

    private class BattleObserver
    extends BattleAdaptor {
        private BattleObserver() {
        }

        public void onTurnEnded(TurnEndedEvent event) {
            if (AwtBattleAdaptor.this.lastMajorEvent.get() == AwtBattleAdaptor.this.majorEvent.get()) {
                AwtBattleAdaptor.this.snapshot.set(event.getTurnSnapshot());
            }
            IRobotSnapshot[] robots = event.getTurnSnapshot().getRobots();
            for (int i = 0; i < robots.length; ++i) {
                RobotSnapshot robot = (RobotSnapshot)robots[i];
                final int r = i;
                final String text = robot.getOutputStreamSnapshot();
                if (text == null || text.length() == 0) continue;
                robot.setOutputStreamSnapshot(null);
                EventQueue.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        AtomicReference atomicReference = AwtBattleAdaptor.this.snapshot;
                        synchronized (atomicReference) {
                            AwtBattleAdaptor.this.outCache[r].append(text);
                        }
                    }
                });
            }
            if (AwtBattleAdaptor.this.isPaused.get()) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        AwtBattleAdaptor.this.awtOnTurnEnded(false, true);
                    }
                });
            }
        }

        public void onRoundStarted(final RoundStartedEvent event) {
            if (AwtBattleAdaptor.this.lastMajorEvent.get() == AwtBattleAdaptor.this.majorEvent.get()) {
                AwtBattleAdaptor.this.snapshot.set(event.getStartSnapshot());
            }
            AwtBattleAdaptor.this.majorEvent.incrementAndGet();
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    AwtBattleAdaptor.this.awtOnTurnEnded(true, false);
                    AwtBattleAdaptor.this.battleEventDispatcher.onRoundStarted(event);
                    AwtBattleAdaptor.this.lastMajorEvent.incrementAndGet();
                }
            });
        }

        public void onBattleStarted(final BattleStartedEvent event) {
            AwtBattleAdaptor.this.majorEvent.incrementAndGet();
            EventQueue.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    AwtBattleAdaptor.this.isRunning.set(true);
                    AwtBattleAdaptor.this.isPaused.set(false);
                    AtomicReference atomicReference = AwtBattleAdaptor.this.snapshot;
                    synchronized (atomicReference) {
                        AwtBattleAdaptor.access$602(AwtBattleAdaptor.this, new StringBuilder[event.getRobotsCount()]);
                        for (int i = 0; i < event.getRobotsCount(); ++i) {
                            ((AwtBattleAdaptor)AwtBattleAdaptor.this).outCache[i] = new StringBuilder(1024);
                        }
                    }
                    AwtBattleAdaptor.this.snapshot.set(null);
                    AwtBattleAdaptor.this.battleEventDispatcher.onBattleStarted(event);
                    AwtBattleAdaptor.this.lastMajorEvent.incrementAndGet();
                    AwtBattleAdaptor.this.awtOnTurnEnded(true, false);
                    AwtBattleAdaptor.this.timerTask.start();
                }
            });
        }

        public void onBattleFinished(final BattleFinishedEvent event) {
            AwtBattleAdaptor.this.majorEvent.incrementAndGet();
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    AwtBattleAdaptor.this.isRunning.set(false);
                    AwtBattleAdaptor.this.isPaused.set(false);
                    AwtBattleAdaptor.this.timerTask.stop();
                    AwtBattleAdaptor.this.awtOnTurnEnded(true, true);
                    AwtBattleAdaptor.this.battleEventDispatcher.onBattleFinished(event);
                    AwtBattleAdaptor.this.lastMajorEvent.incrementAndGet();
                    AwtBattleAdaptor.this.snapshot.set(null);
                    AwtBattleAdaptor.this.awtOnTurnEnded(true, true);
                }
            });
        }

        public void onBattleCompleted(final BattleCompletedEvent event) {
            AwtBattleAdaptor.this.majorEvent.incrementAndGet();
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    AwtBattleAdaptor.this.battleEventDispatcher.onBattleCompleted(event);
                    AwtBattleAdaptor.this.lastMajorEvent.incrementAndGet();
                    AwtBattleAdaptor.this.awtOnTurnEnded(true, true);
                }
            });
        }

        public void onRoundEnded(final RoundEndedEvent event) {
            AwtBattleAdaptor.this.majorEvent.incrementAndGet();
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    AwtBattleAdaptor.this.battleEventDispatcher.onRoundEnded(event);
                    AwtBattleAdaptor.this.lastMajorEvent.incrementAndGet();
                    AwtBattleAdaptor.this.awtOnTurnEnded(true, true);
                }
            });
        }

        public void onBattlePaused(final BattlePausedEvent event) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    AwtBattleAdaptor.this.timerTask.stop();
                    AwtBattleAdaptor.this.battleEventDispatcher.onBattlePaused(event);
                    AwtBattleAdaptor.this.awtOnTurnEnded(true, true);
                    AwtBattleAdaptor.this.isPaused.set(true);
                }
            });
        }

        public void onBattleResumed(final BattleResumedEvent event) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    AwtBattleAdaptor.this.battleEventDispatcher.onBattleResumed(event);
                    if (AwtBattleAdaptor.this.isRunning.get()) {
                        AwtBattleAdaptor.this.timerTask.start();
                        AwtBattleAdaptor.this.isPaused.set(false);
                    }
                }
            });
        }

        public void onBattleMessage(final BattleMessageEvent event) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    AwtBattleAdaptor.this.battleEventDispatcher.onBattleMessage(event);
                }
            });
        }

        public void onBattleError(final BattleErrorEvent event) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    AwtBattleAdaptor.this.battleEventDispatcher.onBattleError(event);
                }
            });
        }
    }

    private class TimerTask
    implements ActionListener {
        private TimerTask() {
        }

        public void actionPerformed(ActionEvent e) {
            AwtBattleAdaptor.this.awtOnTurnEnded(false, true);
        }
    }
}

