/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import net.sf.robocode.battle.IBattleManager;
import net.sf.robocode.cachecleaner.CacheCleaner;
import net.sf.robocode.core.Container;
import net.sf.robocode.host.ICpuManager;
import net.sf.robocode.recording.BattleRecordFormat;
import net.sf.robocode.recording.IRecordManager;
import net.sf.robocode.settings.ISettingsListener;
import net.sf.robocode.settings.ISettingsManager;
import net.sf.robocode.ui.IWindowManagerExt;
import net.sf.robocode.ui.dialog.RobocodeFrame;
import net.sf.robocode.ui.dialog.WindowUtil;
import net.sf.robocode.ui.editor.IRobocodeEditor;
import net.sf.robocode.ui.util.ShortcutUtil;

public class MenuBar
extends JMenuBar {
    private JMenu battleMenu;
    private JMenuItem battleNewMenuItem;
    private JMenuItem battleOpenMenuItem;
    private JMenuItem battleSaveMenuItem;
    private JMenuItem battleSaveAsMenuItem;
    private JMenuItem battleExitMenuItem;
    private JMenuItem battleOpenRecordMenuItem;
    private JMenuItem battleSaveRecordAsMenuItem;
    private JMenuItem battleExportRecordMenuItem;
    private JMenuItem battleImportRecordMenuItem;
    private JMenu robotMenu;
    private JMenuItem robotEditorMenuItem;
    private JMenuItem robotImportMenuItem;
    private JMenuItem robotPackagerMenuItem;
    private JMenuItem robotCreateTeamMenuItem;
    private JMenu optionsMenu;
    private JMenuItem optionsPreferencesMenuItem;
    private JMenuItem optionsFitWindowMenuItem;
    private JCheckBoxMenuItem optionsShowRankingCheckBoxMenuItem;
    private JMenuItem optionsRecalculateCpuConstantMenuItem;
    private JMenuItem optionsCleanRobotCacheMenuItem;
    private JMenu helpMenu;
    private JMenuItem helpOnlineHelpMenuItem;
    private JMenuItem helpCheckForNewVersionMenuItem;
    private JMenuItem helpVersionsTxtMenuItem;
    private JMenuItem helpRobocodeApiMenuItem;
    private JMenuItem helpJavaDocumentationMenuItem;
    private JMenuItem helpFaqMenuItem;
    private JMenuItem helpAboutMenuItem;
    private JMenuItem helpRobocodeMenuItem;
    private JMenuItem helpRoboWikiMenuItem;
    private JMenuItem helpYahooGroupRobocodeMenuItem;
    private JMenuItem helpRobocodeRepositoryMenuItem;
    public final EventHandler eventHandler = new EventHandler();
    private RobocodeFrame robocodeFrame;
    private final ISettingsManager properties;
    private final IWindowManagerExt windowManager;
    private final IBattleManager battleManager;
    private final IRecordManager recordManager;
    private final ICpuManager cpuManager;

    public MenuBar(ISettingsManager properties, IWindowManagerExt windowManager, IBattleManager battleManager, IRecordManager recordManager, ICpuManager cpuManager) {
        this.properties = properties;
        this.windowManager = windowManager;
        this.battleManager = battleManager;
        this.recordManager = recordManager;
        this.cpuManager = cpuManager;
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        this.add(this.getBattleMenu());
        this.add(this.getRobotMenu());
        this.add(this.getOptionsMenu());
        this.add(this.getHelpMenu());
    }

    public void setup(RobocodeFrame robocodeFrame) {
        this.robocodeFrame = robocodeFrame;
    }

    private void battleExitActionPerformed() {
        this.robocodeFrame.dispose();
    }

    private void battleNewActionPerformed() {
        this.windowManager.showNewBattleDialog(this.battleManager.getBattleProperties(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void battleOpenActionPerformed() {
        try {
            this.battleManager.pauseBattle();
            String path = this.windowManager.showBattleOpenDialog(".battle", "Battles");
            if (path != null) {
                this.battleManager.setBattleFilename(path);
                this.windowManager.showNewBattleDialog(this.battleManager.loadBattleProperties(), true);
            }
        }
        finally {
            this.battleManager.resumeBattle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void battleSaveActionPerformed() {
        try {
            this.battleManager.pauseBattle();
            String path = this.battleManager.getBattleFilename();
            if (path == null) {
                path = this.windowManager.saveBattleDialog(this.battleManager.getBattlePath(), ".battle", "Battles");
            }
            if (path != null) {
                this.battleManager.setBattleFilename(path);
                this.battleManager.saveBattleProperties();
            }
        }
        finally {
            this.battleManager.resumeBattle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void battleSaveAsActionPerformed() {
        try {
            this.battleManager.pauseBattle();
            String path = this.windowManager.saveBattleDialog(this.battleManager.getBattlePath(), ".battle", "Battles");
            if (path != null) {
                this.battleManager.setBattleFilename(path);
                this.battleManager.saveBattleProperties();
            }
        }
        finally {
            this.battleManager.resumeBattle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void battleOpenRecordActionPerformed() {
        block6: {
            try {
                this.battleManager.pauseBattle();
                String path = this.windowManager.showBattleOpenDialog(".br", "Records");
                if (path == null) break block6;
                this.battleManager.stop(true);
                this.robocodeFrame.getReplayButton().setVisible(true);
                this.robocodeFrame.getReplayButton().setEnabled(true);
                this.getBattleSaveRecordAsMenuItem().setEnabled(true);
                this.getBattleExportRecordMenuItem().setEnabled(true);
                try {
                    this.robocodeFrame.setBusyPointer(true);
                    this.recordManager.loadRecord(path, BattleRecordFormat.BINARY_ZIP);
                }
                finally {
                    this.robocodeFrame.setBusyPointer(false);
                }
                this.battleManager.replay();
            }
            finally {
                this.battleManager.resumeBattle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void battleImportRecordActionPerformed() {
        block6: {
            try {
                this.battleManager.pauseBattle();
                String path = this.windowManager.showBattleOpenDialog(".br.xml", "XML Records");
                if (path == null) break block6;
                this.battleManager.stop(true);
                this.robocodeFrame.getReplayButton().setVisible(true);
                this.robocodeFrame.getReplayButton().setEnabled(true);
                this.getBattleSaveRecordAsMenuItem().setEnabled(true);
                this.getBattleExportRecordMenuItem().setEnabled(true);
                try {
                    this.robocodeFrame.setBusyPointer(true);
                    this.recordManager.loadRecord(path, BattleRecordFormat.XML);
                }
                finally {
                    this.robocodeFrame.setBusyPointer(false);
                }
                this.battleManager.replay();
            }
            finally {
                this.battleManager.resumeBattle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void battleSaveRecordAsActionPerformed() {
        block7: {
            if (this.recordManager.hasRecord()) {
                try {
                    this.battleManager.pauseBattle();
                    String path = this.windowManager.saveBattleDialog(this.battleManager.getBattlePath(), ".br", "Records");
                    if (path == null) break block7;
                    try {
                        this.robocodeFrame.setBusyPointer(true);
                        this.recordManager.saveRecord(path, BattleRecordFormat.BINARY_ZIP);
                    }
                    finally {
                        this.robocodeFrame.setBusyPointer(false);
                    }
                }
                finally {
                    this.battleManager.resumeBattle();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void battleExportRecordActionPerformed() {
        block7: {
            if (this.recordManager.hasRecord()) {
                try {
                    this.battleManager.pauseBattle();
                    String path = this.windowManager.saveBattleDialog(this.battleManager.getBattlePath(), ".br.xml", "XML Records");
                    if (path == null) break block7;
                    try {
                        this.robocodeFrame.setBusyPointer(true);
                        this.recordManager.saveRecord(path, BattleRecordFormat.XML);
                    }
                    finally {
                        this.robocodeFrame.setBusyPointer(false);
                    }
                }
                finally {
                    this.battleManager.resumeBattle();
                }
            }
        }
    }

    private JMenuItem getBattleExitMenuItem() {
        if (this.battleExitMenuItem == null) {
            this.battleExitMenuItem = new JMenuItem();
            this.battleExitMenuItem.setText("Exit");
            this.battleExitMenuItem.setMnemonic('x');
            this.battleExitMenuItem.setDisplayedMnemonicIndex(1);
            this.battleExitMenuItem.addActionListener(this.eventHandler);
        }
        return this.battleExitMenuItem;
    }

    public JMenu getBattleMenu() {
        if (this.battleMenu == null) {
            this.battleMenu = new JMenu();
            this.battleMenu.setText("Battle");
            this.battleMenu.setMnemonic('B');
            this.battleMenu.add(this.getBattleNewMenuItem());
            this.battleMenu.add(this.getBattleOpenMenuItem());
            this.battleMenu.add(new JSeparator());
            this.battleMenu.add(this.getBattleSaveMenuItem());
            this.battleMenu.add(this.getBattleSaveAsMenuItem());
            this.battleMenu.add(new JSeparator());
            this.battleMenu.add(this.getBattleOpenRecordMenuItem());
            this.battleMenu.add(this.getBattleSaveRecordAsMenuItem());
            this.battleMenu.add(this.getBattleImportRecordMenuItem());
            this.battleMenu.add(this.getBattleExportRecordMenuItem());
            this.battleMenu.add(new JSeparator());
            this.battleMenu.add(this.getBattleExitMenuItem());
            this.battleMenu.addMenuListener(this.eventHandler);
        }
        return this.battleMenu;
    }

    private JMenuItem getBattleNewMenuItem() {
        if (this.battleNewMenuItem == null) {
            this.battleNewMenuItem = new JMenuItem();
            this.battleNewMenuItem.setText("New");
            this.battleNewMenuItem.setMnemonic('N');
            this.battleNewMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, ShortcutUtil.MENU_SHORTCUT_KEY_MASK, false));
            this.battleNewMenuItem.addActionListener(this.eventHandler);
        }
        return this.battleNewMenuItem;
    }

    private JMenuItem getBattleOpenMenuItem() {
        if (this.battleOpenMenuItem == null) {
            this.battleOpenMenuItem = new JMenuItem();
            this.battleOpenMenuItem.setText("Open");
            this.battleOpenMenuItem.setMnemonic('O');
            this.battleOpenMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, ShortcutUtil.MENU_SHORTCUT_KEY_MASK, false));
            this.battleOpenMenuItem.addActionListener(this.eventHandler);
        }
        return this.battleOpenMenuItem;
    }

    public JMenuItem getBattleSaveAsMenuItem() {
        if (this.battleSaveAsMenuItem == null) {
            this.battleSaveAsMenuItem = new JMenuItem();
            this.battleSaveAsMenuItem.setText("Save As");
            this.battleSaveAsMenuItem.setMnemonic('A');
            this.battleSaveAsMenuItem.setDisplayedMnemonicIndex(5);
            this.battleSaveAsMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, ShortcutUtil.MENU_SHORTCUT_KEY_MASK | 1, false));
            this.battleSaveAsMenuItem.setEnabled(false);
            this.battleSaveAsMenuItem.addActionListener(this.eventHandler);
        }
        return this.battleSaveAsMenuItem;
    }

    public JMenuItem getBattleSaveMenuItem() {
        if (this.battleSaveMenuItem == null) {
            this.battleSaveMenuItem = new JMenuItem();
            this.battleSaveMenuItem.setText("Save");
            this.battleSaveMenuItem.setMnemonic('S');
            this.battleSaveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, ShortcutUtil.MENU_SHORTCUT_KEY_MASK, false));
            this.battleSaveMenuItem.setEnabled(false);
            this.battleSaveMenuItem.addActionListener(this.eventHandler);
        }
        return this.battleSaveMenuItem;
    }

    private JMenuItem getBattleOpenRecordMenuItem() {
        if (this.battleOpenRecordMenuItem == null) {
            this.battleOpenRecordMenuItem = new JMenuItem();
            this.battleOpenRecordMenuItem.setText("Open Record");
            this.battleOpenRecordMenuItem.setMnemonic('d');
            this.battleOpenRecordMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, ShortcutUtil.MENU_SHORTCUT_KEY_MASK | 1, false));
            this.battleOpenRecordMenuItem.addActionListener(this.eventHandler);
        }
        return this.battleOpenRecordMenuItem;
    }

    private JMenuItem getBattleImportRecordMenuItem() {
        if (this.battleImportRecordMenuItem == null) {
            this.battleImportRecordMenuItem = new JMenuItem();
            this.battleImportRecordMenuItem.setText("Import XML Record");
            this.battleImportRecordMenuItem.setMnemonic('I');
            this.battleImportRecordMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, ShortcutUtil.MENU_SHORTCUT_KEY_MASK, false));
            this.battleImportRecordMenuItem.addActionListener(this.eventHandler);
        }
        return this.battleImportRecordMenuItem;
    }

    public JMenuItem getBattleSaveRecordAsMenuItem() {
        if (this.battleSaveRecordAsMenuItem == null) {
            this.battleSaveRecordAsMenuItem = new JMenuItem();
            this.battleSaveRecordAsMenuItem.setText("Save Record");
            this.battleSaveRecordAsMenuItem.setMnemonic('R');
            this.battleSaveRecordAsMenuItem.setDisplayedMnemonicIndex(5);
            this.battleSaveRecordAsMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, ShortcutUtil.MENU_SHORTCUT_KEY_MASK, false));
            this.battleSaveRecordAsMenuItem.setEnabled(false);
            this.battleSaveRecordAsMenuItem.addActionListener(this.eventHandler);
            ISettingsManager props = this.properties;
            props.addPropertyListener(new ISettingsListener(){

                public void settingChanged(String property) {
                    if (property.equals("robocode.options.common.enableReplayRecording")) {
                        boolean canReplayRecord = MenuBar.this.recordManager.hasRecord();
                        boolean enableSaveRecord = MenuBar.this.properties.getOptionsCommonEnableReplayRecording() & canReplayRecord;
                        MenuBar.this.battleSaveRecordAsMenuItem.setEnabled(enableSaveRecord);
                    }
                }
            });
        }
        return this.battleSaveRecordAsMenuItem;
    }

    public JMenuItem getBattleExportRecordMenuItem() {
        if (this.battleExportRecordMenuItem == null) {
            this.battleExportRecordMenuItem = new JMenuItem();
            this.battleExportRecordMenuItem.setText("Export XML Record");
            this.battleExportRecordMenuItem.setMnemonic('E');
            this.battleExportRecordMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, ShortcutUtil.MENU_SHORTCUT_KEY_MASK, false));
            this.battleExportRecordMenuItem.setEnabled(false);
            this.battleExportRecordMenuItem.addActionListener(this.eventHandler);
            ISettingsManager props = this.properties;
            props.addPropertyListener(new ISettingsListener(){

                public void settingChanged(String property) {
                    if (property.equals("robocode.options.common.enableReplayRecording")) {
                        boolean canReplayRecord = MenuBar.this.recordManager.hasRecord();
                        boolean enableSaveRecord = MenuBar.this.properties.getOptionsCommonEnableReplayRecording() & canReplayRecord;
                        MenuBar.this.battleExportRecordMenuItem.setEnabled(enableSaveRecord);
                    }
                }
            });
        }
        return this.battleExportRecordMenuItem;
    }

    private JMenuItem getHelpAboutMenuItem() {
        if (this.helpAboutMenuItem == null) {
            this.helpAboutMenuItem = new JMenuItem();
            this.helpAboutMenuItem.setText("About");
            this.helpAboutMenuItem.setMnemonic('A');
            this.helpAboutMenuItem.addActionListener(this.eventHandler);
        }
        return this.helpAboutMenuItem;
    }

    private JMenuItem getHelpCheckForNewVersionMenuItem() {
        if (this.helpCheckForNewVersionMenuItem == null) {
            this.helpCheckForNewVersionMenuItem = new JMenuItem();
            this.helpCheckForNewVersionMenuItem.setText("Check for new version");
            this.helpCheckForNewVersionMenuItem.setMnemonic('C');
            this.helpCheckForNewVersionMenuItem.addActionListener(this.eventHandler);
        }
        return this.helpCheckForNewVersionMenuItem;
    }

    public JMenu getHelpMenu() {
        if (this.helpMenu == null) {
            this.helpMenu = new JMenu();
            this.helpMenu.setText("Help");
            this.helpMenu.setMnemonic('H');
            this.helpMenu.add(this.getHelpOnlineHelpMenuItem());
            this.helpMenu.add(this.getHelpRobocodeApiMenuItem());
            this.helpMenu.add(this.getHelpRoboWikiMenuItem());
            this.helpMenu.add(this.getHelpYahooGroupRobocodeMenuItem());
            this.helpMenu.add(this.getHelpFaqMenuItem());
            this.helpMenu.add(new JSeparator());
            this.helpMenu.add(this.getHelpRobocodeMenuItem());
            this.helpMenu.add(this.getHelpRobocodeRepositoryMenuItem());
            this.helpMenu.add(new JSeparator());
            this.helpMenu.add(this.getHelpJavaDocumentationMenuItem());
            this.helpMenu.add(new JSeparator());
            this.helpMenu.add(this.getHelpCheckForNewVersionMenuItem());
            this.helpMenu.add(this.getHelpVersionsTxtMenuItem());
            this.helpMenu.add(new JSeparator());
            this.helpMenu.add(this.getHelpAboutMenuItem());
            this.helpMenu.addMenuListener(this.eventHandler);
        }
        return this.helpMenu;
    }

    private JMenuItem getHelpFaqMenuItem() {
        if (this.helpFaqMenuItem == null) {
            this.helpFaqMenuItem = new JMenuItem();
            this.helpFaqMenuItem.setText("Robocode FAQ");
            this.helpFaqMenuItem.setMnemonic('F');
            this.helpFaqMenuItem.setDisplayedMnemonicIndex(9);
            this.helpFaqMenuItem.addActionListener(this.eventHandler);
        }
        return this.helpFaqMenuItem;
    }

    private JMenuItem getHelpOnlineHelpMenuItem() {
        if (this.helpOnlineHelpMenuItem == null) {
            this.helpOnlineHelpMenuItem = new JMenuItem();
            this.helpOnlineHelpMenuItem.setText("Online help");
            this.helpOnlineHelpMenuItem.setMnemonic('O');
            this.helpOnlineHelpMenuItem.addActionListener(this.eventHandler);
        }
        return this.helpOnlineHelpMenuItem;
    }

    private JMenuItem getHelpVersionsTxtMenuItem() {
        if (this.helpVersionsTxtMenuItem == null) {
            this.helpVersionsTxtMenuItem = new JMenuItem();
            this.helpVersionsTxtMenuItem.setText("Version info");
            this.helpVersionsTxtMenuItem.setMnemonic('V');
            this.helpVersionsTxtMenuItem.addActionListener(this.eventHandler);
        }
        return this.helpVersionsTxtMenuItem;
    }

    private JMenuItem getHelpRobocodeApiMenuItem() {
        if (this.helpRobocodeApiMenuItem == null) {
            this.helpRobocodeApiMenuItem = new JMenuItem();
            this.helpRobocodeApiMenuItem.setText("Robocode API");
            this.helpRobocodeApiMenuItem.setMnemonic('I');
            this.helpRobocodeApiMenuItem.setDisplayedMnemonicIndex(11);
            this.helpRobocodeApiMenuItem.addActionListener(this.eventHandler);
        }
        return this.helpRobocodeApiMenuItem;
    }

    private JMenuItem getHelpRobocodeMenuItem() {
        if (this.helpRobocodeMenuItem == null) {
            this.helpRobocodeMenuItem = new JMenuItem();
            this.helpRobocodeMenuItem.setText("Robocode home page");
            this.helpRobocodeMenuItem.setMnemonic('H');
            this.helpRobocodeMenuItem.setDisplayedMnemonicIndex(9);
            this.helpRobocodeMenuItem.addActionListener(this.eventHandler);
        }
        return this.helpRobocodeMenuItem;
    }

    private JMenuItem getHelpJavaDocumentationMenuItem() {
        if (this.helpJavaDocumentationMenuItem == null) {
            this.helpJavaDocumentationMenuItem = new JMenuItem();
            this.helpJavaDocumentationMenuItem.setText("Java 5.0 documentation");
            this.helpJavaDocumentationMenuItem.setMnemonic('J');
            this.helpJavaDocumentationMenuItem.addActionListener(this.eventHandler);
        }
        return this.helpJavaDocumentationMenuItem;
    }

    private JMenuItem getHelpRoboWikiMenuItem() {
        if (this.helpRoboWikiMenuItem == null) {
            this.helpRoboWikiMenuItem = new JMenuItem();
            this.helpRoboWikiMenuItem.setText("RoboWiki site");
            this.helpRoboWikiMenuItem.setMnemonic('W');
            this.helpRoboWikiMenuItem.setDisplayedMnemonicIndex(4);
            this.helpRoboWikiMenuItem.addActionListener(this.eventHandler);
        }
        return this.helpRoboWikiMenuItem;
    }

    private JMenuItem getHelpYahooGroupRobocodeMenuItem() {
        if (this.helpYahooGroupRobocodeMenuItem == null) {
            this.helpYahooGroupRobocodeMenuItem = new JMenuItem();
            this.helpYahooGroupRobocodeMenuItem.setText("Yahoo Group for Robocode");
            this.helpYahooGroupRobocodeMenuItem.setMnemonic('Y');
            this.helpYahooGroupRobocodeMenuItem.addActionListener(this.eventHandler);
        }
        return this.helpYahooGroupRobocodeMenuItem;
    }

    private JMenuItem getHelpRobocodeRepositoryMenuItem() {
        if (this.helpRobocodeRepositoryMenuItem == null) {
            this.helpRobocodeRepositoryMenuItem = new JMenuItem();
            this.helpRobocodeRepositoryMenuItem.setText("Robocode Repository");
            this.helpRobocodeRepositoryMenuItem.setMnemonic('R');
            this.helpRobocodeRepositoryMenuItem.setDisplayedMnemonicIndex(9);
            this.helpRobocodeRepositoryMenuItem.addActionListener(this.eventHandler);
        }
        return this.helpRobocodeRepositoryMenuItem;
    }

    private JMenuItem getOptionsFitWindowMenuItem() {
        if (this.optionsFitWindowMenuItem == null) {
            this.optionsFitWindowMenuItem = new JMenuItem();
            this.optionsFitWindowMenuItem.setText("Default window size");
            this.optionsFitWindowMenuItem.setMnemonic('D');
            this.optionsFitWindowMenuItem.addActionListener(this.eventHandler);
        }
        return this.optionsFitWindowMenuItem;
    }

    public JCheckBoxMenuItem getOptionsShowRankingCheckBoxMenuItem() {
        if (this.optionsShowRankingCheckBoxMenuItem == null) {
            this.optionsShowRankingCheckBoxMenuItem = new JCheckBoxMenuItem();
            this.optionsShowRankingCheckBoxMenuItem.setText("Show current rankings");
            this.optionsShowRankingCheckBoxMenuItem.setMnemonic('r');
            this.optionsShowRankingCheckBoxMenuItem.setDisplayedMnemonicIndex(13);
            this.optionsShowRankingCheckBoxMenuItem.addActionListener(this.eventHandler);
            this.optionsShowRankingCheckBoxMenuItem.setEnabled(false);
        }
        return this.optionsShowRankingCheckBoxMenuItem;
    }

    private JMenuItem getOptionsRecalculateCpuConstantMenuItem() {
        if (this.optionsRecalculateCpuConstantMenuItem == null) {
            this.optionsRecalculateCpuConstantMenuItem = new JMenuItem();
            this.optionsRecalculateCpuConstantMenuItem.setText("Recalculate CPU constant");
            this.optionsRecalculateCpuConstantMenuItem.setMnemonic('e');
            this.optionsRecalculateCpuConstantMenuItem.setDisplayedMnemonicIndex(1);
            this.optionsRecalculateCpuConstantMenuItem.addActionListener(this.eventHandler);
        }
        return this.optionsRecalculateCpuConstantMenuItem;
    }

    private JMenuItem getOptionsCleanRobotCacheMenuItem() {
        if (this.optionsCleanRobotCacheMenuItem == null) {
            this.optionsCleanRobotCacheMenuItem = new JMenuItem();
            this.optionsCleanRobotCacheMenuItem.setText("Clean robot cache");
            this.optionsCleanRobotCacheMenuItem.setMnemonic('C');
            this.optionsCleanRobotCacheMenuItem.addActionListener(this.eventHandler);
        }
        return this.optionsCleanRobotCacheMenuItem;
    }

    private JMenu getOptionsMenu() {
        if (this.optionsMenu == null) {
            this.optionsMenu = new JMenu();
            this.optionsMenu.setText("Options");
            this.optionsMenu.setMnemonic('O');
            this.optionsMenu.add(this.getOptionsPreferencesMenuItem());
            this.optionsMenu.add(this.getOptionsFitWindowMenuItem());
            this.optionsMenu.add(new JSeparator());
            this.optionsMenu.add(this.getOptionsShowRankingCheckBoxMenuItem());
            this.optionsMenu.add(new JSeparator());
            this.optionsMenu.add(this.getOptionsRecalculateCpuConstantMenuItem());
            this.optionsMenu.add(this.getOptionsCleanRobotCacheMenuItem());
            this.optionsMenu.addMenuListener(this.eventHandler);
        }
        return this.optionsMenu;
    }

    private JMenuItem getOptionsPreferencesMenuItem() {
        if (this.optionsPreferencesMenuItem == null) {
            this.optionsPreferencesMenuItem = new JMenuItem();
            this.optionsPreferencesMenuItem.setText("Preferences");
            this.optionsPreferencesMenuItem.setMnemonic('P');
            this.optionsPreferencesMenuItem.addActionListener(this.eventHandler);
        }
        return this.optionsPreferencesMenuItem;
    }

    private JMenuItem getRobotEditorMenuItem() {
        if (this.robotEditorMenuItem == null) {
            this.robotEditorMenuItem = new JMenuItem();
            this.robotEditorMenuItem.setText("Editor");
            this.robotEditorMenuItem.setMnemonic('E');
            this.robotEditorMenuItem.setVisible(Container.getComponent(IRobocodeEditor.class) != null);
            this.robotEditorMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, ShortcutUtil.MENU_SHORTCUT_KEY_MASK, false));
            this.robotEditorMenuItem.addActionListener(this.eventHandler);
        }
        return this.robotEditorMenuItem;
    }

    private JMenuItem getRobotImportMenuItem() {
        if (this.robotImportMenuItem == null) {
            this.robotImportMenuItem = new JMenuItem();
            this.robotImportMenuItem.setText("Import downloaded robot");
            this.robotImportMenuItem.setMnemonic('I');
            this.robotImportMenuItem.addActionListener(this.eventHandler);
        }
        return this.robotImportMenuItem;
    }

    public JMenu getRobotMenu() {
        if (this.robotMenu == null) {
            this.robotMenu = new JMenu();
            this.robotMenu.setText("Robot");
            this.robotMenu.setMnemonic('R');
            this.robotMenu.add(this.getRobotEditorMenuItem());
            this.robotMenu.add(new JSeparator());
            this.robotMenu.add(this.getRobotImportMenuItem());
            this.robotMenu.add(this.getRobotPackagerMenuItem());
            this.robotMenu.add(new JSeparator());
            this.robotMenu.add(this.getRobotCreateTeamMenuItem());
            this.robotMenu.addMenuListener(this.eventHandler);
        }
        return this.robotMenu;
    }

    private JMenuItem getRobotPackagerMenuItem() {
        if (this.robotPackagerMenuItem == null) {
            this.robotPackagerMenuItem = new JMenuItem();
            this.robotPackagerMenuItem.setText("Package robot for upload");
            this.robotPackagerMenuItem.setMnemonic('P');
            this.robotPackagerMenuItem.addActionListener(this.eventHandler);
        }
        return this.robotPackagerMenuItem;
    }

    private JMenuItem getRobotCreateTeamMenuItem() {
        if (this.robotCreateTeamMenuItem == null) {
            this.robotCreateTeamMenuItem = new JMenuItem();
            this.robotCreateTeamMenuItem.setText("Create a robot team");
            this.robotCreateTeamMenuItem.setMnemonic('C');
            this.robotCreateTeamMenuItem.addActionListener(this.eventHandler);
        }
        return this.robotCreateTeamMenuItem;
    }

    private void teamCreateTeamActionPerformed() {
        this.windowManager.showCreateTeamDialog();
    }

    private void helpAboutActionPerformed() {
        this.windowManager.showAboutBox();
    }

    private void helpCheckForNewVersionActionPerformed() {
        if (!this.robocodeFrame.checkForNewVersion(true)) {
            WindowUtil.messageError("Unable to check for new version ");
        }
    }

    private void helpFaqActionPerformed() {
        this.windowManager.showFaq();
    }

    private void helpOnlineHelpActionPerformed() {
        this.windowManager.showOnlineHelp();
    }

    private void helpVersionsTxtActionPerformed() {
        this.windowManager.showVersionsTxt();
    }

    private void helpRobocodeApiActionPerformed() {
        this.windowManager.showHelpApi();
    }

    private void helpRobocodeHomeMenuItemActionPerformed() {
        this.windowManager.showRobocodeHome();
    }

    private void helpJavaDocumentationActionPerformed() {
        this.windowManager.showJavaDocumentation();
    }

    private void helpRoboWikiMenuItemActionPerformed() {
        this.windowManager.showRoboWiki();
    }

    private void helpYahooGroupRobocodeActionPerformed() {
        this.windowManager.showYahooGroupRobocode();
    }

    private void helpRobocodeRepositoryActionPerformed() {
        this.windowManager.showRobocodeRepository();
    }

    private void optionsFitWindowActionPerformed() {
        JFrame robocodeFrame = this.windowManager.getRobocodeFrame();
        robocodeFrame.setSize(robocodeFrame.getPreferredSize());
        WindowUtil.fitWindow(robocodeFrame);
    }

    private void optionsShowRankingActionPerformed() {
        this.windowManager.showRankingDialog(this.getOptionsShowRankingCheckBoxMenuItem().getState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void optionsRecalculateCpuConstantPerformed() {
        int ok = JOptionPane.showConfirmDialog(this, "Do you want to recalculate the CPU constant?", "Recalculate CPU constant", 0);
        if (ok == 0) {
            try {
                this.robocodeFrame.setBusyPointer(true);
                this.cpuManager.calculateCpuConstant();
            }
            finally {
                this.robocodeFrame.setBusyPointer(false);
            }
            long cpuConstant = this.cpuManager.getCpuConstant();
            JOptionPane.showMessageDialog(this, "CPU constant: " + cpuConstant + " nanoseconds per turn", "New CPU constant", 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void optionsCleanRobotCachePerformed() {
        int ok = JOptionPane.showConfirmDialog(this, "Do you want to clean the robot cache?", "Clean Robot Cache", 0);
        if (ok == 0) {
            try {
                this.robocodeFrame.setBusyPointer(true);
                CacheCleaner.clean();
            }
            finally {
                this.robocodeFrame.setBusyPointer(false);
            }
        }
    }

    private void optionsPreferencesActionPerformed() {
        this.windowManager.showOptionsPreferences();
    }

    private void robotEditorActionPerformed() {
        this.windowManager.showRobocodeEditor();
    }

    private void robotImportActionPerformed() {
        this.windowManager.showImportRobotDialog();
    }

    private void robotPackagerActionPerformed() {
        this.windowManager.showRobotPackager();
    }

    private class EventHandler
    implements ActionListener,
    MenuListener {
        private EventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            MenuBar mb;
            Object source = e.getSource();
            if (source == (mb = MenuBar.this).getBattleNewMenuItem()) {
                MenuBar.this.battleNewActionPerformed();
            } else if (source == mb.getBattleOpenMenuItem()) {
                MenuBar.this.battleOpenActionPerformed();
            } else if (source == mb.getBattleSaveMenuItem()) {
                MenuBar.this.battleSaveActionPerformed();
            } else if (source == mb.getBattleSaveAsMenuItem()) {
                MenuBar.this.battleSaveAsActionPerformed();
            } else if (source == mb.getBattleOpenRecordMenuItem()) {
                MenuBar.this.battleOpenRecordActionPerformed();
            } else if (source == mb.getBattleImportRecordMenuItem()) {
                MenuBar.this.battleImportRecordActionPerformed();
            } else if (source == mb.getBattleSaveRecordAsMenuItem()) {
                MenuBar.this.battleSaveRecordAsActionPerformed();
            } else if (source == mb.getBattleExportRecordMenuItem()) {
                MenuBar.this.battleExportRecordActionPerformed();
            } else if (source == mb.getBattleExitMenuItem()) {
                MenuBar.this.battleExitActionPerformed();
            } else if (source == mb.getRobotEditorMenuItem()) {
                MenuBar.this.robotEditorActionPerformed();
            } else if (source == mb.getRobotImportMenuItem()) {
                MenuBar.this.robotImportActionPerformed();
            } else if (source == mb.getRobotPackagerMenuItem()) {
                MenuBar.this.robotPackagerActionPerformed();
            } else if (source == mb.getRobotCreateTeamMenuItem()) {
                MenuBar.this.teamCreateTeamActionPerformed();
            } else if (source == mb.getOptionsPreferencesMenuItem()) {
                MenuBar.this.optionsPreferencesActionPerformed();
            } else if (source == mb.getOptionsFitWindowMenuItem()) {
                MenuBar.this.optionsFitWindowActionPerformed();
            } else if (source == mb.getOptionsShowRankingCheckBoxMenuItem()) {
                MenuBar.this.optionsShowRankingActionPerformed();
            } else if (source == mb.getOptionsRecalculateCpuConstantMenuItem()) {
                MenuBar.this.optionsRecalculateCpuConstantPerformed();
            } else if (source == mb.getOptionsCleanRobotCacheMenuItem()) {
                MenuBar.this.optionsCleanRobotCachePerformed();
            } else if (source == mb.getHelpOnlineHelpMenuItem()) {
                MenuBar.this.helpOnlineHelpActionPerformed();
            } else if (source == mb.getHelpRobocodeApiMenuItem()) {
                MenuBar.this.helpRobocodeApiActionPerformed();
            } else if (source == mb.getHelpJavaDocumentationMenuItem()) {
                MenuBar.this.helpJavaDocumentationActionPerformed();
            } else if (source == mb.getHelpFaqMenuItem()) {
                MenuBar.this.helpFaqActionPerformed();
            } else if (source == mb.getHelpRobocodeMenuItem()) {
                MenuBar.this.helpRobocodeHomeMenuItemActionPerformed();
            } else if (source == mb.getHelpRoboWikiMenuItem()) {
                MenuBar.this.helpRoboWikiMenuItemActionPerformed();
            } else if (source == mb.getHelpYahooGroupRobocodeMenuItem()) {
                MenuBar.this.helpYahooGroupRobocodeActionPerformed();
            } else if (source == mb.getHelpRobocodeRepositoryMenuItem()) {
                MenuBar.this.helpRobocodeRepositoryActionPerformed();
            } else if (source == mb.getHelpCheckForNewVersionMenuItem()) {
                MenuBar.this.helpCheckForNewVersionActionPerformed();
            } else if (source == mb.getHelpVersionsTxtMenuItem()) {
                MenuBar.this.helpVersionsTxtActionPerformed();
            } else if (source == mb.getHelpAboutMenuItem()) {
                MenuBar.this.helpAboutActionPerformed();
            }
        }

        public void menuDeselected(MenuEvent e) {
            MenuBar.this.battleManager.resumeBattle();
        }

        public void menuSelected(MenuEvent e) {
            MenuBar.this.battleManager.pauseBattle();
        }

        public void menuCanceled(MenuEvent e) {
        }
    }
}

