/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import net.sf.robocode.battle.BattleProperties;
import net.sf.robocode.battle.IBattleManager;
import net.sf.robocode.core.Container;
import net.sf.robocode.repository.IRepositoryItem;
import net.sf.robocode.settings.ISettingsManager;
import net.sf.robocode.ui.IWindowManager;
import net.sf.robocode.ui.dialog.NewBattleBattleFieldTab;
import net.sf.robocode.ui.dialog.NewBattleRulesTab;
import net.sf.robocode.ui.dialog.RobotSelectionPanel;
import net.sf.robocode.ui.dialog.WizardController;
import net.sf.robocode.ui.dialog.WizardListener;
import net.sf.robocode.ui.dialog.WizardTabbedPane;
import net.sf.robocode.ui.util.ShortcutUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewBattleDialog
extends JDialog
implements WizardListener {
    private static final int MAX_ROBOTS = 256;
    private static final int MIN_ROBOTS = 1;
    private final EventHandler eventHandler = new EventHandler();
    private JPanel newBattleDialogContentPane;
    private WizardTabbedPane tabbedPane;
    private NewBattleBattleFieldTab battleFieldTab;
    private BattleProperties battleProperties;
    private boolean isOpeningBattle;
    private NewBattleRulesTab rulesTab;
    private WizardController wizardController;
    private RobotSelectionPanel robotSelectionPanel;
    private final IBattleManager battleManager;
    private final ISettingsManager settingsManager;

    public NewBattleDialog(IWindowManager windowManager, IBattleManager battleManager, ISettingsManager settingsManager) {
        super((Frame)windowManager.getRobocodeFrame(), true);
        this.battleManager = battleManager;
        this.settingsManager = settingsManager;
    }

    public void setup(BattleProperties battleProperties, boolean openBattle) {
        this.battleProperties = battleProperties;
        this.isOpeningBattle = openBattle;
        this.robotSelectionPanel = null;
        this.initialize();
    }

    @Override
    public void cancelButtonActionPerformed() {
        this.dispose();
    }

    @Override
    public void finishButtonActionPerformed() {
        if (this.robotSelectionPanel.getSelectedRobotsCount() > 24 && JOptionPane.showConfirmDialog(this, "Warning:  The battle you are about to start (" + this.robotSelectionPanel.getSelectedRobotsCount() + " robots) " + " is very large and will consume a lot of CPU and memory.  Do you wish to proceed?", "Large Battle Warning", 0, 2) == 1) {
            return;
        }
        if (this.robotSelectionPanel.getSelectedRobotsCount() == 1 && JOptionPane.showConfirmDialog(this, "You have only selected one robot.  For normal battles you should select at least 2.\nDo you wish to proceed anyway?", "Just one robot?", 0, 3) == 1) {
            return;
        }
        this.battleProperties.setSelectedRobots(this.getRobotSelectionPanel().getSelectedRobotsAsString());
        this.battleProperties.setBattlefieldWidth(this.getBattleFieldTab().getBattleFieldWidth());
        this.battleProperties.setBattlefieldHeight(this.getBattleFieldTab().getBattleFieldHeight());
        this.battleProperties.setNumRounds(this.getRobotSelectionPanel().getNumRounds());
        this.battleProperties.setGunCoolingRate(this.getRulesTab().getGunCoolingRate());
        this.battleProperties.setInactivityTime(this.getRulesTab().getInactivityTime());
        this.dispose();
        this.battleManager.startNewBattle(this.battleProperties, false, false);
    }

    private NewBattleBattleFieldTab getBattleFieldTab() {
        if (this.battleFieldTab == null) {
            this.battleFieldTab = new NewBattleBattleFieldTab();
        }
        return this.battleFieldTab;
    }

    private JPanel getNewBattleDialogContentPane() {
        if (this.newBattleDialogContentPane == null) {
            this.newBattleDialogContentPane = new JPanel();
            this.newBattleDialogContentPane.setLayout(new BorderLayout());
            this.newBattleDialogContentPane.add((Component)this.getWizardController(), "South");
            this.newBattleDialogContentPane.add((Component)this.getTabbedPane(), "Center");
            this.newBattleDialogContentPane.registerKeyboardAction(this.eventHandler, "Refresh", KeyStroke.getKeyStroke(82, ShortcutUtil.MENU_SHORTCUT_KEY_MASK), 1);
        }
        return this.newBattleDialogContentPane;
    }

    private NewBattleRulesTab getRulesTab() {
        if (this.rulesTab == null) {
            this.rulesTab = new NewBattleRulesTab();
        }
        return this.rulesTab;
    }

    public List<IRepositoryItem> getSelectedRobots() {
        return this.getRobotSelectionPanel().getSelectedRobots();
    }

    private void initialize() {
        this.setTitle("New Battle");
        this.setPreferredSize(new Dimension(850, 650));
        this.setDefaultCloseOperation(2);
        this.setContentPane(this.getNewBattleDialogContentPane());
        this.addCancelByEscapeKey();
        this.processBattleProperties();
    }

    private void addCancelByEscapeKey() {
        String CANCEL_ACTION_KEY = "CANCEL_ACTION_KEY";
        int noModifiers = 0;
        KeyStroke escapeKey = KeyStroke.getKeyStroke(27, noModifiers, false);
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(escapeKey, CANCEL_ACTION_KEY);
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                NewBattleDialog.this.cancelButtonActionPerformed();
            }
        };
        this.getRootPane().getActionMap().put(CANCEL_ACTION_KEY, cancelAction);
    }

    private WizardController getWizardController() {
        if (this.wizardController == null) {
            this.wizardController = this.getTabbedPane().getWizardController();
            this.wizardController.setFinishButtonTextAndMnemonic("Start Battle", 'S', 0);
            this.wizardController.setFocusOnEnabled(true);
        }
        return this.wizardController;
    }

    private RobotSelectionPanel getRobotSelectionPanel() {
        if (this.robotSelectionPanel == null) {
            String selectedRobots = "";
            if (this.battleProperties != null) {
                selectedRobots = this.battleProperties.getSelectedRobots();
            }
            this.robotSelectionPanel = (RobotSelectionPanel)Container.createComponent(RobotSelectionPanel.class);
            boolean ignoreTeamRobots = false;
            this.robotSelectionPanel.setup(1, 256, true, "Select robots for the battle", false, false, false, false, false, false, selectedRobots);
        }
        return this.robotSelectionPanel;
    }

    private WizardTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new WizardTabbedPane(this);
            this.tabbedPane.insertTab("Robots", null, this.getRobotSelectionPanel(), null, 0);
            this.tabbedPane.setMnemonicAt(0, 82);
            this.tabbedPane.setDisplayedMnemonicIndexAt(0, 0);
            this.tabbedPane.insertTab("BattleField", null, this.getBattleFieldTab(), null, 1);
            this.tabbedPane.setMnemonicAt(1, 70);
            this.tabbedPane.setDisplayedMnemonicIndexAt(1, 6);
            this.tabbedPane.insertTab("Rules", null, this.getRulesTab(), null, 2);
            this.tabbedPane.setMnemonicAt(2, 85);
            this.tabbedPane.setDisplayedMnemonicIndexAt(2, 1);
        }
        return this.tabbedPane;
    }

    private void processBattleProperties() {
        if (this.battleProperties == null) {
            return;
        }
        this.getBattleFieldTab().setBattleFieldWidth(this.battleProperties.getBattlefieldWidth());
        this.getBattleFieldTab().setBattleFieldHeight(this.battleProperties.getBattlefieldHeight());
        this.getRulesTab().setGunCoolingRate(this.battleProperties.getGunCoolingRate());
        this.getRulesTab().setInactivityTime(this.battleProperties.getInactivityTime());
        int numRounds = this.isOpeningBattle ? this.battleProperties.getNumRounds() : this.settingsManager.getNumberOfRounds();
        this.getRobotSelectionPanel().setNumRounds(numRounds);
    }

    private class EventHandler
    extends WindowAdapter
    implements ActionListener {
        private EventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("Refresh")) {
                NewBattleDialog.this.getRobotSelectionPanel().refreshRobotList(true);
            }
        }
    }
}

