/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.JDialog;
import javax.swing.JPanel;
import net.sf.robocode.settings.ISettingsManager;
import net.sf.robocode.ui.IImageManager;
import net.sf.robocode.ui.IWindowManager;
import net.sf.robocode.ui.dialog.PreferencesCommonOptionsTab;
import net.sf.robocode.ui.dialog.PreferencesDevelopmentOptionsTab;
import net.sf.robocode.ui.dialog.PreferencesRenderingOptionsTab;
import net.sf.robocode.ui.dialog.PreferencesSoundOptionsTab;
import net.sf.robocode.ui.dialog.PreferencesViewOptionsTab;
import net.sf.robocode.ui.dialog.WizardController;
import net.sf.robocode.ui.dialog.WizardListener;
import net.sf.robocode.ui.dialog.WizardTabbedPane;

public class PreferencesDialog
extends JDialog
implements WizardListener {
    private JPanel preferencesDialogContentPane;
    private WizardTabbedPane tabbedPane;
    private WizardController buttonsPanel;
    private PreferencesViewOptionsTab viewOptionsTab;
    private PreferencesRenderingOptionsTab renderingOptionsTab;
    private PreferencesSoundOptionsTab soundOptionsTab;
    private PreferencesDevelopmentOptionsTab developmentOptionsTab;
    private PreferencesCommonOptionsTab commonOptionsTab;
    private final ISettingsManager properties;
    private final IImageManager imageManager;

    public PreferencesDialog(ISettingsManager properties, IWindowManager windowManager, IImageManager imageManager) {
        super((Frame)windowManager.getRobocodeFrame(), true);
        this.properties = properties;
        this.imageManager = imageManager;
        this.initialize();
    }

    private void initialize() {
        this.setDefaultCloseOperation(2);
        this.setTitle("Preferences");
        this.setContentPane(this.getPreferencesDialogContentPane());
    }

    public void cancelButtonActionPerformed() {
        this.dispose();
    }

    private WizardController getButtonsPanel() {
        if (this.buttonsPanel == null) {
            this.buttonsPanel = this.getTabbedPane().getWizardController();
        }
        return this.buttonsPanel;
    }

    private JPanel getPreferencesDialogContentPane() {
        this.getButtonsPanel();
        if (this.preferencesDialogContentPane == null) {
            this.preferencesDialogContentPane = new JPanel();
            this.preferencesDialogContentPane.setLayout(new BorderLayout());
            this.preferencesDialogContentPane.add((Component)this.getTabbedPane(), "Center");
            this.preferencesDialogContentPane.add((Component)this.getButtonsPanel(), "South");
        }
        return this.preferencesDialogContentPane;
    }

    private WizardTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new WizardTabbedPane(this);
            this.tabbedPane.insertTab("View Options", null, this.getViewOptionsTab(), null, 0);
            this.tabbedPane.setMnemonicAt(0, 87);
            this.tabbedPane.setDisplayedMnemonicIndexAt(0, 3);
            this.tabbedPane.insertTab("Rendering Options", null, this.getRenderingOptionsTab(), null, 1);
            this.tabbedPane.setMnemonicAt(1, 82);
            this.tabbedPane.setDisplayedMnemonicIndexAt(1, 0);
            this.tabbedPane.insertTab("Sound Options", null, this.getSoundOptionsTab(), null, 2);
            this.tabbedPane.setMnemonicAt(2, 83);
            this.tabbedPane.setDisplayedMnemonicIndexAt(2, 0);
            this.tabbedPane.insertTab("Development Options", null, this.getDevelopmentOptionsTab(), null, 3);
            this.tabbedPane.setMnemonicAt(3, 68);
            this.tabbedPane.setDisplayedMnemonicIndexAt(3, 0);
            this.tabbedPane.insertTab("Common Options", null, this.getCommonOptionsTab(), null, 4);
            this.tabbedPane.setMnemonicAt(4, 79);
            this.tabbedPane.setDisplayedMnemonicIndexAt(4, 1);
        }
        return this.tabbedPane;
    }

    private JPanel getViewOptionsTab() {
        if (this.viewOptionsTab == null) {
            this.viewOptionsTab = new PreferencesViewOptionsTab(this.properties);
        }
        return this.viewOptionsTab;
    }

    private JPanel getRenderingOptionsTab() {
        if (this.renderingOptionsTab == null) {
            this.renderingOptionsTab = new PreferencesRenderingOptionsTab(this.properties, this.imageManager);
        }
        return this.renderingOptionsTab;
    }

    private JPanel getSoundOptionsTab() {
        if (this.soundOptionsTab == null) {
            this.soundOptionsTab = new PreferencesSoundOptionsTab(this.properties);
        }
        return this.soundOptionsTab;
    }

    private JPanel getDevelopmentOptionsTab() {
        if (this.developmentOptionsTab == null) {
            this.developmentOptionsTab = new PreferencesDevelopmentOptionsTab(this.properties);
        }
        return this.developmentOptionsTab;
    }

    private JPanel getCommonOptionsTab() {
        if (this.commonOptionsTab == null) {
            this.commonOptionsTab = new PreferencesCommonOptionsTab(this.properties);
        }
        return this.commonOptionsTab;
    }

    public void finishButtonActionPerformed() {
        this.viewOptionsTab.storePreferences();
        this.renderingOptionsTab.storePreferences();
        this.soundOptionsTab.storePreferences();
        this.developmentOptionsTab.storePreferences();
        this.commonOptionsTab.storePreferences();
        this.dispose();
    }
}

