/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.packager;

import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.robocode.repository.IRepositoryItem;
import net.sf.robocode.ui.dialog.WizardPanel;
import net.sf.robocode.ui.packager.RobotPackager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfirmPanel
extends WizardPanel {
    private final RobotPackager robotPackager;
    private final EventHandler eventHandler = new EventHandler();
    private boolean visible;
    private JPanel robotListPanel;

    public ConfirmPanel(RobotPackager robotPackager) {
        this.robotPackager = robotPackager;
        this.initialize();
    }

    public JPanel getRobotListPanel() {
        if (this.robotListPanel == null) {
            this.robotListPanel = new JPanel();
            this.robotListPanel.setLayout(new BoxLayout(this.robotListPanel, 1));
            this.robotListPanel.setAlignmentX(0.0f);
        }
        return this.robotListPanel;
    }

    private void initialize() {
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BoxLayout(this, 1));
        this.addComponentListener(this.eventHandler);
        this.add(new JPanel());
    }

    @Override
    public boolean isReady() {
        return this.visible;
    }

    public void setSelectedRobots(List<IRepositoryItem> selectedRobots) {
        this.getRobotListPanel().removeAll();
        if (selectedRobots == null || selectedRobots.size() == 0) {
            this.getRobotListPanel().add(new JLabel("You have not yet selected any robots."));
        } else if (selectedRobots.size() == 1) {
            String robotName = selectedRobots.get(0).getFullClassName();
            this.getRobotListPanel().add(new JLabel("You have selected " + robotName + " for packaging."));
        } else {
            this.getRobotListPanel().add(new JLabel("You have selected the following robots for packaging:"));
            for (IRepositoryItem selected : selectedRobots) {
                this.getRobotListPanel().add(new JLabel(selected.getFullClassName()));
            }
        }
        this.getRobotListPanel().add(new JLabel(""));
        this.getRobotListPanel().setMaximumSize(new Dimension(10000, this.robotListPanel.getPreferredSize().height));
        this.validate();
    }

    public void updateFields() {
        this.removeAll();
        this.setSelectedRobots(this.robotPackager.getRobotSelectionPanel().getSelectedRobots());
        this.add(this.getRobotListPanel());
        this.add(Box.createVerticalStrut(20));
        if (this.robotPackager.getPackagerOptionsPanel().getIncludeSource().isSelected()) {
            this.add(new JLabel("Java source files will be included."));
        } else {
            this.add(new JLabel("Only .class files will be included."));
        }
        this.add(Box.createVerticalStrut(20));
        this.add(new JLabel("The package will be saved in " + this.robotPackager.getFilenamePanel().getFilenameField().getText()));
        this.add(Box.createVerticalStrut(20));
        this.add(new JLabel("If all of the above is correct, click the Package button to start packaging."));
        this.add(new JPanel());
        this.revalidate();
    }

    private class EventHandler
    implements ComponentListener {
        private EventHandler() {
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
        }

        public void componentHidden(ComponentEvent e) {
            ConfirmPanel.this.visible = false;
            ConfirmPanel.this.fireStateChanged();
        }

        public void componentShown(ComponentEvent e) {
            if (ConfirmPanel.this.robotPackager == null) {
                return;
            }
            ConfirmPanel.this.visible = true;
            ConfirmPanel.this.updateFields();
            ConfirmPanel.this.fireStateChanged();
            ConfirmPanel.this.repaint();
        }
    }
}

