/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.packager;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Caret;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;
import net.sf.robocode.repository.IRepositoryItem;
import net.sf.robocode.ui.dialog.WizardPanel;
import net.sf.robocode.ui.packager.RobotPackager;

public class FilenamePanel
extends WizardPanel {
    private final RobotPackager robotPackager;
    private final EventHandler eventHandler = new EventHandler();
    private boolean robocodeErrorShown;
    private JButton browseButton;
    private JTextField filenameField;

    public FilenamePanel(RobotPackager robotPackager) {
        this.robotPackager = robotPackager;
        this.initialize();
    }

    private void initialize() {
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.addComponentListener(this.eventHandler);
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = 18;
        c.fill = 2;
        c.gridwidth = 1;
        c.weightx = 1.0;
        this.add((Component)new JLabel("Please type in a .jar file to save this robot package to: "), c);
        c.gridy = 1;
        this.add((Component)this.getFilenameField(), c);
        c.fill = 0;
        c.gridy = 2;
        c.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.getBrowseButton(), c);
        c.fill = 3;
        c.weighty = 1.0;
        c.gridy = 3;
        this.add((Component)new JPanel(), c);
    }

    public boolean isReady() {
        if (this.filenameField.getText() == null) {
            return false;
        }
        int robocodeIndex = this.filenameField.getText().lastIndexOf(File.separatorChar);
        if (robocodeIndex > 0 && this.filenameField.getText().substring(robocodeIndex + 1).indexOf("robocode") == 0) {
            if (!this.robocodeErrorShown) {
                this.robocodeErrorShown = true;
                new Thread(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(FilenamePanel.this, "Filename cannot begin with robocode");
                    }
                }).start();
            }
            return false;
        }
        return this.filenameField.getText().toLowerCase().indexOf(".jar") != 0;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("options");
        frame.setSize(new Dimension(500, 300));
        frame.getContentPane().add(new FilenamePanel(null));
        try {
            SwingUtilities.invokeAndWait(new ShowFrameWorker(frame));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public JButton getBrowseButton() {
        if (this.browseButton == null) {
            this.browseButton = new JButton("Browse");
            this.browseButton.addActionListener(this.eventHandler);
        }
        return this.browseButton;
    }

    public JTextField getFilenameField() {
        if (this.filenameField == null) {
            this.filenameField = new JTextField("(none selected)", 60);
            this.filenameField.getDocument().addDocumentListener(this.eventHandler);
        }
        return this.filenameField;
    }

    public void showFileSelectDialog() {
        File f = new File("outgoing" + File.separatorChar);
        JFileChooser chooser = new JFileChooser(f);
        chooser.setCurrentDirectory(f);
        FileFilter filter = new FileFilter(){

            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    return true;
                }
                String fn = pathname.getName();
                int idx = fn.lastIndexOf(46);
                String extension = "";
                if (idx >= 0) {
                    extension = fn.substring(idx);
                }
                return extension.equalsIgnoreCase(".jar");
            }

            public String getDescription() {
                return "JAR files";
            }
        };
        chooser.setFileFilter(filter);
        boolean done = false;
        while (!done) {
            File outFile;
            done = true;
            int rv = chooser.showSaveDialog(this);
            if (rv != 0) continue;
            String robotFileName = chooser.getSelectedFile().getPath();
            if (robotFileName.toLowerCase().indexOf(".jar") < 0) {
                robotFileName = robotFileName + ".jar";
            }
            if ((outFile = new File(robotFileName)).exists()) {
                int ok = JOptionPane.showConfirmDialog(this, robotFileName + " already exists.  Are you sure you want to replace it?", "Warning", 1);
                if (ok == 1) {
                    done = false;
                    continue;
                }
                if (ok == 2) {
                    return;
                }
            }
            this.getFilenameField().setText(robotFileName);
            this.fireStateChanged();
        }
    }

    static class ShowFrameWorker
    implements Runnable {
        final JFrame frame;

        public ShowFrameWorker(JFrame frame) {
            this.frame = frame;
        }

        public void run() {
            if (this.frame != null) {
                this.frame.setVisible(true);
            }
        }
    }

    private class EventHandler
    implements ActionListener,
    DocumentListener,
    ComponentListener {
        private EventHandler() {
        }

        public void insertUpdate(DocumentEvent e) {
            FilenamePanel.this.fireStateChanged();
        }

        public void changedUpdate(DocumentEvent e) {
            FilenamePanel.this.fireStateChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            FilenamePanel.this.fireStateChanged();
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == FilenamePanel.this.getBrowseButton()) {
                FilenamePanel.this.showFileSelectDialog();
            }
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
        }

        public void componentHidden(ComponentEvent e) {
        }

        public void componentShown(ComponentEvent e) {
            String fileName = FileUtil.getRobotsDir().getAbsolutePath() + File.separator;
            File outgoingFile = new File(fileName);
            if (!outgoingFile.exists() && !outgoingFile.mkdirs()) {
                Logger.logError((String)("Can't create" + outgoingFile));
            }
            String jarName = "myrobots.jar";
            List<IRepositoryItem> selectedRobots = FilenamePanel.this.robotPackager.getRobotSelectionPanel().getSelectedRobots();
            if (selectedRobots != null && selectedRobots.size() == 1) {
                jarName = selectedRobots.get(0).getFullClassName() + "_" + FilenamePanel.this.robotPackager.getPackagerOptionsPanel().getVersionField().getText() + ".jar";
            }
            FilenamePanel.this.getFilenameField().setText(fileName + jarName);
            Caret caret = FilenamePanel.this.getFilenameField().getCaret();
            caret.setDot(fileName.length());
            caret.moveDot(fileName.length() + jarName.length() - 4);
            FilenamePanel.this.getFilenameField().requestFocus();
        }
    }
}

