/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.roborumble.netengine;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.PatternSyntaxException;
import net.sf.robocode.io.Logger;
import net.sf.robocode.roborumble.battlesengine.CompetitionsSelector;
import net.sf.robocode.roborumble.netengine.FileTransfer;
import net.sf.robocode.roborumble.util.PropertiesUtil;

public class BotsDownload {
    private final String botsrepository;
    private final String participantsfile;
    private final String participantsurl;
    private final String tempdir;
    private final String tag;
    private final String isteams;
    private final String sizesfile;
    private final CompetitionsSelector size;
    private final String ratingsurl;
    private String generalbots;
    private final String minibots;
    private final String microbots;
    private final String nanobots;
    private final String generalbotsfile;
    private final String minibotsfile;
    private final String microbotsfile;
    private final String nanobotsfile;
    private final String removeboturl;
    private String[] excludes;

    public BotsDownload(String propertiesfile) {
        Properties parameters = PropertiesUtil.getProperties(propertiesfile);
        this.botsrepository = parameters.getProperty("BOTSREP", "");
        this.isteams = parameters.getProperty("TEAMS", "NOT");
        this.participantsurl = parameters.getProperty("PARTICIPANTSURL", "");
        this.participantsfile = parameters.getProperty("PARTICIPANTSFILE", "");
        this.tag = parameters.getProperty("STARTAG", "pre");
        this.tempdir = parameters.getProperty("TEMP", "");
        this.sizesfile = parameters.getProperty("CODESIZEFILE", "");
        this.size = new CompetitionsSelector(this.sizesfile, this.botsrepository);
        this.ratingsurl = parameters.getProperty("RATINGS.URL", "");
        this.generalbots = propertiesfile;
        while (this.generalbots.indexOf("/") != -1) {
            this.generalbots = this.generalbots.substring(this.generalbots.indexOf("/") + 1);
        }
        this.generalbots = this.generalbots.substring(0, this.generalbots.indexOf("."));
        this.minibots = parameters.getProperty("MINIBOTS", "");
        this.microbots = parameters.getProperty("MICROBOTS", "");
        this.nanobots = parameters.getProperty("NANOBOTS", "");
        this.generalbotsfile = parameters.getProperty("RATINGS.GENERAL", "");
        this.minibotsfile = parameters.getProperty("RATINGS.MINIBOTS", "");
        this.microbotsfile = parameters.getProperty("RATINGS.MICROBOTS", "");
        this.nanobotsfile = parameters.getProperty("RATINGS.NANOBOTS", "");
        this.removeboturl = parameters.getProperty("UPDATEBOTSURL", "");
        String exclude = parameters.getProperty("EXCLUDE");
        if (exclude != null) {
            exclude = exclude.replaceAll("\\.", "\\\\.");
            exclude = exclude.replaceAll("\\?", ".?");
            exclude = exclude.replaceAll("\\*", ".*");
            this.excludes = exclude.split("[\\s,;]+");
        }
    }

    public boolean downloadRatings() {
        File file;
        if (this.generalbotsfile.length() != 0 && (file = new File(this.generalbotsfile)).exists() && !file.delete()) {
            Logger.logError((String)"Can't delete file");
        }
        if (this.minibotsfile.length() != 0 && (file = new File(this.minibotsfile)).exists() && !file.delete()) {
            Logger.logError((String)"Can't delete file");
        }
        if (this.microbotsfile.length() != 0 && (file = new File(this.microbotsfile)).exists() && !file.delete()) {
            Logger.logError((String)"Can't delete file");
        }
        if (this.nanobotsfile.length() != 0 && (file = new File(this.nanobotsfile)).exists() && !file.delete()) {
            Logger.logError((String)"Can't delete file");
        }
        if (this.ratingsurl.length() == 0) {
            return false;
        }
        boolean downloaded = true;
        if (this.generalbots.length() != 0 && this.generalbotsfile.length() != 0) {
            downloaded = this.downloadRatingsFile(this.generalbots, this.generalbotsfile) & downloaded;
        }
        if (this.minibots.length() != 0 && this.minibotsfile.length() != 0) {
            downloaded = this.downloadRatingsFile(this.minibots, this.minibotsfile) & downloaded;
        }
        if (this.microbots.length() != 0 && this.microbotsfile.length() != 0) {
            downloaded = this.downloadRatingsFile(this.microbots, this.microbotsfile) & downloaded;
        }
        if (this.nanobots.length() != 0 && this.nanobotsfile.length() != 0) {
            downloaded = this.downloadRatingsFile(this.nanobots, this.nanobotsfile) & downloaded;
        }
        return downloaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadParticipantsList() {
        String begin = "<" + this.tag + ">";
        String end = "</" + this.tag + ">";
        Vector<String> bots = new Vector<String>();
        BufferedReader in = null;
        try {
            String str;
            URL url = new URL(this.participantsurl);
            HttpURLConnection urlc = (HttpURLConnection)url.openConnection();
            urlc.setRequestMethod("GET");
            urlc.setDoInput(true);
            urlc.connect();
            boolean arebots = false;
            in = new BufferedReader(new InputStreamReader(urlc.getInputStream()));
            while ((str = in.readLine()) != null) {
                String name;
                if (str.indexOf(begin) != -1) {
                    arebots = true;
                    continue;
                }
                if (str.indexOf(end) != -1) {
                    arebots = false;
                    continue;
                }
                if (!arebots || this.isExcluded(name = str.substring(0, str.indexOf(",")))) continue;
                bots.add(str);
            }
            urlc.disconnect();
            File dir = new File(this.participantsfile).getParentFile();
            if (!dir.exists() && !dir.mkdirs()) {
                Logger.logError((String)("Can't create " + dir));
            }
            PrintStream outtxt = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.participantsfile)), false);
            for (String bot : bots) {
                outtxt.println(bot);
            }
            outtxt.close();
        }
        catch (IOException e) {
            System.out.println("Unable to retrieve participants list");
            System.out.println(e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignored) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadMissingBots() {
        Vector<String> jars = new Vector<String>();
        Vector<String> ids = new Vector<String>();
        Vector<String> names = new Vector<String>();
        BufferedReader br = null;
        try {
            String record;
            FileReader fr = new FileReader(this.participantsfile);
            br = new BufferedReader(fr);
            while ((record = br.readLine()) != null) {
                if (record.indexOf(",") < 0) continue;
                String id = record.substring(record.indexOf(",") + 1);
                String name = record.substring(0, record.indexOf(","));
                String jar = name.replace(' ', '_') + ".jar";
                jars.add(jar);
                ids.add(id);
                names.add(name);
            }
        }
        catch (IOException e) {
            System.out.println("Participants file not found ... Aborting");
            System.out.println(e);
            return;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ignored) {}
            }
        }
        for (int i = 0; i < jars.size(); ++i) {
            boolean downloaded;
            String botjar = (String)jars.get(i);
            String botid = (String)ids.get(i);
            String botname = (String)names.get(i);
            String botpath = this.botsrepository + botjar;
            boolean exists = new File(botpath).exists();
            if (exists || (downloaded = this.downloadBot(botname, botjar, botid, this.botsrepository, this.tempdir))) continue;
            System.out.println("Could not download " + botjar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCodeSize() {
        if (this.sizesfile.length() != 0) {
            BufferedReader br = null;
            try {
                String record;
                FileReader fr = new FileReader(this.participantsfile);
                br = new BufferedReader(fr);
                while ((record = br.readLine()) != null) {
                    String name = record.substring(0, record.indexOf(","));
                    name = name.replace(' ', '_');
                    this.size.checkCompetitorsForSize(name, name, 1500L);
                }
            }
            catch (IOException e) {
                System.out.println("Battles input file not found ... Aborting");
                System.out.println(e);
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private boolean downloadBot(String botname, String file, String id, String destination, String tempdir) {
        String url;
        String filed = tempdir + file;
        String finald = destination + file;
        boolean exists = new File(finald).exists();
        if (exists) {
            System.out.println("The bot already exists in the repository.");
            return false;
        }
        String sessionId = null;
        if (id.indexOf("://") == -1) {
            url = "http://robocoderepository.com/Controller.jsp?submitAction=downloadClass&id=" + id;
            sessionId = FileTransfer.getSessionId("http://robocoderepository.com/BotSearch.jsp?botName=''&authorName=''&uploadDate=");
        } else {
            url = id;
        }
        System.out.println("Trying to download " + botname);
        FileTransfer.DownloadStatus downloadStatus = FileTransfer.download(url, filed, sessionId);
        if (downloadStatus == FileTransfer.DownloadStatus.FILE_NOT_FOUND) {
            System.out.println("Could not find " + botname + " from " + url);
            return false;
        }
        if (downloadStatus == FileTransfer.DownloadStatus.COULD_NOT_CONNECT) {
            System.out.println("Could not connect to " + url);
            return false;
        }
        if (this.checkJarFile(filed, botname)) {
            if (!FileTransfer.copy(filed, finald)) {
                System.out.println("Unable to copy " + filed + " into the repository");
                return false;
            }
        } else {
            System.out.println("Downloaded file is wrong or corrupted:" + file);
            return false;
        }
        System.out.println("Downloaded " + botname + " into " + finald);
        return true;
    }

    private boolean checkJarFile(String file, String botname) {
        if (botname.indexOf(" ") == -1) {
            System.out.println("Are you sure " + botname + " is a bot/team? Can't download it.");
            return false;
        }
        String bot = botname.substring(0, botname.indexOf(" "));
        bot = bot.replace('.', '/');
        bot = !this.isteams.equals("YES") ? bot + ".properties" : bot + ".team";
        try {
            JarFile jarf = new JarFile(file);
            JarEntry zipe = jarf.getJarEntry(bot);
            if (zipe == null) {
                System.out.println("Not able to read properties");
                return false;
            }
            InputStream properties = jarf.getInputStream(zipe);
            Properties parameters = PropertiesUtil.getProperties(properties);
            if (!this.isteams.equals("YES")) {
                String classname = parameters.getProperty("robot.classname", "");
                String version = parameters.getProperty("robot.version", "");
                return botname.equals(classname + " " + version);
            }
            String version = parameters.getProperty("team.version", "");
            return botname.equals(botname.substring(0, botname.indexOf(" ")) + " " + version);
        }
        catch (Exception e) {
            System.out.println(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadRatingsFile(String competition, String file) {
        BufferedReader in = null;
        PrintStream outtxt = null;
        try {
            String str;
            URL url = new URL(this.ratingsurl + "?version=1&game=" + competition);
            HttpURLConnection urlc = (HttpURLConnection)url.openConnection();
            urlc.setRequestMethod("GET");
            urlc.setDoInput(true);
            urlc.connect();
            File dir = new File(file).getParentFile();
            if (!dir.exists() && !dir.mkdirs()) {
                Logger.logError((String)("Can't create " + dir));
            }
            outtxt = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)), false);
            in = new BufferedReader(new InputStreamReader(urlc.getInputStream()));
            while ((str = in.readLine()) != null) {
                outtxt.println(str);
            }
            urlc.disconnect();
        }
        catch (IOException e) {
            System.out.println("Unable to ratings for " + competition);
            System.out.println(e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignored) {}
            }
            if (outtxt != null) {
                outtxt.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyServerForOldParticipants() {
        String bot;
        Hashtable<String, String> namesall = new Hashtable<String, String>();
        BufferedReader br = null;
        try {
            String record;
            FileReader fr = new FileReader(this.participantsfile);
            br = new BufferedReader(fr);
            while ((record = br.readLine()) != null) {
                if (record.indexOf(",") == -1) continue;
                String name = record.substring(0, record.indexOf(",")).replace(' ', '_');
                namesall.put(name, name);
            }
        }
        catch (IOException e) {
            System.out.println("Participants file not found when removing old participants ... Aborting");
            System.out.println(e);
            return;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ignored) {}
            }
        }
        Properties generalratings = PropertiesUtil.getProperties(this.generalbotsfile);
        Properties miniratings = PropertiesUtil.getProperties(this.minibotsfile);
        Properties microratings = PropertiesUtil.getProperties(this.microbotsfile);
        Properties nanoratings = PropertiesUtil.getProperties(this.nanobotsfile);
        Enumeration<?> e = generalratings.propertyNames();
        while (e.hasMoreElements()) {
            bot = (String)e.nextElement();
            if (this.isExcluded(bot) || namesall.containsKey(bot)) continue;
            System.out.println("Removing entry ... " + bot + " from " + this.generalbots);
            this.removebot(this.generalbots, bot);
        }
        e = miniratings.propertyNames();
        while (e.hasMoreElements()) {
            bot = (String)e.nextElement();
            if (this.isExcluded(bot) || namesall.containsKey(bot)) continue;
            System.out.println("Removing entry ... " + bot + " from " + this.minibots);
            this.removebot(this.minibots, bot);
        }
        e = microratings.propertyNames();
        while (e.hasMoreElements()) {
            bot = (String)e.nextElement();
            if (this.isExcluded(bot) || namesall.containsKey(bot)) continue;
            System.out.println("Removing entry ... " + bot + " from " + this.microbots);
            this.removebot(this.microbots, bot);
        }
        e = nanoratings.propertyNames();
        while (e.hasMoreElements()) {
            bot = (String)e.nextElement();
            if (this.isExcluded(bot) || namesall.containsKey(bot)) continue;
            System.out.println("Removing entry ... " + bot + " from " + this.nanobots);
            this.removebot(this.nanobots, bot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removebot(String game, String bot) {
        if (this.removeboturl.length() == 0) {
            System.out.println("UPDATEBOTS URL not defined!");
            return;
        }
        String data = "version=1&game=" + game + "&name=" + bot.trim() + "&dummy=NA";
        PrintWriter wr = null;
        BufferedReader rd = null;
        try {
            String line;
            URL url = new URL(this.removeboturl);
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            wr = new PrintWriter(new OutputStreamWriter(conn.getOutputStream()));
            wr.println(data);
            wr.flush();
            rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = rd.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
        finally {
            if (wr != null) {
                wr.close();
            }
            if (rd != null) {
                try {
                    rd.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    private boolean isExcluded(String bot) {
        if (this.excludes == null) {
            return false;
        }
        for (int i = this.excludes.length - 1; i >= 0; --i) {
            try {
                if (!bot.matches(this.excludes[i])) continue;
                return true;
            }
            catch (PatternSyntaxException e) {
                this.excludes[i] = "";
            }
        }
        return false;
    }
}

