/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.roborumble.netengine;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.Vector;
import net.sf.robocode.roborumble.battlesengine.CompetitionsSelector;
import net.sf.robocode.roborumble.netengine.FileTransfer;
import net.sf.robocode.roborumble.util.PropertiesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultsUpload {
    private final String client;
    private final String resultsfile;
    private final String resultsurl;
    private final String tempdir;
    private String game;
    private final String user;
    private final String sizesfile;
    private final String minibots;
    private final String microbots;
    private final String nanobots;
    private final CompetitionsSelector size;
    private final String battlesnumfile;
    private final String priority;
    private final String teams;
    private final String melee;

    public ResultsUpload(String propertiesfile, String clientVersion) {
        Properties parameters = PropertiesUtil.getProperties(propertiesfile);
        this.resultsfile = parameters.getProperty("OUTPUT", "");
        this.resultsurl = parameters.getProperty("RESULTSURL", "");
        this.tempdir = parameters.getProperty("TEMP", "");
        this.user = parameters.getProperty("USER", "");
        this.game = propertiesfile;
        String botsrepository = parameters.getProperty("BOTSREP", "");
        while (this.game.indexOf("/") != -1) {
            this.game = this.game.substring(this.game.indexOf("/") + 1);
        }
        this.game = this.game.substring(0, this.game.indexOf("."));
        this.sizesfile = parameters.getProperty("CODESIZEFILE", "");
        this.minibots = parameters.getProperty("MINIBOTS", "");
        this.microbots = parameters.getProperty("MICROBOTS", "");
        this.nanobots = parameters.getProperty("NANOBOTS", "");
        this.battlesnumfile = parameters.getProperty("BATTLESNUMFILE", "");
        this.priority = parameters.getProperty("PRIORITYBATTLESFILE", "");
        this.client = clientVersion;
        this.teams = parameters.getProperty("TEAMS", "");
        this.melee = parameters.getProperty("MELEE", "");
        this.size = new CompetitionsSelector(this.sizesfile, botsrepository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadResults() {
        PrintStream prioritybattles;
        PrintStream battlesnum;
        PrintStream outtxt;
        boolean errorsfound = false;
        Vector<String> results = new Vector<String>();
        String match = "";
        String bot1 = "";
        boolean status = false;
        BufferedReader br = null;
        try {
            String record;
            FileReader fr = new FileReader(this.resultsfile);
            br = new BufferedReader(fr);
            while ((record = br.readLine()) != null) {
                if (record.indexOf(this.game) != -1) {
                    match = record;
                    status = false;
                    continue;
                }
                if (!status) {
                    bot1 = record;
                    status = true;
                    continue;
                }
                if (!status) continue;
                String bot2 = record;
                results.add(match);
                results.add(bot1);
                results.add(bot2);
            }
        }
        catch (IOException e) {
            System.out.println("Can't open result file for upload");
            return;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ignored) {}
            }
        }
        try {
            outtxt = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.tempdir + "results.txt")), false);
        }
        catch (IOException e) {
            System.out.println("Not able to open output file ... Aborting");
            System.out.println(e);
            return;
        }
        try {
            battlesnum = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.battlesnumfile)), false);
        }
        catch (IOException e) {
            System.out.println("Not able to open battles number file ... Aborting");
            System.out.println(e);
            outtxt.close();
            return;
        }
        try {
            prioritybattles = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.priority)), false);
        }
        catch (IOException e) {
            System.out.println("Not able to open priorities file ... Aborting");
            System.out.println(e);
            outtxt.close();
            battlesnum.close();
            return;
        }
        for (int i = 0; i < results.size() / 3; ++i) {
            String[] header = ((String)results.get(i * 3)).split(",");
            String[] first = ((String)results.get(i * 3 + 1)).split(",");
            String[] second = ((String)results.get(i * 3 + 2)).split(",");
            String matchtype = "GENERAL";
            if (header.length >= 6) {
                matchtype = header[5];
            }
            String data = "version=1&client=" + this.client + "&" + "teams=" + this.teams + "&" + "melee=" + this.melee + "&" + "game=" + this.game + "&" + "rounds=" + header[1] + "&" + "field=" + header[2] + "&" + "user=" + this.user + "&" + "time=" + header[4] + "&" + "fname=" + first[0] + "&" + "fscore=" + first[1] + "&" + "fbulletd=" + first[2] + "&" + "fsurvival=" + first[3] + "&" + "sname=" + second[0] + "&" + "sscore=" + second[1] + "&" + "sbulletd=" + second[2] + "&" + "ssurvival=" + second[3];
            if (matchtype.equals("GENERAL") || matchtype.equals("SERVER")) {
                errorsfound |= this.senddata(this.game, data, outtxt, true, results, i, battlesnum, prioritybattles);
            }
            if (this.sizesfile.length() == 0) continue;
            if (this.minibots.length() != 0 && !matchtype.equals("NANO") && !matchtype.equals("MICRO") && this.size.checkCompetitorsForSize(first[0], second[0], 1500L)) {
                data = "version=1&client=" + this.client + "&" + "teams=" + this.teams + "&" + "melee=" + this.melee + "&" + "game=" + this.minibots + "&" + "rounds=" + header[1] + "&" + "field=" + header[2] + "&" + "user=" + this.user + "&" + "time=" + header[4] + "&" + "fname=" + first[0] + "&" + "fscore=" + first[1] + "&" + "fbulletd=" + first[2] + "&" + "fsurvival=" + first[3] + "&" + "sname=" + second[0] + "&" + "sscore=" + second[1] + "&" + "sbulletd=" + second[2] + "&" + "ssurvival=" + second[3];
                errorsfound |= this.senddata(this.minibots, data, outtxt, false, results, i, battlesnum, null);
            }
            if (this.microbots.length() != 0 && !matchtype.equals("NANO") && this.size.checkCompetitorsForSize(first[0], second[0], 750L)) {
                data = "version=1&client=" + this.client + "&" + "teams=" + this.teams + "&" + "melee=" + this.melee + "&" + "game=" + this.microbots + "&" + "rounds=" + header[1] + "&" + "field=" + header[2] + "&" + "user=" + this.user + "&" + "time=" + header[4] + "&" + "fname=" + first[0] + "&" + "fscore=" + first[1] + "&" + "fbulletd=" + first[2] + "&" + "fsurvival=" + first[3] + "&" + "sname=" + second[0] + "&" + "sscore=" + second[1] + "&" + "sbulletd=" + second[2] + "&" + "ssurvival=" + second[3];
                errorsfound |= this.senddata(this.microbots, data, outtxt, false, results, i, battlesnum, null);
            }
            if (this.nanobots.length() == 0 || !this.size.checkCompetitorsForSize(first[0], second[0], 250L)) continue;
            data = "version=1&client=" + this.client + "&" + "game=" + this.nanobots + "&" + "rounds=" + header[1] + "&" + "field=" + header[2] + "&" + "user=" + this.user + "&" + "time=" + header[4] + "&" + "fname=" + first[0] + "&" + "fscore=" + first[1] + "&" + "fbulletd=" + first[2] + "&" + "fsurvival=" + first[3] + "&" + "sname=" + second[0] + "&" + "sscore=" + second[1] + "&" + "sbulletd=" + second[2] + "&" + "ssurvival=" + second[3];
            errorsfound |= this.senddata(this.nanobots, data, outtxt, false, results, i, battlesnum, null);
        }
        outtxt.close();
        battlesnum.close();
        prioritybattles.close();
        File r = new File(this.resultsfile);
        boolean b = r.delete();
        if (!b) {
            System.out.println("Unable to delete results file.");
        }
        if (errorsfound && !FileTransfer.copy(this.tempdir + "results.txt", this.resultsfile)) {
            System.out.println("Error when copying results errors file.");
        }
    }

    private void saverror(PrintStream outtxt, String match, String bot1, String bot2, boolean saveonerror) {
        if (saveonerror) {
            outtxt.println(match);
            outtxt.println(bot1);
            outtxt.println(bot2);
        }
        System.out.println("Unable to upload results " + match + " " + bot1 + " " + bot2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean senddata(String game, String data, PrintStream outtxt, boolean saveonerror, Vector<String> results, int i, PrintStream battlesnum, PrintStream prioritybattles) {
        boolean errorsfound = false;
        PrintWriter wr = null;
        BufferedReader rd = null;
        try {
            String line;
            URL url = new URL(this.resultsurl);
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            wr = new PrintWriter(new OutputStreamWriter(conn.getOutputStream()));
            wr.println(data);
            wr.flush();
            rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            boolean ok = false;
            while ((line = rd.readLine()) != null) {
                if (line.indexOf("OK") != -1) {
                    ok = true;
                    System.out.println(line);
                    continue;
                }
                if (line.indexOf("<") != -1 && line.indexOf(">") != -1) {
                    String bot1 = results.get(i * 3 + 1);
                    bot1 = bot1.substring(0, bot1.indexOf(","));
                    String bot2 = results.get(i * 3 + 2);
                    bot2 = bot2.substring(0, bot2.indexOf(","));
                    line = line.replaceAll("<", "");
                    String[] b = (line = line.replaceAll(">", "")).split(" ");
                    if (b.length != 2) continue;
                    battlesnum.println(game + "," + bot1 + "," + b[0]);
                    battlesnum.println(game + "," + bot2 + "," + b[1]);
                    continue;
                }
                if (line.indexOf("[") != -1 && line.indexOf("]") != -1) {
                    line = line.substring(1);
                    line = line.substring(0, line.length() - 1);
                    String[] items = line.split(",");
                    String bot1 = items[0].substring(0, items[0].lastIndexOf("_")) + " " + items[0].substring(items[0].lastIndexOf("_") + 1);
                    String bot2 = items[1].substring(0, items[1].lastIndexOf("_")) + " " + items[1].substring(items[1].lastIndexOf("_") + 1);
                    String battle = bot1 + "," + bot2 + "," + "SERVER";
                    if (prioritybattles == null) continue;
                    prioritybattles.println(battle);
                    continue;
                }
                System.out.println(line);
            }
            if (!ok) {
                this.saverror(outtxt, results.get(i * 3), results.get(i * 3 + 1), results.get(i * 3 + 2), saveonerror);
                if (saveonerror) {
                    errorsfound = true;
                }
            }
        }
        catch (IOException e) {
            System.out.println(e);
            if (saveonerror) {
                errorsfound = true;
            }
            this.saverror(outtxt, results.get(i * 3), results.get(i * 3 + 1), results.get(i * 3 + 2), saveonerror);
        }
        finally {
            if (wr != null) {
                wr.close();
            }
            if (rd != null) {
                try {
                    rd.close();
                }
                catch (IOException ignored) {}
            }
        }
        return errorsfound;
    }
}

