(ns jonmort.plugin.repl.osgi
  (:gen-class :main false)
  (:import (com.atlassian.sal.api.transaction TransactionTemplate TransactionCallback)))

(defn bundle-context []
  (-> (org.osgi.framework.FrameworkUtil/getBundle jonmort.plugin.repl.osgi) .getBundleContext))

(defn service-reference [name]
  (-> (bundle-context) (.getServiceReference name)))

(defn service [name]
  (-> (bundle-context) (.getService (service-reference name))))

(defmacro with-transaction
  "Execute the provided code in a transation"
  [& body]
  `(let [trans-temp# (service "com.atlassian.sal.api.transaction.TransactionTemplate")
         handler# (proxy [TransactionCallback] []
                   (doInTransaction [] ~@body))]
     (.execute trans-temp# handler#)))

(comment
  (.getBundles (bundle-context))
  (.getServiceReference (bundle-context) "com.atlassian.applinks.api.EntityLinkService")
  (service "com.atlassian.applinks.api.EntityLinkService")
  (def app-links (service "com.atlassian.applinks.api.ApplicationLinkService"))
  (def entity-links (service "com.atlassian.applinks.api.EntityLinkService"))

  (let [app-props (service "com.atlassian.sal.api.ApplicationProperties")]
    {:version (.getVersion app-props)
     :home (.getHomeDirectory app-props)
     :base-url (.getBaseUrl app-props)})

  (def trans-temp (service "com.atlassian.sal.api.transaction.TransactionTemplate"))
  (def space-mgr (service "com.atlassian.confluence.spaces.SpaceManager"))
  (.execute trans-temp (proxy [TransactionCallback] []
                         (doInTransaction [] (.getAllSpaces space-mgr))))

  (macroexpand `(with-transaction (first (.getAllSpaces space-mgr))))
  (with-transaction (pr-str (bean (first (.getAllSpaces space-mgr)))))

  (def location "system.admin")
  (def iface-mgr (service "com.atlassian.plugin.web.WebInterfaceManager"))

  (def sections (map #(.getKey %) (.getSections iface-mgr location)))

  (defn sections-for-location [location iface-mgr]
    (let [section-map-fn (fn [section]
                           {:key (.getKey section) :location (.getLocation section)})
          sections (.getSections iface-mgr location)]
      (map section-map-fn sections)))

  (defn item-to-map [item]
    {:url (.getRenderedUrl (.getLink item) {})
     :section (.getSection item)
     :label (-> (.getWebLabel item)
                (.getDisplayableLabel nil {}))})

  (defn items-for-sections [sections]
    (let [items-fn (fn [section]
                     (->> (str (:location section) "/" (:key section))
                          (.getItems iface-mgr )))
          items (mapcat items-fn sections)]
      (map item-to-map  items)))

  (items-for-sections (sections-for-location location iface-mgr))

  (def tc (service "com.tempoplugin.TempoComponent"))

  (def ps (.getPlanningService tc))

(  (map bean  (.find ps "TO_DATE > ? and COLLABORATOR = ?" (to-array [(java.util.Date.) "mary"]))))


  (import 'com.tempoplugin.core)

  (def ws (.getWorklogService tc))

  (w)


  (require '[clojure.reflect :as r])
  (use '[clojure.pprint :only [print-table]])
  (bean (.get  (.getPlanningService tc) 1))
  (print-table (:members (r/reflect tc)))
  (use 'clojure.reflect)

  (defn all-methods [x]
    (->> x reflect
         :members
         (filter :return-type)
         (map :name)
         sort
         (map #(str "." %) )
         distinct
         println))

  (type-reflect (class tc) :reflector AsmReflector)

  )
