/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.ColorspaceFactory;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PatternDisplay;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.color.PdfTexturePaint;
import org.jpedal.color.RotatedTexturePaint;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.PatternObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.Matrix;

public class PatternColorSpace
extends GenericColorSpace {
    private Map cachedPaints = new HashMap();
    private PdfObjectReader currentPdfFile = null;
    private boolean colorsReversed;

    public PatternColorSpace(PdfObjectReader pdfObjectReader) {
        this.value = 1146450818;
        this.currentPdfFile = pdfObjectReader;
        this.currentColor = new PdfColor(1.0f, 1.0f, 1.0f);
    }

    @Override
    public void setColor(String[] stringArray, int n) {
        PatternObject patternObject = (PatternObject)this.patterns.get(stringArray[0]);
        String string = patternObject.getObjectRefAsString();
        if (string != null && this.cachedPaints.containsKey(string)) {
            this.currentColor = (PdfPaint)this.cachedPaints.get(string);
            return;
        }
        this.currentPdfFile.checkResolved(patternObject);
        byte[] byArray = this.currentPdfFile.readStream(patternObject, true, true, true, false, false, patternObject.getCacheName(this.currentPdfFile.getObjectReader()));
        int n2 = patternObject.getInt(1755231159);
        Object object = null;
        float[] fArray = patternObject.getFloatArray(1145198201);
        if (fArray != null) {
            if (n2 == 1) {
                float[][] fArrayArray = new float[][]{{fArray[0], fArray[1], 0.0f}, {fArray[2], fArray[3], 0.0f}, {0.0f, 0.0f, 1.0f}};
                if (fArray[5] < 0.0f) {
                    fArray[4] = 0.0f;
                    fArray[5] = 0.0f;
                }
                object = fArrayArray;
            } else {
                float[][] fArrayArray = new float[][]{{fArray[0], fArray[1], 0.0f}, {fArray[2], fArray[3], 0.0f}, {fArray[4], fArray[5], 1.0f}};
                this.colorsReversed = fArrayArray[2][0] < 0.0f;
                object = Matrix.multiply(fArrayArray, this.CTM);
            }
        }
        if (n2 == 1) {
            this.currentColor = this.setupTiling(patternObject, fArray, (float[][])object, byArray);
        } else if (n2 == 2) {
            this.currentColor = this.setupShading(patternObject, (float[][])object);
        }
    }

    private PdfPaint setupTiling(PdfObject pdfObject, float[] fArray, float[][] fArray2, byte[] byArray) {
        int n;
        int n2;
        boolean bl = fArray != null && fArray[5] == (float)this.pageHeight && fArray[4] == 0.0f;
        this.inputs = fArray;
        PdfPaint pdfPaint = null;
        boolean bl2 = true;
        BufferedImage bufferedImage = null;
        AffineTransform affineTransform = null;
        float[][] fArray3 = null;
        if (fArray2 != null) {
            fArray3 = new float[3][3];
            for (n2 = 0; n2 < 3; ++n2) {
                for (n = 0; n < 3; ++n) {
                    fArray3[n][n2] = fArray2[n][n2];
                }
            }
        }
        if (fArray2 != null && fArray2[0][0] != 0.0f && (double)fArray2[0][1] < 0.001 && (double)fArray2[0][1] > -0.001) {
            fArray2[0][1] = 0.0f;
        }
        if (fArray2 != null && fArray2[1][1] != 0.0f && (double)fArray2[1][0] < 0.001 && (double)fArray2[1][0] > -0.001) {
            fArray2[1][0] = 0.0f;
        }
        if (fArray != null) {
            for (n2 = 0; n2 < 6; ++n2) {
                if (fArray[n2] == 0.0f || !((double)fArray[n2] < 0.001) || !((double)fArray[n2] > -0.001)) continue;
                fArray[n2] = 0.0f;
            }
        }
        if (fArray2 != null && fArray2[0][0] < 0.0f && fArray2[1][1] < 0.0f) {
            fArray2[0][0] = -fArray2[0][0];
            fArray2[1][1] = -fArray2[1][1];
            if (fArray != null) {
                fArray[0] = -fArray[0];
                fArray[3] = -fArray[3];
            }
        }
        n2 = 0;
        n = 0;
        boolean bl3 = false;
        if (fArray2 != null) {
            int n3 = n2 = fArray2[1][0] != 0.0f && fArray2[0][1] != 0.0f && fArray2[0][0] != 0.0f && fArray2[1][1] != 0.0f ? 1 : 0;
            if (n2 != 0 && fArray2[0][0] != 0.0f && (double)fArray2[0][0] < 0.001 && fArray2[1][1] != 0.0f && (double)fArray2[1][1] < 0.001) {
                n2 = 0;
                fArray2[0][0] = -fArray2[0][1];
                fArray2[1][1] = -fArray2[1][0];
                fArray2[1][0] = 0.0f;
                fArray2[0][1] = 0.0f;
            }
            if ((n2 == 0 || !(fArray2[0][0] > 0.0f) || !(fArray2[0][1] < 0.0f) || !(fArray2[1][0] > 0.0f) || !(fArray2[1][1] > 0.0f)) && n2 != 0 && fArray2[0][0] < 0.0f && fArray2[0][1] < 0.0f && fArray2[1][0] < 0.0f && fArray2[1][1] > 0.0f) {
                fArray2[0][0] = -fArray2[0][0];
                fArray2[1][0] = -fArray2[1][0];
                bl3 = true;
            }
            int n4 = n = fArray2[1][1] < 0.0f || fArray2[0][1] < 0.0f ? 1 : 0;
            if (fArray2[0][0] > 0.0f && fArray2[0][1] < 0.0f && fArray2[1][0] > 0.0f && fArray2[1][1] > 0.0f) {
                n = 0;
            }
            if (fArray2[0][0] > 0.1f && (n2 != 0 || n != 0)) {
                bl2 = false;
            }
            if (n != 0 && fArray2[0][1] > 0.0f && fArray2[1][0] > 0.0f) {
                n = 0;
            }
        }
        int n5 = (int)pdfObject.getFloatNumber(591672680);
        int n6 = (int)pdfObject.getFloatNumber(591672681);
        int n7 = n5;
        int n8 = n6;
        if (n7 == 0) {
            n7 = 1;
        }
        if (n8 == 0) {
            n8 = 1;
        }
        if (n7 < 0) {
            n7 = -n7;
        }
        if (n8 < 0) {
            n8 = -n8;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        int n9 = 0;
        int n10 = 0;
        if (fArray2 != null) {
            if (fArray2[1][1] < 0.0f) {
                fArray2[2][1] = n8;
            }
            if ((double)fArray2[1][0] != 0.0) {
                fArray2[2][1] = -fArray2[1][0];
            }
        }
        ObjectStore objectStore = new ObjectStore();
        DynamicVectorRenderer dynamicVectorRenderer = this.decodePatternContent(pdfObject, fArray2, byArray, objectStore);
        BufferedImage bufferedImage2 = dynamicVectorRenderer.getSingleImagePattern();
        if (fArray != null && (double)fArray[0] < 1.5 && (double)fArray[3] < 1.5 && fArray[1] == 0.0f && fArray[2] == 0.0f && (bufferedImage2 != null || n5 == Short.MIN_VALUE && n6 == Short.MIN_VALUE)) {
            AffineTransform affineTransform2 = new AffineTransform();
            affineTransform2.scale(1.0, -1.0);
            affineTransform2.translate(0.0, -bufferedImage2.getHeight());
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform2, null);
            bufferedImage2 = affineTransformOp.filter(bufferedImage2, null);
            if (bufferedImage2.getType() != 2) {
                bufferedImage2 = ColorSpaceConvertor.convertToARGB(bufferedImage2);
            }
            return new PdfTexturePaint(bufferedImage2, new Rectangle((int)(fArray[4] - (float)bufferedImage2.getWidth()), (int)(fArray[5] - (float)bufferedImage2.getHeight()), bufferedImage2.getWidth(), bufferedImage2.getHeight()));
        }
        float f3 = 0.0f;
        float f4 = 0.0f;
        boolean bl4 = false;
        if (fArray2 != null) {
            f3 = fArray2[0][0];
            if (f3 == 0.0f) {
                f3 = fArray2[0][1];
            }
            if (f3 < 0.0f) {
                f3 = -f3;
            }
            if ((f4 = fArray2[1][1]) == 0.0f) {
                f4 = fArray2[1][0];
            }
            if (f4 < 0.0f) {
                f4 = -f4;
            }
        }
        if (fArray2 != null) {
            if (fArray != null && fArray[0] > 1.0f && fArray[3] > 1.0f && n2 == 0) {
                bufferedImage = new BufferedImage((int)((float)n7 * f3), (int)((float)n8 * f4), 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setClip(new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
                dynamicVectorRenderer.setG2(graphics2D);
                dynamicVectorRenderer.paint(null, new AffineTransform(fArray2[0][0], fArray2[0][1], fArray2[1][0], fArray2[1][1], fArray[4], -fArray[5] / 2.0f), null);
            } else {
                BufferedImage bufferedImage3 = null;
                f = fArray2[0][0];
                f2 = fArray2[1][1];
                if (f == 0.0f) {
                    f = fArray2[0][1];
                }
                if (f < 0.0f) {
                    f = -f;
                }
                if (f2 == 0.0f) {
                    f2 = fArray2[1][0];
                }
                if (f2 < 0.0f) {
                    f2 = -f2;
                }
                f *= (float)n7;
                f2 *= (float)n8;
                int n11 = n7;
                int n12 = n8;
                if (n2 == 0) {
                    int n13;
                    int n14;
                    int n15;
                    if (n != 0) {
                        int n16 = (int)((float)n7 / f);
                        int n17 = (int)((float)n8 / f2);
                        if (n16 > 0 && n17 > 0) {
                            n11 = (int)((float)(n16 + 1) * f);
                            n12 = (int)((float)(n17 + 1) * f2);
                            n7 = n11;
                            n8 = n12;
                        }
                    } else if (fArray != null && fArray[0] > 0.0f && fArray[0] < 1.0f && fArray[3] > 0.0f && fArray[3] < 1.0f) {
                        n11 = (int)f;
                        n12 = (int)f2;
                        if (n12 == 0) {
                            n12 = 1;
                        }
                        if ((n9 = (int)fArray[4]) > n7) {
                            while (n9 > 0 && (n9 -= n7) != 0) {
                            }
                            n9 /= 2;
                        }
                        if ((n10 = (int)fArray[5]) > n12) {
                            while (n10 > 0) {
                                n10 -= n12;
                            }
                        }
                    }
                    if (bl4) {
                        bufferedImage = new BufferedImage((int)(f3 + 0.5f), (int)(f4 + 0.5f), 2);
                        affineTransform = AffineTransform.getScaleInstance((float)n7 / f3, (float)n8 / f4);
                    } else {
                        bufferedImage = n11 < 1 || n12 < 1 ? new BufferedImage(1, 1, 2) : new BufferedImage(n11, n12, 2);
                    }
                    Graphics2D graphics2D = bufferedImage.createGraphics();
                    AffineTransform affineTransform3 = graphics2D.getTransform();
                    graphics2D.setClip(new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
                    int n18 = 0;
                    Rectangle rectangle = dynamicVectorRenderer.getOccupiedArea().getBounds();
                    int n19 = 0;
                    int n20 = 0;
                    if (rectangle.x < 0) {
                        n15 = rectangle.width - rectangle.x;
                        n19 = rectangle.x;
                    } else {
                        n15 = rectangle.width + rectangle.x;
                    }
                    if (rectangle.y < 0) {
                        n14 = rectangle.height - rectangle.y;
                        n20 = rectangle.y;
                    } else {
                        n14 = rectangle.height + rectangle.y;
                    }
                    if (n14 == 0) {
                        n14 = 1;
                    }
                    if (bl2) {
                        bufferedImage3 = n15 < 1 || n14 < 1 ? new BufferedImage(1, 1, 2) : new BufferedImage(n15, n14, 2);
                        Graphics2D graphics2D2 = bufferedImage3.createGraphics();
                        graphics2D2.translate(-n19, -n20);
                        dynamicVectorRenderer.setG2(graphics2D2);
                        dynamicVectorRenderer.paint(null, null, null);
                    }
                    if ((n13 = rectangle.x) < 0 && !bl2) {
                        n18 = (int)((float)(-n13) * fArray2[0][0]);
                    }
                    float f5 = n8;
                    if (bl2) {
                        f5 = n8 + bufferedImage3.getHeight() * 2;
                    }
                    int n21 = 0;
                    if (fArray2[1][1] < 0.0f) {
                        n21 = (int)(-f5 / 2.0f);
                    }
                    if (bl && fArray2[0][0] > 0.0f && fArray2[1][1] < 0.0f) {
                        n21 += this.pageHeight - this.pageWidth;
                    }
                    for (float f6 = (float)n21; f6 < f5; f6 += f2) {
                        for (float f7 = (float)n18; f7 < (float)n7; f7 += f) {
                            if (n != 0) {
                                graphics2D.translate(f7, -f6);
                            } else {
                                graphics2D.translate(f7, f6);
                            }
                            if (bl2) {
                                AffineTransform affineTransform4 = new AffineTransform();
                                ColorSpaceConvertor.drawImage(graphics2D, bufferedImage3, affineTransform4, null);
                            } else {
                                dynamicVectorRenderer.setG2(graphics2D);
                                dynamicVectorRenderer.paint(null, affineTransform, null);
                            }
                            graphics2D.setTransform(affineTransform3);
                        }
                    }
                }
            }
        } else {
            if (bl4) {
                bufferedImage = new BufferedImage((int)(f3 + 0.5f), (int)(f4 + 0.5f), 2);
                affineTransform = AffineTransform.getScaleInstance((float)n7 / f3, (float)n8 / f4);
            } else {
                bufferedImage = new BufferedImage(n7, n8, 2);
            }
            Graphics2D graphics2D = bufferedImage.createGraphics();
            dynamicVectorRenderer.setG2(graphics2D);
            dynamicVectorRenderer.paint(null, null, null);
            if (n != 0 && bufferedImage.getHeight() > 1) {
                AffineTransform affineTransform5 = new AffineTransform();
                affineTransform5.translate(0.0, bufferedImage.getHeight());
                affineTransform5.scale(1.0, -1.0);
                AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform5, ColorSpaces.hints);
                bufferedImage = affineTransformOp.filter(bufferedImage, null);
            }
        }
        objectStore.flush();
        if (bufferedImage != null) {
            pdfPaint = new PdfTexturePaint(bufferedImage, new Rectangle(n9, n10, bufferedImage.getWidth(), bufferedImage.getHeight()));
        }
        if (n2 != 0) {
            pdfPaint = new RotatedTexturePaint(bl3, fArray3, pdfObject, bl2, dynamicVectorRenderer, fArray2, n7, n8, f, f2, affineTransform);
        }
        if (pdfPaint != null) {
            this.cachedPaints.put(pdfObject.getObjectRefAsString(), pdfPaint);
        }
        return pdfPaint;
    }

    private DynamicVectorRenderer decodePatternContent(PdfObject pdfObject, float[][] fArray, byte[] byArray, ObjectStore objectStore) {
        PdfObject pdfObject2 = pdfObject.getDictionary(2004251818);
        PdfStreamDecoder pdfStreamDecoder = new PdfStreamDecoder(this.currentPdfFile);
        pdfStreamDecoder.setParameters(false, true, 7, 0);
        pdfStreamDecoder.setIntValue(-12, 1);
        pdfStreamDecoder.setObjectValue(-8, objectStore);
        PatternDisplay patternDisplay = new PatternDisplay(0, false, 20, objectStore);
        patternDisplay.setOptimisedRotation(false);
        try {
            pdfStreamDecoder.setObjectValue(23, patternDisplay);
            if (pdfObject2 != null) {
                pdfStreamDecoder.readResources(pdfObject2, true);
            }
            pdfStreamDecoder.setDefaultColors(this.gs.getStrokeColor(), this.gs.getNonstrokeColor());
            GraphicsState graphicsState = new GraphicsState(0, 0);
            if (fArray != null) {
                graphicsState.CTM = fArray;
            }
            pdfStreamDecoder.decodePageContent(graphicsState, byArray);
        }
        catch (PdfException pdfException) {
            pdfException.printStackTrace();
        }
        pdfStreamDecoder = null;
        return patternDisplay;
    }

    private PdfPaint setupShading(PdfObject pdfObject, float[][] fArray) {
        PdfObject pdfObject2 = pdfObject.getDictionary(878474856);
        PdfObject pdfObject3 = pdfObject2.getDictionary(2087749783);
        GenericColorSpace genericColorSpace = ColorspaceFactory.getColorSpaceInstance(this.currentPdfFile, pdfObject3);
        if (genericColorSpace.getID() == 1247168582 && pdfObject3.getParameterConstant(2054519176) == 1498837125) {
            genericColorSpace = new DeviceCMYKColorSpace();
        }
        if (pdfObject2 == null) {
            return null;
        }
        return null;
    }
}

