/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.images;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.TIFFEncodeParam;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import javax.media.jai.JAI;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.Commands;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.FontMappings;
import org.jpedal.io.JAIHelper;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.utils.LogWriter;

public class ExtractPagesAsThumbnails {
    boolean isTransparent = false;
    private String user_dir = System.getProperty("user.dir");
    private int dpi = 96;
    public static boolean outputMessages = false;
    String output_dir = null;
    String separator = System.getProperty("file.separator");
    PdfDecoder decode_pdf = null;
    private String format = "png";
    private String[] ocr = new String[]{"TeleForm"};
    private boolean useHiresImage = false;
    private String test_file = "/mnt/shared/sample_pdfs/general/World Factbook.pdf";
    public static boolean isTest = false;
    public static boolean orderReversed = false;
    private int scaling = 100;
    private String password = null;
    private float JPEGcompression = -1.0f;

    public ExtractPagesAsThumbnails(String[] stringArray) {
        String string = this.setParams(stringArray);
        File file = new File(string);
        if (!file.exists()) {
            System.out.println("File " + file + " not found");
            System.out.println("May need full path");
            return;
        }
        this.extraction(string, this.output_dir);
    }

    private void extraction(String string, String string2) {
        String string3 = System.getProperty("org.jpedal.dpi");
        if (string3 != null) {
            try {
                this.dpi = Integer.parseInt(string3);
            }
            catch (Exception exception) {
                throw new RuntimeException("Problem with value " + string3 + " (must be integer)");
            }
        }
        String string4 = System.getProperty("org.jpedal.hires");
        if (Commands.hires || string4 != null) {
            this.useHiresImage = true;
        }
        this.output_dir = string2;
        if (!this.user_dir.endsWith(this.separator)) {
            this.user_dir = this.user_dir + this.separator;
        }
        if (string.toLowerCase().endsWith(".pdf")) {
            if (!isTest && string2 == null) {
                string2 = this.user_dir + "thumbnails" + this.separator;
            }
            this.decodeFile(string, string2);
        } else {
            String[] stringArray = null;
            File file = null;
            if (!string.endsWith(this.separator)) {
                string = string + this.separator;
            }
            try {
                file = new File(string);
                if (!file.isDirectory()) {
                    System.err.println(string + " is not a directory. Exiting program");
                } else {
                    stringArray = file.list();
                }
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception trying to access file " + exception.getMessage());
            }
            if (stringArray != null) {
                long l = stringArray.length;
                int n = 0;
                while ((long)n < l) {
                    if (stringArray[n].toLowerCase().endsWith(".pdf")) {
                        if (outputMessages) {
                            System.out.println(string + stringArray[n]);
                        }
                        this.decodeFile(string + stringArray[n], string2);
                    }
                    ++n;
                }
            }
        }
        if (outputMessages) {
            System.out.println("Thumbnails created");
        }
    }

    private void decodeFile(String string, String string2) {
        String string3 = "demo";
        int n = string.lastIndexOf(this.separator);
        if (n == -1) {
            n = string.lastIndexOf(47);
        }
        if (n != -1) {
            string3 = string.substring(n + 1, string.length() - 4);
        } else if (!isTest && string.toLowerCase().endsWith(".pdf")) {
            string3 = string.substring(0, string.length() - 4);
        }
        if (string2 == null) {
            string2 = this.user_dir + "thumbnails" + this.separator;
        }
        try {
            this.decode_pdf = new PdfDecoder(true);
            if (!isTest) {
                FontMappings.setFontReplacements();
            }
            if (isTest) {
                this.dpi = 72;
            }
            this.decode_pdf.setExtractionMode(0, this.dpi, (float)this.dpi / 72.0f);
            if (outputMessages) {
                System.out.println("Opening file :" + string + " at " + this.dpi + " dpi");
            }
            if (this.password != null) {
                this.decode_pdf.openPdfFile(string, this.password);
            } else {
                this.decode_pdf.openPdfFile(string);
            }
        }
        catch (Exception exception) {
            System.err.println("8.Exception " + exception + " in pdf code in " + string);
        }
        if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isFileViewable()) {
            if (!isTest) {
                throw new RuntimeException("Wrong password password used=>" + this.password + "<");
            }
        } else {
            if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isPasswordSupplied() && !this.decode_pdf.isExtractionAllowed()) {
                throw new RuntimeException("Extraction not allowed");
            }
            String string4 = System.getProperty("org.jpedal.separation");
            if (string4 != null) {
                Object[] objectArray = new Object[]{new Integer(7), "", Boolean.FALSE};
                if (string4.equals("all")) {
                    objectArray = new Object[]{new Integer(2), "image_and_shapes", Boolean.FALSE, new Integer(18), "image_without_shapes", Boolean.FALSE, new Integer(1), "text_and_shapes", Boolean.TRUE, new Integer(7), "all", Boolean.FALSE, new Integer(17), "text_without_shapes", Boolean.TRUE};
                }
                int n2 = objectArray.length;
                for (int i = 0; i < n2; i += 3) {
                    this.decode_pdf.setRenderMode((Integer)objectArray[i]);
                    this.extractPageAsImage(string, string2, string3 + "_" + objectArray[i + 1], (Boolean)objectArray[i + 2]);
                }
            } else {
                this.extractPageAsImage(string, string2, string3, this.isTransparent);
            }
        }
        this.decode_pdf.closePdfFile();
    }

    private void extractPageAsImage(String string, String string2, String string3, boolean bl) {
        boolean bl2;
        String string4;
        File file = new File(string2);
        if (!file.exists()) {
            file.mkdirs();
        }
        boolean bl3 = (string4 = System.getProperty("org.jpedal.multipage_tiff")) != null && string4.toLowerCase().equals("true");
        String string5 = System.getProperty("org.jpedal.compression_jpeg");
        if (string5 != null) {
            try {
                this.JPEGcompression = Float.parseFloat(string5);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (this.JPEGcompression < 0.0f || this.JPEGcompression > 1.0f) {
                throw new RuntimeException("Invalid value for JPEG compression - must be between 0 and 1");
            }
        }
        String string6 = System.getProperty("org.jpedal.compress_tiff");
        String string7 = System.getProperty("org.jpedal.jpeg_dpi");
        boolean bl4 = bl2 = string6 != null && string6.toLowerCase().equals("true");
        if (JAIHelper.isJAIused()) {
            JAIHelper.confirmJAIOnClasspath();
        }
        int n = 1;
        int n2 = this.decode_pdf.getPageCount();
        if (n2 > 10 && isTest) {
            n2 = 10;
        }
        if (outputMessages) {
            System.out.println("Thumbnails will be in  " + string2);
        }
        try {
            BufferedImage[] bufferedImageArray = new BufferedImage[1 + (n2 - n)];
            if (orderReversed) {
                for (int i = n2; i >= n; --i) {
                    this.getPage(string2, string3, bl, bl3, string5, string7, bl2, n, n2, bufferedImageArray, i);
                }
            } else {
                for (int i = n; i < n2 + 1; ++i) {
                    this.getPage(string2, string3, bl, bl3, string5, string7, bl2, n, n2, bufferedImageArray, i);
                }
            }
        }
        catch (Exception exception) {
            this.decode_pdf.closePdfFile();
            throw new RuntimeException("Exception " + exception.getMessage() + " with thumbnails on File=" + string);
        }
    }

    private void getPage(String string, String string2, boolean bl, boolean bl2, String string3, String string4, boolean bl3, int n, int n2, BufferedImage[] bufferedImageArray, int n3) throws PdfException, IOException, FileNotFoundException {
        Object object;
        boolean bl4;
        if (outputMessages) {
            System.out.println("Page " + n3);
        }
        String string5 = String.valueOf(n3);
        String string6 = String.valueOf(n2);
        int n4 = string6.length() - string5.length();
        for (int i = 0; i < n4; ++i) {
            string5 = '0' + string5;
        }
        String string7 = bl2 ? string2 + '_' + this.dpi : string2 + '_' + this.dpi + "_page_" + string5;
        PdfFileInformation pdfFileInformation = this.decode_pdf.getFileInformationData();
        String[] stringArray = pdfFileInformation.getFieldValues();
        String[] stringArray2 = pdfFileInformation.getFieldNames();
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!stringArray2[i].equals("Creator")) continue;
            for (int j = 0; j < this.ocr.length; ++j) {
                if (!stringArray[i].equals(this.ocr[j])) continue;
                this.decode_pdf.setRenderMode(2);
            }
        }
        Object object2 = this.decode_pdf.getPageAsImage(n3);
        Iterator iterator = this.decode_pdf.getPageInfo(1);
        boolean bl5 = bl4 = iterator != null;
        while (iterator != null && iterator.hasNext()) {
            int n5 = (Integer)iterator.next();
            if (n5 == 1568372915 || n5 == 391471749) continue;
            bl4 = false;
        }
        if (bl4) {
            object = new BufferedImage(((BufferedImage)object2).getWidth(), ((BufferedImage)object2).getHeight(), 10);
            ((BufferedImage)object).getGraphics().drawImage((Image)object2, 0, 0, null);
            object2 = object;
        }
        if (bl2) {
            bufferedImageArray[n3 - n] = object2;
        }
        if (object2 == null) {
            if (outputMessages && !isTest) {
                System.out.println("No image generated - are you using client mode?");
            }
        } else {
            String string8;
            Graphics2D graphics2D;
            Object object3;
            int n6;
            object = System.getProperty("maxDimension");
            int n7 = -1;
            if (object != null) {
                n7 = Integer.parseInt((String)object);
            }
            if (this.scaling != 100 || n7 != -1) {
                int n8 = ((BufferedImage)object2).getWidth() * this.scaling / 100;
                n6 = ((BufferedImage)object2).getHeight() * this.scaling / 100;
                object3 = null;
                if (n7 != -1 && (n8 > n7 || n6 > n7)) {
                    if (n8 > n6) {
                        n8 = n7;
                        object3 = ((Image)object2).getScaledInstance(n8, -1, 4);
                    } else {
                        n6 = n7;
                        object3 = ((Image)object2).getScaledInstance(-1, n6, 4);
                    }
                } else {
                    object3 = ((Image)object2).getScaledInstance(n8, -1, 4);
                }
                object2 = this.format.toLowerCase().startsWith("jp") ? new BufferedImage(((Image)object3).getWidth(null), ((Image)object3).getHeight(null), 1) : new BufferedImage(((Image)object3).getWidth(null), ((Image)object3).getHeight(null), 2);
                graphics2D = ((BufferedImage)object2).createGraphics();
                graphics2D.drawImage((Image)object3, 0, 0, null);
            }
            if ((string8 = System.getProperty("org.jpedal.imageType")) != null) {
                if (ExtractPagesAsThumbnails.isNumber(string8)) {
                    n6 = Integer.parseInt(string8);
                    if (n6 > -1 && n6 < 14) {
                        object3 = new BufferedImage(((BufferedImage)object2).getWidth(), ((BufferedImage)object2).getHeight(), n6);
                        graphics2D = ((BufferedImage)object3).createGraphics();
                        graphics2D.drawImage((Image)object2, null, null);
                        object2 = object3;
                    } else {
                        System.err.println("Image Type is not valid. Value should be a digit between 0 - 13 based on the BufferedImage TYPE variables.");
                    }
                } else {
                    System.err.println("Image Type provided is not an Integer. Value should be a digit between 0 - 13 based on the BufferedImage TYPE variables.");
                }
            }
            if (JAIHelper.isJAIused() && this.format.startsWith("tif")) {
                TIFFEncodeParam tIFFEncodeParam = new TIFFEncodeParam();
                if (bl3) {
                    tIFFEncodeParam.setCompression(32773);
                }
                if (!bl2) {
                    object3 = new FileOutputStream(string + string5 + string7 + ".tif");
                    JAI.create((String)"encode", (RenderedImage)object2, (Object)object3, (Object)"TIFF", (Object)tIFFEncodeParam);
                } else if (bl2 && n3 == n2) {
                    object3 = new FileOutputStream(string + string7 + ".tif");
                    graphics2D = ImageCodec.createImageEncoder((String)"TIFF", (OutputStream)object3, (ImageEncodeParam)tIFFEncodeParam);
                    Vector<BufferedImage> vector = new Vector<BufferedImage>();
                    vector.addAll(Arrays.asList(bufferedImageArray).subList(1, bufferedImageArray.length));
                    tIFFEncodeParam.setExtraImages(vector.iterator());
                    graphics2D.encode(bufferedImageArray[0]);
                    ((OutputStream)object3).close();
                }
            } else if ((string4 != null || string3 != null) && this.format.startsWith("jp") && JAIHelper.isJAIused()) {
                JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)new FileOutputStream(string + string5 + string7 + "." + this.format));
                object3 = jPEGImageEncoder.getDefaultJPEGEncodeParam((BufferedImage)object2);
                if (string4 != null) {
                    int n9 = 96;
                    try {
                        n9 = Integer.parseInt(string4);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    object3.setDensityUnit(1);
                    object3.setXDensity(n9);
                    object3.setYDensity(n9);
                }
                if (this.JPEGcompression >= 0.0f && this.JPEGcompression <= 1.0f) {
                    object3.setQuality(this.JPEGcompression, false);
                }
                jPEGImageEncoder.encode((BufferedImage)object2, (JPEGEncodeParam)object3);
            } else {
                this.decode_pdf.getObjectStore().saveStoredImage(string + string5 + string7, (BufferedImage)object2, true, false, this.format);
            }
        }
        this.decode_pdf.flushObjectValues(true);
    }

    public static void main(String[] stringArray) {
        boolean bl;
        System.out.println("Simple demo to extract images from a page");
        int n = stringArray.length;
        boolean bl2 = bl = n > 4 || n == 0;
        if (bl) {
            if (n > 0) {
                System.out.println("too many arguments entered - run with no values to see defaults");
                String string = "";
                for (int i = 0; i < stringArray.length; ++i) {
                    string = string + stringArray[i] + '\n';
                }
                System.out.println("you entered:\n" + string + "as the arguments");
            }
            ExtractPagesAsThumbnails.showCommandLineValues();
        }
        new ExtractPagesAsThumbnails(stringArray);
    }

    private String setParams(String[] stringArray) {
        String string = this.test_file;
        int n = stringArray.length;
        if (n == 0) {
            ExtractPagesAsThumbnails.showCommandLineValues();
        } else if (n == 1) {
            string = stringArray[0];
        } else if (n < 6) {
            string = stringArray[0];
            for (int i = 1; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                boolean bl = ExtractPagesAsThumbnails.isNumber(string2);
                if (bl) {
                    try {
                        this.scaling = Integer.parseInt(string2);
                        continue;
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(string2 + " is not an integer");
                    }
                }
                String string3 = string2.toLowerCase();
                if (string3.equals("jpg") || string3.equals("jpeg")) {
                    this.format = "jpg";
                    continue;
                }
                if (string3.equals("tif") || string3.equals("tiff")) {
                    this.format = "tif";
                    continue;
                }
                if (string3.equals("png")) {
                    this.format = "png";
                    continue;
                }
                if (string2.endsWith("/") || string2.endsWith("\\")) {
                    this.output_dir = string2;
                    continue;
                }
                this.password = string2;
            }
        }
        return string;
    }

    private static void showCommandLineValues() {
        System.out.println("Example can take 1-5 parameters");
        System.out.println("Value 1 is the file name or directory of PDF files to process");
        System.out.println("4 optional values of:-\nimage type (jpeg,tiff,png), \nscaling (100 = full size), \npassword for protected file (or null) can also be added ,\noutput path (must end with / or \\ character)");
        System.exit(0);
    }

    private static boolean isNumber(String string) {
        boolean bl = true;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!(c < '0' | c > '9')) continue;
            bl = false;
            i = n;
        }
        return bl;
    }

    public String getOutputDir() {
        return this.output_dir;
    }
}

