/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui;

import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import org.jpedal.examples.simpleviewer.Commands;
import org.jpedal.examples.simpleviewer.Values;
import org.jpedal.examples.simpleviewer.gui.BaseTransferHandler;
import org.jpedal.examples.simpleviewer.gui.SwingGUI;
import org.jpedal.examples.simpleviewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.exception.PdfException;

public class SingleViewTransferHandler
extends BaseTransferHandler {
    public SingleViewTransferHandler(Values values, GUIThumbnailPanel gUIThumbnailPanel, SwingGUI swingGUI, Commands commands) {
        super(values, gUIThumbnailPanel, swingGUI, commands);
    }

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable) {
        try {
            Object object = this.getImport(transferable);
            if (object instanceof String) {
                String string = (String)object;
                if (string.indexOf("file:/") != string.lastIndexOf("file:/")) {
                    this.currentGUI.showMessageDialog("You may only import 1 file at a time");
                } else {
                    this.openFile(string);
                }
            } else if (object instanceof List) {
                List list = (List)object;
                if (list.size() == 1) {
                    File file = (File)list.get(0);
                    this.openFile(file.getAbsolutePath());
                } else {
                    this.currentGUI.showMessageDialog("You may only import 1 file at a time");
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    protected void openFile(String string) throws PdfException {
        boolean bl;
        String string2 = string.toLowerCase();
        boolean bl2 = bl = string2.endsWith(".pdf") || string2.endsWith(".fdf") || string2.endsWith(".tif") || string2.endsWith(".tiff") || string2.endsWith(".png") || string2.endsWith(".jpg") || string2.endsWith(".jpeg");
        if (bl) {
            this.currentCommands.openTransferedFile(string);
        } else {
            this.currentGUI.showMessageDialog("You may only import a valid PDF or image");
        }
    }
}

