/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jpedal.PdfDecoder;
import org.jpedal.SingleDisplay;
import org.jpedal.examples.simpleviewer.SimpleViewer;
import org.jpedal.examples.simpleviewer.Values;
import org.jpedal.examples.simpleviewer.gui.SwingGUI;
import org.jpedal.examples.simpleviewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.simpleviewer.gui.swing.SearchList;
import org.jpedal.exception.PdfException;
import org.jpedal.grouping.DefaultSearchListener;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.Messages;
import org.jpedal.utils.SwingWorker;
import org.jpedal.utils.repositories.Vector_Rectangle;

public class SwingSearchWindow
extends JFrame
implements GUISearchWindow {
    public static int SEARCH_EXTERNAL_WINDOW = 0;
    public static int SEARCH_TABBED_PANE = 1;
    public static int SEARCH_MENU_BAR = 2;
    private boolean backGroundSearch = false;
    int style = 0;
    private boolean isSetup = false;
    boolean usingMenuBarSearch = false;
    int lastPage = -1;
    String defaultMessage = "Search PDF Here";
    JProgressBar progress = new JProgressBar(0, 100);
    int pageIncrement = 0;
    JTextField searchText = null;
    JTextField searchCount;
    DefaultListModel listModel;
    SearchList resultsList;
    JLabel label = null;
    private JPanel advancedPanel;
    private JComboBox searchType;
    private JCheckBox wholeWordsOnlyBox;
    private JCheckBox caseSensitiveBox;
    private JCheckBox multiLineBox;
    private JCheckBox highlightAll;
    private JCheckBox searchAll;
    private JCheckBox useRegEx;
    ActionListener AL = null;
    ListSelectionListener LSL = null;
    WindowListener WL;
    KeyListener KL;
    SwingWorker searcher = null;
    public boolean isSearch = false;
    public boolean hasSearched = false;
    public boolean requestInterupt = false;
    JButton searchButton = null;
    private int itemFoundCount = 0;
    Map textPages = new HashMap();
    Map textRectangles = new HashMap();
    String[] searchTerms = new String[]{""};
    boolean singlePageSearch = false;
    final JPanel nav = new JPanel();
    Values commonValues;
    SwingGUI currentGUI;
    PdfDecoder decode_pdf;
    int searchTypeParameters = 0;
    int firstPageWithResults = 0;
    private boolean deleteOnClick;

    @Override
    public void setWholeWords(boolean bl) {
        this.wholeWordsOnlyBox.setSelected(bl);
    }

    @Override
    public void setCaseSensitive(boolean bl) {
        this.caseSensitiveBox.setSelected(bl);
    }

    @Override
    public void setMultiLine(boolean bl) {
        this.multiLineBox.setSelected(bl);
    }

    public void setHighlightAll(boolean bl) {
        this.highlightAll.setSelected(bl);
    }

    public void setRegularExpressionUsage(boolean bl) {
        this.useRegEx.setSelected(bl);
    }

    public SwingSearchWindow(SwingGUI swingGUI) {
        this.currentGUI = swingGUI;
        this.setName("searchFrame");
    }

    @Override
    public Component getContentPanel() {
        return this.getContentPane();
    }

    @Override
    public boolean isSearching() {
        return this.isSearch;
    }

    @Override
    public void init(PdfDecoder pdfDecoder, Values values) {
        this.decode_pdf = pdfDecoder;
        this.commonValues = values;
        if (this.isSetup) {
            this.searchCount.setText(Messages.getMessage("PdfViewerSearch.ItemsFound") + ' ' + this.itemFoundCount);
            this.searchText.selectAll();
            this.searchText.grabFocus();
        } else {
            this.isSetup = true;
            this.setTitle(Messages.getMessage("PdfViewerSearchGUITitle.DefaultMessage"));
            this.defaultMessage = Messages.getMessage("PdfViewerSearchGUI.DefaultMessage");
            this.searchText = new JTextField(10);
            this.searchText.setText(this.defaultMessage);
            this.searchText.setName("searchText");
            this.searchButton = new JButton(Messages.getMessage("PdfViewerSearch.Button"));
            this.advancedPanel = new JPanel(new GridBagLayout());
            this.searchType = new JComboBox<String>(new String[]{Messages.getMessage("PdfViewerSearch.MatchWhole"), Messages.getMessage("PdfViewerSearch.MatchAny")});
            this.wholeWordsOnlyBox = new JCheckBox(Messages.getMessage("PdfViewerSearch.WholeWords"));
            this.wholeWordsOnlyBox.setName("wholeWords");
            this.caseSensitiveBox = new JCheckBox(Messages.getMessage("PdfViewerSearch.CaseSense"));
            this.caseSensitiveBox.setName("caseSensitive");
            this.multiLineBox = new JCheckBox(Messages.getMessage("PdfViewerSearch.MultiLine"));
            this.multiLineBox.setName("multiLine");
            this.highlightAll = new JCheckBox(Messages.getMessage("PdfViewerSearch.HighlightsCheckBox"));
            this.highlightAll.setName("highlightAll");
            this.useRegEx = new JCheckBox(Messages.getMessage("PdfViewerSearch.RegExCheckBox"));
            this.useRegEx.setName("useregex");
            this.searchType.setName("combo");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.advancedPanel.setPreferredSize(new Dimension(this.advancedPanel.getPreferredSize().width, 150));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 19;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            this.advancedPanel.add((Component)new JLabel(Messages.getMessage("PdfViewerSearch.ReturnResultsAs")), gridBagConstraints);
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.gridy = 1;
            this.advancedPanel.add((Component)this.searchType, gridBagConstraints);
            gridBagConstraints.gridy = 2;
            this.advancedPanel.add((Component)new JLabel(Messages.getMessage("PdfViewerSearch.AdditionalOptions")), gridBagConstraints);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridy = 3;
            this.advancedPanel.add((Component)this.wholeWordsOnlyBox, gridBagConstraints);
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridy = 4;
            this.advancedPanel.add((Component)this.caseSensitiveBox, gridBagConstraints);
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridy = 5;
            this.advancedPanel.add((Component)this.multiLineBox, gridBagConstraints);
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridy = 6;
            this.advancedPanel.add((Component)this.highlightAll, gridBagConstraints);
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridy = 7;
            this.advancedPanel.add((Component)this.useRegEx, gridBagConstraints);
            this.advancedPanel.setVisible(false);
            this.nav.setLayout(new BorderLayout());
            this.WL = new WindowListener(){

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                }

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    SwingSearchWindow.this.removeSearchWindow(true);
                }

                @Override
                public void windowClosed(WindowEvent windowEvent) {
                }

                @Override
                public void windowIconified(WindowEvent windowEvent) {
                }

                @Override
                public void windowDeiconified(WindowEvent windowEvent) {
                }

                @Override
                public void windowActivated(WindowEvent windowEvent) {
                }

                @Override
                public void windowDeactivated(WindowEvent windowEvent) {
                }
            };
            this.addWindowListener(this.WL);
            this.nav.add((Component)this.searchButton, "East");
            this.nav.add((Component)this.searchText, "Center");
            this.searchAll = new JCheckBox();
            this.searchAll.setSelected(true);
            this.searchAll.setText(Messages.getMessage("PdfViewerSearch.CheckBox"));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)this.searchAll, "North");
            this.label = new JLabel("<html><center> Show Advanced");
            this.label.setForeground(Color.blue);
            this.label.setName("advSearch");
            this.label.addMouseListener(new MouseListener(){
                boolean isVisible = false;
                String text = "Show Advanced";

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    if (SingleDisplay.allowChangeCursor) {
                        SwingSearchWindow.this.nav.setCursor(new Cursor(12));
                    }
                    SwingSearchWindow.this.label.setText("<html><center><a href=" + this.text + ">" + this.text + "</a></center>");
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    if (SingleDisplay.allowChangeCursor) {
                        SwingSearchWindow.this.nav.setCursor(new Cursor(0));
                    }
                    SwingSearchWindow.this.label.setText("<html><center>" + this.text);
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (this.isVisible) {
                        this.text = Messages.getMessage("PdfViewerSearch.ShowOptions");
                        SwingSearchWindow.this.label.setText("<html><center><a href=" + this.text + ">" + this.text + "</a></center>");
                        SwingSearchWindow.this.advancedPanel.setVisible(false);
                    } else {
                        this.text = Messages.getMessage("PdfViewerSearch.HideOptions");
                        SwingSearchWindow.this.label.setText("<html><center><a href=" + this.text + ">" + this.text + "</a></center>");
                        SwingSearchWindow.this.advancedPanel.setVisible(true);
                    }
                    this.isVisible = !this.isVisible;
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                }
            });
            this.label.setBorder(BorderFactory.createEmptyBorder(3, 4, 4, 4));
            jPanel.add((Component)this.label, "South");
            this.nav.add((Component)jPanel, "North");
            this.itemFoundCount = 0;
            this.textPages.clear();
            this.textRectangles.clear();
            this.listModel = null;
            this.searchCount = new JTextField(Messages.getMessage("PdfViewerSearch.ItemsFound") + ' ' + this.itemFoundCount);
            this.searchCount.setEditable(false);
            this.nav.add((Component)this.searchCount, "South");
            this.listModel = new DefaultListModel();
            this.resultsList = new SearchList(this.listModel, this.textPages, this.textRectangles);
            this.resultsList.setName("results");
            this.LSL = new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        SwingSearchWindow swingSearchWindow = SwingSearchWindow.this;
                        if (!swingSearchWindow.commonValues.isProcessing()) {
                            Integer n;
                            Object v;
                            float f = SwingSearchWindow.this.currentGUI.getScaling();
                            int n2 = SwingSearchWindow.this.resultsList.getSelectedIndex();
                            SwingSearchWindow.this.decode_pdf.getTextLines().clearHighlights();
                            if (n2 != -1 && (v = SwingSearchWindow.this.textPages.get(n = new Integer(n2))) != null) {
                                int n3 = (Integer)v;
                                if (SwingSearchWindow.this.commonValues.getCurrentPage() != n3) {
                                    SwingSearchWindow.this.commonValues.setCurrentPage(n3);
                                    SwingSearchWindow.this.currentGUI.resetStatusMessage(Messages.getMessage("PdfViewer.LoadingPage") + ' ' + SwingSearchWindow.this.commonValues.getCurrentPage());
                                    SwingSearchWindow.this.decode_pdf.setPageParameters(f, SwingSearchWindow.this.commonValues.getCurrentPage());
                                    SwingSearchWindow.this.currentGUI.decodePage(false);
                                    SwingSearchWindow.this.decode_pdf.invalidate();
                                }
                                while (true) {
                                    SwingSearchWindow swingSearchWindow2 = SwingSearchWindow.this;
                                    if (!swingSearchWindow2.commonValues.isProcessing()) break;
                                    try {
                                        Thread.sleep(500L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        interruptedException.printStackTrace();
                                    }
                                }
                                if ((SwingSearchWindow.this.searchTypeParameters & 0x10) == 16) {
                                    Rectangle[] rectangleArray;
                                    Vector_Rectangle vector_Rectangle = new Vector_Rectangle();
                                    int n4 = -1;
                                    for (int i = 0; i != SwingSearchWindow.this.resultsList.getModel().getSize(); ++i) {
                                        Object v2;
                                        Object v3 = SwingSearchWindow.this.textPages.get(new Integer(i));
                                        if (v3 == null) continue;
                                        int n5 = (Integer)v3;
                                        if (n5 != n4) {
                                            vector_Rectangle.trim();
                                            rectangleArray = vector_Rectangle.get();
                                            for (int j = 0; j != rectangleArray.length; ++j) {
                                                System.out.println(rectangleArray[j]);
                                            }
                                            SwingSearchWindow.this.decode_pdf.getTextLines().addHighlights(rectangleArray, true, n4);
                                            n4 = n5;
                                            vector_Rectangle = new Vector_Rectangle();
                                        }
                                        if ((v2 = SwingSearchWindow.this.textRectangles.get(new Integer(i))) instanceof Rectangle) {
                                            vector_Rectangle.addElement((Rectangle)v2);
                                        }
                                        if (!(v2 instanceof Rectangle[])) continue;
                                        Rectangle[] rectangleArray2 = (Rectangle[])v2;
                                        for (int j = 0; j != rectangleArray2.length; ++j) {
                                            vector_Rectangle.addElement(rectangleArray2[j]);
                                        }
                                    }
                                    vector_Rectangle.trim();
                                    rectangleArray = vector_Rectangle.get();
                                    SwingSearchWindow.this.decode_pdf.getTextLines().addHighlights(rectangleArray, true, n4);
                                } else {
                                    Object v4 = SwingSearchWindow.this.textPages.get(n);
                                    int n6 = (Integer)v4;
                                    Vector_Rectangle vector_Rectangle = new Vector_Rectangle();
                                    Rectangle rectangle = null;
                                    Object v5 = SwingSearchWindow.this.textRectangles.get(n);
                                    if (v5 instanceof Rectangle) {
                                        vector_Rectangle.addElement((Rectangle)v5);
                                        rectangle = (Rectangle)v5;
                                    }
                                    if (v5 instanceof Rectangle[]) {
                                        Rectangle[] rectangleArray = (Rectangle[])v5;
                                        rectangle = rectangleArray[0];
                                        for (int i = 0; i != rectangleArray.length; ++i) {
                                            vector_Rectangle.addElement(rectangleArray[i]);
                                        }
                                    }
                                    SwingSearchWindow.this.currentGUI.currentCommands.scrollRectToHighlight(rectangle, n6);
                                    vector_Rectangle.trim();
                                    SwingSearchWindow.this.decode_pdf.getTextLines().addHighlights(vector_Rectangle.get(), true, n6);
                                }
                                SwingSearchWindow.this.decode_pdf.invalidate();
                                SwingSearchWindow.this.decode_pdf.repaint();
                                SwingSearchWindow.this.currentGUI.zoom(false);
                            }
                        }
                        if (SwingSearchWindow.this.commonValues.getCurrentPage() == 1) {
                            SwingSearchWindow.this.currentGUI.setBackNavigationButtonsEnabled(false);
                        } else {
                            SwingSearchWindow.this.currentGUI.setBackNavigationButtonsEnabled(true);
                        }
                        if (SwingSearchWindow.this.commonValues.getCurrentPage() == SwingSearchWindow.this.decode_pdf.getPageCount()) {
                            SwingSearchWindow.this.currentGUI.setForwardNavigationButtonsEnabled(false);
                        } else {
                            SwingSearchWindow.this.currentGUI.setForwardNavigationButtonsEnabled(true);
                        }
                    } else {
                        SwingSearchWindow.this.resultsList.repaint();
                    }
                }
            };
            this.resultsList.addListSelectionListener(this.LSL);
            this.resultsList.setSelectionMode(1);
            this.AL = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!SwingSearchWindow.this.isSearch) {
                        try {
                            SwingSearchWindow.this.searchTypeParameters = 0;
                            if (SwingSearchWindow.this.wholeWordsOnlyBox.isSelected()) {
                                SwingSearchWindow.this.searchTypeParameters |= 1;
                            }
                            if (SwingSearchWindow.this.caseSensitiveBox.isSelected()) {
                                SwingSearchWindow.this.searchTypeParameters |= 2;
                            }
                            if (SwingSearchWindow.this.multiLineBox.isSelected()) {
                                SwingSearchWindow.this.searchTypeParameters |= 8;
                            }
                            if (SwingSearchWindow.this.highlightAll.isSelected()) {
                                SwingSearchWindow.this.searchTypeParameters |= 0x10;
                            }
                            if (SwingSearchWindow.this.useRegEx.isSelected()) {
                                SwingSearchWindow.this.searchTypeParameters |= 0x20;
                            }
                            String string = SwingSearchWindow.this.searchText.getText().trim();
                            if (SwingSearchWindow.this.searchType.getSelectedIndex() == 0) {
                                SwingSearchWindow.this.searchTerms = new String[]{string};
                            } else {
                                SwingSearchWindow.this.searchTerms = string.split(" ");
                                for (int i = 0; i < SwingSearchWindow.this.searchTerms.length; ++i) {
                                    SwingSearchWindow.this.searchTerms[i] = SwingSearchWindow.this.searchTerms[i].trim();
                                }
                            }
                            SwingSearchWindow.this.singlePageSearch = !SwingSearchWindow.this.searchAll.isSelected();
                            SwingSearchWindow.this.searchText();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else {
                        SwingSearchWindow.this.requestInterupt = true;
                        SwingSearchWindow.this.isSearch = false;
                        SwingSearchWindow.this.searchButton.setText(Messages.getMessage("PdfViewerSearch.Button"));
                    }
                    SwingSearchWindow.this.currentGUI.getPdfDecoder().requestFocusInWindow();
                }
            };
            this.searchButton.addActionListener(this.AL);
            this.searchText.selectAll();
            this.deleteOnClick = true;
            this.KL = new KeyListener(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                    char c;
                    int n;
                    if (SwingSearchWindow.this.searchText.getText().length() == 0) {
                        SwingSearchWindow.this.currentGUI.nextSearch.setVisible(false);
                        SwingSearchWindow.this.currentGUI.previousSearch.setVisible(false);
                    }
                    if (SwingSearchWindow.this.deleteOnClick) {
                        SwingSearchWindow.this.deleteOnClick = false;
                        SwingSearchWindow.this.searchText.setText("");
                    }
                    if ((n = keyEvent.getID()) == 400 && (c = keyEvent.getKeyChar()) == '\n') {
                        if (!SwingSearchWindow.this.decode_pdf.isOpen()) {
                            SwingSearchWindow.this.currentGUI.showMessageDialog("File must be open before you can search.");
                        } else {
                            try {
                                SwingSearchWindow.this.currentGUI.nextSearch.setVisible(true);
                                SwingSearchWindow.this.currentGUI.previousSearch.setVisible(true);
                                SwingSearchWindow.this.currentGUI.nextSearch.setEnabled(false);
                                SwingSearchWindow.this.currentGUI.previousSearch.setEnabled(false);
                                SwingSearchWindow.this.isSearch = false;
                                SwingSearchWindow.this.searchTypeParameters = 0;
                                if (SwingSearchWindow.this.wholeWordsOnlyBox.isSelected()) {
                                    SwingSearchWindow.this.searchTypeParameters |= 1;
                                }
                                if (SwingSearchWindow.this.caseSensitiveBox.isSelected()) {
                                    SwingSearchWindow.this.searchTypeParameters |= 2;
                                }
                                if (SwingSearchWindow.this.multiLineBox.isSelected()) {
                                    SwingSearchWindow.this.searchTypeParameters |= 8;
                                }
                                if (SwingSearchWindow.this.highlightAll.isSelected()) {
                                    SwingSearchWindow.this.searchTypeParameters |= 0x10;
                                }
                                if (SwingSearchWindow.this.useRegEx.isSelected()) {
                                    SwingSearchWindow.this.searchTypeParameters |= 0x20;
                                }
                                String string = SwingSearchWindow.this.searchText.getText().trim();
                                if (SwingSearchWindow.this.searchType.getSelectedIndex() == 0) {
                                    SwingSearchWindow.this.searchTerms = new String[]{string};
                                } else {
                                    SwingSearchWindow.this.searchTerms = string.split(" ");
                                    for (int i = 0; i < SwingSearchWindow.this.searchTerms.length; ++i) {
                                        SwingSearchWindow.this.searchTerms[i] = SwingSearchWindow.this.searchTerms[i].trim();
                                    }
                                }
                                SwingSearchWindow.this.singlePageSearch = !SwingSearchWindow.this.searchAll.isSelected();
                                SwingSearchWindow.this.searchText();
                                SwingSearchWindow.this.currentGUI.getPdfDecoder().requestFocusInWindow();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                }
            };
            this.searchText.addKeyListener(this.KL);
            if (this.style == SEARCH_EXTERNAL_WINDOW || this.style == SEARCH_TABBED_PANE) {
                JScrollPane jScrollPane = new JScrollPane();
                jScrollPane.getViewport().add(this.resultsList);
                jScrollPane.setVerticalScrollBarPolicy(20);
                jScrollPane.setHorizontalScrollBarPolicy(30);
                jScrollPane.getVerticalScrollBar().setUnitIncrement(80);
                jScrollPane.getHorizontalScrollBar().setUnitIncrement(80);
                this.getContentPane().setLayout(new BorderLayout());
                this.getContentPane().add((Component)jScrollPane, "Center");
                this.getContentPane().add((Component)this.nav, "North");
                this.getContentPane().add((Component)this.advancedPanel, "South");
                Container container = this.currentGUI.getFrame();
                if (this.commonValues.getModeOfOperation() == 1 && this.currentGUI.getFrame() instanceof JFrame) {
                    container = ((JFrame)this.currentGUI.getFrame()).getContentPane();
                }
                if (this.style == SEARCH_EXTERNAL_WINDOW) {
                    int n = 230;
                    int n2 = container.getHeight();
                    int n3 = container.getLocationOnScreen().x;
                    int n4 = container.getWidth() + n3;
                    int n5 = container.getLocationOnScreen().y;
                    Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                    int n6 = dimension.width;
                    if (n4 + n > n6 && this.style == SEARCH_EXTERNAL_WINDOW) {
                        n4 = n6 - n;
                        container.setSize(n4 - n3, container.getHeight());
                    }
                    this.setSize(n, n2);
                    this.setLocation(n4, n5);
                }
                this.searchAll.setFocusable(false);
                this.searchText.grabFocus();
            } else {
                this.currentGUI.setSearchText(this.searchText);
            }
        }
    }

    @Override
    public void findWithoutWindow(PdfDecoder pdfDecoder, Values values, int n, boolean bl, boolean bl2, String string) {
        if (!this.isSearch) {
            this.backGroundSearch = true;
            this.isSearch = true;
            this.decode_pdf = pdfDecoder;
            this.commonValues = values;
            this.decode_pdf.setLayout(new BorderLayout());
            this.decode_pdf.add((Component)this.progress, "South");
            this.progress.setValue(0);
            this.progress.setMaximum(this.commonValues.getPageCount());
            this.progress.setVisible(true);
            this.decode_pdf.validate();
            String string2 = string;
            if (!bl) {
                this.searchTerms = new String[]{string2};
            } else {
                this.searchTerms = string2.split(" ");
                for (int i = 0; i < this.searchTerms.length; ++i) {
                    this.searchTerms[i] = this.searchTerms[i].trim();
                }
            }
            this.searchTypeParameters = n;
            this.singlePageSearch = bl2;
            this.find(pdfDecoder, values);
        } else {
            this.currentGUI.showMessageDialog("Please wait for search to finish before starting another.");
        }
    }

    @Override
    public void find(PdfDecoder pdfDecoder, Values values) {
        if (!this.backGroundSearch) {
            this.init(pdfDecoder, values);
            if (this.style == SEARCH_EXTERNAL_WINDOW) {
                this.setVisible(true);
            }
        } else {
            try {
                this.searchText();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void removeSearchWindow(boolean bl) {
        this.setVisible(false);
        this.setVisible(false);
        if (this.searcher != null) {
            this.searcher.interrupt();
        }
        if (this.isSetup && !bl) {
            if (this.listModel != null) {
                this.listModel.clear();
            }
            this.itemFoundCount = 0;
            this.isSearch = false;
        }
        if (this.decode_pdf != null) {
            this.decode_pdf.getTextLines().clearHighlights();
            this.decode_pdf.repaint();
        }
    }

    private void searchText() throws Exception {
        if (this.searcher != null) {
            this.searcher.interrupt();
        }
        this.usingMenuBarSearch = this.style == SEARCH_MENU_BAR;
        this.lastPage = -1;
        if (this.listModel == null) {
            this.listModel = new DefaultListModel();
        }
        if (this.resultsList == null) {
            this.resultsList = new SearchList(this.listModel, this.textPages, this.textRectangles);
        }
        this.resultsList.setStatus(4);
        if (!this.backGroundSearch) {
            this.searchButton.setText(Messages.getMessage("PdfViewerSearchButton.Stop"));
            this.searchButton.invalidate();
            this.searchButton.repaint();
            this.searchCount.setText(Messages.getMessage("PdfViewerSearch.Scanning1"));
            this.searchCount.repaint();
        }
        this.searcher = new SwingWorker(){

            @Override
            public Object construct() {
                int n;
                SwingSearchWindow.this.isSearch = true;
                SwingSearchWindow.this.hasSearched = true;
                try {
                    SwingSearchWindow.this.listModel.removeAllElements();
                    if (!SwingSearchWindow.this.backGroundSearch) {
                        SwingSearchWindow.this.resultsList.repaint();
                    }
                    boolean bl = false;
                    SwingSearchWindow.this.textPages.clear();
                    SwingSearchWindow.this.textRectangles.clear();
                    SwingSearchWindow.this.itemFoundCount = 0;
                    SwingSearchWindow.this.decode_pdf.getTextLines().clearHighlights();
                    PdfPageData pdfPageData = SwingSearchWindow.this.decode_pdf.getPdfPageData();
                    if (SwingSearchWindow.this.singlePageSearch || SwingSearchWindow.this.usingMenuBarSearch) {
                        if (SwingSearchWindow.this.singlePageSearch) {
                            SwingSearchWindow.this.searchPageRange(pdfPageData, SwingSearchWindow.this.commonValues.getCurrentPage(), SwingSearchWindow.this.commonValues.getCurrentPage() + 1);
                        } else {
                            for (int i = 0; i != SwingSearchWindow.this.commonValues.getPageCount() + 1 && SwingSearchWindow.this.resultsList.getResultCount() < 1; ++i) {
                                n = SwingSearchWindow.this.commonValues.getCurrentPage() + i;
                                if (n > SwingSearchWindow.this.commonValues.getPageCount()) {
                                    n -= SwingSearchWindow.this.commonValues.getPageCount();
                                }
                                SwingSearchWindow.this.searchPageRange(pdfPageData, n, n + 1);
                            }
                        }
                    } else if (!SwingSearchWindow.this.backGroundSearch || !SwingSearchWindow.this.usingMenuBarSearch) {
                        SwingSearchWindow.this.searchPageRange(pdfPageData, 1, SwingSearchWindow.this.commonValues.getPageCount() + 1);
                    }
                    if (!SwingSearchWindow.this.backGroundSearch) {
                        SwingSearchWindow.this.searchCount.setText(Messages.getMessage("PdfViewerSearch.ItemsFound") + ' ' + SwingSearchWindow.this.itemFoundCount + "  " + Messages.getMessage("PdfViewerSearch.Done"));
                        SwingSearchWindow.this.searchButton.setText(Messages.getMessage("PdfViewerSearch.Button"));
                    }
                    SwingSearchWindow.this.resultsList.invalidate();
                    SwingSearchWindow.this.resultsList.repaint();
                    SwingSearchWindow.this.resultsList.setSelectedIndex(0);
                    SwingSearchWindow.this.resultsList.setLength(SwingSearchWindow.this.listModel.capacity());
                    SwingSearchWindow.this.currentGUI.setResults(SwingSearchWindow.this.resultsList);
                    SwingSearchWindow.this.currentGUI.nextSearch.setEnabled(true);
                    SwingSearchWindow.this.currentGUI.previousSearch.setEnabled(true);
                    SwingSearchWindow.this.isSearch = false;
                    SwingSearchWindow.this.requestInterupt = false;
                }
                catch (InterruptedException interruptedException) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SwingSearchWindow.this.requestInterupt = false;
                            SwingSearchWindow.this.backGroundSearch = false;
                            SwingSearchWindow.this.currentGUI.showMessageDialog("Search stopped by user.");
                            if (!SwingSearchWindow.this.backGroundSearch) {
                                SwingSearchWindow.this.currentGUI.nextSearch.setEnabled(true);
                                SwingSearchWindow.this.currentGUI.previousSearch.setEnabled(true);
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SwingSearchWindow.this.requestInterupt = false;
                            SwingSearchWindow.this.backGroundSearch = false;
                            if (SimpleViewer.showMessages) {
                                SwingSearchWindow.this.currentGUI.showMessageDialog("An error occured during search. Some results may be missing.\n\nPlease send the file to IDRSolutions for investigation.");
                            }
                            if (!SwingSearchWindow.this.backGroundSearch) {
                                SwingSearchWindow.this.currentGUI.nextSearch.setEnabled(true);
                                SwingSearchWindow.this.currentGUI.previousSearch.setEnabled(true);
                            }
                        }
                    });
                }
                SwingSearchWindow swingSearchWindow = SwingSearchWindow.this;
                if (!swingSearchWindow.commonValues.isProcessing()) {
                    Integer n2;
                    Object v;
                    float f = SwingSearchWindow.this.currentGUI.getScaling();
                    SwingSearchWindow.this.resultsList.setSelectedIndex(0);
                    int n3 = SwingSearchWindow.this.resultsList.getSelectedIndex();
                    SwingSearchWindow.this.decode_pdf.getTextLines().clearHighlights();
                    if (n3 == -1 && SwingSearchWindow.this.resultsList.getResultCount() > 0) {
                        n3 = 0;
                    }
                    if (n3 != -1 && (v = SwingSearchWindow.this.textPages.get(n2 = new Integer(n3))) != null) {
                        int n4 = (Integer)v;
                        if (SwingSearchWindow.this.commonValues.getCurrentPage() != n4) {
                            SwingSearchWindow.this.commonValues.setCurrentPage(n4);
                            SwingSearchWindow.this.currentGUI.resetStatusMessage(Messages.getMessage("PdfViewer.LoadingPage") + ' ' + SwingSearchWindow.this.commonValues.getCurrentPage());
                            SwingSearchWindow.this.decode_pdf.setPageParameters(f, SwingSearchWindow.this.commonValues.getCurrentPage());
                            SwingSearchWindow.this.currentGUI.decodePage(false);
                            SwingSearchWindow.this.decode_pdf.invalidate();
                        }
                        while (true) {
                            SwingSearchWindow swingSearchWindow2 = SwingSearchWindow.this;
                            if (!swingSearchWindow2.commonValues.isProcessing()) break;
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                        }
                        SwingSearchWindow.this.firstPageWithResults = SwingSearchWindow.this.commonValues.getCurrentPage();
                        if ((SwingSearchWindow.this.searchTypeParameters & 0x10) == 16) {
                            Rectangle[] rectangleArray;
                            Vector_Rectangle vector_Rectangle = new Vector_Rectangle();
                            n = -1;
                            int n5 = 0;
                            for (int i = 0; i != SwingSearchWindow.this.textPages.size(); ++i) {
                                Object v2;
                                Object v3 = SwingSearchWindow.this.textPages.get(new Integer(i));
                                if (v3 == null) continue;
                                n5 = (Integer)v3;
                                if (n5 != n && n != -1) {
                                    vector_Rectangle.trim();
                                    rectangleArray = vector_Rectangle.get();
                                    SwingSearchWindow.this.decode_pdf.getTextLines().addHighlights(rectangleArray, true, n);
                                    n = n5;
                                    vector_Rectangle = new Vector_Rectangle();
                                }
                                if ((v2 = SwingSearchWindow.this.textRectangles.get(new Integer(i))) instanceof Rectangle) {
                                    vector_Rectangle.addElement((Rectangle)v2);
                                }
                                if (!(v2 instanceof Rectangle[])) continue;
                                Rectangle[] rectangleArray2 = (Rectangle[])v2;
                                for (int j = 0; j != rectangleArray2.length; ++j) {
                                    vector_Rectangle.addElement(rectangleArray2[j]);
                                }
                            }
                            vector_Rectangle.trim();
                            rectangleArray = vector_Rectangle.get();
                            SwingSearchWindow.this.decode_pdf.getTextLines().addHighlights(rectangleArray, true, n5);
                        } else {
                            Object v4 = SwingSearchWindow.this.textRectangles.get(n2);
                            if (v4 instanceof Rectangle) {
                                SwingSearchWindow.this.currentGUI.currentCommands.scrollRectToHighlight((Rectangle)v4, SwingSearchWindow.this.commonValues.getCurrentPage());
                                SwingSearchWindow.this.decode_pdf.getTextLines().addHighlights(new Rectangle[]{(Rectangle)v4}, true, SwingSearchWindow.this.commonValues.getCurrentPage());
                            }
                            if (v4 instanceof Rectangle[]) {
                                SwingSearchWindow.this.currentGUI.currentCommands.scrollRectToHighlight(((Rectangle[])v4)[0], SwingSearchWindow.this.commonValues.getCurrentPage());
                                SwingSearchWindow.this.decode_pdf.getTextLines().addHighlights((Rectangle[])v4, true, SwingSearchWindow.this.commonValues.getCurrentPage());
                            }
                        }
                        SwingSearchWindow.this.decode_pdf.invalidate();
                        SwingSearchWindow.this.decode_pdf.repaint();
                    }
                }
                if (SwingSearchWindow.this.commonValues.getCurrentPage() == 1) {
                    SwingSearchWindow.this.currentGUI.setBackNavigationButtonsEnabled(false);
                } else {
                    SwingSearchWindow.this.currentGUI.setBackNavigationButtonsEnabled(true);
                }
                if (SwingSearchWindow.this.commonValues.getCurrentPage() == SwingSearchWindow.this.decode_pdf.getPageCount()) {
                    SwingSearchWindow.this.currentGUI.setForwardNavigationButtonsEnabled(false);
                } else {
                    SwingSearchWindow.this.currentGUI.setForwardNavigationButtonsEnabled(true);
                }
                SwingSearchWindow.this.decode_pdf.remove(SwingSearchWindow.this.progress);
                SwingSearchWindow.this.decode_pdf.validate();
                SwingSearchWindow.this.backGroundSearch = false;
                SwingSearchWindow.this.resultsList.setStatus(2);
                return null;
            }
        };
        this.searcher.start();
    }

    @Override
    public int getFirstPageWithResults() {
        return this.firstPageWithResults;
    }

    private void searchPageRange(PdfPageData pdfPageData, int n, int n2) throws Exception {
        int n3 = 0;
        for (int i = n; i < n2 && !this.requestInterupt; ++i) {
            if (Thread.interrupted()) continue;
            this.progress.setValue(this.progress.getValue() + 1);
            this.decode_pdf.repaint();
            try {
                PdfGroupingAlgorithms pdfGroupingAlgorithms;
                if (i == this.commonValues.getCurrentPage()) {
                    pdfGroupingAlgorithms = this.decode_pdf.getGroupingObject();
                } else {
                    this.decode_pdf.decodePageInBackground(i);
                    pdfGroupingAlgorithms = this.decode_pdf.getBackgroundGroupingObject();
                }
                pdfGroupingAlgorithms.generateTeasers();
                pdfGroupingAlgorithms.setIncludeHTML(true);
                int n4 = pdfPageData.getCropBoxX(i);
                int n5 = pdfPageData.getCropBoxWidth(i);
                int n6 = pdfPageData.getCropBoxY(i);
                int n7 = pdfPageData.getCropBoxHeight(i);
                DefaultSearchListener defaultSearchListener = new DefaultSearchListener();
                SortedMap sortedMap = pdfGroupingAlgorithms.findMultipleTermsInRectangleWithMatchingTeasers(n4, n6, n5, n7, pdfPageData.getRotation(i), i, this.searchTerms, this.searchTypeParameters, defaultSearchListener);
                if (Thread.interrupted()) continue;
                if (!sortedMap.isEmpty()) {
                    if (!this.backGroundSearch) {
                        this.currentGUI.nextSearch.setEnabled(true);
                        this.currentGUI.previousSearch.setEnabled(true);
                    }
                    this.itemFoundCount += sortedMap.size();
                    for (Map.Entry entry : sortedMap.entrySet()) {
                        Object object;
                        Object k = entry.getKey();
                        final String string = (String)entry.getValue();
                        if (!SwingUtilities.isEventDispatchThread()) {
                            object = new Runnable(){

                                @Override
                                public void run() {
                                    if (string.indexOf("<b>") == -1) {
                                        SwingSearchWindow.this.listModel.addElement(string);
                                    } else {
                                        SwingSearchWindow.this.listModel.addElement("<html>" + string + "</html>");
                                    }
                                }
                            };
                            SwingUtilities.invokeLater((Runnable)object);
                        } else if (string.indexOf("<b>") == -1) {
                            this.listModel.addElement(string);
                        } else {
                            this.listModel.addElement("<html>" + string + "</html>");
                        }
                        object = new Integer(n3);
                        ++n3;
                        this.textRectangles.put(object, k);
                        this.textPages.put(object, new Integer(i));
                    }
                }
                if (!this.backGroundSearch && !sortedMap.isEmpty() | i % 16 == 0) {
                    this.searchCount.setText(Messages.getMessage("PdfViewerSearch.ItemsFound") + ' ' + this.itemFoundCount + ' ' + Messages.getMessage("PdfViewerSearch.Scanning") + i);
                    this.searchCount.invalidate();
                    this.searchCount.repaint();
                }
            }
            catch (PdfException pdfException) {
                this.backGroundSearch = false;
                this.requestInterupt = false;
            }
            if (this.requestInterupt) {
                this.currentGUI.showMessageDialog("Search stopped by user.");
            }
            this.lastPage = i;
        }
    }

    public int getListLength() {
        return this.listModel.capacity();
    }

    @Override
    public void grabFocusInInput() {
        this.searchText.grabFocus();
    }

    @Override
    public boolean isSearchVisible() {
        return this.isVisible();
    }

    @Override
    public void setStyle(int n) {
        this.style = n;
    }

    @Override
    public int getStyle() {
        return this.style;
    }

    public JTextField getSearchText() {
        return this.searchText;
    }

    public void setSearchText(String string) {
        this.deleteOnClick = false;
        this.searchText.setText(string);
    }

    @Override
    public Map getTextRectangles() {
        return this.textRectangles;
    }

    @Override
    public SearchList getResults() {
        return this.resultsList;
    }

    @Override
    public SearchList getResults(int n) {
        if (this.usingMenuBarSearch && n != this.lastPage && this.style == SEARCH_MENU_BAR) {
            this.listModel = new DefaultListModel();
            this.textPages.clear();
            this.textRectangles.clear();
            this.resultsList = new SearchList(this.listModel, this.textPages, this.textRectangles);
            this.resultsList.setStatus(4);
            try {
                this.searchPageRange(this.decode_pdf.getPdfPageData(), n, n + 1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.lastPage = n;
        }
        return this.resultsList;
    }

    @Override
    public void resetSearchWindow() {
        if (this.isSetup) {
            this.searchText.setText(this.defaultMessage);
            this.deleteOnClick = true;
            if (this.hasSearched) {
                this.currentGUI.nextSearch.setVisible(false);
                this.currentGUI.previousSearch.setVisible(false);
                this.hasSearched = false;
            }
            this.currentGUI.getPdfDecoder().requestFocusInWindow();
        }
    }
}

