/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.utils;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import javax.swing.ProgressMonitor;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.gui.SwingGUI;
import org.jpedal.examples.simpleviewer.gui.popups.SaveImage;
import org.jpedal.examples.simpleviewer.gui.popups.SaveText;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfSecurityException;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.gui.GUIFactory;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.JAIHelper;
import org.jpedal.objects.PdfImageData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.Strip;
import org.jpedal.utils.SwingWorker;

public class Exporter {
    public static final int RECTANGLE = 1;
    public static final int WORDLIST = 2;
    public static final int TABLE = 3;
    private final String separator = System.getProperty("file.separator");
    private String fileName = "";
    private GUIFactory currentGUI;
    private PdfDecoder dPDF;
    private String selectedFile;

    public Exporter(SwingGUI swingGUI, String string, PdfDecoder pdfDecoder) {
        int n;
        String string2 = new File(string).getName();
        if (string2.lastIndexOf(46) != -1) {
            string2 = string2.substring(0, string2.lastIndexOf(46));
        }
        StringBuffer stringBuffer = new StringBuffer(string2);
        while ((n = stringBuffer.toString().indexOf("%20")) != -1) {
            stringBuffer.replace(n, n + 3, " ");
        }
        this.fileName = stringBuffer.toString();
        this.currentGUI = swingGUI;
        this.selectedFile = string;
        this.dPDF = pdfDecoder;
    }

    private static void saveImage(BufferedImage bufferedImage, String string, String string2) {
        if (JAIHelper.isJAIused()) {
            JAIHelper.confirmJAIOnClasspath();
        }
        if (string2.indexOf("tif") != -1 && JAIHelper.isJAIused()) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                JAI.create((String)"encode", (RenderedImage)bufferedImage, (Object)fileOutputStream, (Object)"TIFF", null);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        } else {
            try {
                ImageIO.write((RenderedImage)bufferedImage, string2, new File(string));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void decodeHires(int n, int n2, String string, String string2) {
        PdfDecoder pdfDecoder = null;
        String string3 = "";
        try {
            pdfDecoder = new PdfDecoder(false);
            pdfDecoder.setExtractionMode(36, 72, 1.0f);
            pdfDecoder.openPdfFile(this.selectedFile);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (pdfDecoder.isEncrypted() && !pdfDecoder.isPasswordSupplied() && !pdfDecoder.isExtractionAllowed()) {
            return;
        }
        ProgressMonitor progressMonitor = new ProgressMonitor(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerMessage.ExtractImages"), "", n, n2);
        try {
            int n3 = 0;
            boolean bl = false;
            for (int i = n; i < n2 + 1; ++i) {
                File file;
                if (progressMonitor.isCanceled()) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerError.UserStoppedExport") + n3 + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfImagesExported"));
                    return;
                }
                pdfDecoder.decodePage(i);
                PdfImageData pdfImageData = pdfDecoder.getPdfImageData();
                int n4 = pdfImageData.getImageCount();
                if (n4 > 0 && !(file = new File(string3 = string2 + i + this.separator)).exists()) {
                    file.mkdir();
                }
                for (int j = 0; j < n4; ++j) {
                    String string4 = pdfImageData.getImageName(j);
                    float f = pdfImageData.getImageXCoord(j);
                    float f2 = pdfImageData.getImageYCoord(j);
                    float f3 = pdfImageData.getImageWidth(j);
                    float f4 = pdfImageData.getImageHeight(j);
                    try {
                        Object object;
                        BufferedImage bufferedImage = pdfDecoder.getObjectStore().loadStoredImage("CLIP_" + string4);
                        if (bufferedImage != null) {
                            int n5;
                            if (string.toLowerCase().startsWith("jp")) {
                                bufferedImage = ColorSpaceConvertor.convertToRGB(bufferedImage);
                            }
                            if (((File)(object = new File(string3 + string4 + '.' + string))).exists() && !bl && (n5 = this.currentGUI.showOverwriteDialog(((File)object).getAbsolutePath(), true)) != 0) {
                                if (n5 == 1) {
                                    bl = true;
                                } else {
                                    if (n5 == 2) {
                                        progressMonitor.setProgress(i);
                                        continue;
                                    }
                                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerError.UserStoppedExport") + n3 + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfImagesExported"));
                                    progressMonitor.close();
                                    return;
                                }
                            }
                            Exporter.saveImage(bufferedImage, string3 + string4 + '.' + string, string);
                            ++n3;
                        }
                        object = new OutputStreamWriter((OutputStream)new FileOutputStream(string3 + string4 + ".xml"), "UTF-8");
                        ((Writer)object).write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                        ((Writer)object).write("<!-- Pixel Location of image x1,y1,x2,y2\n");
                        ((Writer)object).write("(x1,y1 is top left corner)\n");
                        ((Writer)object).write("(origin is bottom left corner)  -->\n");
                        ((Writer)object).write("\n\n<META>\n");
                        ((Writer)object).write("<PAGELOCATION x1=\"" + f + "\" " + "y1=\"" + (f2 + f4) + "\" " + "x2=\"" + (f + f3) + "\" " + "y2=\"" + f2 + "\" />\n");
                        ((Writer)object).write("<FILE>" + this.fileName + "</FILE>\n");
                        ((Writer)object).write("</META>\n");
                        ((OutputStreamWriter)object).close();
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        LogWriter.writeLog("Exception " + exception + " in extracting images");
                    }
                }
                pdfDecoder.flushObjectValues(true);
                progressMonitor.setProgress(i + 1);
            }
            progressMonitor.close();
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.ImagesSavedTo") + ' ' + string2);
        }
        catch (Exception exception) {
            pdfDecoder.closePdfFile();
            LogWriter.writeLog("Exception " + exception.getMessage());
        }
        pdfDecoder.closePdfFile();
    }

    public void extractImagesOnPages(SaveImage saveImage) {
        final int n = saveImage.getStartPage();
        final int n2 = saveImage.getEndPage();
        if (n < 1 || n2 < 1) {
            return;
        }
        final int n3 = saveImage.getImageType();
        final String string = saveImage.getPrefix();
        final String string2 = saveImage.getRootDir() + this.separator + this.fileName + this.separator + "images" + this.separator;
        File file = new File(string2);
        if (!file.exists()) {
            file.mkdirs();
        }
        SwingWorker swingWorker = new SwingWorker(){

            @Override
            public Object construct() {
                switch (n3) {
                    case 32: {
                        Exporter.this.decodeHires(n, n2, string, string2);
                        break;
                    }
                    case 2: {
                        Exporter.this.decodeImages(n, n2, string, string2, false);
                        break;
                    }
                    case 4: {
                        Exporter.this.decodeImages(n, n2, string, string2, true);
                        break;
                    }
                    default: {
                        System.out.println("Unknown setting");
                    }
                }
                return null;
            }
        };
        swingWorker.start();
    }

    private void decodeImages(int n, int n2, String string, String string2, boolean bl) {
        PdfDecoder pdfDecoder = null;
        try {
            pdfDecoder = new PdfDecoder(false);
            pdfDecoder.setExtractionMode(6, 72, 1.0f);
            pdfDecoder.openPdfFile(this.selectedFile);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (pdfDecoder.isEncrypted() && !pdfDecoder.isPasswordSupplied() && !pdfDecoder.isExtractionAllowed()) {
            return;
        }
        ProgressMonitor progressMonitor = new ProgressMonitor(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerMessage.ExtractImages"), "", n, n2);
        try {
            int n3 = 0;
            boolean bl2 = false;
            for (int i = n; i < n2 + 1; ++i) {
                if (progressMonitor.isCanceled()) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerError.UserStoppedExport") + n3 + Messages.getMessage("PdfViewerError.ReportNumberOfImagesExported"));
                    return;
                }
                pdfDecoder.decodePage(i);
                PdfImageData pdfImageData = pdfDecoder.getPdfImageData();
                int n4 = pdfImageData.getImageCount();
                String string3 = string2 + this.separator;
                string3 = bl ? string3 + "downsampled" + this.separator + i + this.separator : string3 + "normal" + this.separator + i + this.separator;
                if (n4 > 0) {
                    File file = new File(string3);
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    if (!(file = new File(string3)).exists()) {
                        file.mkdirs();
                    }
                }
                for (int j = 0; j < n4; ++j) {
                    String string4 = pdfImageData.getImageName(j);
                    try {
                        int n5;
                        File file;
                        BufferedImage bufferedImage;
                        if (bl) {
                            bufferedImage = pdfDecoder.getObjectStore().loadStoredImage(string4);
                            if (string.toLowerCase().startsWith("jp")) {
                                bufferedImage = ColorSpaceConvertor.convertToRGB(bufferedImage);
                            }
                        } else {
                            bufferedImage = pdfDecoder.getObjectStore().loadStoredImage(string4);
                            if (string.toLowerCase().startsWith("jp")) {
                                bufferedImage = ColorSpaceConvertor.convertToRGB(bufferedImage);
                            }
                        }
                        if ((file = new File(string3 + string4 + '.' + string)).exists() && !bl2 && (n5 = this.currentGUI.showOverwriteDialog(file.getAbsolutePath(), true)) != 0) {
                            if (n5 == 1) {
                                bl2 = true;
                            } else {
                                if (n5 == 2) {
                                    progressMonitor.setProgress(i);
                                    continue;
                                }
                                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerError.UserStoppedExport") + n3 + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfImagesExported"));
                                progressMonitor.close();
                                return;
                            }
                        }
                        Exporter.saveImage(bufferedImage, string3 + string4 + '.' + string, string);
                        ++n3;
                        continue;
                    }
                    catch (Exception exception) {
                        System.err.println("Exception " + exception + " in extracting images");
                    }
                }
                pdfDecoder.flushObjectValues(true);
                progressMonitor.setProgress(i + 1);
            }
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.ImagesSavedTo") + ' ' + string2);
            progressMonitor.close();
        }
        catch (Exception exception) {
            pdfDecoder.closePdfFile();
            LogWriter.writeLog("Exception " + exception.getMessage());
        }
        pdfDecoder.closePdfFile();
    }

    public void extractTextOnPages(SaveText saveText) {
        final int n = saveText.getStartPage();
        final int n2 = saveText.getEndPage();
        if (n < 1 || n2 < 1) {
            return;
        }
        final int n3 = saveText.getTextType();
        final boolean bl = saveText.isXMLExtaction();
        final String string = saveText.getRootDir() + this.separator + this.fileName + this.separator + "text" + this.separator;
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        SwingWorker swingWorker = new SwingWorker(){

            @Override
            public Object construct() {
                switch (n3) {
                    case 1: {
                        Exporter.this.decodeTextRectangle(n, n2, string, bl);
                        break;
                    }
                    case 2: {
                        Exporter.this.decodeTextWordlist(n, n2, string, bl);
                        break;
                    }
                    case 3: {
                        Exporter.this.decodeTextTable(n, n2, string, bl);
                        break;
                    }
                    default: {
                        System.out.println("Unknown setting");
                    }
                }
                return null;
            }
        };
        swingWorker.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeTextTable(int n, int n2, String string, boolean bl) {
        PdfDecoder pdfDecoder = null;
        try {
            pdfDecoder = new PdfDecoder(false);
            pdfDecoder.setExtractionMode(1);
            PdfDecoder.init(true);
            pdfDecoder.openPdfFile(this.selectedFile);
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " in pdf code");
        }
        if (pdfDecoder.isEncrypted() && !pdfDecoder.isPasswordSupplied() && !pdfDecoder.isExtractionAllowed()) {
            System.out.println("Encrypted settings");
            System.out.println("Please look at SimpleViewer for code sample to handle such files");
        } else {
            ProgressMonitor progressMonitor = new ProgressMonitor(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerMessage.ExtractText"), "", n, n2);
            try {
                int n3 = 0;
                boolean bl2 = false;
                for (int i = n; i < n2 + 1; ++i) {
                    if (progressMonitor.isCanceled()) {
                        this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerError.UserStoppedExport") + n3 + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfPagesExported"));
                        return;
                    }
                    pdfDecoder.decodePage(i);
                    PdfGroupingAlgorithms pdfGroupingAlgorithms = pdfDecoder.getGroupingObject();
                    PdfPageData pdfPageData = pdfDecoder.getPdfPageData();
                    int n4 = pdfPageData.getMediaBoxX(i);
                    int n5 = pdfPageData.getMediaBoxWidth(i) + n4;
                    int n6 = pdfPageData.getMediaBoxY(i);
                    int n7 = pdfPageData.getMediaBoxHeight(i) + n6;
                    String string2 = "_text.csv";
                    if (bl) {
                        string2 = "_xml.txt";
                    }
                    Map map = null;
                    String string3 = null;
                    try {
                        map = pdfGroupingAlgorithms.extractTextAsTable(n4, n7, n5, n6, i, !bl, false, false, false, 0);
                        string3 = (String)map.get("content");
                    }
                    catch (PdfException pdfException) {
                        pdfDecoder.closePdfFile();
                        System.err.println("Exception " + pdfException.getMessage() + " with table extraction");
                    }
                    catch (Error error) {
                        error.printStackTrace();
                    }
                    if (string3 == null) {
                        System.out.println("No text found");
                    } else {
                        File file;
                        String string4 = string + this.separator + "table" + this.separator;
                        File file2 = new File(string4);
                        if (!file2.exists()) {
                            file2.mkdirs();
                        }
                        if ((file = new File(string4 + this.fileName + '_' + i + string2)).exists() && !bl2) {
                            int n8;
                            if (n2 - n > 1) {
                                n8 = this.currentGUI.showOverwriteDialog(file.getAbsolutePath(), true);
                                if (n8 != 0) {
                                    if (n8 == 1) {
                                        bl2 = true;
                                    } else {
                                        if (n8 != 2) {
                                            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerError.UserStoppedExport") + n3 + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfPagesExported"));
                                            progressMonitor.close();
                                            return;
                                        }
                                        progressMonitor.setProgress(i);
                                        continue;
                                    }
                                }
                            } else {
                                n8 = this.currentGUI.showOverwriteDialog(file.getAbsolutePath(), false);
                                if (n8 != 0) {
                                    return;
                                }
                            }
                        }
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string4 + this.fileName + '_' + i + string2), "UTF-8");
                        if (bl) {
                            outputStreamWriter.write("<xml><BODY>\n\n");
                        }
                        outputStreamWriter.write(string3);
                        if (bl) {
                            outputStreamWriter.write("\n</body></xml>");
                        }
                        outputStreamWriter.close();
                    }
                    ++n3;
                    progressMonitor.setProgress(i + 1);
                    pdfDecoder.flushObjectValues(false);
                }
                progressMonitor.close();
                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.TextSavedTo") + ' ' + string);
            }
            catch (Exception exception) {
                pdfDecoder.closePdfFile();
                System.err.println("Exception " + exception.getMessage());
                exception.printStackTrace();
            }
            catch (Error error) {
                System.out.println("h34343");
                error.printStackTrace();
            }
            pdfDecoder.flushObjectValues(true);
        }
        pdfDecoder.closePdfFile();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeTextWordlist(int n, int n2, String string, boolean bl) {
        PdfDecoder pdfDecoder = null;
        try {
            pdfDecoder = new PdfDecoder(false);
            pdfDecoder.setExtractionMode(1);
            PdfDecoder.init(true);
            PdfGroupingAlgorithms.useUnrotatedCoords = false;
            pdfDecoder.openPdfFile(this.selectedFile);
        }
        catch (PdfSecurityException pdfSecurityException) {
            System.err.println("Exception " + pdfSecurityException + " in pdf code for wordlist" + this.selectedFile);
        }
        catch (PdfException pdfException) {
            System.err.println("Exception " + pdfException + " in pdf code for wordlist" + this.selectedFile);
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " in pdf code for wordlist" + this.selectedFile);
            exception.printStackTrace();
        }
        if (pdfDecoder.isEncrypted() && !pdfDecoder.isPasswordSupplied() && !pdfDecoder.isExtractionAllowed()) {
            System.out.println("Encrypted settings");
            System.out.println("Please look at SimpleViewer for code sample to handle such files");
        } else {
            int n3 = n;
            int n4 = n2;
            int n5 = 0;
            ProgressMonitor progressMonitor = new ProgressMonitor(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerMessage.ExtractText"), "", n, n2);
            try {
                int n6 = 0;
                boolean bl2 = false;
                for (int i = n3; i < n4 + 1; ++i) {
                    if (progressMonitor.isCanceled()) {
                        this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerError.UserStoppedExport") + n6 + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfPagesExported"));
                        return;
                    }
                    pdfDecoder.decodePage(i);
                    PdfGroupingAlgorithms pdfGroupingAlgorithms = pdfDecoder.getGroupingObject();
                    PdfPageData pdfPageData = pdfDecoder.getPdfPageData();
                    int n7 = pdfPageData.getMediaBoxX(i);
                    int n8 = pdfPageData.getMediaBoxWidth(i) + n7;
                    int n9 = pdfPageData.getMediaBoxX(i);
                    int n10 = pdfPageData.getMediaBoxHeight(i) - n9;
                    Vector vector = null;
                    try {
                        vector = pdfGroupingAlgorithms.extractTextAsWordlist(n7, n10, n8, n9, i, true, "&:=()!;.,\\/\"\"''");
                    }
                    catch (PdfException pdfException) {
                        pdfDecoder.closePdfFile();
                        System.err.println("Exception= " + pdfException + " in " + this.selectedFile);
                        pdfException.printStackTrace();
                    }
                    catch (Error error) {
                        error.printStackTrace();
                    }
                    if (vector == null) {
                        System.out.println("No text found");
                    } else {
                        String string2 = string + this.separator + "wordlist" + this.separator;
                        File file = new File(string2);
                        if (!file.exists()) {
                            file.mkdirs();
                        }
                        String string3 = "_text.txt";
                        String string4 = System.getProperty("file.encoding");
                        if (bl) {
                            string3 = "_xml.txt";
                            string4 = "UTF-8";
                        }
                        int n11 = vector.size() / 5;
                        n5 += n11;
                        File file2 = new File(string2 + this.fileName + '_' + i + string3);
                        if (file2.exists() && !bl2) {
                            int n12;
                            if (n2 - n > 1) {
                                n12 = this.currentGUI.showOverwriteDialog(file2.getAbsolutePath(), true);
                                if (n12 != 0) {
                                    if (n12 == 1) {
                                        bl2 = true;
                                    } else {
                                        if (n12 != 2) {
                                            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerError.UserStoppedExport") + n6 + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfPagesExported"));
                                            progressMonitor.close();
                                            return;
                                        }
                                        progressMonitor.setProgress(i);
                                        continue;
                                    }
                                }
                            } else {
                                n12 = this.currentGUI.showOverwriteDialog(file2.getAbsolutePath(), false);
                                if (n12 != 0) {
                                    return;
                                }
                            }
                        }
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string2 + this.fileName + '_' + i + string3), string4);
                        Iterator iterator = vector.iterator();
                        while (iterator.hasNext()) {
                            String string5 = (String)iterator.next();
                            if (!bl) {
                                string5 = Strip.convertToText(string5, true);
                            }
                            int n13 = (int)Float.parseFloat((String)iterator.next());
                            int n14 = (int)Float.parseFloat((String)iterator.next());
                            int n15 = (int)Float.parseFloat((String)iterator.next());
                            int n16 = (int)Float.parseFloat((String)iterator.next());
                            outputStreamWriter.write(string5 + ',' + n13 + ',' + n14 + ',' + n15 + ',' + n16 + '\n');
                        }
                        outputStreamWriter.close();
                    }
                    ++n6;
                    progressMonitor.setProgress(i + 1);
                    pdfDecoder.flushObjectValues(false);
                }
                progressMonitor.close();
                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.TextSavedTo") + ' ' + string);
            }
            catch (Exception exception) {
                pdfDecoder.closePdfFile();
                System.err.println("Exception " + exception + " in " + this.selectedFile);
                exception.printStackTrace();
            }
            catch (Error error) {
                error.printStackTrace();
            }
        }
        pdfDecoder.closePdfFile();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeTextRectangle(int n, int n2, String string, boolean bl) {
        PdfDecoder pdfDecoder = null;
        try {
            pdfDecoder = new PdfDecoder(false);
            if (!bl) {
                pdfDecoder.useTextExtraction();
            }
            pdfDecoder.setExtractionMode(1);
            PdfDecoder.init(true);
            pdfDecoder.openPdfFile(this.selectedFile);
        }
        catch (PdfSecurityException pdfSecurityException) {
            System.err.println("Security Exception " + pdfSecurityException + " in pdf code for text extraction on file ");
        }
        catch (PdfException pdfException) {
            System.err.println("Pdf Exception " + pdfException + " in pdf code for text extraction on file ");
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " in pdf code for text extraction on file ");
            exception.printStackTrace();
        }
        if (pdfDecoder.isEncrypted() && !pdfDecoder.isPasswordSupplied() && !pdfDecoder.isExtractionAllowed()) {
            System.out.println("Encrypted settings");
            System.out.println("Please look at SimpleViewer for code sample to handle such files");
        } else {
            ProgressMonitor progressMonitor = new ProgressMonitor(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerMessage.ExtractText"), "", n, n2);
            try {
                int n3 = 0;
                boolean bl2 = false;
                for (int i = n; i < n2 + 1; ++i) {
                    File file;
                    if (progressMonitor.isCanceled()) {
                        this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerError.UserStoppedExport") + n3 + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfPagesExported"));
                        return;
                    }
                    pdfDecoder.decodePage(i);
                    PdfGroupingAlgorithms pdfGroupingAlgorithms = pdfDecoder.getGroupingObject();
                    PdfPageData pdfPageData = pdfDecoder.getPdfPageData();
                    int n4 = pdfPageData.getMediaBoxX(i);
                    int n5 = pdfPageData.getMediaBoxWidth(i) + n4;
                    int n6 = pdfPageData.getMediaBoxY(i);
                    int n7 = pdfPageData.getMediaBoxHeight(i) + n6;
                    String string2 = null;
                    try {
                        string2 = pdfGroupingAlgorithms.extractTextInRectangle(n4, n7, n5, n6, i, false, true);
                    }
                    catch (PdfException pdfException) {
                        pdfDecoder.closePdfFile();
                        System.err.println("Exception " + pdfException.getMessage() + " in file " + pdfDecoder.getObjectStore().fullFileName);
                        pdfException.printStackTrace();
                    }
                    if (string2 == null) continue;
                    String string3 = string + this.separator + "rectangle" + this.separator;
                    File file2 = new File(string3);
                    if (!file2.exists()) {
                        file2.mkdirs();
                    }
                    String string4 = "_text.txt";
                    String string5 = System.getProperty("file.encoding");
                    if (bl) {
                        string4 = "_xml.txt";
                        string5 = "UTF-8";
                    }
                    if ((file = new File(string3 + this.fileName + '_' + i + string4)).exists() && !bl2) {
                        int n8;
                        if (n2 - n > 1) {
                            n8 = this.currentGUI.showOverwriteDialog(file.getAbsolutePath(), true);
                            if (n8 != 0) {
                                if (n8 == 1) {
                                    bl2 = true;
                                } else {
                                    if (n8 != 2) {
                                        this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerError.UserStoppedExport") + n3 + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfPagesExported"));
                                        progressMonitor.close();
                                        return;
                                    }
                                    progressMonitor.setProgress(i);
                                    continue;
                                }
                            }
                        } else {
                            n8 = this.currentGUI.showOverwriteDialog(file.getAbsolutePath(), false);
                            if (n8 != 0) {
                                return;
                            }
                        }
                    }
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string3 + this.fileName + '_' + i + string4), string5);
                    if (bl) {
                        outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
                        outputStreamWriter.write("<!-- Pixel Location of text x1,y1,x2,y2\n");
                        outputStreamWriter.write("(x1,y1 is top left corner)\n");
                        outputStreamWriter.write("(x1,y1 is bottom right corner)\n");
                        outputStreamWriter.write("(origin is bottom left corner)  -->\n");
                        outputStreamWriter.write("\n\n<ARTICLE>\n");
                        outputStreamWriter.write("<LOCATION x1=\"" + n4 + "\" " + "y1=\"" + n7 + "\" " + "x2=\"" + n5 + "\" " + "y2=\"" + n6 + "\" />\n");
                        outputStreamWriter.write("\n\n<TEXT>\n");
                        outputStreamWriter.write(string2);
                        outputStreamWriter.write("\n\n</TEXT>\n");
                        outputStreamWriter.write("\n\n</ARTICLE>\n");
                    } else {
                        outputStreamWriter.write(string2);
                    }
                    ++n3;
                    outputStreamWriter.close();
                    progressMonitor.setProgress(i + 1);
                    pdfDecoder.flushObjectValues(true);
                }
                progressMonitor.close();
                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.TextSavedTo") + ' ' + string);
            }
            catch (Exception exception) {
                pdfDecoder.closePdfFile();
                System.err.println("Exception " + exception.getMessage());
                exception.printStackTrace();
                System.out.println(pdfDecoder.getObjectStore().getCurrentFilename());
            }
        }
        pdfDecoder.closePdfFile();
    }
}

