/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfFontException;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class FontMappings {
    public static boolean fontsInitialised = false;
    public static String defaultFont = null;
    public static boolean enforceFontSubstitution = false;
    public static Map fontSubstitutionTable = null;
    public static Map fontPropertiesTable = null;
    public static Map fontPossDuplicates = null;
    public static Map fontSubstitutionFontID = null;
    public static Map fontSubstitutionLocation = new Hashtable();
    public static Map fontSubstitutionAliasTable = new Hashtable();
    private static boolean fontsSet = false;
    private static final String separator = System.getProperty("file.separator");
    private static int fontSubstitutionMode = 1;

    private FontMappings() {
    }

    public String toString() {
        return "Static font maps: fontSubstitutionTable, fontSubstitutionFontID, fontSubstitutionLocation, fontSubstitutionAliasTable";
    }

    public static void initFonts() {
        block10: {
            Object object;
            String string;
            block9: {
                try {
                    string = System.getProperty("org.jpedal.fontmaps");
                    if (string != null) {
                        object = new StringTokenizer(string, ",");
                        while (((StringTokenizer)object).hasMoreTokens()) {
                            String string2 = ((StringTokenizer)object).nextToken();
                            StringTokenizer stringTokenizer = new StringTokenizer(string2, "=:");
                            int n = stringTokenizer.countTokens() - 1;
                            String[] stringArray = new String[n];
                            String string3 = stringTokenizer.nextToken();
                            for (int i = 0; i < n; ++i) {
                                stringArray[i] = stringTokenizer.nextToken();
                            }
                            FontMappings.setSubstitutedFontAliases(string3, stringArray);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!LogWriter.isOutput()) break block9;
                    LogWriter.writeLog("Unable to read org.jpedal.fontmaps " + exception.getMessage());
                }
            }
            try {
                string = System.getProperty("org.jpedal.fontdirs");
                object = null;
                if (string != null) {
                    object = FontMappings.addFonts(string, (String)object);
                }
                if (object != null && LogWriter.isOutput()) {
                    LogWriter.writeLog("Could not find " + (String)object);
                }
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block10;
                LogWriter.writeLog("Unable to read FontDirs " + exception.getMessage());
            }
        }
    }

    public static void setFontSubstitutionMode(int n) {
        fontSubstitutionMode = n;
    }

    public static int getFontSubstitutionMode() {
        return fontSubstitutionMode;
    }

    public static void setSubstitutedFontAliases(String string, String[] stringArray) {
        if (stringArray != null) {
            String string2 = string.toLowerCase();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string3 = stringArray[i].toLowerCase();
                if (string3.equals(string2)) continue;
                fontSubstitutionAliasTable.put(string3, string2);
            }
        }
    }

    public static String addFonts(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (!string3.endsWith("/") & !string3.endsWith("\\")) {
                string3 = string3 + separator;
            }
            FontMappings.addTTDir(string3, string2);
        }
        return string2;
    }

    public static void dispose() {
        fontSubstitutionTable = null;
        fontPropertiesTable = null;
        fontPossDuplicates = null;
        fontSubstitutionFontID = null;
        fontSubstitutionLocation = null;
        fontSubstitutionAliasTable = null;
    }

    public static String addTTDir(String string, String string2) {
        File file;
        if (fontSubstitutionTable == null) {
            fontSubstitutionTable = new HashMap();
            fontSubstitutionFontID = new HashMap();
            fontPossDuplicates = new HashMap();
            fontPropertiesTable = new HashMap();
        }
        if ((file = new File(string)).exists() && file.isDirectory()) {
            String[] stringArray = file.list();
            if (stringArray != null) {
                for (String string3 : stringArray) {
                    FontMappings.addFontFile(string3, string);
                }
            }
        } else {
            string2 = string2 == null ? string : string2 + ',' + string;
        }
        return string2;
    }

    public static void setFontReplacements() {
        String[] stringArray = new String[]{"acarialunicodems__cn"};
        FontMappings.setSubstitutedFontAliases("adobeheitistd-regular", stringArray);
        if (PdfDecoder.isRunningOnMac) {
            FontMappings.setSubstitutedFontAliases("Courier italic", new String[]{"Courier-Oblique"});
            FontMappings.setSubstitutedFontAliases("Courier bold", new String[]{"Courier-Bold"});
            FontMappings.setSubstitutedFontAliases("Courier bold italic", new String[]{"Courier-BoldOblique"});
            FontMappings.setSubstitutedFontAliases("Courier new italic", new String[]{"CourierNew,italic", "CourierStd-Oblique"});
            FontMappings.setSubstitutedFontAliases("Courier new bold", new String[]{"CourierNew,Bold", "Courier-Bold", "CourierStd-Bold"});
            FontMappings.setSubstitutedFontAliases("Courier new bold italic", new String[]{"CourierNew-BoldOblique", "CourierStd-BoldOblique"});
            FontMappings.setSubstitutedFontAliases("Courier new", new String[]{"CourierNew", "Courier", "CourierStd"});
            FontMappings.setSubstitutedFontAliases("arial", new String[]{"Helvetica", "arialmt"});
            FontMappings.setSubstitutedFontAliases("arial italic", new String[]{"arial-italic", "arial-italicmt", "Helvetica-Oblique", "Arial,Italic"});
            FontMappings.setSubstitutedFontAliases("arial bold", new String[]{"arial-boldmt", "Helvetica-Bold", "Arial,bold"});
            FontMappings.setSubstitutedFontAliases("arial bold italic", new String[]{"Arial-BoldItalicMT", "Helvetica-BoldOblique"});
            FontMappings.setSubstitutedFontAliases("arial Narrow", new String[]{"ArialNarrow"});
            FontMappings.setSubstitutedFontAliases("arial Narrow italic", new String[]{"ArialNarrow-italic"});
            FontMappings.setSubstitutedFontAliases("arial Narrow bold", new String[]{"ArialNarrow-bold"});
            FontMappings.setSubstitutedFontAliases("arial Narrow bold italic", new String[]{"ArialNarrow-bolditalic"});
            FontMappings.setSubstitutedFontAliases("times new roman bold", new String[]{"Times-Bold", "TimesNewRoman,Bold", "TimesNewRomanPS-BoldMT"});
            FontMappings.setSubstitutedFontAliases("times new roman bold italic", new String[]{"Times-BoldItalic", "TimesNewRoman,BoldItalic", "TimesNewRomanPS-BoldItalicMT"});
            FontMappings.setSubstitutedFontAliases("times new roman italic", new String[]{"Times-Italic", "TimesNewRoman,Italic", "TimesNewRomanPS-ItalicMT"});
            FontMappings.setSubstitutedFontAliases("times new roman", new String[]{"Times-Roman", "TimesNewRoman", "Times", "TimesNewRomanPSMT"});
            FontMappings.setSubstitutedFontAliases("wingdings", new String[]{"ZapfDingbats", "ZaDb"});
        } else {
            FontMappings.setSubstitutedFontAliases("Couri", new String[]{"Courier-Oblique", "CourierNew,italic", "CourierStd-Oblique"});
            FontMappings.setSubstitutedFontAliases("Courbd", new String[]{"Courier-Bold", "CourierNew,Bold", "CourierStd-Bold"});
            FontMappings.setSubstitutedFontAliases("Courbi", new String[]{"Courier-BoldOblique", "CourierNew-BoldOblique", "CourierStd-BoldOblique"});
            FontMappings.setSubstitutedFontAliases("Cour", new String[]{"CourierNew", "Courier", "CourierStd", "CourierNewPSMT"});
            FontMappings.setSubstitutedFontAliases("arial", new String[]{"Helvetica", "arialmt"});
            FontMappings.setSubstitutedFontAliases("ariali", new String[]{"arial-italic", "arial-italicmt", "Helvetica-Oblique", "Arial,Italic"});
            FontMappings.setSubstitutedFontAliases("arialbd", new String[]{"arial-boldmt", "Helvetica-Bold", "Arial,bold", "arial bold"});
            FontMappings.setSubstitutedFontAliases("arialbdi", new String[]{"Arial-BoldItalicMT", "Helvetica-BoldOblique"});
            FontMappings.setSubstitutedFontAliases("arialn", new String[]{"ArialNarrow"});
            FontMappings.setSubstitutedFontAliases("arialni", new String[]{"ArialNarrow-italic"});
            FontMappings.setSubstitutedFontAliases("arialnb", new String[]{"ArialNarrow-bold"});
            FontMappings.setSubstitutedFontAliases("arialnbi", new String[]{"ArialNarrow-bolditalic"});
            FontMappings.setSubstitutedFontAliases("timesbd", new String[]{"Times-Bold", "TimesNewRoman,Bold", "TimesNewRomanPS-BoldMT"});
            FontMappings.setSubstitutedFontAliases("timesi", new String[]{"Times-BoldItalic", "TimesNewRoman,BoldItalic"});
            FontMappings.setSubstitutedFontAliases("timesbi", new String[]{"Times-Italic", "TimesNewRoman,Italic"});
            FontMappings.setSubstitutedFontAliases("times", new String[]{"Times-Roman", "TimesNewRoman", "Times", "TimesNewRomanPSMT"});
            FontMappings.setSubstitutedFontAliases("wingdings", new String[]{"ZapfDingbats", "ZaDb"});
        }
        if (!fontsSet) {
            fontsSet = true;
            FontMappings.setFontDirs(new String[]{"C:/windows/fonts/", "C:/winNT/fonts/", "/Library/Fonts/", "/usr/share/fonts/truetype/msttcorefonts/"});
        }
    }

    public static String setFontDirs(String[] stringArray) {
        String string;
        block8: {
            string = null;
            if (fontSubstitutionTable == null) {
                fontSubstitutionTable = new HashMap();
                fontSubstitutionFontID = new HashMap();
                fontPossDuplicates = new HashMap();
                fontPropertiesTable = new HashMap();
            }
            try {
                if (stringArray == null) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Null font parameter passed");
                    }
                    fontSubstitutionAliasTable.clear();
                    fontSubstitutionLocation.clear();
                    fontSubstitutionTable.clear();
                    fontSubstitutionFontID.clear();
                    fontPossDuplicates.clear();
                    fontPropertiesTable.clear();
                } else {
                    for (String string2 : stringArray) {
                        if (!string2.endsWith("/") && !string2.endsWith("\\")) {
                            string2 = string2 + separator;
                        }
                        string = FontMappings.addTTDir(string2, string);
                    }
                }
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block8;
                LogWriter.writeLog("Unable to run setFontDirs " + exception.getMessage());
            }
        }
        return string;
    }

    public static boolean addSubstituteFonts(String string, boolean bl) {
        boolean bl2;
        block13: {
            bl2 = false;
            try {
                String[] stringArray = new String[]{"tt", "t1c", "t1"};
                String[] stringArray2 = new String[]{"/TrueType", "/Type1C", "/Type1"};
                enforceFontSubstitution = bl;
                ClassLoader classLoader = FontMappings.class.getClass().getClassLoader();
                InputStream inputStream = classLoader.getResourceAsStream(string);
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Looking for root " + string);
                }
                if (inputStream != null) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Adding fonts fonts found in  tt,t1c,t1 sub-directories of " + string);
                    }
                    bl2 = true;
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string2;
                        if (!string.endsWith("/")) {
                            string = string + '/';
                        }
                        if ((inputStream = classLoader.getResourceAsStream(string2 = string + stringArray[i] + '/')) == null) continue;
                        System.out.println("Found  " + string2 + ' ' + inputStream);
                        try {
                            String string3;
                            ArrayList arrayList = inputStream instanceof ByteArrayInputStream ? FontMappings.readIndirectValues(inputStream) : FontMappings.getDirectoryMatches(string2);
                            int n = arrayList.size();
                            for (int j = 0; j < n && (string3 = (String)arrayList.get(j)) != null; ++j) {
                                int n2 = string3.indexOf(46);
                                String string4 = n2 == -1 ? string3 : string3.substring(0, n2);
                                fontSubstitutionTable.put(string4.toLowerCase(), stringArray2[i]);
                                fontSubstitutionLocation.put(string4.toLowerCase(), string2 + string3);
                            }
                            continue;
                        }
                        catch (Exception exception) {
                            if (LogWriter.isOutput()) {
                                LogWriter.writeLog("Exception " + exception + " reading substitute fonts");
                            }
                            System.out.println("Exception " + exception + " reading substitute fonts");
                        }
                    }
                } else if (LogWriter.isOutput()) {
                    LogWriter.writeLog("No fonts found at " + string);
                }
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block13;
                LogWriter.writeLog("Exception adding substitute fonts " + exception.getMessage());
            }
        }
        return bl2;
    }

    public static void addFontFile(String string, String string2) {
        if (fontSubstitutionTable == null) {
            fontSubstitutionTable = new HashMap();
            fontSubstitutionFontID = new HashMap();
            fontPossDuplicates = new HashMap();
            fontPropertiesTable = new HashMap();
        }
        if (string2 != null && !string2.endsWith("/") && !string2.endsWith("\\")) {
            string2 = string2 + separator;
        }
        String string3 = string.toLowerCase();
        int n = StandardFonts.getFontType(string3);
        InputStream inputStream = null;
        if (n != 8) {
            boolean bl = false;
            try {
                inputStream = new FileInputStream(string2 + string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bl = true;
            }
            catch (Error error) {
                error.printStackTrace();
                bl = true;
            }
            if (!bl) {
                int n2 = string.indexOf(46);
                String string4 = n2 == -1 ? string.toLowerCase() : string.substring(0, n2).toLowerCase();
                if (fontSubstitutionMode == 1 || n == 6) {
                    if (n == 1228944677) {
                        fontSubstitutionTable.put(string4, "/Type1");
                    } else {
                        fontSubstitutionTable.put(string4, "/TrueType");
                    }
                    fontSubstitutionLocation.put(string4, string2 + string);
                    fontPropertiesTable.put(string4 + "_type", new Integer(n));
                    fontPropertiesTable.put(string4 + "_path", string2 + string);
                } else if (n == 7 || n == 1217103210) {
                    if (fontSubstitutionMode == 5) {
                        String[] stringArray = null;
                        try {
                            stringArray = StandardFonts.readNamesFromFont(n, string2 + string, 2);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        String[] stringArray2 = null;
                        try {
                            stringArray2 = StandardFonts.readNamesFromFont(n, string2 + string, 3);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        int n3 = 0;
                        if (stringArray != null) {
                            n3 = stringArray.length;
                        }
                        for (int i = 0; i < n3; ++i) {
                            if (stringArray[i] == null) {
                                stringArray[i] = Strip.stripAllSpaces(string4);
                            }
                            if (stringArray2[i] == null) {
                                stringArray2[i] = Strip.stripAllSpaces(string4);
                            }
                            Object v = fontSubstitutionTable.get(stringArray[i]);
                            Object v2 = fontPossDuplicates.get(stringArray[i]);
                            if (v == null && v2 == null) {
                                fontSubstitutionTable.put(stringArray[i], "/TrueType");
                                fontSubstitutionLocation.put(stringArray[i], string2 + string);
                                fontSubstitutionFontID.put(stringArray[i], new Integer(i));
                                fontPossDuplicates.put(stringArray[i], stringArray2[i]);
                                continue;
                            }
                            if (stringArray2[i].equals(stringArray[i])) continue;
                            fontSubstitutionTable.put(stringArray[i], "/TrueType");
                            fontSubstitutionLocation.put(stringArray[i], string2 + string);
                            fontSubstitutionFontID.put(stringArray[i], new Integer(i));
                            fontPropertiesTable.put(stringArray[i] + "_type", new Integer(n));
                            fontPropertiesTable.put(stringArray[i] + "_path", string2 + string);
                            if (v2.equals("DONE")) continue;
                            fontPossDuplicates.put(stringArray[i], "DONE");
                            fontSubstitutionTable.remove(stringArray[i]);
                            fontSubstitutionTable.put(stringArray2[i], "/TrueType");
                            String string5 = (String)fontSubstitutionLocation.get(stringArray[i]);
                            fontSubstitutionLocation.remove(stringArray[i]);
                            fontSubstitutionLocation.put(stringArray2[i], string5);
                            fontSubstitutionFontID.remove(stringArray[i]);
                            fontSubstitutionFontID.put(stringArray2[i], new Integer(i));
                            fontPropertiesTable.remove(stringArray2[i] + "_path");
                            fontPropertiesTable.remove(stringArray2[i] + "_type");
                            fontPropertiesTable.put(stringArray2[i] + "_type", new Integer(n));
                            fontPropertiesTable.put(stringArray2[i] + "_path", string2 + string);
                        }
                    } else {
                        String[] stringArray = null;
                        try {
                            stringArray = StandardFonts.readNamesFromFont(n, string2 + string, fontSubstitutionMode);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (stringArray != null) {
                            for (int i = 0; i < stringArray.length; ++i) {
                                if (stringArray[i] == null) {
                                    stringArray[i] = Strip.stripAllSpaces(string4);
                                }
                                fontSubstitutionTable.put(stringArray[i], "/TrueType");
                                fontSubstitutionLocation.put(stringArray[i], string2 + string);
                                fontSubstitutionFontID.put(stringArray[i], new Integer(i));
                                fontPropertiesTable.put(stringArray[i] + "_type", new Integer(n));
                                fontPropertiesTable.put(stringArray[i] + "_path", string2 + string);
                            }
                        }
                    }
                } else if (n == 1228944677) {
                    String[] stringArray = null;
                    try {
                        stringArray = StandardFonts.readNamesFromFont(n, string2 + string, fontSubstitutionMode);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    if (stringArray != null) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (stringArray[i] == null) {
                                stringArray[i] = Strip.stripAllSpaces(string4);
                            }
                            fontSubstitutionTable.put(stringArray[i], "/Type1");
                            fontSubstitutionLocation.put(stringArray[i], string2 + string);
                            fontSubstitutionFontID.put(stringArray[i], new Integer(i));
                            fontPropertiesTable.put(stringArray[i] + "_type", new Integer(n));
                            fontPropertiesTable.put(stringArray[i] + "_path", string2 + string);
                        }
                    }
                }
            } else if (LogWriter.isOutput()) {
                LogWriter.writeLog("No fonts found at " + string2);
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static ArrayList getDirectoryMatches(String string) throws IOException {
        string.replaceAll("\\.", "/");
        URL uRL = Thread.currentThread().getContextClassLoader().getResource(string);
        ArrayList<String> arrayList = new ArrayList<String>(0);
        String string2 = uRL.toString();
        System.out.println("scanning " + string2);
        if (string2.startsWith("jar:") && string2.endsWith(string)) {
            int n = string2.lastIndexOf(string);
            string2 = string2.substring(0, n);
            System.out.println("entry= " + string2);
            URL uRL2 = new URL(string2);
            JarURLConnection jarURLConnection = (JarURLConnection)uRL2.openConnection();
            JarFile jarFile = jarURLConnection.getJarFile();
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                if (!(!jarEntry.isDirectory() & jarEntry.getName().startsWith(string))) continue;
                String string3 = jarEntry.getName();
                int n2 = string3.lastIndexOf(47);
                string3 = string3.substring(n2 + 1);
                arrayList.add(string3);
            }
        } else if (LogWriter.isOutput()) {
            LogWriter.writeLog("Path: " + string2);
        }
        return arrayList;
    }

    private static ArrayList readIndirectValues(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        ArrayList<String> arrayList = new ArrayList<String>(0);
        while ((string = bufferedReader.readLine()) != null) {
            arrayList.add(string);
        }
        bufferedReader.close();
        return arrayList;
    }

    public static void setDefaultDisplayFont(String string) throws PdfFontException {
        boolean bl = false;
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].toLowerCase().equals(string.toLowerCase())) continue;
            bl = true;
            defaultFont = stringArray[i];
            i = n;
        }
        if (!bl) {
            throw new PdfFontException("Font " + string + " is not available.");
        }
    }
}

