/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.io.Serializable;
import java.util.Map;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.fonts.tt.CFF;
import org.jpedal.fonts.tt.CMAP;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Glyf;
import org.jpedal.fonts.tt.Head;
import org.jpedal.fonts.tt.Hhea;
import org.jpedal.fonts.tt.Hmtx;
import org.jpedal.fonts.tt.Loca;
import org.jpedal.fonts.tt.Maxp;
import org.jpedal.fonts.tt.Name;
import org.jpedal.fonts.tt.Post;
import org.jpedal.fonts.tt.TTGlyph;

public class TTGlyphs
extends PdfJavaGlyphs {
    protected boolean hasGIDtoCID;
    protected int[] CIDToGIDMap;
    float[] FontBBox = new float[]{0.0f, 0.0f, 1000.0f, 1000.0f};
    private String[] diffTable = null;
    boolean isCorrupted = false;
    private CMAP currentCMAP;
    private Post currentPost;
    private Glyf currentGlyf;
    private Hmtx currentHmtx;
    private FontFile2 fontTable;
    private CFF currentCFF;
    int glyphCount = 0;
    int type = 1217103210;
    private int unitsPerEm;
    private boolean hasCFF;
    private boolean isCID;

    @Override
    public PdfGlyph getEmbeddedGlyph(GlyphFactory glyphFactory, String string, float[][] fArray, int n, String string2, float f, String string3) {
        PdfGlyph pdfGlyph;
        int n2 = n;
        if (this.hasGIDtoCID) {
            n = this.CIDToGIDMap[n];
        }
        if (this.lastTrm[0][0] != fArray[0][0] | this.lastTrm[1][0] != fArray[1][0] | this.lastTrm[0][1] != fArray[0][1] | this.lastTrm[1][1] != fArray[1][1]) {
            this.lastTrm = fArray;
            this.flush();
        }
        if ((pdfGlyph = this.getEmbeddedCachedShape(n2)) == null) {
            int n3 = n;
            if (!(this.isCID && this.isIdentity() || this.currentCMAP == null)) {
                n3 = this.currentCMAP.convertIndexToCharacterCode(string, n, this.remapFont, this.isSubsetted, this.diffTable);
            }
            if (n3 < 1) {
                n3 = this.currentPost.convertGlyphToCharacterCode(string);
            }
            try {
                if (this.hasCFF) {
                    pdfGlyph = this.currentCFF.getCFFGlyph(glyphFactory, string, fArray, n3, string2, f, string3);
                    if (pdfGlyph != null) {
                        pdfGlyph.setWidth(this.getUnscaledWidth(string, n, string2, false));
                    }
                } else {
                    pdfGlyph = this.getTTGlyph(n3, string, n, string2, f);
                }
            }
            catch (Exception exception) {
                pdfGlyph = null;
            }
            this.setEmbeddedCachedShape(n2, pdfGlyph);
        }
        return pdfGlyph;
    }

    public PdfGlyph getTTGlyph(int n, String string, int n2, String string2, float f) {
        if (this.isCorrupted) {
            n = n2;
        }
        TTGlyph tTGlyph = null;
        try {
            int n3;
            if (n != -1 && (n3 = this.currentGlyf.getCharString(n)) != -1) {
                tTGlyph = new TTGlyph(string, false, this.currentGlyf, this.fontTable, this.currentHmtx, n, (float)this.unitsPerEm / 1000.0f, this.baseFontName);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return tTGlyph;
    }

    @Override
    public void setDiffValues(String[] stringArray) {
        this.diffTable = stringArray;
    }

    @Override
    public void setEncodingToUse(boolean bl, int n, boolean bl2, boolean bl3) {
        if (this.currentCMAP != null) {
            if (this.isCorrupted) {
                this.currentCMAP.setEncodingToUse(bl, n, true, bl3);
            } else {
                this.currentCMAP.setEncodingToUse(bl, n, bl2, bl3);
            }
        }
    }

    @Override
    public int getConvertedGlyph(int n) {
        if (this.currentCMAP == null) {
            return n;
        }
        return this.currentCMAP.convertIndexToCharacterCode(null, n, false, false, this.diffTable);
    }

    @Override
    public float getTTWidth(String string, int n, String string2, boolean bl) {
        int n2 = n;
        float f = 0.0f;
        try {
            if (!bl) {
                n2 = this.currentCMAP.convertIndexToCharacterCode(string, n, this.remapFont, this.isSubsetted, this.diffTable);
            }
            if (n2 < 1) {
                n2 = this.currentPost.convertGlyphToCharacterCode(string);
            }
            f = this.currentHmtx.getWidth(n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    private float getUnscaledWidth(String string, int n, String string2, boolean bl) {
        int n2 = n;
        float f = 0.0f;
        try {
            if (!bl) {
                n2 = this.currentCMAP.convertIndexToCharacterCode(string, n, this.remapFont, this.isSubsetted, this.diffTable);
            }
            if (n2 < 1) {
                n2 = this.currentPost.convertGlyphToCharacterCode(string);
            }
            f = this.currentHmtx.getUnscaledWidth(n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    @Override
    public void setGIDtoCID(int[] nArray) {
        this.hasGIDtoCID = true;
        this.CIDToGIDMap = nArray;
    }

    public static String[] readFontNames(FontData fontData, int n) {
        FontFile2 fontFile2 = new FontFile2(fontData);
        int n2 = fontFile2.getFontCount();
        String[] stringArray = new String[n2];
        for (int i = 0; i < n2; ++i) {
            String string;
            fontFile2.setSelectedFontIndex(i);
            Name name = new Name(fontFile2);
            if (n == 2) {
                string = name.getString(Name.POSTSCRIPT_NAME);
            } else if (n == 3) {
                string = name.getString(Name.FONT_FAMILY_NAME);
            } else if (n == 4) {
                string = name.getString(Name.FULL_FONT_NAME);
            } else {
                throw new RuntimeException("Unsupported mode " + n + ". Unable to resolve font names");
            }
            stringArray[i] = string == null ? null : string.toLowerCase();
        }
        if (fontData != null) {
            fontData.close();
        }
        return stringArray;
    }

    public static void addStringValues(FontData fontData, Map map) {
        FontFile2 fontFile2 = new FontFile2(fontData);
        int n = fontFile2.getFontCount();
        for (int i = 0; i < n; ++i) {
            fontFile2.setSelectedFontIndex(i);
            Name name = new Name(fontFile2);
            Map map2 = name.getStrings();
            if (map2 == null) continue;
            for (Integer n2 : map2.keySet()) {
                int n3 = n2;
                if (n3 >= Name.stringNames.length) continue;
                map.put(Name.stringNames[n2], map2.get(n2));
            }
        }
        if (fontData != null) {
            fontData.close();
        }
    }

    @Override
    public int readEmbeddedFont(boolean bl, byte[] byArray, FontData fontData) {
        Serializable serializable;
        this.isCID = bl;
        FontFile2 fontFile2 = byArray != null ? new FontFile2(byArray) : new FontFile2(fontData);
        if (FontMappings.fontSubstitutionFontID == null) {
            fontFile2.setPointer(0);
        } else {
            serializable = (Integer)FontMappings.fontSubstitutionFontID.get(this.fontName.toLowerCase());
            if (serializable != null) {
                fontFile2.setPointer((Integer)serializable);
            } else {
                fontFile2.setPointer(0);
            }
        }
        serializable = new Head(fontFile2);
        this.currentPost = new Post(fontFile2);
        Maxp maxp = new Maxp(fontFile2);
        this.glyphCount = maxp.getGlyphCount();
        Loca loca = new Loca(fontFile2, this.glyphCount, ((Head)serializable).getFormat());
        this.isCorrupted = loca.isCorrupted();
        this.currentGlyf = new Glyf(fontFile2, this.glyphCount, loca.getIndices());
        this.currentCFF = new CFF(fontFile2, this.isCID);
        this.hasCFF = this.currentCFF.hasCFFData();
        if (this.hasCFF) {
            this.type = 6;
        }
        Hhea hhea = new Hhea(fontFile2);
        this.FontBBox = ((Head)serializable).getFontBBox();
        this.currentHmtx = new Hmtx(fontFile2, this.glyphCount, hhea.getNumberOfHMetrics(), (int)this.FontBBox[3]);
        int n = fontFile2.selectTable(2);
        if (n != 0) {
            this.currentCMAP = new CMAP(fontFile2, n, this.currentGlyf);
        }
        this.unitsPerEm = ((Head)serializable).getUnitsPerEm();
        fontFile2 = null;
        this.fontTable = new FontFile2(this.currentGlyf.getTableData(), true);
        if (fontData != null) {
            fontData.close();
        }
        return this.type;
    }

    @Override
    public float[] getFontBoundingBox() {
        return this.FontBBox;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public boolean isCorrupted() {
        return this.isCorrupted;
    }

    @Override
    public void setCorrupted(boolean bl) {
        this.isCorrupted = bl;
    }
}

