/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.conversion;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.tt.Hhea;
import org.jpedal.fonts.tt.conversion.FontTableWriter;
import org.jpedal.fonts.tt.conversion.TTFontWriter;

public class HheaWriter
extends Hhea
implements FontTableWriter {
    private int glyphCount;
    private double xMaxExtent;
    private double minRightSideBearing;
    private double minLeftSideBearing;
    private double advanceWidthMax;
    private double lowestDescender;
    private double highestAscender;

    public HheaWriter(PdfJavaGlyphs pdfJavaGlyphs, double d, double d2, double d3, double d4, double d5, double d6) {
        this.glyphCount = pdfJavaGlyphs.getGlyphCount();
        this.xMaxExtent = d;
        this.minRightSideBearing = d2;
        this.minLeftSideBearing = d3;
        this.advanceWidthMax = d4;
        this.lowestDescender = d5;
        this.highestAscender = d6;
    }

    @Override
    public byte[] writeTable() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(TTFontWriter.setNextUint32(65536));
        byteArrayOutputStream.write(TTFontWriter.setFWord((int)this.highestAscender));
        byteArrayOutputStream.write(TTFontWriter.setFWord((int)this.lowestDescender));
        byteArrayOutputStream.write(TTFontWriter.setFWord(0));
        byteArrayOutputStream.write(TTFontWriter.setUFWord((int)this.advanceWidthMax));
        byteArrayOutputStream.write(TTFontWriter.setFWord((int)this.minLeftSideBearing));
        byteArrayOutputStream.write(TTFontWriter.setFWord((int)this.minRightSideBearing));
        byteArrayOutputStream.write(TTFontWriter.setFWord((int)this.xMaxExtent));
        byteArrayOutputStream.write(TTFontWriter.setNextInt16(1));
        byteArrayOutputStream.write(TTFontWriter.setNextInt16(0));
        byteArrayOutputStream.write(TTFontWriter.setFWord(0));
        for (int i = 0; i < 4; ++i) {
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(0));
        }
        byteArrayOutputStream.write(TTFontWriter.setNextInt16(0));
        byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.glyphCount));
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public int getIntValue(int n) {
        return 0;
    }
}

