/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import org.jpedal.function.PDFFunction;
import org.jpedal.function.PDFGenericFunction;

public class PDFSampled
extends PDFGenericFunction
implements PDFFunction {
    private int[] size;
    private float[] samples;
    int returnValues;

    public PDFSampled(byte[] byArray, int n, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, int[] nArray) {
        super(fArray, fArray2);
        int n2;
        int n3;
        this.size = nArray;
        int n4 = n;
        if (fArray3 != null) {
            this.encode = fArray3;
        } else {
            n3 = nArray.length;
            this.encode = new float[n3 * 2];
            for (n2 = 0; n2 < n3; ++n2) {
                this.encode[n2 * 2 + 1] = nArray[n2] - 1;
            }
        }
        if (fArray4 != null) {
            this.decode = fArray4;
        } else {
            n3 = fArray2.length;
            this.decode = new float[n3];
            System.arraycopy(fArray2, 0, this.decode, 0, n3);
        }
        if (n4 == 8) {
            n3 = byArray.length;
            this.samples = new float[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                this.samples[n2] = (float)(byArray[n2] & 0xFF) / 256.0f;
            }
        } else if (n4 == 4) {
            n3 = byArray.length * 2;
            this.samples = new float[n3];
            n2 = 0;
            for (int i = 0; i < n3; i += 2) {
                this.samples[i] = (float)((byArray[n2] & 0xF0) >> 4) / 16.0f;
                this.samples[i + 1] = (float)(byArray[n2] & 0xF) / 16.0f;
                ++n2;
            }
        } else if (n4 == 2) {
            n3 = byArray.length * 4;
            this.samples = new float[n3];
            n2 = 0;
            for (int i = 0; i < n3; i += 4) {
                this.samples[i] = (float)((byArray[n2] & 0xC0) >> 6) / 4.0f;
                this.samples[i + 1] = (float)((byArray[n2] & 0x30) >> 4) / 4.0f;
                this.samples[i + 2] = (float)((byArray[n2] & 0xC) >> 2) / 4.0f;
                this.samples[i + 3] = (float)(byArray[n2] & 3) / 4.0f;
                ++n2;
            }
        } else if (n4 == 1) {
            n3 = byArray.length * 8;
            this.samples = new float[n3];
            n2 = 0;
            for (int i = 0; i < n3; i += 8) {
                this.samples[i] = (float)((byArray[n2] & 0x80) >> 7) / 2.0f;
                this.samples[i + 1] = (float)((byArray[n2] & 0x40) >> 6) / 2.0f;
                this.samples[i + 2] = (float)((byArray[n2] & 0x20) >> 5) / 2.0f;
                this.samples[i + 3] = (float)((byArray[n2] & 0x10) >> 4) / 2.0f;
                this.samples[i + 4] = (float)((byArray[n2] & 8) >> 3) / 2.0f;
                this.samples[i + 5] = (float)((byArray[n2] & 4) >> 2) / 2.0f;
                this.samples[i + 6] = (float)((byArray[n2] & 2) >> 1) / 2.0f;
                this.samples[i + 7] = (float)(byArray[n2] & 1) / 2.0f;
                ++n2;
            }
        } else if (n4 == 12) {
            n3 = 16 / n4;
            n2 = byArray.length * n3 * 2;
            this.samples = new float[n2];
            int n5 = 0;
            int n6 = 0;
            int n7 = (2 << n4) - 1;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    this.samples[i] = (((byArray[n5] << 8) + byArray[n5] & n7 << 16 - j * n4) >> 16 - n4) / n7;
                }
                while (n6 > 16) {
                    n5 += 2;
                    n6 -= 16;
                }
            }
        } else {
            n3 = n4 / 8;
            n2 = byArray.length / n3;
            this.samples = new float[n2];
            int n8 = 0;
            long l = 0L;
            if (n4 == 16) {
                l = 65536L;
            } else if (n4 == 24) {
                l = 0x1000000L;
            } else if (n4 == 32) {
                l = 0x19990000L;
            } else {
                throw new RuntimeException("Unexpected value in PDFSampled" + n4);
            }
            for (int i = 0; i < n2; ++i) {
                long l2 = 0L;
                for (int j = 0; j < n3; ++j) {
                    l2 += (long)((byArray[n8 + j] & 0xFF) << 8 * (n3 - j - 1));
                }
                this.samples[i] = (float)l2 / (float)l;
                n8 += n3;
            }
        }
        this.returnValues = fArray2.length / 2;
    }

    @Override
    public float[] computeStitch(float[] fArray) {
        return this.compute(fArray);
    }

    @Override
    public float[] compute(float[] fArray) {
        int n;
        float[] fArray2;
        float[] fArray3 = new float[this.returnValues];
        int n2 = this.range.length / 2;
        int n3 = this.domain.length / 2;
        if (n2 < n3) {
            int n4 = fArray.length;
            fArray2 = new float[n4];
            for (n = 0; n < n4; ++n) {
                fArray2[n4 - n - 1] = fArray[n];
            }
            fArray = fArray2;
        }
        float[] fArray4 = new float[n3 * 2];
        fArray2 = fArray;
        for (n = 0; n < n3; ++n) {
            int n5;
            fArray4[n * 2] = this.encodeInput(fArray2[n], n);
            if (n2 == n3) {
                fArray3[n] = this.decodeSample(fArray4[n * 2], n, n2, 0);
                continue;
            }
            if (n3 < n2) {
                for (n5 = 0; n5 < n2; ++n5) {
                    fArray3[n5] = this.decodeSample(fArray4[n * 2], n5, n2, n5);
                }
                continue;
            }
            if (n2 >= n3) continue;
            for (n5 = 0; n5 < n2; ++n5) {
                fArray3[n5] = this.decodeSample(fArray4[n * 2], n5, n2, n5);
            }
        }
        return fArray3;
    }

    private float encodeInput(float f, int n) {
        f = PDFSampled.min(PDFSampled.max(f, this.domain[n * 2]), this.domain[n * 2 + 1]);
        f = PDFSampled.interpolate(f, this.domain[n * 2], this.domain[n * 2 + 1], this.encode[n * 2], this.encode[n * 2 + 1]);
        f = PDFSampled.min(PDFSampled.max(f, 0.0f), this.size[n] - 1);
        return f;
    }

    private float decodeSample(float f, int n, int n2, int n3) {
        int n4 = (int)f;
        if (f - (float)((int)f) > 0.0f) {
            n4 = (int)f + 1;
        }
        float f2 = (float)n4 - f;
        float f3 = 1.0f - f2;
        int n5 = (int)f * n2 + n3;
        int n6 = n4 * n2 + n3;
        float f4 = f2 * this.samples[n5] + f3 * this.samples[n6];
        f4 = PDFSampled.interpolate(f4, 0.0f, 1.0f, this.decode[n * 2], this.decode[n * 2 + 1]);
        f4 = PDFSampled.min(PDFSampled.max(f4, this.range[n * 2]), this.range[n * 2 + 1]);
        return f4;
    }
}

