/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.IOException;
import org.jpedal.io.RandomAccessBuffer;

public class RandomAccessDataBuffer
implements RandomAccessBuffer {
    private byte[] data;
    private long pointer;

    public RandomAccessDataBuffer(byte[] byArray) {
        this.data = byArray;
        this.pointer = -1L;
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.pointer;
    }

    @Override
    public void seek(long l) throws IOException {
        if (!this.checkPos(l)) {
            throw new IOException("Position out of bounds");
        }
        this.pointer = l;
    }

    @Override
    public void close() throws IOException {
        this.data = null;
        this.pointer = -1L;
    }

    @Override
    public long length() throws IOException {
        if (this.data != null) {
            return this.data.length;
        }
        throw new IOException("Data buffer not initialized.");
    }

    @Override
    public int read() throws IOException {
        if (this.checkPos(this.pointer)) {
            return RandomAccessDataBuffer.b2i(this.data[(int)this.pointer++]);
        }
        return -1;
    }

    private int peek() throws IOException {
        if (this.checkPos(this.pointer)) {
            return RandomAccessDataBuffer.b2i(this.data[(int)this.pointer]);
        }
        return -1;
    }

    @Override
    public String readLine() throws IOException {
        int n;
        if (this.pointer >= (long)(this.data.length - 1)) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.read()) >= 0) {
            if (n == 10 || n == 13) {
                if (this.peek() != 10 && this.peek() != 13 || this.peek() == n) break;
                this.read();
                break;
            }
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        if (this.data == null) {
            throw new IOException("Data buffer not initialized.");
        }
        if (this.pointer < 0L || this.pointer >= (long)this.data.length) {
            return -1;
        }
        int n = Math.min(byArray.length, this.data.length - (int)this.pointer);
        for (int i = 0; i < n; ++i) {
            byArray[i] = this.data[(int)this.pointer++];
        }
        return n;
    }

    private static int b2i(byte by) {
        if (by >= 0) {
            return by;
        }
        return 256 + by;
    }

    private boolean checkPos(long l) throws IOException {
        return l >= 0L && l < this.length();
    }

    @Override
    public byte[] getPdfBuffer() {
        return this.data;
    }
}

