/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.filter;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.jpedal.io.filter.BaseFilter;
import org.jpedal.io.filter.PdfFilter;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class Flate
extends BaseFilter
implements PdfFilter {
    private int predictor = 1;
    private int colors = 1;
    private int bitsPerComponent = 8;
    private int columns = 1;
    private boolean hasError = false;

    public Flate(PdfObject pdfObject) {
        super(pdfObject);
        if (pdfObject != null) {
            int n;
            int n2;
            int n3 = pdfObject.getInt(-1344207655);
            if (n3 != -1) {
                this.bitsPerComponent = n3;
            }
            if ((n2 = pdfObject.getInt(1010783618)) != -1) {
                this.colors = n2;
            }
            if ((n = pdfObject.getInt(1162902911)) != -1) {
                this.columns = n;
            }
            this.predictor = pdfObject.getInt(1970893723);
        }
    }

    @Override
    public byte[] decode(byte[] byArray) throws Exception {
        int n = 512000;
        ByteArrayOutputStream byteArrayOutputStream = null;
        boolean bl = true;
        if (byArray != null) {
            while (bl) {
                Inflater inflater = new Inflater();
                inflater.setInput(byArray);
                int n2 = byArray.length;
                byteArrayOutputStream = new ByteArrayOutputStream(n2);
                if (n2 < n) {
                    n = n2;
                }
                byte[] byArray2 = new byte[n];
                try {
                    while (!inflater.finished()) {
                        int n3 = inflater.inflate(byArray2);
                        byteArrayOutputStream.write(byArray2, 0, n3);
                        if (inflater.getRemaining() != 0) continue;
                    }
                    bl = false;
                }
                catch (Exception exception) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Exception in Flate " + exception);
                    }
                    bl = true;
                    this.hasError = true;
                    if (byArray.length > 10) {
                        byte[] byArray3 = new byte[byArray.length - 1];
                        System.arraycopy(byArray, 0, byArray3, 0, byArray.length - 1);
                        byArray = byArray3;
                        continue;
                    }
                    bl = false;
                }
            }
            byArray = byteArrayOutputStream.toByteArray();
            return this.applyPredictor(this.predictor, byArray, this.colors, this.bitsPerComponent, this.columns);
        }
        return byArray;
    }

    @Override
    public void decode(BufferedInputStream bufferedInputStream, BufferedOutputStream bufferedOutputStream, String string, Map map) throws Exception {
        block6: {
            this.bis = bufferedInputStream;
            this.streamCache = bufferedOutputStream;
            this.cachedObjects = map;
            if (bufferedInputStream != null) {
                try {
                    InflaterInputStream inflaterInputStream = new InflaterInputStream(bufferedInputStream);
                    int n = 0;
                    while (true) {
                        int n2 = ((InputStream)inflaterInputStream).read();
                        if (((InputStream)inflaterInputStream).available() == 0 || n2 == -1) break;
                        bufferedOutputStream.write(n2);
                        ++n;
                    }
                    if (this.predictor != 1 && this.predictor != 10) {
                        bufferedOutputStream.flush();
                        bufferedOutputStream.close();
                        if (string != null) {
                            this.setupCachedObjectForDecoding(string);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (!LogWriter.isOutput()) break block6;
                    LogWriter.writeLog("Exception " + exception + " accessing Flate filter ");
                }
            }
        }
        this.applyPredictor(this.predictor, null, this.colors, this.bitsPerComponent, this.columns);
    }

    @Override
    public boolean hasError() {
        return this.hasError;
    }
}

