/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.filter.ccitt;

import org.jpedal.exception.PdfException;
import org.jpedal.io.filter.ccitt.CCITT2D;
import org.jpedal.io.filter.ccitt.CCITTDecoder;
import org.jpedal.objects.raw.PdfObject;

public class CCITTMix
extends CCITT2D
implements CCITTDecoder {
    private int fillBits = 0;

    public CCITTMix(byte[] byArray, int n, int n2, PdfObject pdfObject) {
        super(byArray, n, n2, pdfObject);
        this.data = byArray;
        this.is2D = false;
    }

    @Override
    public byte[] decode() {
        Object[] objectArray;
        try {
            objectArray = new int[this.width + 1];
            int[] nArray = new int[this.width + 1];
            int[] nArray2 = new int[2];
            if (this.readEOL(true) != 1) {
                throw new PdfException("TIFFFaxDecoder3");
            }
            this.decode1DRun(nArray);
            for (int i = 1; i < this.height; ++i) {
                if (this.readEOL(false) == 0) {
                    Object[] objectArray2 = objectArray;
                    objectArray = nArray;
                    nArray = objectArray2;
                    this.set2D((int[])objectArray, nArray, this.changingElemSize, nArray2);
                    nArray[this.currIndex++] = this.bitOffset;
                    this.changingElemSize = this.currIndex;
                    continue;
                }
                this.decode1DRun(nArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        objectArray = this.creatOutputFromBitset();
        if (!this.BlackIs1) {
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = (byte)(255 - objectArray[i]);
            }
        }
        return objectArray;
    }

    void decode1DRun(int[] nArray) throws Exception {
        int n = 0;
        boolean bl = true;
        this.changingElemSize = 0;
        while (n < this.columns) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            while (bl) {
                n6 = this.get1DBits(10);
                this.bitReached += 10;
                n5 = white[n6];
                n4 = n5 & 1;
                n3 = n5 >>> 1 & 0xF;
                if (n3 == 12) {
                    int n7 = this.get1DBits(2);
                    this.bitReached += 2;
                    n6 = n6 << 2 & 0xC | n7;
                    n5 = additionalMakeup[n6];
                    n3 = n5 >>> 1 & 7;
                    n2 = n5 >>> 4 & 0xFFF;
                    n += n2;
                    this.outPtr += n2;
                    this.bitReached -= 4 - n3;
                    continue;
                }
                if (n3 == 0 || n3 == 15) {
                    throw new Exception("1Derror");
                }
                n2 = n5 >>> 5 & 0x7FF;
                n += n2;
                this.bitReached -= 10 - n3;
                if (n4 == 0) {
                    bl = false;
                    nArray[this.changingElemSize++] = n;
                }
                this.outPtr += n2;
            }
            if (n == this.columns) break;
            while (!bl) {
                n6 = this.get1DBits(4);
                n5 = initBlack[n6];
                this.bitReached += 4;
                n3 = n5 >>> 1 & 0xF;
                n2 = n5 >>> 5 & 0x7FF;
                if (n2 == 100) {
                    n6 = this.get1DBits(9);
                    this.bitReached += 9;
                    n5 = black[n6];
                    n4 = n5 & 1;
                    n3 = n5 >>> 1 & 0xF;
                    n2 = n5 >>> 5 & 0x7FF;
                    if (n3 == 12) {
                        this.bitReached -= 5;
                        n6 = this.get1DBits(4);
                        this.bitReached += 4;
                        n5 = additionalMakeup[n6];
                        n3 = n5 >>> 1 & 7;
                        n2 = n5 >>> 4 & 0xFFF;
                        this.out.set(this.outPtr, this.outPtr + n2, true);
                        this.outPtr += n2;
                        n += n2;
                        this.bitReached -= 4 - n3;
                        continue;
                    }
                    if (n3 == 15) {
                        throw new PdfException("1D error");
                    }
                    this.out.set(this.outPtr, this.outPtr + n2, true);
                    this.outPtr += n2;
                    n += n2;
                    this.bitReached -= 9 - n3;
                    if (n4 != 0) continue;
                    bl = true;
                    nArray[this.changingElemSize++] = n;
                    continue;
                }
                if (n2 == 200) {
                    n6 = this.get1DBits(2);
                    this.bitReached += 2;
                    n5 = twoBitBlack[n6];
                    n2 = n5 >>> 5 & 0x7FF;
                    n3 = n5 >>> 1 & 0xF;
                    this.out.set(this.outPtr, this.outPtr + n2, true);
                    this.outPtr += n2;
                    this.bitReached -= 2 - n3;
                    bl = true;
                    nArray[this.changingElemSize++] = n += n2;
                    continue;
                }
                this.out.set(this.outPtr, this.outPtr + n2, true);
                this.outPtr += n2;
                this.bitReached -= 4 - n3;
                bl = true;
                nArray[this.changingElemSize++] = n += n2;
            }
            if (n != this.columns) continue;
        }
        nArray[this.changingElemSize++] = n;
    }

    private int readEOL(boolean bl) throws PdfException {
        int n;
        if (this.fillBits == 0) {
            n = this.get1DBits(12);
            this.bitReached += 12;
            if (bl && n == 0) {
                int n2 = this.get1DBits(4);
                this.bitReached += 4;
                if (n2 == 1) {
                    this.fillBits = 1;
                    return 1;
                }
            }
            if (n != 1) {
                throw new PdfException("EOL error1");
            }
        } else if (this.fillBits == 1) {
            int n3;
            n = this.bitReached & 7;
            int n4 = this.get1DBits(n);
            this.bitReached += n;
            if (n4 != 0) {
                throw new PdfException("EOL error2");
            }
            if (n < 4) {
                n3 = this.get1DBits(8);
                this.bitReached += 8;
                if (n3 != 0) {
                    throw new PdfException("EOL error3");
                }
            }
            n3 = this.get1DBits(8);
            this.bitReached += 8;
            while (n3 != 1) {
                if (n3 != 0) {
                    throw new PdfException("EOL error4");
                }
                n3 = this.get1DBits(8);
                this.bitReached += 8;
            }
        }
        n = this.get1DBits(1);
        ++this.bitReached;
        return n;
    }
}

