/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render.output.javafx;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jpedal.examples.javafx.JavaFXFontMapper;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.render.output.FontMapper;
import org.jpedal.render.output.OutputDisplay;
import org.jpedal.render.output.TextBlock;
import org.jpedal.render.output.javafx.JavaFXHelper;

public class JavaFXMLDisplay
extends OutputDisplay {
    private static final String separator = System.getProperty("file.separator");
    String packageName = "";
    private int shapeCount = 0;
    private String textName;
    private String imagePrefix = null;
    private String javaFxFileName = "";

    public JavaFXMLDisplay(int n, Point2D point2D, Rectangle rectangle, boolean bl, int n2, ObjectStore objectStore) {
        super(n, point2D, rectangle, bl, n2, objectStore);
        this.type = 5;
        Helper = new JavaFXHelper();
    }

    public static String getDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd - MMMMM - yyyy");
        Date date = new Date();
        return simpleDateFormat.format(date);
    }

    @Override
    protected void completeOutput() {
        this.flushText();
        String string = this.rootDir.substring(0, this.rootDir.length() - 1);
        Boolean bl = false;
        if (this.pageData.getPageCount() == 1) {
            bl = true;
        }
        this.writeCustom(0, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.writeCustom(0, "");
        this.writeCustom(0, "<?import java.lang.*?>");
        this.writeCustom(0, "<?import javafx.scene.*?>");
        this.writeCustom(0, "<?import javafx.scene.control.*?>");
        this.writeCustom(0, "<?import javafx.scene.layout.*?>");
        this.writeCustom(0, "<?import javafx.scene.image.*?>");
        this.writeCustom(0, "");
        this.writeCustom(0, "<AnchorPane id=\"AnchorPane\" prefHeight=\"" + (this.pageData.getCropBoxHeight(this.pageNumber) + 46) + "\" prefWidth=\"" + this.pageData.getCropBoxWidth(this.pageNumber) + "\" xmlns:fx=\"http://javafx.com/fxml\" fx:controller=\"" + this.packageName + ".MainClass\">");
        this.writeCustom(0, "\t<children>");
        this.writeCustom(0, "");
        this.writeCustom(0, "");
        this.writeCustom(0, "");
        try {
            this.writeCustom(0, this.script.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string2 = this.createMainClassContent();
        this.createJavaFXMLMethodsContent(string2);
        this.writeCustom(0, "\t</children>");
        this.writeCustom(0, "\n\t<children>");
        this.writeCustom(0, "\t\t<HBox id=\"navBar\" alignment=\"center\" spacing=\"5\" style=\"-fx-background-color: #104E8B\" prefHeight=\"35\" prefWidth=\"" + this.pageData.getCropBoxWidth(this.pageNumber) + "\" layoutY=\"" + (this.pageData.getCropBoxHeight(this.pageNumber) + 10) + "\"" + ">");
        this.writeCustom(0, "\t\t\t<children>");
        this.writeCustom(0, "\t\t\t\t");
        this.writeCustom(0, "\t\t\t\t<Button id=\"start\">");
        this.writeCustom(0, "\t\t\t\t\t<tooltip>");
        this.writeCustom(0, "\t\t\t\t\t\t<Tooltip text=\"First page\" />");
        this.writeCustom(0, "\t\t\t\t\t</tooltip>");
        this.writeCustom(0, "\t\t\t\t\t<graphic>");
        this.writeCustom(0, "\t\t\t\t\t\t<ImageView>");
        this.writeCustom(0, "\t\t\t\t\t\t\t<image>");
        this.writeCustom(0, "\t\t\t\t\t\t\t\t<Image url=\"@img/icons/smstart.gif\"/>");
        this.writeCustom(0, "\t\t\t\t\t\t\t</image>");
        this.writeCustom(0, "\t\t\t\t\t\t</ImageView>");
        this.writeCustom(0, "\t\t\t\t\t</graphic>");
        this.writeCustom(0, "\t\t\t\t</Button>");
        this.writeCustom(0, "\t\t\t\t<Button id=\"back10Pages\">");
        this.writeCustom(0, "\t\t\t\t\t<tooltip>");
        this.writeCustom(0, "\t\t\t\t\t\t<Tooltip text=\"Previous 10 pages\" />");
        this.writeCustom(0, "\t\t\t\t\t</tooltip>");
        this.writeCustom(0, "\t\t\t\t\t<graphic>");
        this.writeCustom(0, "\t\t\t\t\t\t<ImageView>");
        this.writeCustom(0, "\t\t\t\t\t\t\t<image>");
        this.writeCustom(0, "\t\t\t\t\t\t\t\t<Image url=\"@img/icons/smfback.gif\"/>");
        this.writeCustom(0, "\t\t\t\t\t\t\t</image>");
        this.writeCustom(0, "\t\t\t\t\t\t</ImageView>");
        this.writeCustom(0, "\t\t\t\t\t</graphic>");
        this.writeCustom(0, "\t\t\t\t</Button>");
        this.writeCustom(0, "\t\t\t\t<Button id=\"backOnePage\">");
        this.writeCustom(0, "\t\t\t\t\t<tooltip>");
        this.writeCustom(0, "\t\t\t\t\t\t<Tooltip text=\"Previous page\" />");
        this.writeCustom(0, "\t\t\t\t\t</tooltip>");
        this.writeCustom(0, "\t\t\t\t\t<graphic>");
        this.writeCustom(0, "\t\t\t\t\t\t<ImageView>");
        this.writeCustom(0, "\t\t\t\t\t\t\t<image>");
        this.writeCustom(0, "\t\t\t\t\t\t\t\t<Image url=\"@img/icons/smback.gif\"/>");
        this.writeCustom(0, "\t\t\t\t\t\t\t</image>");
        this.writeCustom(0, "\t\t\t\t\t\t</ImageView>");
        this.writeCustom(0, "\t\t\t\t\t</graphic>");
        this.writeCustom(0, "\t\t\t\t</Button>");
        this.writeCustom(0, "\t\t\t\t<TextField text= \"" + this.pageNumberAsString + "\" maxHeight=\"25\" prefWidth=\"50\" editable= \"NO\"/>");
        this.writeCustom(0, "\t\t\t\t<Label text=\":\" style=\"-fx-font: DARK 26 Arial;\"/>");
        this.writeCustom(0, "\t\t\t\t<TextField text= \"" + this.pageData.getPageCount() + "\" maxHeight=\"25\" prefWidth=\"50\" editable= \"NO\"/>");
        this.writeCustom(0, "\t\t\t\t<Button id=\"forward\">");
        this.writeCustom(0, "\t\t\t\t\t<tooltip>");
        this.writeCustom(0, "\t\t\t\t\t\t<Tooltip text=\"Next page\" />");
        this.writeCustom(0, "\t\t\t\t\t</tooltip>");
        this.writeCustom(0, "\t\t\t\t\t<graphic>");
        this.writeCustom(0, "\t\t\t\t\t\t<ImageView>");
        this.writeCustom(0, "\t\t\t\t\t\t\t<image>");
        this.writeCustom(0, "\t\t\t\t\t\t\t\t<Image url=\"@img/icons/smforward.gif\"/>");
        this.writeCustom(0, "\t\t\t\t\t\t\t</image>");
        this.writeCustom(0, "\t\t\t\t\t\t</ImageView>");
        this.writeCustom(0, "\t\t\t\t\t</graphic>");
        this.writeCustom(0, "\t\t\t\t</Button>");
        this.writeCustom(0, "\t\t\t\t<Button id=\"next10Pages\">");
        this.writeCustom(0, "\t\t\t\t\t<tooltip>");
        this.writeCustom(0, "\t\t\t\t\t\t<Tooltip text=\"Next 10 pages\" />");
        this.writeCustom(0, "\t\t\t\t\t</tooltip>");
        this.writeCustom(0, "\t\t\t\t\t<graphic>");
        this.writeCustom(0, "\t\t\t\t\t\t<ImageView>");
        this.writeCustom(0, "\t\t\t\t\t\t\t<image>");
        this.writeCustom(0, "\t\t\t\t\t\t\t\t<Image url=\"@img/icons/smfforward.gif\"/>");
        this.writeCustom(0, "\t\t\t\t\t\t\t</image>");
        this.writeCustom(0, "\t\t\t\t\t\t</ImageView>");
        this.writeCustom(0, "\t\t\t\t\t</graphic>");
        this.writeCustom(0, "\t\t\t\t</Button>");
        this.writeCustom(0, "\t\t\t\t<Button  id=\"end\">");
        this.writeCustom(0, "\t\t\t\t\t<tooltip>");
        this.writeCustom(0, "\t\t\t\t\t\t<Tooltip text=\"Last page\" />");
        this.writeCustom(0, "\t\t\t\t\t</tooltip>");
        this.writeCustom(0, "\t\t\t\t\t<graphic>");
        this.writeCustom(0, "\t\t\t\t\t\t<ImageView>");
        this.writeCustom(0, "\t\t\t\t\t\t\t<image>");
        this.writeCustom(0, "\t\t\t\t\t\t\t\t<Image url=\"@img/icons/smend.gif\"/>");
        this.writeCustom(0, "\t\t\t\t\t\t\t</image>");
        this.writeCustom(0, "\t\t\t\t\t\t</ImageView>");
        this.writeCustom(0, "\t\t\t\t\t</graphic>");
        this.writeCustom(0, "\t\t\t\t</Button>");
        this.writeCustom(0, "\t\t\t\t");
        this.writeCustom(0, "\t\t\t</children>");
        this.writeCustom(0, "\t\t</HBox>");
        this.writeCustom(0, "\t</children>");
        this.writeCustom(0, "</AnchorPane>");
        try {
            this.output.flush();
            this.output.close();
            this.output = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void createJavaFXMLMethodsContent(String string) {
        block0: {
            this.writeCustom(13, "/**");
            this.writeCustom(13, "* ===========================================");
            this.writeCustom(13, "* Java Pdf Extraction Decoding Access Library");
            this.writeCustom(13, "* ===========================================");
            this.writeCustom(13, "*");
            this.writeCustom(13, "* Project Info:  http://www.jpedal.org");
            this.writeCustom(13, "*");
            this.writeCustom(13, "* generated by JPedal PDF to javaFXML");
            this.writeCustom(13, "*");
            this.writeCustom(13, "* --------------------------------------------");
            this.writeCustom(13, "* page" + this.pageNumberAsString + ".fxml");
            this.writeCustom(13, "* --------------------------------------------");
            this.writeCustom(13, "* --------------------------------------------");
            this.writeCustom(13, "* " + JavaFXMLDisplay.getDate());
            this.writeCustom(13, "* --------------------------------------------");
            this.writeCustom(13, "*/");
            this.writeCustom(13, "");
            this.writeCustom(13, "");
            this.writeCustom(13, "package " + this.packageName + ";");
            this.writeCustom(13, "");
            this.writeCustom(13, "import java.net.URL;");
            this.writeCustom(13, "import java.util.ResourceBundle;");
            this.writeCustom(13, "import javafx.fxml.Initializable;");
            this.writeCustom(13, "");
            this.writeCustom(13, "");
            this.writeCustom(13, "public class javaFXMLMethods implements Initializable {");
            this.writeCustom(13, "");
            this.writeCustom(13, "");
            this.writeCustom(13, "\t@Override");
            this.writeCustom(13, "\tpublic void initialize(URL url, ResourceBundle rb) {");
            this.writeCustom(13, "\t");
            this.writeCustom(13, "\t}");
            this.writeCustom(13, "}");
            String string2 = this.rootDir;
            File file = new File(string2);
            if (file.exists()) break block0;
            file.mkdirs();
        }
    }

    private String createMainClassContent() {
        this.writeCustom(4, "/**");
        this.writeCustom(4, "* ===========================================");
        this.writeCustom(4, "* Java Pdf Extraction Decoding Access Library");
        this.writeCustom(4, "* ===========================================");
        this.writeCustom(4, "*");
        this.writeCustom(4, "* Project Info:  http://www.jpedal.org");
        this.writeCustom(4, "*");
        this.writeCustom(4, "* generated by JPedal PDF to javaFXML");
        this.writeCustom(4, "*");
        this.writeCustom(4, "* --------------------------------------------");
        this.writeCustom(4, "* " + this.packageName);
        this.writeCustom(4, "* --------------------------------------------");
        this.writeCustom(4, "* --------------------------------------------");
        this.writeCustom(4, "* " + JavaFXMLDisplay.getDate());
        this.writeCustom(4, "* --------------------------------------------");
        this.writeCustom(4, "*/");
        this.writeCustom(4, "");
        this.writeCustom(4, "");
        this.writeCustom(4, " package " + this.packageName + ";");
        this.writeCustom(4, "");
        this.writeCustom(4, " import javafx.application.Application;");
        this.writeCustom(4, " import java.net.URL;");
        this.writeCustom(4, " import java.util.ResourceBundle;");
        this.writeCustom(4, " import javafx.fxml.Initializable;");
        this.writeCustom(4, " import javafx.fxml.FXMLLoader;");
        this.writeCustom(4, " import javafx.scene.Parent;");
        this.writeCustom(4, " import javafx.scene.Scene;");
        this.writeCustom(4, " import javafx.stage.Stage;");
        this.writeCustom(4, " import javafx.fxml.FXML;");
        this.writeCustom(4, " import javafx.event.ActionEvent;");
        this.writeCustom(4, "");
        this.writeCustom(4, "");
        this.writeCustom(4, "public class MainClass extends Application implements Initializable{");
        this.writeCustom(4, "");
        this.writeCustom(4, "\tpublic static void main(String[] args) {");
        this.writeCustom(4, "\t\tApplication.launch(MainClass.class, args);");
        this.writeCustom(4, "\t}");
        this.writeCustom(4, "\t");
        this.writeCustom(4, "\t@Override");
        this.writeCustom(4, "\tpublic void start(Stage stage) throws Exception {");
        this.writeCustom(4, "\t\tParent root = FXMLLoader.load(getClass().getResource(\"page1.fxml\"));");
        this.writeCustom(4, "\t\t");
        this.writeCustom(4, "\t\tstage.setTitle(\"" + this.packageName + "\");");
        this.writeCustom(4, "\t\tstage.setScene(new Scene(root));");
        this.writeCustom(4, "\t\tstage.show();");
        this.writeCustom(4, "\t}");
        this.writeCustom(4, "");
        this.writeCustom(4, "\t@Override");
        this.writeCustom(4, "\tpublic void initialize(URL url, ResourceBundle rb) {");
        this.writeCustom(4, "\t");
        this.writeCustom(4, "\t}");
        this.writeCustom(4, "\t");
        this.writeCustom(4, "\t@FXML");
        this.writeCustom(4, "\tprivate void firstPage(ActionEvent event) {");
        this.writeCustom(4, "\t\tSystem.out.println(\"firstPage Clicked!\");");
        this.writeCustom(4, "\t}");
        this.writeCustom(4, "\t");
        this.writeCustom(4, "\t@FXML");
        this.writeCustom(4, "\tprivate void previous10Pages(ActionEvent event) {");
        this.writeCustom(4, "\t\tSystem.out.println(\"previous10Pages Clicked!\");");
        this.writeCustom(4, "\t}");
        this.writeCustom(4, "\t");
        this.writeCustom(4, "\t@FXML");
        this.writeCustom(4, "\tprivate void previousPage(ActionEvent event) {");
        this.writeCustom(4, "\t\tSystem.out.println(\"previousPage Clicked!\");");
        this.writeCustom(4, "\t}");
        this.writeCustom(4, "\t");
        this.writeCustom(4, "\t@FXML");
        this.writeCustom(4, "\tprivate void nextPage(ActionEvent event) {");
        this.writeCustom(4, "\t\tSystem.out.println(\"nextPage Clicked!\");");
        this.writeCustom(4, "\t}");
        this.writeCustom(4, "\t");
        this.writeCustom(4, "\t@FXML");
        this.writeCustom(4, "\tprivate void next10tPages(ActionEvent event) {");
        this.writeCustom(4, "\t\tSystem.out.println(\"next10tPages Clicked!\");");
        this.writeCustom(4, "\t}");
        this.writeCustom(4, "\t");
        this.writeCustom(4, "\t@FXML");
        this.writeCustom(4, "\tprivate void endPage(ActionEvent event) {");
        this.writeCustom(4, "\t\tSystem.out.println(\"endPage Clicked!\");");
        this.writeCustom(4, "\t}");
        this.writeCustom(4, "\t");
        this.writeCustom(4, "}");
        String string = this.rootDir;
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(string + "MainClass.java"));
            printWriter.println(this.css.toString());
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    private void writeoutJavaFXText() {
        if (this.currentTextBlock.isEmpty()) {
            throw new RuntimeException("writeoutTextAsDiv() called incorrectly.  Attempted to write out text with empty text block use flushText.");
        }
        float f = this.currentTextBlock.getRotationAngle();
        int n = (int)((double)(f * 180.0f) / Math.PI);
        if (n < 0) {
            n += 360;
        }
        String string = this.currentTextBlock.getWeight();
        String string2 = "";
        if (string.equals("normal")) {
            string2 = "NORMAL";
        } else if (string.equals("bold")) {
            string2 = "BOLD";
        } else if (string.equals("bolder")) {
            string2 = "BLACK";
        } else if (string.equals("lighter")) {
            string2 = "EXTRA_LIGHT";
        } else if (string.equals("100")) {
            string2 = "THIN";
        } else if (string.equals("900")) {
            string2 = "BLACK";
        }
        this.textName = "textBox_" + this.textID;
        String string3 = JavaFXMLDisplay.rgbToColor(this.currentTextBlock.getColor());
        if (this.currentTextBlock.getRotationAngleInDegrees() == 0) {
            this.writeCustom(2, "\n\t<Label id=\"" + this.textName + "\" text =\"" + JavaFXMLDisplay.tidyQuotes(this.currentTextBlock.getOutputString(true)) + "\" layoutX=\"" + (float)((int)this.currentTextBlock.getX()) * this.scaling + "\" layoutY=\"" + (float)((int)(this.currentTextBlock.getY() + (float)this.fontSize)) * this.scaling + "\" prefWidth=\"" + (int)this.currentTextBlock.getWidth() + "\" prefHeight=\"" + this.currentTextBlock.getFontSize() + "\" style=\"-fx-font: " + string2 + " " + this.currentTextBlock.getFontSize() + " " + this.currentTextBlock.getFont() + "; -fx-text-fill: " + string3 + ";\"/>");
        } else {
            this.writeCustom(2, "\n\t<Label id=\"" + this.textName + "\" text =\"" + JavaFXMLDisplay.tidyQuotes(this.currentTextBlock.getOutputString(true)) + "\" layoutX=\"" + (float)((int)this.currentTextBlock.getX()) * this.scaling + "\" layoutY=\"" + (float)((int)(this.currentTextBlock.getY() + (float)this.fontSize)) * this.scaling + "\" prefWidth=\"" + (int)this.currentTextBlock.getWidth() + "\" prefHeight=\"" + this.currentTextBlock.getFontSize() + "\" rotate=\"" + n + "\" style=\"-fx-font: " + string2 + " " + this.currentTextBlock.getFontSize() + " " + this.currentTextBlock.getFont() + "; -fx-text-fill: " + string3 + ";\"/>");
        }
        String string4 = this.currentTextBlock.getStyle();
        if (f != 0.0f || !this.writeEveryGlyf) {
            // empty if block
        }
        switch (n) {
            case 90: {
                break;
            }
        }
        ++this.textID;
    }

    private static String tidyQuotes(String string) {
        if (string.contains("\"")) {
            string = string.replaceAll("\"", "\\\\\"");
        } else if (string.contains("&")) {
            string = string.replaceAll("&", "&amp;");
        }
        return string;
    }

    @Override
    public void setBooleanValue(int n, boolean bl) {
        switch (n) {
            case 4: {
                this.includeJSFontResizingCode = bl;
                break;
            }
            case 5: {
                this.putTextOnCanvas = bl;
                break;
            }
            default: {
                super.setBooleanValue(n, bl);
            }
        }
    }

    @Override
    public void setTag(int n, String string) {
        switch (n) {
            case 0: {
                this.tag[0] = string;
                break;
            }
            default: {
                super.setTag(n, string);
            }
        }
    }

    @Override
    public void drawEmbeddedText(float[][] fArray, int n, PdfGlyph pdfGlyph, Object object, int n2, GraphicsState graphicsState, AffineTransform affineTransform, String string, PdfFont pdfFont) {
        super.drawEmbeddedText(fArray, n, pdfGlyph, object, n2, graphicsState, affineTransform, string, pdfFont);
    }

    @Override
    public void drawShape(Shape shape, GraphicsState graphicsState, int n) {
    }

    @Override
    public int drawImage(int n, BufferedImage bufferedImage, GraphicsState graphicsState, boolean bl, String string, int n2, int n3) {
        int n4 = super.drawImage(n, bufferedImage, graphicsState, bl, string, n2, n3);
        if (n4 == -2) {
            float f = graphicsState.getAlpha(2);
            if (f < 1.0f) {
                this.writeCustom(2, "pdf.globalAlpha = " + f + "; ");
            }
            switch (this.pageRotation) {
                case 90: {
                    this.writeCustom(2, "\n\t<ImageView layoutX=\"" + (int)((double)this.cropBox.height - this.coords[1] - (double)this.ih) + "\" layoutY=\"" + (int)this.coords[0] + "\">");
                    this.writeCustom(2, "\t\t<image>");
                    this.writeCustom(2, "\t\t\t<Image url=\"@" + this.imageName.substring(1) + "\"/>");
                    this.writeCustom(2, "\t\t</image>");
                    this.writeCustom(2, "\t</ImageView>");
                }
                case 270: {
                    this.writeCustom(2, "\n\t<ImageView layoutX=\"" + (int)this.coords[1] + "\" layoutY=\"" + (int)this.coords[0] + "\">");
                    this.writeCustom(2, "\t\t<image>");
                    this.writeCustom(2, "\t\t\t<Image url=\"@" + this.imageName.substring(1) + "\"/>");
                    this.writeCustom(2, "\t\t</image>");
                    this.writeCustom(2, "\t</ImageView>");
                }
            }
            this.writeCustom(2, "\n\t<ImageView id=\"" + string + "\" layoutX=\"" + (int)this.coords[0] + "\" layoutY=\"" + (int)this.coords[1] + "\">");
            this.writeCustom(2, "\t\t<image>");
            this.writeCustom(2, "\t\t\t<Image url=\"@" + this.imageName.substring(1) + "\"/>");
            this.writeCustom(2, "\t\t</image>");
            this.writeCustom(2, "\t</ImageView>");
            if (f < 1.0f) {
                this.writeCustom(2, "pdf_canvas.globalAlpha = 1.0; ");
            }
        }
        return -1;
    }

    @Override
    public void setOutputDir(String string, String string2, String string3) {
        super.setOutputDir(string, string2, string3);
        this.javaFxFileName = "page" + string3;
        this.packageName = string2;
        if (this.packageName.contains(" ")) {
            this.packageName = this.packageName.replaceAll(" ", "_");
        }
    }

    @Override
    public void init(int n, int n2, int n3, Color color) {
        super.init(n, n2, n3, color);
        if (this.rootDir == null) {
            throw new RuntimeException("Please pass in output_dir (second param if running ExtractpageAsJavaFX");
        }
        try {
            this.output = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.rootDir + this.javaFxFileName + ".fxml"), this.encodingType[0]));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public synchronized void writeCustom(int n, Object object) {
        switch (n) {
            case 0: {
                try {
                    this.output.write(object.toString());
                    this.output.write(10);
                    this.output.flush();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 1: {
                this.topSection.append('\t');
                this.topSection.append(object.toString());
                this.topSection.append('\n');
                break;
            }
            case 2: {
                this.script.append('\t');
                this.script.append(object.toString());
                this.script.append('\n');
                break;
            }
            case 3: {
                this.form.append(object.toString());
                break;
            }
            case 5: {
                this.images.append(object.toString());
                break;
            }
            case 6: {
                this.testDivs.append(object.toString());
                break;
            }
            case 4: {
                this.css.append(object.toString());
                this.css.append('\n');
                break;
            }
            case 13: {
                this.javaFXMLMethods.append(object.toString());
                this.javaFXMLMethods.append('\n');
                break;
            }
            case 7: {
                try {
                    this.writeEveryGlyf = (Boolean)object;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 8: {
                try {
                    this.encodingType = (String[])object;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 9: {
                if (this.jsImagesAdded) break;
                this.writeCustom(1, object);
                this.jsImagesAdded = true;
                break;
            }
            case 10: {
                Object object2;
                Object[] objectArray = (Object[])object;
                PdfFont pdfFont = (PdfFont)objectArray[0];
                String string = pdfFont.getFontName();
                String string2 = (String)objectArray[2];
                String string3 = this.rootDir + this.javaFxFileName + "/";
                File file = new File(string3);
                if (!file.exists()) {
                    file.mkdirs();
                }
                try {
                    object2 = new BufferedOutputStream(new FileOutputStream(string3 + string + "." + string2));
                    ((FilterOutputStream)object2).write((byte[])objectArray[1]);
                    ((BufferedOutputStream)object2).flush();
                    ((FilterOutputStream)object2).close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                object2 = new StringBuffer();
                ((StringBuffer)object2).append("@font-face {\n");
                ((StringBuffer)object2).append("\tfont-family: " + string + ";\n");
                ((StringBuffer)object2).append("\tsrc: url(\"" + this.javaFxFileName + "/" + string + "." + string2 + "\");\n");
                ((StringBuffer)object2).append("}\n");
                this.writeCustom(4, object2);
                break;
            }
            default: {
                super.writeCustom(n, object);
            }
        }
    }

    @Override
    protected void flushText() {
        if (this.currentTextBlock == null || this.currentTextBlock.isEmpty()) {
            return;
        }
        this.writeoutJavaFXText();
        if (!this.currentTextBlock.isEmpty()) {
            this.previousTextBlock = this.currentTextBlock;
        }
        this.currentTextBlock = new TextBlock(this.putTextOnCanvas);
    }

    @Override
    protected void drawPatternedShape(Shape shape, GraphicsState graphicsState) {
    }

    protected void drawNonPatternedShape(Shape shape, GraphicsState graphicsState, int n) {
    }

    @Override
    protected void drawTextArea() {
        if (this.currentTextBlock.isEmpty()) {
            return;
        }
        int n = this.putTextOnCanvas ? 0 : this.currentTextBlock.getFontSize();
        double[] dArray = new double[]{this.currentTextBlock.getX(), (int)this.currentTextBlock.getY() + n};
        this.writeCustom(2, "pdf.moveTo(" + this.coordsToStringParam(dArray, 2) + ");");
        dArray[0] = this.currentTextBlock.getX() + this.currentTextBlock.getWidth();
        this.writeCustom(2, "pdf.lineTo(" + this.coordsToStringParam(dArray, 2) + ");");
        dArray[1] = this.currentTextBlock.getY() - (float)this.currentTextBlock.getFontSize() + (float)n;
        this.writeCustom(2, "pdf.lineTo(" + this.coordsToStringParam(dArray, 2) + ");");
        dArray[0] = this.currentTextBlock.getX();
        this.writeCustom(2, "pdf.lineTo(" + this.coordsToStringParam(dArray, 2) + ");");
        this.writeCustom(2, "pdf.closePath();");
        this.writeCustom(2, "pdf.strokeStyle = '" + JavaFXMLDisplay.rgbToColor(200) + "';");
        this.writeCustom(2, "pdf.lineWidth = '1'");
        this.writeCustom(2, "pdf.stroke();");
    }

    @Override
    protected void drawPageBorder() {
        double[] dArray = new double[]{this.cropBox.x, this.cropBox.y};
        this.writeCustom(2, "pdf.moveTo(" + this.coordsToStringParam(dArray, 2) + ");");
        dArray[0] = dArray[0] + (double)this.cropBox.width;
        this.writeCustom(2, "pdf.lineTo(" + this.coordsToStringParam(dArray, 2) + ");");
        dArray[1] = dArray[1] + (double)this.cropBox.height;
        this.writeCustom(2, "pdf.lineTo(" + this.coordsToStringParam(dArray, 2) + ");");
        dArray[0] = dArray[0] - (double)this.cropBox.width;
        this.writeCustom(2, "pdf.lineTo(" + this.coordsToStringParam(dArray, 2) + ");");
        this.writeCustom(2, "pdf.closePath();");
        this.writeCustom(2, "pdf.strokeStyle = '" + JavaFXMLDisplay.rgbToColor(0) + "';");
        this.writeCustom(2, "pdf.lineWidth = '1'");
        this.writeCustom(2, "pdf.stroke();");
    }

    @Override
    protected FontMapper getFontMapper(PdfFont pdfFont) {
        return new JavaFXFontMapper(pdfFont.getFontName(), this.fontMode, pdfFont.isFontEmbedded);
    }
}

