/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui.popups;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.gui.popups.WizardPanelModel;
import org.jpedal.examples.simpleviewer.objects.SignData;
import org.jpedal.examples.simpleviewer.utils.FileFilterer;
import org.jpedal.exception.PdfException;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;
import org.jpedal.utils.Messages;

public class SignWizardModel
implements WizardPanelModel {
    private static final String MODE_SELECT = "0";
    private static final String PFX_PANEL = "1";
    private static final String KEYSTORE_PANEL = "3";
    private static final String COMMON_PANEL = "4";
    private static final String ENCRYPTION_PANEL = "5";
    private static final String VISIBLE_SIGNATURE_PANEL = "6";
    public static final String NO_FILE_SELECTED = Messages.getMessage("PdfSigner.NoFileSelected");
    private static final int MAXIMUM_PANELS = 5;
    private SignData signData;
    private PdfDecoder pdfDecoder;
    private String rootDir;
    private ModeSelect modeSelect;
    private PFXPanel pFXPanel;
    private KeystorePanel keystorePanel;
    private CommonPanel commonPanel;
    private EncryptionPanel encryptionPanel;
    private SignaturePanel signaturePanel;
    private Map panels;
    private String currentPanel;

    public SignWizardModel(SignData signData, String string, String string2) {
        String string3;
        this.signData = signData;
        this.rootDir = string2;
        this.pdfDecoder = new PdfDecoder();
        try {
            this.pdfDecoder.openPdfFile(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.pdfDecoder.isEncrypted() && (string3 = System.getProperty("org.jpedal.password")) != null) {
            try {
                this.pdfDecoder.setEncryptionPassword(string3);
            }
            catch (PdfException pdfException) {
                pdfException.printStackTrace();
            }
        }
        this.testForSignedPDF();
        this.panels = new HashMap();
        this.modeSelect = new ModeSelect();
        this.pFXPanel = new PFXPanel();
        this.keystorePanel = new KeystorePanel();
        this.commonPanel = new CommonPanel();
        this.encryptionPanel = new EncryptionPanel();
        this.signaturePanel = new SignaturePanel();
        this.panels.put(MODE_SELECT, this.modeSelect);
        this.panels.put(PFX_PANEL, this.pFXPanel);
        this.panels.put(KEYSTORE_PANEL, this.keystorePanel);
        this.panels.put(COMMON_PANEL, this.commonPanel);
        this.panels.put(ENCRYPTION_PANEL, this.encryptionPanel);
        this.panels.put(VISIBLE_SIGNATURE_PANEL, this.signaturePanel);
        this.currentPanel = MODE_SELECT;
    }

    public Map getJPanels() {
        return this.panels;
    }

    public String next() {
        this.updateSignData();
        if (this.currentPanel.equals(MODE_SELECT)) {
            if (!this.signData.isKeystoreSign()) {
                this.currentPanel = PFX_PANEL;
                return PFX_PANEL;
            }
            this.currentPanel = KEYSTORE_PANEL;
            return KEYSTORE_PANEL;
        }
        if (this.currentPanel.equals(PFX_PANEL)) {
            this.currentPanel = VISIBLE_SIGNATURE_PANEL;
            return VISIBLE_SIGNATURE_PANEL;
        }
        if (this.currentPanel.equals(KEYSTORE_PANEL)) {
            this.currentPanel = VISIBLE_SIGNATURE_PANEL;
            return VISIBLE_SIGNATURE_PANEL;
        }
        if (this.currentPanel.equals(VISIBLE_SIGNATURE_PANEL)) {
            this.currentPanel = ENCRYPTION_PANEL;
            return ENCRYPTION_PANEL;
        }
        if (this.currentPanel.equals(ENCRYPTION_PANEL)) {
            this.currentPanel = COMMON_PANEL;
            return COMMON_PANEL;
        }
        throw new NullPointerException("Whoops! Tried to move to a nextID where there is no nextID to be had");
    }

    public String previous() {
        this.updateSignData();
        if (this.currentPanel.equals(PFX_PANEL) || this.currentPanel.equals(KEYSTORE_PANEL)) {
            this.currentPanel = MODE_SELECT;
            return MODE_SELECT;
        }
        if (this.currentPanel.equals(ENCRYPTION_PANEL)) {
            this.currentPanel = VISIBLE_SIGNATURE_PANEL;
            return VISIBLE_SIGNATURE_PANEL;
        }
        if (this.currentPanel.equals(VISIBLE_SIGNATURE_PANEL)) {
            if (this.signData.isKeystoreSign()) {
                this.currentPanel = KEYSTORE_PANEL;
                return KEYSTORE_PANEL;
            }
            this.currentPanel = PFX_PANEL;
            return PFX_PANEL;
        }
        if (this.currentPanel.equals(COMMON_PANEL)) {
            this.currentPanel = ENCRYPTION_PANEL;
            return ENCRYPTION_PANEL;
        }
        throw new NullPointerException("Tried to move to get a previousID where there is no previous");
    }

    public boolean hasPrevious() {
        return !this.currentPanel.equals(MODE_SELECT);
    }

    public String getStartPanelID() {
        return MODE_SELECT;
    }

    public boolean isFinishPanel() {
        return this.currentPanel == COMMON_PANEL;
    }

    public boolean canAdvance() {
        if (this.currentPanel.equals(COMMON_PANEL)) {
            return this.commonPanel.canFinish();
        }
        if (this.currentPanel.equals(PFX_PANEL)) {
            return this.pFXPanel.canAdvance();
        }
        if (this.currentPanel.equals(KEYSTORE_PANEL)) {
            return this.keystorePanel.canAdvance();
        }
        if (this.currentPanel.equals(ENCRYPTION_PANEL)) {
            return this.encryptionPanel.canAdvance();
        }
        return true;
    }

    public void updateSignData() {
        if (this.currentPanel.equals(PFX_PANEL)) {
            this.pFXPanel.collectData();
        } else if (this.currentPanel.equals(KEYSTORE_PANEL)) {
            this.keystorePanel.collectData();
        } else if (this.currentPanel.equals(COMMON_PANEL)) {
            this.commonPanel.collectData();
        } else if (this.currentPanel.equals(ENCRYPTION_PANEL)) {
            this.encryptionPanel.collectData();
        } else if (this.currentPanel.equals(MODE_SELECT)) {
            this.modeSelect.collectData();
        } else if (this.currentPanel.equals(VISIBLE_SIGNATURE_PANEL)) {
            this.signaturePanel.collectData();
        } else {
            throw new NullPointerException("Tried to update a panel which doesnt exist");
        }
    }

    public void registerNextChangeListeners(ChangeListener changeListener) {
        this.commonPanel.registerChange(changeListener);
        this.pFXPanel.registerChange(changeListener);
        this.keystorePanel.registerChange(changeListener);
        this.encryptionPanel.registerChange(changeListener);
    }

    public void registerNextKeyListeners(KeyListener keyListener) {
        this.pFXPanel.registerListener(keyListener);
        this.keystorePanel.registerNextKeyListeners(keyListener);
        this.encryptionPanel.registerNextKeyListeners(keyListener);
    }

    public void close() {
        this.updateSignData();
        this.pdfDecoder.closePdfFile();
    }

    private void testForSignedPDF() {
        this.signData.setAppend(false);
        for (int i = 1; i <= this.pdfDecoder.getPageCount(); ++i) {
            try {
                this.pdfDecoder.decodePage(i);
                this.pdfDecoder.waitForDecodingToFinish();
                AcroRenderer acroRenderer = this.pdfDecoder.getFormRenderer();
                Iterator iterator = acroRenderer.getSignatureObjects();
                if (iterator == null) continue;
                this.signData.setAppend(true);
                break;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private boolean isPdfSigned() {
        return this.signData.isAppendMode();
    }

    private static class PanelTemplate
    extends JPanel {
        public PanelTemplate() {
            boolean bl = false;
            this.setLayout(new BorderLayout());
            this.add((Component)new TitlePanel("Template"), "North");
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            this.add((Component)new ProgressPanel(3), "South");
        }
    }

    private static class TitlePanel
    extends JPanel {
        public TitlePanel(String string) {
            this.setBackground(Color.gray);
            this.setBorder(BorderFactory.createEtchedBorder(0));
            JLabel jLabel = new JLabel();
            jLabel.setBackground(Color.gray);
            jLabel.setFont(new Font("Dialog", 1, 14));
            jLabel.setText(string);
            jLabel.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
            jLabel.setOpaque(true);
            this.add(jLabel);
        }
    }

    private static class ProgressPanel
    extends JPanel {
        public ProgressPanel(int n) {
            this.setBorder(new EtchedBorder());
            JLabel jLabel = new JLabel("Step " + n + " of " + 5);
            jLabel.setAlignmentX(1.0f);
            this.add(jLabel);
        }
    }

    private class SignaturePanel
    extends JPanel {
        private JCheckBox visibleCheck = new JCheckBox(Messages.getMessage("PdfSigner.VisibleSignature"));
        private JComponent sigPreviewComp;
        private JSlider pageSlider;
        private JLabel pageNumberLabel;
        private int currentPage = 1;
        private Point signRectOrigin;
        private Point signRectEnd;
        private int offsetX;
        private int offsetY;
        private float scale;
        private int previewWidth;
        private int previewHeight;
        private volatile boolean drawRect = false;
        private boolean signAreaUndefined = true;
        private BufferedImage previewImage;

        public SignaturePanel() {
            try {
                this.previewImage = SignWizardModel.this.pdfDecoder.getPageAsImage(this.currentPage);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n = 0;
            this.setLayout(new BorderLayout());
            this.add((Component)new TitlePanel(Messages.getMessage("PdfSigner.VisibleSignature") + " " + Messages.getMessage("PdfViewerMenu.options")), "North");
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 19;
            this.visibleCheck.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SignaturePanel.this.sigPreviewComp.repaint();
                    if (SignWizardModel.this.pdfDecoder.getPageCount() > 1) {
                        SignaturePanel.this.pageSlider.setEnabled(SignaturePanel.this.visibleCheck.isSelected());
                    }
                }
            });
            jPanel.add((Component)this.visibleCheck, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(10, 0, 10, 0);
            jPanel.add((Component)new JSeparator(0), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 2;
            jPanel.add((Component)this.previewPanel(), gridBagConstraints);
            this.add((Component)jPanel, "Center");
            this.add((Component)new ProgressPanel(3), "South");
        }

        public void collectData() {
            SignWizardModel.this.signData.setVisibleSignature(this.visibleCheck.isSelected());
            if (this.visibleCheck.isSelected()) {
                int n = this.previewImage.getHeight();
                int n2 = (int)((this.signRectOrigin.getX() - (double)this.offsetX) / (double)this.scale);
                int n3 = (int)((double)n - (this.signRectOrigin.getY() - (double)this.offsetY) / (double)this.scale);
                int n4 = (int)((this.signRectEnd.getX() - (double)this.offsetX) / (double)this.scale);
                int n5 = (int)((double)n - (this.signRectEnd.getY() - (double)this.offsetY) / (double)this.scale);
                PdfPageData pdfPageData = SignWizardModel.this.pdfDecoder.getPdfPageData();
                int n6 = pdfPageData.getCropBoxX(this.currentPage);
                int n7 = pdfPageData.getCropBoxY(this.currentPage);
                SignWizardModel.this.signData.setRectangle(n2 += n6, n3 += n7, n4 += n6, n5 += n7);
                SignWizardModel.this.signData.setSignPage(this.currentPage);
            }
        }

        private JPanel previewPanel() {
            JPanel jPanel = new JPanel(new BorderLayout());
            this.sigPreviewComp = new JComponent(){

                public void paintComponent(Graphics graphics) {
                    SignaturePanel.this.sigPreview(graphics);
                }
            };
            this.sigPreviewComp.setPreferredSize(new Dimension(200, 200));
            this.sigPreviewComp.setToolTipText(Messages.getMessage("PdfSigner.ClickAndDrag"));
            this.sigPreviewComp.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent mouseEvent) {
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                }

                public void mouseExited(MouseEvent mouseEvent) {
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    if (SignaturePanel.this.visibleCheck.isSelected()) {
                        SignaturePanel.this.signRectOrigin.setLocation(mouseEvent.getX(), mouseEvent.getY());
                        SignaturePanel.this.drawRect = true;
                        Thread thread = new Thread(SignaturePanel.this.signAreaThread());
                        thread.start();
                    }
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    if (SignaturePanel.this.visibleCheck.isSelected()) {
                        SignaturePanel.this.drawRect = false;
                        SignaturePanel.this.sigPreviewComp.repaint();
                    }
                }
            });
            jPanel.add((Component)this.sigPreviewComp, "Center");
            if (SignWizardModel.this.pdfDecoder.getPageCount() > 1) {
                this.pageNumberLabel = new JLabel(Messages.getMessage("PdfSigner.PageNumber") + " " + this.currentPage);
                this.pageNumberLabel.setHorizontalAlignment(0);
                jPanel.add((Component)this.pageNumberLabel, "North");
                this.pageSlider = new JSlider(0, 1, SignWizardModel.this.pdfDecoder.getPageCount(), this.currentPage);
                this.pageSlider.setMajorTickSpacing(SignWizardModel.this.pdfDecoder.getPageCount() - 1);
                this.pageSlider.setPaintLabels(true);
                this.pageSlider.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                        if (SignaturePanel.this.pageSlider.getValueIsAdjusting()) {
                            SignaturePanel.this.currentPage = SignaturePanel.this.pageSlider.getValue();
                            try {
                                SignaturePanel.this.previewImage = SignWizardModel.this.pdfDecoder.getPageAsImage(SignaturePanel.this.currentPage);
                                SignaturePanel.this.sigPreviewComp.repaint();
                                SignaturePanel.this.pageNumberLabel.setText(Messages.getMessage("PdfSigner.PageNumber") + " " + SignaturePanel.this.currentPage);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                });
                jPanel.add((Component)this.pageSlider, "South");
                this.pageSlider.setEnabled(false);
            }
            return jPanel;
        }

        private void sigPreview(Graphics graphics) {
            int n = this.sigPreviewComp.getWidth();
            int n2 = this.sigPreviewComp.getHeight();
            this.previewWidth = this.previewImage.getWidth();
            this.previewHeight = this.previewImage.getHeight();
            this.scale = this.previewWidth > this.previewHeight ? (float)n / (float)this.previewWidth : (float)n2 / (float)this.previewHeight;
            this.previewWidth = (int)((float)this.previewWidth * this.scale);
            this.previewHeight = (int)((float)this.previewHeight * this.scale);
            this.offsetX = (n - this.previewWidth) / 2;
            this.offsetY = (n2 - this.previewHeight) / 2;
            graphics.drawImage(this.previewImage, this.offsetX, this.offsetY, this.previewWidth, this.previewHeight, null);
            if (this.visibleCheck.isSelected()) {
                graphics.clipRect(this.offsetX, this.offsetY, this.previewWidth, this.previewHeight);
                this.drawSignBox(graphics);
            }
        }

        private void drawSignBox(Graphics graphics) {
            int n;
            if (this.signAreaUndefined) {
                PdfPageData pdfPageData = SignWizardModel.this.pdfDecoder.getPdfPageData();
                this.signRectOrigin = new Point(this.offsetX, this.offsetY);
                this.signRectEnd = new Point((int)((float)pdfPageData.getCropBoxWidth(this.currentPage) * this.scale) - 1 + this.offsetX, (int)((float)pdfPageData.getCropBoxHeight(this.currentPage) * this.scale) - 1 + this.offsetY);
                this.signAreaUndefined = false;
            }
            int n2 = (int)this.signRectOrigin.getX();
            int n3 = (int)this.signRectOrigin.getY();
            int n4 = (int)this.signRectEnd.getX();
            int n5 = (int)this.signRectEnd.getY();
            if (n2 > n4) {
                n = n4;
                n4 = n2;
                n2 = n;
            }
            if (n3 > n5) {
                n = n3;
                n3 = n5;
                n5 = n;
            }
            graphics.drawRect(n2, n3, n4 - n2, n5 - n3);
            graphics.drawLine(n2, n3, n4, n5);
            graphics.drawLine(n2, n5, n4, n3);
        }

        private Runnable signAreaThread() {
            return new Runnable(){

                public void run() {
                    Point point = SignaturePanel.this.sigPreviewComp.getLocationOnScreen();
                    while (SignaturePanel.this.drawRect) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        double d = MouseInfo.getPointerInfo().getLocation().getX() - point.getX();
                        double d2 = MouseInfo.getPointerInfo().getLocation().getY() - point.getY();
                        SignaturePanel.this.signRectEnd.setLocation(d, d2);
                        SignaturePanel.this.sigPreviewComp.repaint();
                    }
                }
            };
        }
    }

    private class EncryptionPanel
    extends JPanel {
        private JCheckBox encryptionCheck = new JCheckBox("Encrypt");
        private JCheckBox allowPrinting = new JCheckBox("Allow Printing");
        private JCheckBox allowModifyContent = new JCheckBox("Allow Content Modification");
        private JCheckBox allowCopy = new JCheckBox("Allow Copy");
        private JCheckBox allowModifyAnnotation = new JCheckBox("Allow Annotation Modification");
        private JCheckBox allowFillIn = new JCheckBox("Allow Fill In");
        private JCheckBox allowScreenReader = new JCheckBox("Allow Screen Reader");
        private JCheckBox allowAssembly = new JCheckBox("Allow Assembly");
        private JCheckBox allowDegradedPrinting = new JCheckBox("Allow Degraded Printing");
        private JPasswordField userPassword = new JPasswordField();
        private JPasswordField ownerPassword = new JPasswordField();
        private JCheckBox flatten = new JCheckBox("Flatten PDF");
        private JCheckBox visiblePassUserCheck = new JCheckBox();
        private JCheckBox visiblePassOwnerCheck = new JCheckBox();
        private boolean ownerAdvance = false;
        private volatile boolean canAdvance = true;

        public EncryptionPanel() {
            int n = 0;
            this.setLayout(new BorderLayout());
            this.add((Component)new TitlePanel(Messages.getMessage("PdfSigner.EncryptionOptions")), "North");
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 19;
            this.encryptionCheck.setEnabled(!SignWizardModel.this.isPdfSigned());
            this.encryptionCheck.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    EncryptionPanel.this.canAdvance = !EncryptionPanel.this.encryptionCheck.isSelected() || EncryptionPanel.this.ownerAdvance;
                }
            });
            jPanel.add((Component)this.encryptionCheck, gridBagConstraints);
            this.encryptionCheck.setSelected(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 24;
            this.flatten.setEnabled(!SignWizardModel.this.isPdfSigned());
            jPanel.add((Component)this.flatten, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            ++n;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.fill = 2;
            jPanel.add((Component)new JSeparator(0), gridBagConstraints);
            this.allowPrinting.setEnabled(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 2;
            jPanel.add((Component)this.allowPrinting, gridBagConstraints);
            this.allowModifyContent.setEnabled(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 2;
            jPanel.add((Component)this.allowModifyContent, gridBagConstraints);
            this.allowCopy.setEnabled(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 2;
            jPanel.add((Component)this.allowCopy, gridBagConstraints);
            this.allowModifyAnnotation.setEnabled(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 2;
            jPanel.add((Component)this.allowModifyAnnotation, gridBagConstraints);
            this.allowFillIn.setEnabled(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 2;
            jPanel.add((Component)this.allowFillIn, gridBagConstraints);
            this.allowScreenReader.setEnabled(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 2;
            jPanel.add((Component)this.allowScreenReader, gridBagConstraints);
            this.allowAssembly.setEnabled(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 2;
            jPanel.add((Component)this.allowAssembly, gridBagConstraints);
            this.allowDegradedPrinting.setEnabled(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 2;
            jPanel.add((Component)this.allowDegradedPrinting, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.fill = 2;
            jPanel.add((Component)new JSeparator(0), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            jPanel.add((Component)new JLabel(Messages.getMessage("PdfSigner.UserPassword")), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            this.userPassword.setEnabled(false);
            this.userPassword.setPreferredSize(new Dimension(100, 20));
            this.userPassword.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent keyEvent) {
                }

                public void keyPressed(KeyEvent keyEvent) {
                }

                public void keyTyped(KeyEvent keyEvent) {
                    EncryptionPanel.this.ownerAdvance = true;
                    EncryptionPanel.this.canAdvance = true;
                }
            });
            jPanel.add((Component)this.userPassword, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.visiblePassUserCheck.setToolTipText(Messages.getMessage("PdfSigner.ShowPassword"));
            this.visiblePassUserCheck.addActionListener(new ActionListener(){
                private char defaultChar;

                public void actionPerformed(ActionEvent actionEvent) {
                    if (EncryptionPanel.this.visiblePassUserCheck.isSelected()) {
                        this.defaultChar = EncryptionPanel.this.userPassword.getEchoChar();
                        EncryptionPanel.this.userPassword.setEchoChar('\u0000');
                    } else {
                        EncryptionPanel.this.userPassword.setEchoChar(this.defaultChar);
                    }
                }
            });
            this.visiblePassUserCheck.setEnabled(false);
            jPanel.add((Component)this.visiblePassUserCheck, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            jPanel.add((Component)new JLabel(Messages.getMessage("PdfSigner.OwnerPassword")), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            this.ownerPassword.setEnabled(false);
            this.ownerPassword.setPreferredSize(new Dimension(100, 20));
            jPanel.add((Component)this.ownerPassword, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.visiblePassOwnerCheck.setToolTipText(Messages.getMessage("PdfSigner.ShowPassword"));
            this.visiblePassOwnerCheck.addActionListener(new ActionListener(){
                private char defaultChar;

                public void actionPerformed(ActionEvent actionEvent) {
                    if (EncryptionPanel.this.visiblePassOwnerCheck.isSelected()) {
                        this.defaultChar = EncryptionPanel.this.ownerPassword.getEchoChar();
                        EncryptionPanel.this.ownerPassword.setEchoChar('\u0000');
                    } else {
                        EncryptionPanel.this.ownerPassword.setEchoChar(this.defaultChar);
                    }
                }
            });
            this.visiblePassOwnerCheck.setEnabled(false);
            jPanel.add((Component)this.visiblePassOwnerCheck, gridBagConstraints);
            if (SignWizardModel.this.isPdfSigned()) {
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.fill = 2;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = n;
                gridBagConstraints.gridwidth = 3;
                gridBagConstraints.insets = new Insets(25, 0, 0, 0);
                JLabel jLabel = new JLabel(Messages.getMessage("PdfSigner.DisabledSigned"), 0);
                jLabel.setForeground(Color.red);
                jPanel.add((Component)jLabel, gridBagConstraints);
            }
            this.encryptionCheck.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    boolean bl = itemEvent.getStateChange() == 1;
                    EncryptionPanel.this.allowPrinting.setEnabled(bl);
                    EncryptionPanel.this.allowModifyContent.setEnabled(bl);
                    EncryptionPanel.this.allowCopy.setEnabled(bl);
                    EncryptionPanel.this.allowModifyAnnotation.setEnabled(bl);
                    EncryptionPanel.this.allowFillIn.setEnabled(bl);
                    EncryptionPanel.this.allowScreenReader.setEnabled(bl);
                    EncryptionPanel.this.allowAssembly.setEnabled(bl);
                    EncryptionPanel.this.allowDegradedPrinting.setEnabled(bl);
                    EncryptionPanel.this.userPassword.setEnabled(bl);
                    EncryptionPanel.this.ownerPassword.setEnabled(bl);
                    EncryptionPanel.this.visiblePassUserCheck.setEnabled(bl);
                    EncryptionPanel.this.visiblePassOwnerCheck.setEnabled(bl);
                }
            });
            this.add((Component)jPanel, "Center");
            this.add((Component)new ProgressPanel(4), "South");
        }

        public void registerChange(ChangeListener changeListener) {
            this.encryptionCheck.addChangeListener(changeListener);
        }

        public void registerNextKeyListeners(KeyListener keyListener) {
            this.userPassword.addKeyListener(keyListener);
        }

        public boolean canAdvance() {
            return this.canAdvance;
        }

        public void collectData() {
            SignWizardModel.this.signData.setFlatten(this.flatten.isSelected());
            SignWizardModel.this.signData.setEncrypt(this.encryptionCheck.isSelected());
            if (this.encryptionCheck.isSelected()) {
                SignWizardModel.this.signData.setEncryptUserPass(this.userPassword.getPassword());
                SignWizardModel.this.signData.setEncryptOwnerPass(this.ownerPassword.getPassword());
                int n = 0;
                if (this.allowPrinting.isSelected()) {
                    n |= 0xFFFFFFFF;
                }
                if (this.allowModifyContent.isSelected()) {
                    n |= 0xFFFFFFFF;
                }
                if (this.allowCopy.isSelected()) {
                    n |= 0xFFFFFFFF;
                }
                if (this.allowModifyAnnotation.isSelected()) {
                    n |= 0xFFFFFFFF;
                }
                if (this.allowFillIn.isSelected()) {
                    n |= 0xFFFFFFFF;
                }
                if (this.allowScreenReader.isSelected()) {
                    n |= 0xFFFFFFFF;
                }
                if (this.allowAssembly.isSelected()) {
                    n |= 0xFFFFFFFF;
                }
                if (this.allowDegradedPrinting.isSelected()) {
                    n |= 0xFFFFFFFF;
                }
                SignWizardModel.this.signData.setEncryptPermissions(n);
            }
        }
    }

    private class CommonPanel
    extends JPanel {
        private JLabel reasonLabel = new JLabel();
        private JTextField signerReasonArea = new JTextField();
        private JLabel locationLabel = new JLabel();
        private JTextField signerLocationField = new JTextField();
        private JLabel outputFileLabel = new JLabel();
        private JLabel currentOutputFilePath = new JLabel();
        private JButton browseOutputButton = new JButton();
        private volatile boolean canAdvance = false;

        public CommonPanel() {
            try {
                this.init();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private void init() {
            this.setLayout(new BorderLayout());
            this.add((Component)new TitlePanel(Messages.getMessage("PdfSigner.ReasonAndLocation")), "North");
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setBorder(BorderFactory.createEtchedBorder(1));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.reasonLabel.setText(Messages.getMessage("PdfSigner.Reason") + ":");
            this.reasonLabel.setFont(new Font("Dialog", 1, 14));
            gridBagConstraints.anchor = 23;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(10, 0, 0, 0);
            jPanel.add((Component)this.reasonLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.insets = new Insets(10, 0, 10, 0);
            this.signerReasonArea.setPreferredSize(new Dimension(200, 20));
            jPanel.add((Component)this.signerReasonArea, gridBagConstraints);
            this.locationLabel.setText(Messages.getMessage("PdfSigner.Location") + ":");
            this.locationLabel.setFont(new Font("Dialog", 1, 14));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            jPanel.add((Component)this.locationLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints.gridwidth = 3;
            this.signerLocationField.setPreferredSize(new Dimension(200, 20));
            jPanel.add((Component)this.signerLocationField, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.insets = new Insets(10, 0, 0, 0);
            jPanel.add((Component)new JSeparator(0), gridBagConstraints);
            this.outputFileLabel.setText(Messages.getMessage("PdfSigner.OutputFile"));
            this.outputFileLabel.setFont(new Font("Dialog", 1, 14));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.insets = new Insets(5, 10, 0, 0);
            jPanel.add((Component)this.outputFileLabel, gridBagConstraints);
            this.currentOutputFilePath.setText(NO_FILE_SELECTED);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 6;
            gridBagConstraints.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints.gridwidth = 3;
            this.currentOutputFilePath.setPreferredSize(new Dimension(100, 20));
            jPanel.add((Component)this.currentOutputFilePath, gridBagConstraints);
            this.browseOutputButton.setText(Messages.getMessage("PdfViewerOption.Browse"));
            this.browseOutputButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser(SignWizardModel.this.rootDir);
                    int n = jFileChooser.showSaveDialog(null);
                    File file = jFileChooser.getSelectedFile();
                    if (file != null && n == 0) {
                        if (file.exists()) {
                            JOptionPane.showMessageDialog(null, Messages.getMessage("PdfSigner.PleaseChooseAnotherFile"), Messages.getMessage("PdfViewerGeneralError.message"), 0);
                            CommonPanel.this.canAdvance = false;
                            CommonPanel.this.currentOutputFilePath.setText(NO_FILE_SELECTED);
                            SignWizardModel.this.signData.setOutputFilePath(null);
                        } else if (file.isDirectory()) {
                            JOptionPane.showMessageDialog(null, Messages.getMessage("PdfSigner.NoFileSelected"), Messages.getMessage("PdfViewerGeneralError.message"), 0);
                            CommonPanel.this.canAdvance = false;
                            CommonPanel.this.currentOutputFilePath.setText(NO_FILE_SELECTED);
                        } else {
                            CommonPanel.this.currentOutputFilePath.setText(file.getAbsolutePath());
                            CommonPanel.this.canAdvance = true;
                        }
                    }
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.insets = new Insets(5, 25, 0, 25);
            gridBagConstraints.anchor = 26;
            jPanel.add((Component)this.browseOutputButton, gridBagConstraints);
            this.add((Component)jPanel, "Center");
            this.add((Component)new ProgressPanel(5), "South");
        }

        public boolean canFinish() {
            return this.canAdvance;
        }

        public void registerChange(ChangeListener changeListener) {
            this.browseOutputButton.addChangeListener(changeListener);
        }

        public void collectData() {
            SignWizardModel.this.signData.setReason(this.signerReasonArea.getText());
            SignWizardModel.this.signData.setLocation(this.signerLocationField.getText());
            SignWizardModel.this.signData.setOutputFilePath(this.currentOutputFilePath.getText());
        }
    }

    private class KeystorePanel
    extends JPanel {
        private JLabel keyStoreLabel = new JLabel();
        private JLabel currentKeyStorePath = new JLabel(NO_FILE_SELECTED);
        private JButton browseKeyStoreButton = new JButton();
        private JLabel passwordKeyStoreLabel = new JLabel();
        private JPasswordField passwordKeyStoreField = new JPasswordField();
        private JCheckBox visiblePassKeyCheck = new JCheckBox();
        private JLabel aliasNameLabel = new JLabel();
        private JTextField aliasNameField = new JTextField();
        private JLabel aliasPasswordLabel = new JLabel();
        private JPasswordField aliasPasswordField = new JPasswordField();
        private JCheckBox visiblePassAliasCheck = new JCheckBox();
        private volatile boolean storeAdvance;
        private volatile boolean storePassAdvance;
        private volatile boolean aliasAdvance;
        private volatile boolean aliasPassAdvance = false;

        public KeystorePanel() {
            try {
                this.init();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private void init() {
            this.setLayout(new BorderLayout());
            this.add((Component)new TitlePanel(Messages.getMessage("PdfSigner.KeyStoreMode")), "North");
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setBorder(BorderFactory.createEtchedBorder(1));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.keyStoreLabel.setText(Messages.getMessage("PdfSigner.SelectKeyStore"));
            this.keyStoreLabel.setFont(new Font("Dialog", 1, 14));
            gridBagConstraints.anchor = 23;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(0, 10, 10, 0);
            jPanel.add((Component)this.keyStoreLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.insets = new Insets(0, 20, 0, 10);
            this.currentKeyStorePath.setPreferredSize(new Dimension(250, 20));
            jPanel.add((Component)this.currentKeyStorePath, gridBagConstraints);
            this.browseKeyStoreButton.setText(Messages.getMessage("PdfViewerOption.Browse"));
            this.browseKeyStoreButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser(SignWizardModel.this.rootDir);
                    jFileChooser.setFileHidingEnabled(false);
                    int n = jFileChooser.showOpenDialog(null);
                    File file = jFileChooser.getSelectedFile();
                    if (file != null && n == 0) {
                        KeystorePanel.this.currentKeyStorePath.setText(file.getAbsolutePath());
                        KeystorePanel.this.storeAdvance = true;
                    }
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 30, 0, 0);
            jPanel.add((Component)this.browseKeyStoreButton, gridBagConstraints);
            this.passwordKeyStoreLabel.setText(Messages.getMessage("PdfSigner.Password"));
            this.passwordKeyStoreLabel.setFont(new Font("Dialog", 1, 14));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.insets = new Insets(30, 10, 0, 10);
            jPanel.add((Component)this.passwordKeyStoreLabel, gridBagConstraints);
            this.passwordKeyStoreField.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent keyEvent) {
                }

                public void keyPressed(KeyEvent keyEvent) {
                }

                public void keyTyped(KeyEvent keyEvent) {
                    KeystorePanel.this.storePassAdvance = true;
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.insets = new Insets(30, 10, 0, 10);
            jPanel.add((Component)this.passwordKeyStoreField, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.insets = new Insets(30, 0, 0, 0);
            this.visiblePassKeyCheck.setToolTipText(Messages.getMessage("PdfSigner.ShowPassword"));
            this.visiblePassKeyCheck.addActionListener(new ActionListener(){
                private char defaultChar;

                public void actionPerformed(ActionEvent actionEvent) {
                    if (KeystorePanel.this.visiblePassKeyCheck.isSelected()) {
                        this.defaultChar = KeystorePanel.this.passwordKeyStoreField.getEchoChar();
                        KeystorePanel.this.passwordKeyStoreField.setEchoChar('\u0000');
                    } else {
                        KeystorePanel.this.passwordKeyStoreField.setEchoChar(this.defaultChar);
                    }
                }
            });
            jPanel.add((Component)this.visiblePassKeyCheck, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.insets = new Insets(10, 0, 10, 0);
            jPanel.add((Component)new JSeparator(0), gridBagConstraints);
            this.aliasNameLabel.setText(Messages.getMessage("PdfSigner.AliasName"));
            this.aliasNameLabel.setFont(new Font("Dialog", 1, 14));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.insets = new Insets(0, 10, 10, 0);
            jPanel.add((Component)this.aliasNameLabel, gridBagConstraints);
            this.aliasNameField.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent keyEvent) {
                }

                public void keyPressed(KeyEvent keyEvent) {
                }

                public void keyTyped(KeyEvent keyEvent) {
                    KeystorePanel.this.aliasAdvance = true;
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets = new Insets(0, 10, 0, 10);
            this.aliasNameField.setPreferredSize(new Dimension(150, 20));
            jPanel.add((Component)this.aliasNameField, gridBagConstraints);
            this.aliasPasswordLabel.setText(Messages.getMessage("PdfSigner.AliasPassword"));
            this.aliasPasswordLabel.setFont(new Font("Dialog", 1, 14));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 7;
            gridBagConstraints.insets = new Insets(10, 10, 0, 10);
            jPanel.add((Component)this.aliasPasswordLabel, gridBagConstraints);
            this.aliasPasswordField.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent keyEvent) {
                }

                public void keyPressed(KeyEvent keyEvent) {
                }

                public void keyTyped(KeyEvent keyEvent) {
                    KeystorePanel.this.aliasPassAdvance = true;
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 7;
            gridBagConstraints.insets = new Insets(0, 10, 0, 10);
            gridBagConstraints.anchor = 20;
            this.aliasPasswordField.setPreferredSize(new Dimension(100, 20));
            jPanel.add((Component)this.aliasPasswordField, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 7;
            gridBagConstraints.insets = new Insets(10, 0, 0, 0);
            this.visiblePassAliasCheck.setToolTipText(Messages.getMessage("PdfSigner.ShowPassword"));
            this.visiblePassAliasCheck.addActionListener(new ActionListener(){
                private char defaultChar;

                public void actionPerformed(ActionEvent actionEvent) {
                    if (KeystorePanel.this.visiblePassAliasCheck.isSelected()) {
                        this.defaultChar = KeystorePanel.this.aliasPasswordField.getEchoChar();
                        KeystorePanel.this.aliasPasswordField.setEchoChar('\u0000');
                    } else {
                        KeystorePanel.this.aliasPasswordField.setEchoChar(this.defaultChar);
                    }
                }
            });
            jPanel.add((Component)this.visiblePassAliasCheck, gridBagConstraints);
            this.add((Component)jPanel, "Center");
            this.add((Component)new ProgressPanel(2), "South");
        }

        public void registerChange(ChangeListener changeListener) {
            this.browseKeyStoreButton.addChangeListener(changeListener);
        }

        public void registerNextKeyListeners(KeyListener keyListener) {
            this.passwordKeyStoreField.addKeyListener(keyListener);
            this.aliasNameField.addKeyListener(keyListener);
            this.aliasPasswordField.addKeyListener(keyListener);
        }

        public boolean canAdvance() {
            return this.storeAdvance && this.storePassAdvance && this.aliasAdvance && this.aliasPassAdvance;
        }

        public void collectData() {
            SignWizardModel.this.signData.setKeyStorePath(this.currentKeyStorePath.getText());
            SignWizardModel.this.signData.setKeystorePassword(this.passwordKeyStoreField.getPassword());
            SignWizardModel.this.signData.setAlias(this.aliasNameField.getText());
            SignWizardModel.this.signData.setAliasPassword(this.aliasPasswordField.getPassword());
        }
    }

    private class ModeSelect
    extends JPanel {
        private String selfString = Messages.getMessage("PdfSigner.HaveKeystore");
        private String otherString = Messages.getMessage("PdfSigner.HavePfx");
        private int y = 0;
        private JRadioButton selfButton = new JRadioButton(this.selfString);
        private String[] certifyOptions = new String[]{Messages.getMessage("PdfSigner.NotCertified"), Messages.getMessage("PdfSigner.NoChangesAllowed"), Messages.getMessage("PdfSigner.FormFilling"), Messages.getMessage("PdfSigner.FormFillingAndAnnotations")};
        private JComboBox certifyCombo = new JComboBox<String>(this.certifyOptions);
        private int certifyMode = -1;

        public ModeSelect() {
            Object object;
            if (!SignWizardModel.this.signData.isAppendMode()) {
                this.certifyCombo = new JComboBox<String>(this.certifyOptions);
            } else {
                object = new String[]{"Not Allowed..."};
                this.certifyCombo = new JComboBox<String>((E[])object);
            }
            this.setLayout(new BorderLayout());
            this.add((Component)new TitlePanel(Messages.getMessage("PdfSigner.SelectSigningMode")), "North");
            object = new JPanel();
            ((Container)object).setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.selfButton.setActionCommand(this.selfString);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = this.y++;
            gridBagConstraints.anchor = 23;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(10, 0, 20, 0);
            this.selfButton.setFont(new Font("Dialog", 1, 12));
            ((Container)object).add((Component)this.selfButton, gridBagConstraints);
            JRadioButton jRadioButton = new JRadioButton(this.otherString);
            jRadioButton.setActionCommand(this.otherString);
            jRadioButton.setSelected(true);
            SignWizardModel.this.signData.setSignMode(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = this.y++;
            gridBagConstraints.fill = 2;
            jRadioButton.setFont(new Font("Dialog", 1, 12));
            ((Container)object).add((Component)jRadioButton, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = this.y++;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(30, 0, 30, 0);
            ((Container)object).add((Component)new JSeparator(0), gridBagConstraints);
            JLabel jLabel = new JLabel(Messages.getMessage("PdfSigner.CertificationAuthor"));
            jLabel.setFont(new Font("Dialog", 1, 12));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = this.y++;
            gridBagConstraints.fill = 10;
            ((Container)object).add((Component)jLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = this.y;
            gridBagConstraints.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints.anchor = 20;
            this.certifyCombo.setEnabled(!SignWizardModel.this.isPdfSigned());
            this.certifyCombo.setSelectedIndex(0);
            this.certifyCombo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = (String)ModeSelect.this.certifyCombo.getSelectedItem();
                    if (string.equals(Messages.getMessage("PdfSigner.NotCertified"))) {
                        ModeSelect.this.certifyMode = -1;
                    } else if (string.equals(Messages.getMessage("PdfSigner.NoChangesAllowed"))) {
                        ModeSelect.this.certifyMode = -1;
                    } else if (string.equals(Messages.getMessage("PdfSigner.FormFilling"))) {
                        ModeSelect.this.certifyMode = -1;
                    } else if (string.equals(Messages.getMessage("PdfSigner.FormFillingAndAnnotations"))) {
                        ModeSelect.this.certifyMode = -1;
                    } else {
                        throw new NullPointerException("The certifyCombo box is sending a string that is not recognised.");
                    }
                }
            });
            ((Container)object).add((Component)this.certifyCombo, gridBagConstraints);
            if (SignWizardModel.this.isPdfSigned()) {
                this.certifyCombo.setToolTipText(Messages.getMessage("PdfSigner.NotPermittedOnSigned"));
            }
            this.add((Component)object, "Center");
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.selfButton);
            buttonGroup.add(jRadioButton);
            this.add((Component)new ProgressPanel(1), "South");
        }

        public void collectData() {
            SignWizardModel.this.signData.setSignMode(this.selfButton.isSelected());
            SignWizardModel.this.signData.setCertifyMode(this.certifyMode);
        }
    }

    private class PFXPanel
    extends JPanel {
        private JLabel keyFileLabel = new JLabel();
        private JButton browseKeyButton = new JButton();
        private JLabel currentKeyFilePath = new JLabel(NO_FILE_SELECTED);
        private JCheckBox visiblePassCheck = new JCheckBox();
        private JLabel passwordLabel = new JLabel();
        private JPasswordField passwordField = new JPasswordField();
        private volatile boolean keyNext = false;
        private volatile boolean passNext = false;
        private int y = 0;

        public PFXPanel() {
            try {
                this.init();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private void init() throws Exception {
            this.setLayout(new BorderLayout());
            this.add((Component)new TitlePanel(Messages.getMessage("PdfSigner.PfxSignMode")), "North");
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setBorder(BorderFactory.createEtchedBorder(1));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.keyFileLabel.setText(Messages.getMessage("PdfSigner.KeyFile"));
            this.keyFileLabel.setFont(new Font("Dialog", 1, 14));
            gridBagConstraints.anchor = 23;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(0, 10, 10, 0);
            jPanel.add((Component)this.keyFileLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 0;
            ++this.y;
            gridBagConstraints.gridy = this.y++;
            gridBagConstraints.gridwidth = 3;
            this.currentKeyFilePath.setPreferredSize(new Dimension(250, 20));
            gridBagConstraints.insets = new Insets(10, 10, 10, 10);
            jPanel.add((Component)this.currentKeyFilePath, gridBagConstraints);
            this.browseKeyButton.setText(Messages.getMessage("PdfViewerOption.Browse"));
            this.browseKeyButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser(SignWizardModel.this.rootDir);
                    String[] stringArray = new String[]{"pfx"};
                    jFileChooser.addChoosableFileFilter(new FileFilterer(stringArray, "Key (pfx)"));
                    int n = jFileChooser.showOpenDialog(null);
                    File file = jFileChooser.getSelectedFile();
                    if (file != null && n == 0) {
                        PFXPanel.this.currentKeyFilePath.setText(file.getAbsolutePath());
                        PFXPanel.this.keyNext = true;
                    }
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 25, 0, 10);
            jPanel.add((Component)this.browseKeyButton, gridBagConstraints);
            this.passwordLabel.setText(Messages.getMessage("PdfSigner.Password"));
            this.passwordLabel.setFont(new Font("Dialog", 1, 14));
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = this.y;
            gridBagConstraints.insets = new Insets(20, 10, 10, 10);
            jPanel.add((Component)this.passwordLabel, gridBagConstraints);
            this.passwordField.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent keyEvent) {
                }

                public void keyPressed(KeyEvent keyEvent) {
                    PFXPanel.this.passNext = true;
                }

                public void keyTyped(KeyEvent keyEvent) {
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = this.y;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.insets = new Insets(20, 10, 0, 10);
            this.passwordField.setPreferredSize(new Dimension(100, 20));
            jPanel.add((Component)this.passwordField, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = this.y;
            gridBagConstraints.insets = new Insets(20, 0, 0, 0);
            this.visiblePassCheck.setToolTipText(Messages.getMessage("PdfSigner.ShowPassword"));
            this.visiblePassCheck.addActionListener(new ActionListener(){
                private char defaultChar;

                public void actionPerformed(ActionEvent actionEvent) {
                    if (PFXPanel.this.visiblePassCheck.isSelected()) {
                        this.defaultChar = PFXPanel.this.passwordField.getEchoChar();
                        PFXPanel.this.passwordField.setEchoChar('\u0000');
                    } else {
                        PFXPanel.this.passwordField.setEchoChar(this.defaultChar);
                    }
                }
            });
            jPanel.add((Component)this.visiblePassCheck, gridBagConstraints);
            this.add((Component)jPanel, "Center");
            this.add((Component)new ProgressPanel(2), "South");
        }

        public void registerChange(ChangeListener changeListener) {
            this.browseKeyButton.addChangeListener(changeListener);
        }

        public void registerListener(KeyListener keyListener) {
            this.passwordField.addKeyListener(keyListener);
        }

        public boolean canAdvance() {
            return this.passNext && this.keyNext;
        }

        public void collectData() {
            SignWizardModel.this.signData.setKeyFilePassword(this.passwordField.getPassword());
            SignWizardModel.this.signData.setKeyFilePath(this.currentKeyFilePath.getText());
        }
    }
}

