/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui.swing;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jpedal.PageOffsets;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.Commands;
import org.jpedal.examples.simpleviewer.Values;
import org.jpedal.examples.simpleviewer.gui.SwingGUI;
import org.jpedal.examples.simpleviewer.gui.swing.SwingMouseSelector;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;

public class SwingMousePageTurn {
    private PdfDecoder decode_pdf;
    private SwingGUI currentGUI;
    private Values commonValues;
    private Commands currentCommands;
    private long lastPress;
    private boolean drawingTurnover = false;
    private boolean previewTurnover = false;
    private boolean pageTurnAnimating = false;
    private int pageFlowCurrentPage;
    private double middleDragStartX;
    private double middleDragStartY;
    private double xVelocity;
    private double yVelocity;
    private Timer middleDragTimer;
    long timeOfLastPageChange;
    boolean altIsDown = false;

    public SwingMousePageTurn(PdfDecoder pdfDecoder, SwingGUI swingGUI, Values values, Commands commands) {
        this.decode_pdf = pdfDecoder;
        this.currentGUI = swingGUI;
        this.commonValues = values;
        this.currentCommands = commands;
    }

    public void updateRectangle() {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.decode_pdf.getDisplayView() == 5 && mouseEvent.getButton() == 1) {
            if (this.decode_pdf.getCursor().getType() != 12) {
                return;
            }
            int n = this.commonValues.getCurrentPage();
            this.currentCommands.pages.getScroll().setValue(this.pageFlowCurrentPage - 1);
            this.pageFlowCurrentPage += this.pageFlowCurrentPage - n;
            this.decode_pdf.paintAll(this.decode_pdf.getGraphics());
        }
        if (this.decode_pdf.getDisplayView() == 1 && mouseEvent.getButton() == 1 && this.currentGUI.addUniqueIconToFileAttachment) {
            int[] nArray = this.updateXY(mouseEvent.getX(), mouseEvent.getY());
            this.checkLinks(true, this.decode_pdf.getIO(), nArray[0], nArray[1]);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.previewTurnover && this.currentCommands.getPages().getTurnoverOn() && this.decode_pdf.getDisplayView() == 3 && mouseEvent.getButton() == 1) {
            this.drawingTurnover = true;
            this.currentGUI.setCursor(2);
            this.lastPress = System.currentTimeMillis();
        }
        if (mouseEvent.getButton() == 2) {
            this.middleDragStartX = (double)mouseEvent.getX() - this.decode_pdf.getVisibleRect().getX();
            this.middleDragStartY = (double)mouseEvent.getY() - this.decode_pdf.getVisibleRect().getY();
            this.currentGUI.setCursor(4);
            if (this.middleDragTimer == null) {
                this.middleDragTimer = new Timer(100, new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Rectangle rectangle = SwingMousePageTurn.this.decode_pdf.getVisibleRect();
                        rectangle.translate((int)SwingMousePageTurn.this.xVelocity, (int)SwingMousePageTurn.this.yVelocity);
                        if (SwingMousePageTurn.this.xVelocity < -2.0) {
                            if (SwingMousePageTurn.this.yVelocity < -2.0) {
                                SwingMousePageTurn.this.currentGUI.setCursor(6);
                            } else if (SwingMousePageTurn.this.yVelocity > 2.0) {
                                SwingMousePageTurn.this.currentGUI.setCursor(12);
                            } else {
                                SwingMousePageTurn.this.currentGUI.setCursor(5);
                            }
                        } else if (SwingMousePageTurn.this.xVelocity > 2.0) {
                            if (SwingMousePageTurn.this.yVelocity < -2.0) {
                                SwingMousePageTurn.this.currentGUI.setCursor(8);
                            } else if (SwingMousePageTurn.this.yVelocity > 2.0) {
                                SwingMousePageTurn.this.currentGUI.setCursor(10);
                            } else {
                                SwingMousePageTurn.this.currentGUI.setCursor(9);
                            }
                        } else if (SwingMousePageTurn.this.yVelocity < -2.0) {
                            SwingMousePageTurn.this.currentGUI.setCursor(7);
                        } else if (SwingMousePageTurn.this.yVelocity > 2.0) {
                            SwingMousePageTurn.this.currentGUI.setCursor(11);
                        } else {
                            SwingMousePageTurn.this.currentGUI.setCursor(4);
                        }
                        SwingMousePageTurn.this.decode_pdf.scrollRectToVisible(rectangle);
                    }
                });
            }
            this.middleDragTimer.start();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.currentCommands.getPages().getTurnoverOn() && this.decode_pdf.getDisplayView() == 3) {
            this.drawingTurnover = false;
            boolean bl = this.currentGUI.getDragLeft();
            boolean bl2 = this.currentGUI.getDragTop();
            if (this.lastPress + 200L > System.currentTimeMillis()) {
                if (bl) {
                    this.currentCommands.executeCommand(52, null);
                } else {
                    this.currentCommands.executeCommand(53, null);
                }
                this.previewTurnover = false;
                this.currentGUI.setCursor(3);
            } else {
                Point point = new Point();
                point.y = this.decode_pdf.getInsetH();
                if (!bl2) {
                    point.y = (int)((float)point.y + (float)this.decode_pdf.getPdfPageData().getCropBoxHeight(1) * this.decode_pdf.getScaling());
                }
                point.x = bl ? (int)(this.decode_pdf.getVisibleRect().getWidth() / 2.0 - (double)((float)this.decode_pdf.getPdfPageData().getCropBoxWidth(1) * this.decode_pdf.getScaling())) : (int)(this.decode_pdf.getVisibleRect().getWidth() / 2.0 + (double)((float)this.decode_pdf.getPdfPageData().getCropBoxWidth(1) * this.decode_pdf.getScaling()));
                this.testFall(point, mouseEvent.getPoint(), bl);
            }
        }
        if (mouseEvent.getButton() == 2) {
            this.xVelocity = 0.0;
            this.yVelocity = 0.0;
            this.currentGUI.setCursor(3);
            this.middleDragTimer.stop();
            this.decode_pdf.repaint();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.altIsDown = mouseEvent.isAltDown();
            if (this.currentGUI.addUniqueIconToFileAttachment) {
                int[] nArray = this.updateXY(mouseEvent.getX(), mouseEvent.getY());
                this.checkLinks(true, this.decode_pdf.getIO(), nArray[0], nArray[1]);
            }
            if (this.currentCommands.getPages().getTurnoverOn() && (this.drawingTurnover || this.previewTurnover) && this.decode_pdf.getDisplayView() == 3) {
                this.currentGUI.setCursor(2);
                if (this.currentGUI.getDragLeft()) {
                    if (this.currentGUI.getDragTop()) {
                        this.decode_pdf.setUserOffsets(mouseEvent.getX(), mouseEvent.getY(), 996);
                    } else {
                        this.decode_pdf.setUserOffsets(mouseEvent.getX(), mouseEvent.getY(), 998);
                    }
                } else if (this.currentGUI.getDragTop()) {
                    this.decode_pdf.setUserOffsets(mouseEvent.getX(), mouseEvent.getY(), 997);
                } else {
                    this.decode_pdf.setUserOffsets(mouseEvent.getX(), mouseEvent.getY(), 999);
                }
            }
        } else if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
            this.xVelocity = ((double)mouseEvent.getX() - this.decode_pdf.getVisibleRect().getX() - this.middleDragStartX) / 4.0;
            this.yVelocity = ((double)mouseEvent.getY() - this.decode_pdf.getVisibleRect().getY() - this.middleDragStartY) / 4.0;
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        double d;
        double d2;
        float f;
        int n;
        Point point;
        if (this.decode_pdf.getDisplayView() == 5) {
            int n2;
            int n3;
            if (this.currentGUI.getRotation() % 180 == 90) {
                n3 = this.decode_pdf.getPdfPageData().getCropBoxHeight(1);
                n2 = this.decode_pdf.getPdfPageData().getCropBoxWidth(1);
            } else {
                n3 = this.decode_pdf.getPdfPageData().getCropBoxWidth(1);
                n2 = this.decode_pdf.getPdfPageData().getCropBoxHeight(1);
            }
            point = mouseEvent.getPoint();
            double d3 = (int)point.getX();
            n = (int)point.getY();
            f = this.decode_pdf.getScaling();
            d2 = f * (float)n2;
            int n4 = this.decode_pdf.getInsetH();
            d3 -= (double)(this.decode_pdf.getWidth() / 2);
            double d4 = (double)n3 * 0.5 * (double)f;
            d = PageOffsets.getPageFlowPageWidth((int)((float)n3 * f), f);
            if (d3 < -d4) {
                d3 = d3 + d4 - d;
            } else if (d3 >= d4) {
                d3 = d3 - d4 + d;
            } else {
                this.decode_pdf.setPDFCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            double d5 = d3 > 0.0 ? (d - d3 % d) / ((double)((float)n3 * f) * PageOffsets.PAGEFLOW_SIDE_SIZE * 0.5) : (d - -d3 % d) / ((double)((float)n3 * f) * PageOffsets.PAGEFLOW_SIDE_SIZE * 0.5);
            double d6 = d5 * (PageOffsets.PAGEFLOW_SIDE_SIZE * d2 * 0.15000000000000002);
            if ((double)n < (double)n4 + (1.0 - PageOffsets.PAGEFLOW_SIDE_SIZE) * d2 / 2.0 + d6) {
                this.decode_pdf.setPDFCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            if ((double)n > (double)n4 + d2 - (1.0 - PageOffsets.PAGEFLOW_SIDE_SIZE) * d2 / 2.0 - d6) {
                this.decode_pdf.setPDFCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            d3 = this.currentGUI.getCurrentPage() + (int)(d3 / d);
            this.pageFlowCurrentPage = (int)d3;
            if (d3 > 0.0 && d3 <= (double)this.decode_pdf.getPdfPageData().getPageCount()) {
                this.decode_pdf.setPDFCursor(Cursor.getPredefinedCursor(12));
            } else {
                this.decode_pdf.setPDFCursor(Cursor.getPredefinedCursor(0));
            }
        } else if (this.decode_pdf.getDisplayView() == 3 && this.currentCommands.getPages().getTurnoverOn() && ((SwingGUI)this.decode_pdf.getExternalHandler(11)).getPageTurnScalingAppropriate() && !this.decode_pdf.getPdfPageData().hasMultipleSizes() && !this.pageTurnAnimating) {
            Point point2;
            float f2 = (float)this.decode_pdf.getPdfPageData().getCropBoxHeight(1) * this.decode_pdf.getScaling() - 1.0f;
            float f3 = (float)this.decode_pdf.getPdfPageData().getCropBoxWidth(1) * this.decode_pdf.getScaling() - 1.0f;
            if ((this.decode_pdf.getPdfPageData().getRotation(1) + this.currentGUI.getRotation()) % 180 == 90) {
                float f4 = f2;
                f2 = f3 + 1.0f;
                f3 = f4;
            }
            point = new Point();
            if (this.commonValues.getCurrentPage() + 1 < this.commonValues.getPageCount()) {
                point.x = (int)(this.decode_pdf.getVisibleRect().getWidth() / 2.0 + (double)f3);
                point.y = (int)((float)this.decode_pdf.getInsetH() + f2);
                point2 = mouseEvent.getPoint();
                if (point2.x > point.x - 30 && point2.x <= point.x && (point2.y > point.y - 30 && point2.y <= point.y || (float)point2.y >= (float)point.y - f2 && (float)point2.y < (float)point.y - f2 + 30.0f)) {
                    this.currentGUI.setCursor(1);
                    this.previewTurnover = true;
                    if ((float)point2.y >= (float)point.y - f2 && (float)point2.y < (float)point.y - f2 + 30.0f) {
                        point.y = (int)((float)point.y - f2);
                        this.decode_pdf.setUserOffsets((int)point2.getX(), (int)point2.getY(), 997);
                    } else {
                        this.decode_pdf.setUserOffsets((int)point2.getX(), (int)point2.getY(), 999);
                    }
                } else {
                    if (this.currentGUI.getDragTop()) {
                        point.y = (int)((float)point.y - f2);
                    }
                    this.testFall(point, point2, false);
                }
            }
            if (this.commonValues.getCurrentPage() != 1) {
                point.x = (int)(this.decode_pdf.getVisibleRect().getWidth() / 2.0 - (double)f3);
                point.y = (int)((float)this.decode_pdf.getInsetH() + f2);
                point2 = mouseEvent.getPoint();
                if (point2.x < point.x + 30 && point2.x >= point.x && (point2.y > point.y - 30 && point2.y <= point.y || (float)point2.y >= (float)point.y - f2 && (float)point2.y < (float)point.y - f2 + 30.0f)) {
                    this.currentGUI.setCursor(1);
                    this.previewTurnover = true;
                    if ((float)point2.y >= (float)point.y - f2 && (float)point2.y < (float)point.y - f2 + 30.0f) {
                        point.y = (int)((float)point.y - f2);
                        this.decode_pdf.setUserOffsets((int)point2.getX(), (int)point2.getY(), 996);
                    } else {
                        this.decode_pdf.setUserOffsets((int)point2.getX(), (int)point2.getY(), 998);
                    }
                } else {
                    if (this.currentGUI.getDragTop()) {
                        point.y = (int)((float)point.y - f2);
                    }
                    this.testFall(point, point2, true);
                }
            }
        }
        if (this.currentGUI.useNewLayout) {
            int[] nArray = new int[2];
            nArray[0] = 1;
            if (this.decode_pdf.getDisplayView() == 1 || SwingMouseSelector.activateMultipageHighlight) {
                int n5;
                int n6;
                if (this.currentGUI.getRotation() % 180 == 90) {
                    n6 = this.decode_pdf.getPdfPageData().getCropBoxHeight(1);
                    n5 = this.decode_pdf.getPdfPageData().getCropBoxWidth(1);
                } else {
                    n6 = this.decode_pdf.getPdfPageData().getCropBoxWidth(1);
                    n5 = this.decode_pdf.getPdfPageData().getCropBoxHeight(1);
                }
                Point point3 = mouseEvent.getPoint();
                int n7 = (int)point3.getX();
                n = (int)point3.getY();
                f = this.decode_pdf.getScaling();
                d2 = f * (float)n5;
                double d7 = f * (float)n6;
                int n8 = this.decode_pdf.getInsetH();
                d = (double)(this.decode_pdf.getWidth() / 2) - d7 / 2.0;
                nArray[1] = (double)n7 >= d && (double)n7 <= d + d7 && n >= n8 && (double)n <= (double)n8 + d2 ? 1 : 0;
            } else {
                nArray[1] = 0;
            }
            this.currentGUI.setMultibox(nArray);
        }
        if (this.currentGUI.addUniqueIconToFileAttachment) {
            int[] nArray = this.updateXY(mouseEvent.getX(), mouseEvent.getY());
            this.checkLinks(false, this.decode_pdf.getIO(), nArray[0], nArray[1]);
        }
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.decode_pdf.getDisplayView() == 6) {
            return;
        }
        if (this.currentGUI.getProperties().getValue("allowScrollwheelZoom").toLowerCase().equals("true") && mouseWheelEvent.isControlDown()) {
            int n;
            block18: {
                n = this.currentGUI.getSelectedComboIndex(252);
                if (n != -1) {
                    n = (int)this.decode_pdf.getDPIFactory().removeScaling(this.decode_pdf.getScaling() * 100.0f);
                } else {
                    String string = (String)this.currentGUI.getSelectedComboItem(252);
                    try {
                        n = (int)Float.parseFloat(string);
                    }
                    catch (Exception exception) {
                        char c;
                        int n2;
                        n = -1;
                        int n3 = string.length();
                        for (n2 = 0; n2 < n3 && ((c = string.charAt(n2)) >= '0' && c <= '9') | c == '.'; ++n2) {
                        }
                        if (n2 > 0) {
                            string = string.substring(0, n2);
                        }
                        if (n != -1) break block18;
                        try {
                            n = (int)Float.parseFloat(string);
                        }
                        catch (Exception exception2) {
                            n = -1;
                        }
                    }
                }
            }
            float f = mouseWheelEvent.getWheelRotation();
            if ((n != 1 || f < 0.0f) && !((float)n + (f = f < 0.0f ? 1.25f : 0.8f) < 0.0f)) {
                float f2 = (float)n * f;
                f2 = (int)f2 == n ? (float)(n + 1) : (float)((int)f2);
                if (f2 < 1.0f) {
                    f2 = 1.0f;
                }
                if (f2 > 1000.0f) {
                    f2 = 1000.0f;
                }
                final Rectangle rectangle = this.decode_pdf.getVisibleRect();
                final double d = (double)mouseWheelEvent.getX() / this.decode_pdf.getBounds().getWidth();
                final double d2 = (double)mouseWheelEvent.getY() / this.decode_pdf.getBounds().getHeight();
                this.currentGUI.snapScalingToDefaults(f2);
                Thread thread = new Thread(){

                    public void run() {
                        try {
                            SwingMousePageTurn.this.decode_pdf.scrollRectToVisible(new Rectangle((int)(d * (double)SwingMousePageTurn.this.decode_pdf.getWidth() - rectangle.getWidth() / 2.0), (int)(d2 * (double)SwingMousePageTurn.this.decode_pdf.getHeight() - rectangle.getHeight() / 2.0), (int)SwingMousePageTurn.this.decode_pdf.getVisibleRect().getWidth(), (int)SwingMousePageTurn.this.decode_pdf.getVisibleRect().getHeight()));
                            SwingMousePageTurn.this.decode_pdf.repaint();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                };
                thread.start();
                SwingUtilities.invokeLater(thread);
            }
        } else {
            final JScrollBar jScrollBar = ((JScrollPane)this.decode_pdf.getParent().getParent()).getVerticalScrollBar();
            if ((jScrollBar.getValue() >= jScrollBar.getMaximum() - jScrollBar.getHeight() || jScrollBar.getHeight() == 0) && mouseWheelEvent.getUnitsToScroll() > 0 && this.timeOfLastPageChange + 700L < System.currentTimeMillis() && this.currentGUI.getPageNumber() < this.decode_pdf.getPageCount()) {
                this.timeOfLastPageChange = System.currentTimeMillis();
                this.currentCommands.executeCommand(53, null);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        jScrollBar.setValue(jScrollBar.getMinimum());
                    }
                });
            } else if (jScrollBar.getValue() == jScrollBar.getMinimum() && mouseWheelEvent.getUnitsToScroll() < 0 && this.timeOfLastPageChange + 700L < System.currentTimeMillis() && this.currentGUI.getPageNumber() > 1) {
                this.timeOfLastPageChange = System.currentTimeMillis();
                this.currentCommands.executeCommand(52, null);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        jScrollBar.setValue(jScrollBar.getMaximum());
                    }
                });
            } else {
                Area area = new Area(this.decode_pdf.getVisibleRect());
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(0.0, mouseWheelEvent.getUnitsToScroll() * this.decode_pdf.getScrollInterval());
                area = area.createTransformedArea(affineTransform);
                this.decode_pdf.scrollRectToVisible(area.getBounds());
            }
        }
    }

    public void checkLinks(boolean bl, PdfObjectReader pdfObjectReader, int n, int n2) {
        Map map = this.currentGUI.getHotspots();
        if (map != null) {
            Iterator iterator = map.keySet().iterator();
            FormObject formObject = null;
            while (iterator.hasNext() && !(formObject = (FormObject)iterator.next()).getBoundingRectangle().contains(n, n2)) {
                formObject = null;
            }
            if (formObject != null) {
                System.out.println(bl + " obj=" + formObject + " " + formObject.getObjectRefAsString() + " " + formObject.getBoundingRectangle());
                if (!bl) {
                    return;
                }
                PdfObject pdfObject = null;
                PdfObject pdfObject2 = formObject.getDictionary(5667);
                if (pdfObject2 != null) {
                    pdfObject = pdfObject2.getDictionary(5398);
                }
                JFileChooser jFileChooser = new JFileChooser(this.commonValues.getInputDir());
                jFileChooser.setFileSelectionMode(0);
                int n3 = jFileChooser.showSaveDialog(this.currentGUI.getFrame());
                if (n3 == 0) {
                    File file = jFileChooser.getSelectedFile();
                    if (pdfObject != null) {
                        pdfObjectReader.checkResolved(pdfObject);
                    }
                    PdfObject pdfObject3 = pdfObject.getDictionary(22);
                    String string = pdfObject3.getCachedStreamFile(pdfObjectReader.getObjectReader());
                    System.out.println("file=" + string);
                    if (string != null) {
                        ObjectStore.copy(string, file.toString());
                    } else {
                        byte[] byArray = pdfObject3.getDecodedStream();
                        if (byArray != null) {
                            try {
                                FileOutputStream fileOutputStream = new FileOutputStream(file);
                                fileOutputStream.write(byArray);
                                fileOutputStream.close();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                }
            }
        }
    }

    protected int[] updateXY(int n, int n2) {
        float f = this.currentGUI.getScaling();
        SwingMousePageTurn swingMousePageTurn = this;
        int n3 = swingMousePageTurn.currentGUI.getPDFDisplayInset();
        int n4 = this.currentGUI.getRotation();
        int n5 = (int)((float)(this.currentGUI.AdjustForAlignment(n) - n3) / f);
        int n6 = (int)((float)(n2 - n3) / f);
        if (this.commonValues.maxViewY != 0) {
            n5 = (int)((double)((float)n5 - (float)this.commonValues.dx * f) / this.commonValues.viewportScale);
            n6 = (int)(((double)this.currentGUI.mediaH - (double)((float)this.currentGUI.mediaH - (float)n6 / f - (float)this.commonValues.dy) / this.commonValues.viewportScale) * (double)f);
        }
        int[] nArray = new int[2];
        if (n4 == 90) {
            nArray[1] = n5 + this.currentGUI.cropY;
            nArray[0] = n6 + this.currentGUI.cropX;
        } else if (n4 == 180) {
            nArray[0] = this.currentGUI.mediaW - (n5 + this.currentGUI.mediaW - this.currentGUI.cropW - this.currentGUI.cropX);
            nArray[1] = n6 + this.currentGUI.cropY;
        } else if (n4 == 270) {
            nArray[1] = this.currentGUI.mediaH - (n5 + this.currentGUI.mediaH - this.currentGUI.cropH - this.currentGUI.cropY);
            nArray[0] = this.currentGUI.mediaW - (n6 + this.currentGUI.mediaW - this.currentGUI.cropW - this.currentGUI.cropX);
        } else {
            nArray[0] = n5 + this.currentGUI.cropX;
            nArray[1] = this.currentGUI.mediaH - (n6 + this.currentGUI.mediaH - this.currentGUI.cropH - this.currentGUI.cropY);
        }
        return nArray;
    }

    public void testFall(final Point point, final Point point2, boolean bl) {
        if (!this.previewTurnover) {
            return;
        }
        float f = (float)this.decode_pdf.getPdfPageData().getCropBoxWidth(1) * this.decode_pdf.getScaling() - 1.0f;
        if ((this.decode_pdf.getPdfPageData().getRotation(1) + this.currentGUI.getRotation()) % 180 == 90) {
            f = (float)this.decode_pdf.getPdfPageData().getCropBoxHeight(1) * this.decode_pdf.getScaling();
        }
        final float f2 = f;
        if (!bl) {
            if (!this.currentGUI.getDragLeft()) {
                this.decode_pdf.setPDFCursor(Cursor.getDefaultCursor());
                Thread thread = new Thread(){

                    public void run() {
                        point.x = (int)(SwingMousePageTurn.this.decode_pdf.getVisibleRect().getWidth() / 2.0 + (double)f2);
                        boolean bl = true;
                        if ((float)point2.x < (float)point.x - f2) {
                            point.x = (int)((float)point.x - 2.0f * f2);
                            bl = false;
                        }
                        int n = 1;
                        if (bl && point2.x >= point.x) {
                            point2.x = point.x - 1;
                        }
                        if (!bl && point2.x <= point.x) {
                            point2.x = point.x + 1;
                        }
                        if (!SwingMousePageTurn.this.currentGUI.getDragTop() && point2.y >= point.y) {
                            point2.y = point.y - 1;
                        }
                        if (SwingMousePageTurn.this.currentGUI.getDragTop() && point2.y <= point.y) {
                            point2.y = point.y + 1;
                        }
                        double d = point.x - point2.x;
                        double d2 = point.y - point2.y;
                        while (bl && point2.getX() <= point.getX() || !bl && point2.getX() >= point.getX() || !SwingMousePageTurn.this.currentGUI.getDragTop() && point2.getY() <= point.getY() || SwingMousePageTurn.this.currentGUI.getDragTop() && point2.getY() >= point.getY()) {
                            double d3 = (double)n * d * 0.002;
                            double d4 = (double)n * d2 * 0.002;
                            if (Math.abs(d3) < 1.0) {
                                d3 /= Math.abs(d3);
                            }
                            if (Math.abs(d4) < 1.0) {
                                d4 /= Math.abs(d4);
                            }
                            point2.setLocation(point2.getX() + d3, point2.getY() + d4);
                            if (SwingMousePageTurn.this.currentGUI.getDragTop()) {
                                SwingMousePageTurn.this.decode_pdf.setUserOffsets((int)point2.getX(), (int)point2.getY(), 997);
                            } else {
                                SwingMousePageTurn.this.decode_pdf.setUserOffsets((int)point2.getX(), (int)point2.getY(), 999);
                            }
                            if (n < 32) {
                                n *= 2;
                            }
                            try {
                                Thread.sleep(50L);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        if (!bl) {
                            int n2 = SwingMousePageTurn.this.commonValues.getCurrentPage() + 1;
                            if (SwingMousePageTurn.this.currentCommands.getPages().getSeparateCover() && n2 % 2 == 1) {
                                ++n2;
                            } else if (!SwingMousePageTurn.this.currentCommands.getPages().getSeparateCover() && n2 % 2 == 0) {
                                ++n2;
                            }
                            SwingMousePageTurn.this.commonValues.setCurrentPage(n2);
                            SwingMousePageTurn.this.currentGUI.setPageNumber();
                            SwingMousePageTurn.this.decode_pdf.setPageParameters(SwingMousePageTurn.this.currentGUI.getScaling(), SwingMousePageTurn.this.commonValues.getCurrentPage());
                            SwingMousePageTurn.this.currentGUI.decodePage(false);
                        }
                        SwingMousePageTurn.this.decode_pdf.setUserOffsets(0, 0, 995);
                        SwingMousePageTurn.this.setPageTurnAnimating(false);
                    }
                };
                this.setPageTurnAnimating(true);
                thread.start();
                this.previewTurnover = false;
            }
        } else if (this.previewTurnover && this.currentGUI.getDragLeft()) {
            this.decode_pdf.setPDFCursor(Cursor.getDefaultCursor());
            Thread thread = new Thread(){

                public void run() {
                    point.x = (int)(SwingMousePageTurn.this.decode_pdf.getVisibleRect().getWidth() / 2.0 - (double)f2);
                    boolean bl = true;
                    if ((float)point2.x > (float)point.x + f2) {
                        point.x = (int)((float)point.x + 2.0f * f2);
                        bl = false;
                    }
                    int n = 1;
                    if (!bl && point2.x >= point.x) {
                        point2.x = point.x - 1;
                    }
                    if (bl && point2.x <= point.x) {
                        point2.x = point.x + 1;
                    }
                    if (!SwingMousePageTurn.this.currentGUI.getDragTop() && point2.y >= point.y) {
                        point2.y = point.y - 1;
                    }
                    if (SwingMousePageTurn.this.currentGUI.getDragTop() && point2.y <= point.y) {
                        point2.y = point.y + 1;
                    }
                    double d = point.x - point2.x;
                    double d2 = point.y - point2.y;
                    while (!bl && point2.getX() <= point.getX() || bl && point2.getX() >= point.getX() || !SwingMousePageTurn.this.currentGUI.getDragTop() && point2.getY() <= point.getY() || SwingMousePageTurn.this.currentGUI.getDragTop() && point2.getY() >= point.getY()) {
                        double d3 = (double)n * d * 0.002;
                        double d4 = (double)n * d2 * 0.002;
                        if (Math.abs(d3) < 1.0) {
                            d3 /= Math.abs(d3);
                        }
                        if (Math.abs(d4) < 1.0) {
                            d4 /= Math.abs(d4);
                        }
                        point2.setLocation(point2.getX() + d3, point2.getY() + d4);
                        if (SwingMousePageTurn.this.currentGUI.getDragTop()) {
                            SwingMousePageTurn.this.decode_pdf.setUserOffsets((int)point2.getX(), (int)point2.getY(), 996);
                        } else {
                            SwingMousePageTurn.this.decode_pdf.setUserOffsets((int)point2.getX(), (int)point2.getY(), 998);
                        }
                        if (n < 32) {
                            n *= 2;
                        }
                        try {
                            Thread.sleep(50L);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    if (!bl) {
                        int n2 = SwingMousePageTurn.this.commonValues.getCurrentPage() - 2;
                        if (n2 == 0) {
                            n2 = 1;
                        }
                        SwingMousePageTurn.this.commonValues.setCurrentPage(n2);
                        SwingMousePageTurn.this.currentGUI.setPageNumber();
                        SwingMousePageTurn.this.decode_pdf.setPageParameters(SwingMousePageTurn.this.currentGUI.getScaling(), SwingMousePageTurn.this.commonValues.getCurrentPage());
                        SwingMousePageTurn.this.currentGUI.decodePage(false);
                    }
                    SwingMousePageTurn.this.decode_pdf.setUserOffsets(0, 0, 995);
                    SwingMousePageTurn.this.setPageTurnAnimating(false);
                }
            };
            this.setPageTurnAnimating(true);
            thread.start();
            this.previewTurnover = false;
        }
    }

    public void setPageTurnAnimating(boolean bl) {
        this.pageTurnAnimating = bl;
        if (bl) {
            this.currentGUI.forward.setEnabled(false);
            this.currentGUI.back.setEnabled(false);
            this.currentGUI.fforward.setEnabled(false);
            this.currentGUI.fback.setEnabled(false);
            this.currentGUI.end.setEnabled(false);
            this.currentGUI.first.setEnabled(false);
        } else {
            this.currentGUI.hideRedundentNavButtons();
        }
    }

    public boolean getPageTurnAnimating() {
        return this.pageTurnAnimating;
    }
}

