/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.RescueBodyNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RescueNode
extends Node {
    private Node bodyNode;
    private RescueBodyNode rescueNode;
    private Node elseNode;

    public RescueNode(SourcePosition position, Node bodyNode, RescueBodyNode rescueNode, Node elseNode) {
        super(position);
        this.bodyNode = bodyNode;
        this.rescueNode = rescueNode;
        this.elseNode = elseNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.RESCUENODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitRescueNode(this);
    }

    public Node getBody() {
        return this.bodyNode;
    }

    @Deprecated
    public Node getBodyException() {
        return this.getBody();
    }

    public void setBody(Node body) {
        this.bodyNode = body;
    }

    public Node getElse() {
        return this.elseNode;
    }

    @Deprecated
    public Node getElseNode() {
        return this.getElse();
    }

    public void setElse(Node elseNode) {
        this.elseNode = elseNode;
    }

    public RescueBodyNode getRescue() {
        return this.rescueNode;
    }

    @Deprecated
    public RescueBodyNode getRescueNode() {
        return this.getRescue();
    }

    public void setRescue(RescueBodyNode rescue) {
        this.rescueNode = rescue;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.rescueNode, this.bodyNode, this.elseNode);
    }
}

